/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.alert;

import io.vproxy.base.util.LogType;
import io.vproxy.base.util.Logger;
import io.vproxy.vfx.manager.font.FontManager;
import io.vproxy.vfx.manager.font.FontUsages;
import io.vproxy.vfx.manager.internal_i18n.InternalI18n;
import io.vproxy.vfx.ui.alert.ThemeAlertBase;
import io.vproxy.vfx.ui.layout.VPadding;
import io.vproxy.vfx.ui.pane.ClickableFusionPane;
import io.vproxy.vfx.ui.wrapper.ThemeLabel;
import io.vproxy.vfx.util.FXUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.Labeled;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.layout.Region;
import javafx.scene.text.Font;

public class StackTraceAlert
extends ThemeAlertBase {
    private StackTraceAlert(String desc, Throwable throwable) {
        Logger.error((LogType)LogType.ALERT, (String)("StackTraceAlert: " + desc), (Throwable)throwable);
        this.setTitle(InternalI18n.get().stacktraceAlertTitle());
        ThemeLabel headerText = new ThemeLabel(InternalI18n.get().stacktraceAlertHeaderText()){
            {
                FontManager.get().setFont(FontUsages.alert, (Labeled)this);
            }
        };
        ThemeLabel descText = new ThemeLabel(){
            {
                FontManager.get().setFont(FontUsages.alert, (Labeled)this);
            }
        };
        if (desc != null && !desc.isBlank()) {
            descText.setText(desc);
        }
        ThemeLabel aboutStacktraceText = new ThemeLabel(InternalI18n.get().stacktraceAlertLabel()){
            {
                FontManager.get().setFont(FontUsages.alert, (Labeled)this);
            }
        };
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        String exceptionText = sw.toString();
        final ClickableFusionPane stacktracePane = new ClickableFusionPane();
        stacktracePane.setOnAction(e -> Clipboard.getSystemClipboard().setContent(Map.of(DataFormat.PLAIN_TEXT, exceptionText)));
        stacktracePane.getNode().setPrefWidth(this.getStage().getWidth() - 40.0 - 5.0);
        ThemeLabel stacktraceText = new ThemeLabel(exceptionText){
            {
                super(text);
                this.setFont(new Font("JetBrains Mono", 14.0));
                this.setWrapText(true);
                this.setPrefWidth(stacktracePane.getNode().getPrefWidth() - 20.0);
            }
        };
        stacktracePane.getContentPane().getChildren().add((Object)stacktraceText);
        FXUtils.observeHeight((Region)stacktraceText, stacktracePane.getNode(), 20.0);
        FXUtils.runDelay(50, () -> StackTraceAlert.lambda$new$1(stacktraceText));
        this.alertMessagePane.getChildren().addAll((Object[])new Node[]{headerText, descText, new VPadding(20.0), aboutStacktraceText, stacktracePane.getNode()});
    }

    public static void show(Throwable throwable) {
        StackTraceAlert.show("", throwable);
    }

    public static void show(String desc, Throwable throwable) {
        FXUtils.runOnFX(() -> new StackTraceAlert(desc, throwable).show());
    }

    public static void showAndWait(Throwable throwable) {
        StackTraceAlert.showAndWait("", throwable);
    }

    public static void showAndWait(String desc, Throwable throwable) {
        new StackTraceAlert(desc, throwable).showAndWait();
    }

    private static /* synthetic */ void lambda$new$1(4 stacktraceText) {
        stacktraceText.setMinHeight(stacktraceText.getHeight() + 1.0);
    }
}

