/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.alert;

import io.vproxy.vfx.manager.internal_i18n.InternalI18n;
import io.vproxy.vfx.ui.button.FusionButton;
import io.vproxy.vfx.ui.layout.HPadding;
import io.vproxy.vfx.ui.layout.VPadding;
import io.vproxy.vfx.ui.stage.VStage;
import io.vproxy.vfx.ui.stage.VStageInitParams;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;

public class ThemeAlertBase
extends VStage {
    public static final int PADDING_H = 20;
    protected final VBox alertMessagePane = new VBox();
    protected final FusionButton okButton = new FusionButton(InternalI18n.get().alertOkButton()){
        {
            this.setPrefWidth(120.0);
            this.setPrefHeight(45.0);
        }
    };

    public ThemeAlertBase() {
        super(new VStageInitParams().setIconifyButton(false).setMaximizeAndResetButton(false).setResizable(false));
        this.getStage().centerOnScreen();
        Pane root = this.getInitialScene().getContentPane();
        root.getChildren().add((Object)new HBox(new Node[]{new HPadding(20.0), new VBox(new Node[]{this.alertMessagePane, new VPadding(15.0), new HBox(new Node[]{this.okButton}){
            {
                this.setAlignment(Pos.CENTER_RIGHT);
            }
        }, new VPadding(10.0)}), new HPadding(20.0)}));
        this.getStage().setWidth(720.0);
        root.heightProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            double h = now.doubleValue();
            if ((h = 28.0 + h + 2.0) > 800.0) {
                h = 800.0;
            }
            this.getStage().setHeight(h);
        });
        this.okButton.setOnAction(e -> this.close());
    }

    @Override
    public void show() {
        super.show();
        this.temporaryOnTop();
    }

    @Override
    public void showAndWait() {
        super.showAndWait();
        this.temporaryOnTop();
    }
}

