/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.button;

import io.vproxy.vfx.manager.font.FontManager;
import io.vproxy.vfx.manager.font.FontUsages;
import io.vproxy.vfx.theme.Theme;
import io.vproxy.vfx.ui.button.AbstractFusionButton;
import io.vproxy.vfx.util.FXUtils;
import javafx.animation.AnimationTimer;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.layout.Background;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.stage.Window;

public class FusionButton
extends AbstractFusionButton {
    private final Label text = new Label(){
        {
            this.setTextFill((Paint)Theme.current().fusionButtonTextColor());
            FontManager.get().setFont(FontUsages.fusionButtonText, (Labeled)this);
        }
    };
    private EventHandler<?> actionHandler = null;
    private Window watchingWindow = null;
    private final ChangeListener<? super Boolean> windowFocusPlayAnimationListener = (ob, old, now) -> {
        if (now == null) {
            return;
        }
        this.setInternalDisableAnimation(now == false);
    };
    private Animation timer = null;
    private final Pane borderLightPane = new Pane();
    private boolean disableAnimation = !Theme.current().enableFusionButtonAnimation();
    private boolean internalDisableAnimation = false;
    private boolean alreadyClicked = false;
    private boolean onlyAnimateWhenNotClicked = false;

    public FusionButton() {
        this(null);
    }

    public FusionButton(String text) {
        this.text.textProperty().addListener((ob, old, now) -> this.updateTextPosition());
        this.widthProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            this.updateTextPosition();
            double w = now.doubleValue();
            this.borderLightPane.setPrefWidth(w);
        });
        this.heightProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            this.updateTextPosition();
            double h = now.doubleValue();
            this.borderLightPane.setPrefHeight(h);
        });
        if (text != null) {
            this.text.setText(text);
        }
        this.setCursor(Cursor.HAND);
        this.getChildren().add((Object)this.text);
        this.sceneProperty().addListener((ob, old, now) -> {
            Window oldWindow = this.watchingWindow;
            this.watchingWindow = null;
            if (oldWindow != null) {
                oldWindow.focusedProperty().removeListener(this.windowFocusPlayAnimationListener);
            }
            if (now != null) {
                Window newWindow;
                this.watchingWindow = newWindow = now.getWindow();
                newWindow.focusedProperty().addListener(this.windowFocusPlayAnimationListener);
                this.setInternalDisableAnimation(!newWindow.isFocused());
            } else {
                this.setInternalDisableAnimation(true);
            }
        });
        this.setInternalDisableAnimation(true);
        this.disabledProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            this.handleDisable((boolean)now);
        });
        this.borderLightPane.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Theme.current().fusionButtonAnimatingBorderLightColor(), BorderStrokeStyle.SOLID, this.getCornerRadii(), new BorderWidths(1.5))}));
        this.borderLightPane.setBackground(Background.EMPTY);
        this.borderLightPane.setOpacity(0.0);
        this.getChildren().add((Object)this.borderLightPane);
        this.setPrefWidth(64.0);
        this.setPrefHeight(24.0);
    }

    private void handleDisable(boolean v) {
        if (v) {
            this.setCursor(Cursor.DEFAULT);
            this.setMouseTransparent(true);
            this.text.setTextFill((Paint)Theme.current().fusionButtonDisabledTextColor());
        } else {
            this.setCursor(Cursor.HAND);
            this.setMouseTransparent(false);
            this.text.setTextFill((Paint)Theme.current().fusionButtonTextColor());
            this.startAnimating();
        }
    }

    private void updateTextPosition() {
        Rectangle2D bounds = FXUtils.calculateTextBounds(this.text);
        this.text.setLayoutX((this.getWidth() - bounds.getWidth()) / 2.0);
        this.text.setLayoutY((this.getHeight() - bounds.getHeight()) / 2.0);
    }

    public void setText(String text) {
        this.text.setText(text);
    }

    public void setOnAction(EventHandler<?> handler) {
        this.actionHandler = handler;
    }

    public EventHandler<?> getOnAction() {
        return this.actionHandler;
    }

    @Override
    protected void onMouseClicked() {
        this.alreadyClicked = true;
        EventHandler<?> actionHandler = this.actionHandler;
        if (actionHandler == null) {
            return;
        }
        actionHandler.handle(null);
    }

    @Override
    protected CornerRadii getCornerRadii() {
        return new CornerRadii(4.0);
    }

    public Label getTextNode() {
        return this.text;
    }

    public boolean startAnimating() {
        Animation timer = this.timer;
        if (timer != null) {
            return true;
        }
        if (this.isDisableAnimation0()) {
            return false;
        }
        timer = new Animation();
        timer.start();
        this.timer = timer;
        return true;
    }

    public void stopAnimating() {
        Animation timer = this.timer;
        this.timer = null;
        if (timer != null) {
            timer.stop();
        }
        this.borderLightPane.setOpacity(0.0);
    }

    public boolean isDisableAnimation() {
        return this.disableAnimation;
    }

    public boolean isDisableAnimation0() {
        return this.disableAnimation || this.internalDisableAnimation || this.isDisabled() || this.alreadyClicked && this.onlyAnimateWhenNotClicked;
    }

    public void setDisableAnimation(boolean disableAnimation) {
        this.disableAnimation = disableAnimation;
        if (disableAnimation) {
            this.stopAnimating();
        } else {
            this.startAnimating();
        }
    }

    public boolean isOnlyAnimateWhenNotClicked() {
        return this.onlyAnimateWhenNotClicked;
    }

    public void setOnlyAnimateWhenNotClicked(boolean onlyAnimateWhenNotClicked) {
        this.onlyAnimateWhenNotClicked = onlyAnimateWhenNotClicked;
    }

    private void setInternalDisableAnimation(boolean internalDisableAnimation) {
        this.internalDisableAnimation = internalDisableAnimation;
        if (internalDisableAnimation) {
            this.stopAnimating();
        } else {
            this.startAnimating();
        }
    }

    private class Animation
    extends AnimationTimer {
        private long beginTs = 0L;

        private Animation() {
        }

        public void handle(long now) {
            long delta;
            if (this.beginTs == 0L) {
                this.beginTs = now;
                return;
            }
            long noAnimate = 2000L;
            long showTime = 3500L;
            long glowTime = 4000L;
            long hideTime = 5500L;
            long fullPeriod = 10000L;
            if (delta > 10000L) {
                for (delta = (now - this.beginTs) / 1000000L; delta > 10000L; delta -= 10000L) {
                }
                this.beginTs = now - delta * 1000000L;
            }
            if (delta < 2000L) {
                FusionButton.this.borderLightPane.setOpacity(0.0);
            }
            if (delta < 3500L) {
                double p = (double)(delta - 2000L) / 1500.0;
                FusionButton.this.borderLightPane.setOpacity(p);
            } else if (delta < 4000L) {
                FusionButton.this.borderLightPane.setOpacity(1.0);
            } else if (delta < 5500L) {
                double p = (double)(delta - 4000L) / 1500.0;
                FusionButton.this.borderLightPane.setOpacity(1.0 - p);
            } else {
                FusionButton.this.borderLightPane.setOpacity(0.0);
                if (FusionButton.this.isDisableAnimation0()) {
                    FusionButton.this.timer = null;
                    this.stop();
                }
            }
        }
    }
}

