/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.button;

import io.vproxy.vfx.ui.button.FusionButton;
import javafx.geometry.Bounds;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class FusionImageButton
extends FusionButton {
    private final ImageView imageView = new ImageView();

    public FusionImageButton() {
        this((Image)null);
    }

    public FusionImageButton(Image image) {
        if (image != null) {
            this.imageView.setImage(image);
        }
        this.imageView.setPreserveRatio(true);
        this.getChildren().add((Object)this.imageView);
        this.widthProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            this.updateImagePosition();
        });
        this.heightProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            this.updateImagePosition();
        });
        this.setDisableAnimation(true);
    }

    public ImageView getImageView() {
        return this.imageView;
    }

    private void updateImagePosition() {
        Bounds bounds = this.imageView.getLayoutBounds();
        this.imageView.setLayoutX((this.getWidth() - bounds.getWidth()) / 2.0);
        this.imageView.setLayoutY((this.getHeight() - bounds.getHeight()) / 2.0);
    }
}

