/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.button;

import io.vproxy.vfx.control.click.ClickEventHandler;
import io.vproxy.vfx.manager.image.ImageManager;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class ImageButton
extends ImageView {
    private final double w;
    private final double h;
    private EventHandler<Event> handler;

    public ImageButton(String prefix, String suffix) {
        this.setCursor(Cursor.HAND);
        final Image normalImage = ImageManager.get().load(prefix + "-normal." + suffix);
        this.w = normalImage.getWidth();
        this.h = normalImage.getHeight();
        final Image hoverImage = ImageManager.get().load(prefix + "-hover." + suffix);
        final Image downImage = ImageManager.get().load(prefix + "-down." + suffix);
        this.setImage(normalImage);
        ClickEventHandler clickHandler = new ClickEventHandler(){

            @Override
            protected void onMouseEntered() {
                ImageButton.this.setImage(hoverImage);
            }

            @Override
            protected void onMouseExited() {
                ImageButton.this.setImage(normalImage);
            }

            @Override
            protected void onMousePressed() {
                ImageButton.this.setImage(downImage);
            }

            @Override
            protected void onMouseReleased() {
                ImageButton.this.setImage(hoverImage);
            }

            @Override
            protected void onMouseClicked() {
                EventHandler<Event> handler = ImageButton.this.handler;
                if (handler == null) {
                    return;
                }
                handler.handle(null);
            }
        };
        this.setOnMouseEntered(clickHandler);
        this.setOnMouseExited(clickHandler);
        this.setOnMousePressed(clickHandler);
        this.setOnMouseReleased(clickHandler);
    }

    public void setOnAction(EventHandler<? extends Event> handler) {
        this.handler = handler;
    }

    public void setScale(double v) {
        this.setFitWidth(this.w * v);
        this.setFitHeight(this.h * v);
    }
}

