/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.loading;

import io.vproxy.vfx.manager.font.FontManager;
import io.vproxy.vfx.manager.font.FontUsages;
import io.vproxy.vfx.theme.Theme;
import io.vproxy.vfx.ui.layout.VPadding;
import io.vproxy.vfx.ui.loading.VProgressBar;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;

public class LoadingPane
extends Pane {
    private final Label label = new Label(){
        {
            FontManager.get().setFont(FontUsages.loading, (Labeled)this);
            this.setTextFill((Paint)Theme.current().normalTextColor());
        }
    };
    private final VProgressBar progressBar = new VProgressBar();

    public LoadingPane(String defaultText) {
        this.label.setText(defaultText);
        this.getChildren().add((Object)new VBox(new Node[]{this.label, new VPadding(15.0), this.progressBar}));
        this.progressBar.setCurrentLoadingItemCallback(item -> this.label.setText(item.name));
    }

    public void setLength(double length) {
        this.progressBar.setLength(length);
    }

    public VProgressBar getProgressBar() {
        return this.progressBar;
    }
}

