/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.loading;

import io.vproxy.base.util.callback.Callback;
import io.vproxy.vfx.ui.layout.HPadding;
import io.vproxy.vfx.ui.layout.VPadding;
import io.vproxy.vfx.ui.loading.LoadingFailure;
import io.vproxy.vfx.ui.loading.LoadingItem;
import io.vproxy.vfx.ui.loading.LoadingPane;
import io.vproxy.vfx.ui.stage.VStage;
import io.vproxy.vfx.ui.stage.VStageInitParams;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;

public class LoadingStage
extends VStage {
    private final LoadingPane loadingPane;

    public LoadingStage(String title) {
        super(new VStageInitParams().setIconifyButton(false).setMaximizeAndResetButton(false).setResizable(false));
        this.loadingPane = new LoadingPane(title);
        this.setTitle(title);
        this.getStage().setWidth(670.0);
        this.getStage().setHeight(120.0);
        Pane pane = this.getInitialScene().getContentPane();
        pane.getChildren().add((Object)new HBox(new Node[]{new HPadding(10.0), new VBox(new Node[]{new VPadding(15.0), this.loadingPane})}));
        this.loadingPane.setLength(640.0);
    }

    @Override
    public void close() {
        super.close();
        this.terminate();
    }

    public void setItems(List<LoadingItem> items) {
        this.loadingPane.getProgressBar().setItems(items);
    }

    public void setInterval(long interval) {
        this.loadingPane.getProgressBar().setInterval(interval);
    }

    public void load(final Callback<Void, LoadingFailure> cb) {
        this.show();
        this.loadingPane.getProgressBar().load(new Callback<Void, LoadingFailure>(){

            protected void onSucceeded(Void value) {
                cb.succeeded();
            }

            protected void onFailed(LoadingFailure failure) {
                cb.failed((Throwable)failure);
            }

            protected void doFinally() {
                LoadingStage.this.close();
            }
        });
    }

    public void terminate() {
        this.loadingPane.getProgressBar().terminate();
    }
}

