/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.loading;

import io.vproxy.base.util.callback.Callback;
import io.vproxy.vfx.manager.internal_i18n.InternalI18n;
import io.vproxy.vfx.manager.task.TaskManager;
import io.vproxy.vfx.theme.Theme;
import io.vproxy.vfx.ui.loading.LoadingFailure;
import io.vproxy.vfx.ui.loading.LoadingItem;
import io.vproxy.vfx.ui.shapes.VLine;
import io.vproxy.vfx.util.FXUtils;
import io.vproxy.vfx.util.MiscUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Paint;

public class VProgressBar
extends Group {
    private static final double radius = 1.0;
    private static final double width = 2.0;
    private double length;
    private double progress;
    private final VLine backgroundLine = new VLine(2.0);
    private final VLine progressLine = new VLine(2.0);
    private final DoublePropertyBase progressProperty = new DoublePropertyBase(){

        protected void invalidated() {
            VProgressBar.this.setProgress(VProgressBar.this.progressProperty.get());
        }

        public Object getBean() {
            return VProgressBar.this;
        }

        public String getName() {
            return "progressProperty";
        }
    };
    private List<LoadingItem> items = new ArrayList<LoadingItem>();
    private long interval = 0L;
    private Callback<Void, LoadingFailure> cb = null;
    private volatile boolean isDone = false;
    private Consumer<LoadingItem> currentLoadingItemCallback = null;

    public VProgressBar() {
        this.getChildren().addAll((Object[])new Node[]{this.backgroundLine, this.progressLine});
        this.backgroundLine.setStartX(1.0);
        this.backgroundLine.setStroke((Paint)Theme.current().progressBarBackgroundColor());
        this.progressLine.setStartX(1.0);
        this.progressLine.setStroke((Paint)Theme.current().progressBarProgressColor());
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
        this.backgroundLine.setEndX(length - 1.0);
        this.updateProgressLine();
    }

    public DoubleProperty progressProperty() {
        return this.progressProperty;
    }

    public double getProgress() {
        return this.progress;
    }

    public void setProgress(double progress) {
        if (progress < 0.0) {
            progress = 0.0;
        } else if (progress > 1.0) {
            progress = 1.0;
        }
        this.progress = progress;
        this.progressProperty.set(progress);
        this.updateProgressLine();
    }

    private void updateProgressLine() {
        double l = this.length * this.progress;
        this.progressLine.setEndX(l - 1.0);
    }

    public void setCurrentLoadingItemCallback(Consumer<LoadingItem> currentLoadingItemCallback) {
        this.currentLoadingItemCallback = currentLoadingItemCallback;
    }

    public void setItems(List<LoadingItem> items) {
        this.items = items;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void load(Callback<Void, LoadingFailure> cb) {
        this.cb = cb;
        long total = 0L;
        for (LoadingItem item : this.items) {
            total += (long)item.weight;
        }
        this.loadItem(total, 0L, this.items.iterator(), () -> Platform.runLater(() -> {
            this.isDone = true;
            Platform.runLater(() -> Platform.runLater(() -> ((Callback)cb).succeeded()));
        }));
    }

    private void loadItem(long total, long current, Iterator<LoadingItem> ite, Runnable cb) {
        if (!ite.hasNext()) {
            cb.run();
            return;
        }
        if (this.isDone) {
            return;
        }
        LoadingItem item = ite.next();
        FXUtils.runOnFX(() -> {
            Consumer<LoadingItem> currentCB = this.currentLoadingItemCallback;
            if (currentCB != null) {
                currentCB.accept(item);
            }
        });
        TaskManager.get().execute(() -> {
            Throwable _ex;
            boolean _ok;
            try {
                _ok = item.loadFunc.getAsBoolean();
                _ex = null;
            }
            catch (Throwable t) {
                _ex = t;
                _ok = false;
            }
            boolean ok = _ok;
            Throwable loadingException = _ex;
            if (ok && this.interval > 0L) {
                MiscUtils.threadSleep(this.interval);
            }
            Platform.runLater(() -> {
                if (!ok) {
                    this.isDone = true;
                    Platform.runLater(() -> this.cb.failed((Throwable)new LoadingFailure(item, loadingException)));
                    return;
                }
                long newCurr = current + (long)item.weight;
                this.setProgress((double)newCurr / (double)total);
                this.loadItem(total, newCurr, ite, cb);
            });
        });
    }

    public boolean terminate() {
        if (this.isDone) {
            return false;
        }
        this.isDone = true;
        FXUtils.runOnFX(() -> this.cb.failed((Throwable)new LoadingFailure(InternalI18n.get().loadingCanceled())));
        return true;
    }
}

