/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.pane;

import io.vproxy.vfx.animation.AnimationGraph;
import io.vproxy.vfx.animation.AnimationGraphBuilder;
import io.vproxy.vfx.animation.AnimationNode;
import io.vproxy.vfx.control.click.ClickEventHandler;
import io.vproxy.vfx.theme.Theme;
import io.vproxy.vfx.util.algebradata.ColorData;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public abstract class AbstractFusionPane
extends Pane {
    private final AnimationGraph<ColorData> animation;
    private final AnimationNode<ColorData> normalNode = new AnimationNode<ColorData>("normal", new ColorData(this.normalColor()));
    private final AnimationNode<ColorData> hoverNode = new AnimationNode<ColorData>("hover", new ColorData(this.hoverColor()));
    private final AnimationNode<ColorData> downNode = new AnimationNode<ColorData>("down", new ColorData(this.downColor()));
    protected CornerRadii cornerRadii = CornerRadii.EMPTY;
    protected final ClickEventHandler clickHandler;

    public AbstractFusionPane() {
        Platform.runLater(() -> {
            this.cornerRadii = this.getCornerRadii();
            this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)((ColorData)this.normalNode.value).getColor(), this.cornerRadii, Insets.EMPTY)}));
        });
        this.animation = AnimationGraphBuilder.simpleTwoNodeGraph(this.normalNode, this.hoverNode, 300L).addNode(this.downNode).setApply((from, to, data) -> this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)data.getColor(), this.cornerRadii, Insets.EMPTY)}))).build(this.normalNode);
        this.clickHandler = new ClickEventHandler(){

            @Override
            protected void onMouseEntered() {
                AbstractFusionPane.this.onMouseEntered();
            }

            @Override
            protected void onMouseExited() {
                AbstractFusionPane.this.onMouseExited();
            }

            @Override
            protected void onMousePressed() {
                AbstractFusionPane.this.onMousePressed();
            }

            @Override
            protected void onMouseReleased() {
                AbstractFusionPane.this.onMouseReleased();
            }

            @Override
            protected void onMouseClicked() {
                AbstractFusionPane.this.onMouseClicked();
            }
        };
        this.setOnMouseEntered(this.clickHandler);
        this.setOnMouseExited(this.clickHandler);
        this.setOnMousePressed(this.clickHandler);
        this.setOnMouseReleased(this.clickHandler);
    }

    protected void onMouseEntered() {
        this.animation.play(this.hoverNode);
    }

    protected void onMouseExited() {
        this.animation.play(this.normalNode);
    }

    protected void onMousePressed() {
        this.animation.stopAndSetNode(this.downNode);
    }

    protected void onMouseReleased() {
        this.animation.stopAndSetNode(this.hoverNode);
    }

    protected void onMouseClicked() {
    }

    protected abstract CornerRadii getCornerRadii();

    protected Color normalColor() {
        return Theme.current().fusionPaneNormalBackgroundColor();
    }

    protected Color hoverColor() {
        return Theme.current().fusionPaneHoverBackgroundColor();
    }

    protected Color downColor() {
        return this.hoverColor();
    }

    protected double normalContentOpacity() {
        return 1.0;
    }

    protected double hoverContentOpacity() {
        return 1.0;
    }
}

