/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.pane;

import io.vproxy.base.util.callback.Callback;
import io.vproxy.vfx.animation.AnimationGraph;
import io.vproxy.vfx.animation.AnimationGraphBuilder;
import io.vproxy.vfx.animation.AnimationNode;
import io.vproxy.vfx.theme.Theme;
import io.vproxy.vfx.ui.layout.HPadding;
import io.vproxy.vfx.ui.layout.VPadding;
import io.vproxy.vfx.ui.pane.AbstractFusionPane;
import io.vproxy.vfx.util.FXUtils;
import io.vproxy.vfx.util.algebradata.ColorData;
import io.vproxy.vfx.util.algebradata.DoubleData;
import javafx.scene.Node;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class FusionPane {
    public static final int PADDING_V = 10;
    public static final int PADDING_H = 10;
    private final AnimationGraph<DoubleData> contentOpacityAnimation;
    private final AnimationNode<DoubleData> contentOpacityNormalNode;
    private final AnimationNode<DoubleData> contentOpacityHoverNode;
    private final AbstractFusionPane root = this.buildRootNode();
    private final Pane content = new Pane();

    public FusionPane() {
        this(true);
    }

    public FusionPane(Node ... nodes) {
        this(true, nodes);
    }

    public FusionPane(boolean manuallyHandleOuterRegion) {
        this(manuallyHandleOuterRegion, new Node[0]);
    }

    public FusionPane(boolean manuallyHandleOuterRegion, Node ... nodes) {
        this.root.getChildren().add((Object)new VBox(new Node[]{new VPadding(10.0), new HBox(new Node[]{new HPadding(10.0), this.content, new HPadding(10.0)}), new VPadding(10.0)}));
        if (manuallyHandleOuterRegion) {
            FXUtils.observeWidthHeightWithPreferred((Region)this.root, (Region)this.content, -20.0, -20.0);
        }
        FXUtils.makeClipFor((Region)this.content, 4.0);
        this.getContentPane().getChildren().addAll((Object[])nodes);
        this.contentOpacityNormalNode = new AnimationNode<DoubleData>("normal", new DoubleData(this.root.normalContentOpacity()));
        this.contentOpacityHoverNode = new AnimationNode<DoubleData>("hover", new DoubleData(this.root.hoverContentOpacity()));
        this.contentOpacityAnimation = AnimationGraphBuilder.simpleTwoNodeGraph(this.contentOpacityNormalNode, this.contentOpacityHoverNode, 300L).setApply((from, to, data) -> this.content.setOpacity(data.value)).build(this.contentOpacityNormalNode);
    }

    protected AbstractFusionPane buildRootNode() {
        return new FusionPaneImpl();
    }

    public Region getNode() {
        return this.root;
    }

    public Pane getContentPane() {
        return this.content;
    }

    protected class FusionPaneImpl
    extends AbstractFusionPane {
        private final AnimationNode<ColorData> border = new AnimationNode<ColorData>("solid", new ColorData(this.hoverBorderColor()));
        private final AnimationNode<ColorData> noBorder = new AnimationNode<ColorData>("transparent", new ColorData(this.normalBorderColor()));
        private final AnimationGraph<ColorData> borderAnimation = AnimationGraphBuilder.simpleTwoNodeGraph(this.noBorder, this.border, 300L).setApply((from, to, data) -> this.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)data.getColor(), BorderStrokeStyle.SOLID, this.cornerRadii, new BorderWidths(0.5))}))).build(this.noBorder);

        protected FusionPaneImpl() {
        }

        @Override
        protected void onMouseEntered() {
            super.onMouseEntered();
            this.borderAnimation.play(this.border);
            FusionPane.this.contentOpacityAnimation.play(FusionPane.this.contentOpacityHoverNode);
        }

        @Override
        protected void onMouseExited() {
            super.onMouseExited();
            this.borderAnimation.play(this.noBorder, (Callback<Void, Exception>)Callback.ofIgnoreExceptionFunction(v -> this.setBorder(Border.EMPTY)));
            FusionPane.this.contentOpacityAnimation.play(FusionPane.this.contentOpacityNormalNode);
        }

        @Override
        protected void onMouseClicked() {
        }

        @Override
        protected CornerRadii getCornerRadii() {
            return new CornerRadii(8.0);
        }

        protected Color normalBorderColor() {
            Color c = Theme.current().fusionPaneBorderColor();
            return new Color(c.getRed(), c.getGreen(), c.getBlue(), 0.0);
        }

        protected Color hoverBorderColor() {
            return Theme.current().fusionPaneBorderColor();
        }
    }
}

