/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.scene;

import io.vproxy.vfx.animation.AnimationGraph;
import io.vproxy.vfx.animation.AnimationGraphBuilder;
import io.vproxy.vfx.animation.AnimationNode;
import io.vproxy.vfx.control.scroll.NodeWithVScrollPane;
import io.vproxy.vfx.control.scroll.VScrollPane;
import io.vproxy.vfx.ui.scene.VSceneGroup;
import io.vproxy.vfx.ui.scene.VSceneHideMethod;
import io.vproxy.vfx.ui.scene.VSceneRole;
import io.vproxy.vfx.util.FXUtils;
import io.vproxy.vfx.util.algebradata.XYZTData;
import java.util.HashSet;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;

public class VScene
implements NodeWithVScrollPane {
    public static final int ANIMATION_DURATION_MILLIS = 300;
    private static final int SHOW_DELAY_MILLIS = 50;
    private final Pane root = new Pane();
    private final VScrollPane scrollPane = new VScrollPane();
    private final Pane content = new Pane();
    public final VSceneRole role;
    private ImageView backgroundImage;
    final AnimationNode<XYZTData> stateTop = new AnimationNode<XYZTData>("top", new XYZTData(0.0, -1.0, 1.0, 0.0));
    final AnimationNode<XYZTData> stateRight = new AnimationNode<XYZTData>("right", new XYZTData(1.0, 0.0, 1.0, 0.0));
    final AnimationNode<XYZTData> stateBottom = new AnimationNode<XYZTData>("bottom", new XYZTData(0.0, 1.0, 1.0, 0.0));
    final AnimationNode<XYZTData> stateLeft = new AnimationNode<XYZTData>("left", new XYZTData(-1.0, 0.0, 1.0, 0.0));
    final AnimationNode<XYZTData> stateCenterShown = new AnimationNode<XYZTData>("center", new XYZTData(0.0, 0.0, 1.0, 1.0));
    final AnimationNode<XYZTData> stateFaded = new AnimationNode<XYZTData>("faded", new XYZTData(0.0, 0.0, 2.8E-45f, 0.0));
    final AnimationNode<XYZTData> stateRemoved = new AnimationNode<XYZTData>("removed", new XYZTData(0.0, 0.0, 1.0, 0.0), this::transferredToRemovedState);
    final AnimationGraph<XYZTData> animationGraph = new AnimationGraphBuilder<XYZTData>().addNode(this.stateTop).addNode(this.stateRight).addNode(this.stateBottom).addNode(this.stateLeft).addNode(this.stateCenterShown).addNode(this.stateFaded).addNode(this.stateRemoved).addEdge(this.stateRemoved, this.stateTop, 50L).addEdge(this.stateRemoved, this.stateRight, 50L).addEdge(this.stateRemoved, this.stateBottom, 50L).addEdge(this.stateRemoved, this.stateLeft, 50L).addEdge(this.stateRemoved, this.stateFaded, 50L).addEdge(this.stateTop, this.stateRemoved, 1L).addEdge(this.stateRight, this.stateRemoved, 1L).addEdge(this.stateBottom, this.stateRemoved, 1L).addEdge(this.stateLeft, this.stateRemoved, 1L).addEdge(this.stateFaded, this.stateRemoved, 1L).addEdge(this.stateTop, this.stateCenterShown, 250L).addEdge(this.stateRight, this.stateCenterShown, 250L).addEdge(this.stateBottom, this.stateCenterShown, 250L).addEdge(this.stateLeft, this.stateCenterShown, 250L).addEdge(this.stateFaded, this.stateCenterShown, 250L).addEdge(this.stateCenterShown, this.stateTop, 299L).addEdge(this.stateCenterShown, this.stateRight, 299L).addEdge(this.stateCenterShown, this.stateBottom, 299L).addEdge(this.stateCenterShown, this.stateLeft, 299L).addEdge(this.stateCenterShown, this.stateFaded, 299L).setStateTransferBeginCallback(this::animationStateTransferBegin).setApply(this::applyAnimation).build(this.stateRemoved);
    VSceneGroup.ProgressInformer progressInformer;
    ObservableList<Node> parentChildren;
    double xN;
    double yN;
    double x0;
    double y0;
    double x1;
    double y1;
    final Set<ChangeListener<? super Number>> changeListeners = new HashSet<ChangeListener<? super Number>>();
    Node bundle;
    Pane cover;
    VSceneHideMethod defaultHideMethod;

    public VScene(VSceneRole role) {
        this.role = role;
        this.scrollPane.setContent((Node)this.content);
        FXUtils.observeWidthHeight((Region)this.root, this.scrollPane.getNode());
        this.root.getChildren().add((Object)this.scrollPane.getNode());
        this.root.widthProperty().addListener(ob -> this.updateBackgroundImagePos());
        this.root.heightProperty().addListener(ob -> this.updateBackgroundImagePos());
    }

    public Region getNode() {
        return this.root;
    }

    @Override
    public VScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @Override
    public Region getSelfNode() {
        return this.getNode();
    }

    public Pane getContentPane() {
        return this.content;
    }

    public void enableAutoContentWidthHeight() {
        this.enableAutoContentWidth();
        this.enableAutoContentHeight();
    }

    public void enableAutoContentWidth() {
        FXUtils.observeWidth((Region)this.root, (Region)this.content, -1.0);
    }

    public void enableAutoContentHeight() {
        FXUtils.observeHeight((Region)this.root, (Region)this.content, -1.0);
    }

    private void transferredToRemovedState(AnimationNode<XYZTData> from, AnimationNode<XYZTData> to) {
        if (this.parentChildren != null && this.bundle != null) {
            this.parentChildren.remove((Object)this.bundle);
        }
    }

    private void applyAnimation(AnimationNode<XYZTData> from, AnimationNode<XYZTData> to, XYZTData data) {
        if (from == this.stateRemoved || to == this.stateRemoved) {
            return;
        }
        double x = data.x;
        double y = data.y;
        double opacity = data.z;
        x = x < 0.0 ? (this.xN - this.x0) * -x + this.x0 : (x > 0.0 ? (this.x1 - this.x0) * x + this.x0 : this.x0);
        y = y < 0.0 ? (this.yN - this.y0) * -y + this.y0 : (y > 0.0 ? (this.y1 - this.y0) * y + this.y0 : this.y0);
        this.getNode().setLayoutX(x);
        this.getNode().setLayoutY(y);
        this.getNode().setOpacity(opacity);
        if (this.progressInformer != null) {
            this.progressInformer.informUpdate(this, data.t);
        }
    }

    private void animationStateTransferBegin(AnimationNode<XYZTData> from, AnimationNode<XYZTData> to) {
        if (from == this.stateRemoved) {
            if (this.bundle != null) {
                this.bundle.setOpacity((double)2.8E-45f);
                this.bundle.setMouseTransparent(true);
                if (this.parentChildren != null && !this.parentChildren.contains((Object)this.bundle)) {
                    this.parentChildren.add((Object)this.bundle);
                }
            }
        } else if ((from == this.stateTop || from == this.stateBottom || from == this.stateLeft || from == this.stateRight || from == this.stateFaded) && to == this.stateCenterShown && this.bundle != null) {
            this.bundle.setOpacity(1.0);
            this.bundle.setMouseTransparent(false);
        }
    }

    public void setBackgroundImage(Image img) {
        if (img == null) {
            if (this.backgroundImage == null) {
                return;
            }
            this.root.getChildren().remove((Object)this.backgroundImage);
            this.backgroundImage = null;
            return;
        }
        if (this.backgroundImage == null) {
            this.backgroundImage = new ImageView(img);
            this.backgroundImage.setPreserveRatio(true);
            this.root.getChildren().add(0, (Object)this.backgroundImage);
        } else {
            this.backgroundImage.setImage(img);
        }
        this.updateBackgroundImagePos();
    }

    private void updateBackgroundImagePos() {
        if (this.backgroundImage == null) {
            return;
        }
        if (this.backgroundImage.getImage() == null) {
            return;
        }
        double iw = this.backgroundImage.getImage().getWidth();
        double ih = this.backgroundImage.getImage().getHeight();
        double nw = this.root.getWidth();
        double nh = this.root.getHeight();
        if (nw <= 0.0 || nh <= 0.0 || iw <= 0.0 || ih <= 0.0) {
            return;
        }
        if (iw / ih > nw / nh) {
            this.backgroundImage.setFitHeight(nh);
            this.backgroundImage.setFitWidth(nh * iw / ih);
        } else {
            this.backgroundImage.setFitWidth(nw);
            this.backgroundImage.setFitHeight(nw * ih / iw);
        }
        double bw = this.backgroundImage.getFitWidth();
        double bh = this.backgroundImage.getFitHeight();
        this.backgroundImage.setLayoutX((nw - bw) / 2.0);
        this.backgroundImage.setLayoutY((nh - bh) / 2.0);
    }

    protected boolean checkBeforeShowing() throws Exception {
        return true;
    }

    protected void beforeShowing() {
    }

    protected void onShown() {
    }

    protected boolean checkBeforeHiding() throws Exception {
        return true;
    }

    protected void beforeHiding() {
    }

    protected void onHidden() {
    }
}

