/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.scene;

import io.vproxy.base.util.LogType;
import io.vproxy.base.util.Logger;
import io.vproxy.base.util.callback.Callback;
import io.vproxy.vfx.animation.AnimationNode;
import io.vproxy.vfx.manager.internal_i18n.InternalI18n;
import io.vproxy.vfx.theme.Theme;
import io.vproxy.vfx.ui.alert.StackTraceAlert;
import io.vproxy.vfx.ui.scene.VScene;
import io.vproxy.vfx.ui.scene.VSceneAddParams;
import io.vproxy.vfx.ui.scene.VSceneGroupInitParams;
import io.vproxy.vfx.ui.scene.VSceneHideMethod;
import io.vproxy.vfx.ui.scene.VSceneRole;
import io.vproxy.vfx.ui.scene.VSceneShowMethod;
import io.vproxy.vfx.util.FXUtils;
import io.vproxy.vfx.util.algebradata.XYZTData;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;

public class VSceneGroup {
    private final VSceneGroupInitParams initParams;
    private final Pane root = new Pane();
    private final Set<VScene> scenes = new HashSet<VScene>();
    private final Group mainSceneGroup = new Group();
    private VScene currentMainScene;
    private VScene nextMainScene = null;
    private final Set<VScene> showingScenes = new HashSet<VScene>();
    private final Set<VScene> animatingShow = new HashSet<VScene>();
    private final Set<VScene> animatingHide = new HashSet<VScene>();

    public VSceneGroup(VScene initialMainScene) {
        this(initialMainScene, new VSceneGroupInitParams());
    }

    public VSceneGroup(VScene initialMainScene, VSceneGroupInitParams initParams) {
        if (initialMainScene.role != VSceneRole.MAIN) {
            throw new IllegalArgumentException(initialMainScene + " is not a MAIN scene");
        }
        try {
            boolean res = initialMainScene.checkBeforeShowing();
            if (!res) {
                throw new IllegalArgumentException("unable to show because beforeShowing() method returned false");
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        initialMainScene.beforeShowing();
        this.initParams = initParams;
        if (initParams.useClip) {
            FXUtils.makeClipFor((Region)this.root, 4.0);
        }
        this.root.getChildren().add((Object)this.mainSceneGroup);
        this.scenes.add(initialMainScene);
        initialMainScene.bundle = initialMainScene.getNode();
        this.mainSceneGroup.getChildren().add((Object)initialMainScene.bundle);
        this.currentMainScene = initialMainScene;
        initialMainScene.parentChildren = this.mainSceneGroup.getChildren();
        initialMainScene.progressInformer = this::progressUpdate;
        initialMainScene.changeListeners.add(FXUtils.observeWidth((Region)this.root, initialMainScene.getNode()));
        initialMainScene.changeListeners.add(FXUtils.observeHeight((Region)this.root, initialMainScene.getNode()));
        initialMainScene.animationGraph.stopAndSetNode(initialMainScene.stateCenterShown);
        initialMainScene.onShown();
    }

    public void addScene(VScene scene) {
        this.addScene(scene, null);
    }

    public void addScene(VScene scene, VSceneHideMethod defaultHideMethod) {
        this.addScene(scene, defaultHideMethod, new VSceneAddParams());
    }

    public void addScene(VScene scene, VSceneHideMethod defaultHideMethod, VSceneAddParams addParams) {
        if (!this.scenes.add(scene)) {
            throw new IllegalArgumentException("scene " + scene + " already added");
        }
        if (defaultHideMethod == null && scene.role != VSceneRole.MAIN) {
            throw new IllegalArgumentException("non-main scene must use addScene(VScene, VSceneHideMethod) to add the scene to scene group");
        }
        if (scene.role.manageWidth) {
            scene.changeListeners.add(FXUtils.observeWidth((Region)this.root, scene.getNode()));
        }
        if (scene.role.manageHeight) {
            scene.changeListeners.add(FXUtils.observeHeight((Region)this.root, scene.getNode()));
        }
        if (scene.role.centralWidth) {
            scene.changeListeners.add(FXUtils.observeWidthCenter((Region)this.root, scene.getNode()));
        }
        if (scene.role.centralHeight) {
            scene.changeListeners.add(FXUtils.observeHeightCenter((Region)this.root, scene.getNode()));
        }
        if (scene.role.showCover) {
            Pane cover = new Pane(){
                {
                    this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)(VSceneGroup.this.initParams.gradientCover ? Theme.current().makeCoverGradientBackground() : Theme.current().coverBackgroundColor()), CornerRadii.EMPTY, Insets.EMPTY)}));
                }
            };
            if (scene.role.temporary && addParams.coverClickable) {
                cover.setOnMouseClicked(e -> this.hide(scene, defaultHideMethod));
            }
            scene.cover = cover;
            scene.bundle = new Group(new Node[]{cover, scene.getNode()});
            scene.bundle.sceneProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$addScene$1(cover, arg_0, arg_1, arg_2));
        } else {
            scene.bundle = scene.getNode();
        }
        scene.defaultHideMethod = defaultHideMethod;
        scene.parentChildren = scene.role == VSceneRole.MAIN ? this.mainSceneGroup.getChildren() : this.root.getChildren();
        scene.progressInformer = this::progressUpdate;
    }

    public void removeScene(VScene scene) {
        if (this.currentMainScene == scene) {
            throw new IllegalArgumentException("currentMainScene cannot be removed: " + this.currentMainScene);
        }
        if (!this.scenes.contains(scene)) {
            throw new NoSuchElementException("" + scene);
        }
        scene.animationGraph.stopAndSetNode(scene.stateRemoved);
        for (ChangeListener<? super Number> lsn : scene.changeListeners) {
            this.root.widthProperty().removeListener(lsn);
            this.root.heightProperty().removeListener(lsn);
            scene.getNode().widthProperty().removeListener(lsn);
            scene.getNode().heightProperty().removeListener(lsn);
        }
        scene.changeListeners.clear();
        this.root.getChildren().remove((Object)scene.bundle);
        this.mainSceneGroup.getChildren().remove((Object)scene.bundle);
        scene.bundle = null;
        scene.cover = null;
        scene.defaultHideMethod = null;
        scene.parentChildren = null;
        scene.progressInformer = null;
        this.showingScenes.remove(scene);
        this.animatingHide.remove(scene);
        this.animatingShow.remove(scene);
        this.scenes.remove(scene);
        scene.getNode().setLayoutX(0.0);
        scene.getNode().setLayoutY(0.0);
    }

    public void show(VScene scene, VSceneShowMethod method) {
        if (scene == this.currentMainScene || this.showingScenes.contains(scene)) {
            return;
        }
        if (!this.scenes.contains(scene)) {
            throw new IllegalArgumentException(scene + " is not managed by this scene group");
        }
        if (this.animatingHide.contains(scene)) {
            this.animatingHide.remove(scene);
            this.animatingShow.add(scene);
            if (this.precheckShow(scene)) {
                scene.animationGraph.play(scene.stateCenterShown, (Callback<Void, Exception>)Callback.ofIgnoreExceptionFunction(v -> this.postShowing(scene)));
            }
            return;
        }
        if (this.animatingShow.contains(scene)) {
            return;
        }
        if (!this.precheckShow(scene)) {
            return;
        }
        if (scene.role == VSceneRole.MAIN) {
            if (!this.precheckHide(this.currentMainScene)) {
                return;
            }
            this.currentMainScene.beforeHiding();
            this.nextMainScene = scene;
        }
        scene.beforeShowing();
        Callback cb = Callback.ofIgnoreExceptionFunction(v -> this.showStep2(scene, method));
        switch (method) {
            case FROM_TOP: {
                scene.animationGraph.play(scene.stateTop, (Callback<Void, Exception>)cb);
                if (scene.role != VSceneRole.MAIN) break;
                this.hideSkipCheck(this.currentMainScene, VSceneHideMethod.TO_BOTTOM);
                break;
            }
            case FROM_BOTTOM: {
                scene.animationGraph.play(scene.stateBottom, (Callback<Void, Exception>)cb);
                if (scene.role != VSceneRole.MAIN) break;
                this.hideSkipCheck(this.currentMainScene, VSceneHideMethod.TO_TOP);
                break;
            }
            case FROM_LEFT: {
                scene.animationGraph.play(scene.stateLeft, (Callback<Void, Exception>)cb);
                if (scene.role != VSceneRole.MAIN) break;
                this.hideSkipCheck(this.currentMainScene, VSceneHideMethod.TO_RIGHT);
                break;
            }
            case FROM_RIGHT: {
                scene.animationGraph.play(scene.stateRight, (Callback<Void, Exception>)cb);
                if (scene.role != VSceneRole.MAIN) break;
                this.hideSkipCheck(this.currentMainScene, VSceneHideMethod.TO_LEFT);
                break;
            }
            case FADE_IN: {
                scene.animationGraph.play(scene.stateFaded, (Callback<Void, Exception>)cb);
                if (scene.role != VSceneRole.MAIN) break;
                this.hideSkipCheck(this.currentMainScene, VSceneHideMethod.FADE_OUT);
            }
        }
    }

    private boolean precheckShow(VScene scene) {
        try {
            return scene.checkBeforeShowing();
        }
        catch (Exception e) {
            Logger.error((LogType)LogType.USER_HANDLE_FAIL, (String)("failed running pre-check for showing scene " + scene), (Throwable)e);
            StackTraceAlert.showAndWait(InternalI18n.get().sceneGroupPreCheckShowSceneFailed(), e);
            return false;
        }
    }

    private boolean precheckHide(VScene scene) {
        try {
            return scene.checkBeforeHiding();
        }
        catch (Exception e) {
            Logger.error((LogType)LogType.USER_HANDLE_FAIL, (String)("failed running pre-check for hiding scene " + scene), (Throwable)e);
            StackTraceAlert.showAndWait(InternalI18n.get().sceneGroupPreCheckHideSceneFailed(), e);
            return false;
        }
    }

    private void showStep2(VScene scene, VSceneShowMethod method) {
        switch (method) {
            case FROM_TOP: {
                scene.x0 = 0.0;
                scene.y0 = 0.0;
                scene.yN = -scene.getNode().getHeight();
                this.doAnimate(scene, null, true);
                break;
            }
            case FROM_BOTTOM: {
                scene.x0 = 0.0;
                scene.y0 = this.root.getHeight() - scene.getNode().getHeight();
                scene.y1 = this.root.getHeight();
                this.doAnimate(scene, null, true);
                break;
            }
            case FROM_LEFT: {
                scene.x0 = 0.0;
                scene.y0 = 0.0;
                scene.xN = -scene.getNode().getWidth();
                this.doAnimate(scene, null, true);
                break;
            }
            case FROM_RIGHT: {
                scene.x0 = this.root.getWidth() - scene.getNode().getWidth();
                scene.y0 = 0.0;
                scene.x1 = this.root.getWidth();
                this.doAnimate(scene, null, true);
                break;
            }
            case FADE_IN: {
                scene.x0 = scene.getNode().getLayoutX();
                scene.y0 = scene.getNode().getLayoutY();
                this.doAnimate(scene, null, true);
            }
        }
    }

    public void hide(VScene scene, VSceneHideMethod method) {
        if (!this.scenes.contains(scene)) {
            throw new IllegalArgumentException(scene + " is not managed by this scene group");
        }
        if (this.currentMainScene != scene && !this.showingScenes.contains(scene)) {
            return;
        }
        if (scene.role == VSceneRole.MAIN) {
            throw new IllegalArgumentException(this.scenes + " cannot be hidden manually");
        }
        if (!this.precheckHide(scene)) {
            return;
        }
        scene.beforeHiding();
        this.hideSkipCheck(scene, method);
    }

    private void hideSkipCheck(VScene scene, VSceneHideMethod method) {
        if (this.animatingShow.contains(scene)) {
            this.animatingShow.remove(scene);
            this.animatingHide.add(scene);
            scene.animationGraph.play(scene.stateRemoved, (Callback<Void, Exception>)Callback.ofIgnoreExceptionFunction(v -> this.postHiding(scene)));
            return;
        }
        if (this.animatingHide.contains(scene)) {
            return;
        }
        scene.x0 = scene.getNode().getLayoutX();
        scene.y0 = scene.getNode().getLayoutY();
        switch (method) {
            case TO_TOP: {
                scene.yN = -scene.getNode().getHeight();
                this.doAnimate(scene, scene.stateTop, false);
                break;
            }
            case TO_BOTTOM: {
                scene.y1 = this.root.getHeight();
                this.doAnimate(scene, scene.stateBottom, false);
                break;
            }
            case TO_LEFT: {
                scene.xN = -scene.getNode().getWidth();
                this.doAnimate(scene, scene.stateLeft, false);
                break;
            }
            case TO_RIGHT: {
                scene.x1 = this.root.getWidth();
                this.doAnimate(scene, scene.stateRight, false);
                break;
            }
            case FADE_OUT: {
                this.doAnimate(scene, scene.stateFaded, false);
            }
        }
    }

    private void progressUpdate(VScene scene, double p) {
        this.animateCover(scene, p);
    }

    private void animateCover(VScene scene, double p) {
        if (scene.cover != null) {
            scene.cover.setOpacity(p);
        }
    }

    private void doAnimate(VScene scene, AnimationNode<XYZTData> keyNode, boolean isShowing) {
        Set<VScene> animatingSet = isShowing ? this.animatingShow : this.animatingHide;
        animatingSet.add(scene);
        Callback cb = Callback.ofIgnoreExceptionFunction(v -> {
            animatingSet.remove(scene);
            if (isShowing) {
                this.postShowing(scene);
            } else {
                this.postHiding(scene);
            }
        });
        if (isShowing) {
            scene.animationGraph.play(scene.stateCenterShown, (Callback<Void, Exception>)cb);
        } else {
            scene.animationGraph.play(List.of(keyNode, scene.stateRemoved), (Callback<Void, Exception>)cb);
        }
    }

    private void postShowing(VScene scene) {
        if (scene.role == VSceneRole.MAIN) {
            this.currentMainScene = scene;
            this.nextMainScene = null;
        } else {
            this.showingScenes.add(scene);
        }
        scene.getContentPane().requestFocus();
        scene.onShown();
    }

    private void postHiding(VScene scene) {
        this.showingScenes.remove(scene);
        if (scene.role != VSceneRole.MAIN) {
            this.currentMainScene.getContentPane().requestFocus();
        }
        scene.onHidden();
    }

    public VScene getCurrentMainScene() {
        return this.currentMainScene;
    }

    public VScene getNextMainScene() {
        return this.nextMainScene;
    }

    public VScene getNextOrCurrentMainScene() {
        VScene nx = this.getNextMainScene();
        if (nx == null) {
            return this.getCurrentMainScene();
        }
        return nx;
    }

    public boolean isShowing(VScene scene) {
        return scene == this.currentMainScene || this.showingScenes.contains(scene) || this.animatingShow.contains(scene);
    }

    public Set<VScene> getScenes() {
        return Collections.unmodifiableSet(this.scenes);
    }

    public Region getNode() {
        return this.root;
    }

    private /* synthetic */ void lambda$addScene$1(1 cover, ObservableValue ob, Scene old, Scene now) {
        if (now == null) {
            return;
        }
        cover.setPrefWidth(this.root.getWidth());
        cover.setPrefHeight(this.root.getHeight());
    }

    static interface ProgressInformer {
        public void informUpdate(VScene var1, double var2);
    }
}

