/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.shapes;

import io.vproxy.vfx.entity.Point;
import io.vproxy.vfx.ui.shapes.EndpointStyle;
import io.vproxy.vfx.ui.shapes.VLine;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class BrokenLine {
    private final List<VLine> lines = new ArrayList<VLine>();
    private final Group group = new Group();

    public BrokenLine(double width, double ... points) {
        this(width, BrokenLine.makePoints(points));
    }

    private static List<Point> makePoints(double[] points) {
        if (points.length % 2 != 0) {
            throw new IllegalArgumentException("points length must be an even number");
        }
        ArrayList<Point> ret = new ArrayList<Point>();
        Double x = null;
        for (double p : points) {
            if (x == null) {
                x = p;
                continue;
            }
            ret.add(new Point(x, p));
            x = null;
        }
        return ret;
    }

    public BrokenLine(double width, List<Point> points) {
        if (points.size() < 2) {
            throw new IllegalArgumentException("too few points to make a line");
        }
        for (int i = 1; i < points.size(); ++i) {
            Point current = points.get(i);
            Point previous = points.get(i - 1);
            VLine line = new VLine(width);
            this.lines.add(line);
            this.group.getChildren().add((Object)line);
            line.setStart(previous.x, previous.y);
            line.setEnd(current.x, current.y);
        }
    }

    public void setStartStyle(EndpointStyle style) {
        this.lines.get(0).setStartStyle(style);
    }

    public void setEndStyle(EndpointStyle style) {
        this.lines.get(this.lines.size() - 1).setEndStyle(style);
    }

    public void setStroke(Color color) {
        for (VLine l : this.lines) {
            l.setStroke((Paint)color);
        }
    }

    public Node getNode() {
        return this.group;
    }
}

