/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.shapes;

import io.vproxy.vfx.animation.AnimationGraph;
import io.vproxy.vfx.animation.AnimationGraphBuilder;
import io.vproxy.vfx.animation.AnimationNode;
import io.vproxy.vfx.control.click.ClickEventHandler;
import io.vproxy.vfx.util.algebradata.ColorData;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;

public class ClickableCircle
extends Circle {
    private EventHandler<?> handler;

    public ClickableCircle(Color normalColor, Color hoverColor, Color downColor) {
        final AnimationNode<ColorData> normal = new AnimationNode<ColorData>("normal", new ColorData(normalColor));
        final AnimationNode<ColorData> hover = new AnimationNode<ColorData>("hover", new ColorData(hoverColor));
        final AnimationNode<ColorData> down = new AnimationNode<ColorData>("down", new ColorData(downColor));
        final AnimationGraph<ColorData> animation = new AnimationGraphBuilder<ColorData>().addNode(normal).addNode(hover).addNode(down).addTwoWayEdge(normal, hover, 300L).setApply((from, to, d) -> this.setFill((Paint)d.getColor())).build(normal);
        this.setStrokeWidth(0.5);
        this.setCursor(Cursor.HAND);
        ClickEventHandler clickHandler = new ClickEventHandler(){

            @Override
            protected void onMouseEntered() {
                animation.play(hover);
            }

            @Override
            protected void onMouseExited() {
                animation.play(normal);
            }

            @Override
            protected void onMousePressed() {
                animation.stopAndSetNode(down);
            }

            @Override
            protected void onMouseReleased() {
                animation.stopAndSetNode(hover);
            }

            @Override
            protected void onMouseClicked() {
                ClickableCircle.this.clicked();
            }
        };
        this.setOnMouseEntered(clickHandler);
        this.setOnMouseExited(clickHandler);
        this.setOnMousePressed(clickHandler);
        this.setOnMouseReleased(clickHandler);
    }

    public void setOnAction(EventHandler<?> handler) {
        this.handler = handler;
    }

    private void clicked() {
        EventHandler<?> handler = this.handler;
        if (handler != null) {
            handler.handle(null);
        }
    }
}

