/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.shapes;

import io.vproxy.vfx.control.drag.DragHandler;
import io.vproxy.vfx.entity.Point;
import io.vproxy.vfx.manager.font.FontManager;
import io.vproxy.vfx.manager.font.FontUsages;
import io.vproxy.vfx.util.FXUtils;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;

public class MovablePoint
extends Group {
    public MovablePoint(String labelText) {
        Circle point = new Circle(5.0);
        point.setStrokeWidth(2.0);
        point.setStroke((Paint)Color.RED);
        point.setFill((Paint)Color.TRANSPARENT);
        Circle dot = new Circle(2.0);
        dot.setFill((Paint)Color.RED);
        dot.setStrokeWidth(0.0);
        Label label = new Label(labelText){
            {
                FontManager.get().setFont(FontUsages.movableShapeLabel, (Labeled)this);
            }
        };
        point.setCursor(Cursor.MOVE);
        label.setTextFill((Paint)Color.RED);
        Rectangle2D wh = FXUtils.calculateTextBounds(label);
        label.setLayoutX(-wh.getWidth() / 2.0);
        label.setLayoutY(10.0);
        DragHandler handler = new DragHandler(){

            @Override
            protected void set(double x, double y) {
                MovablePoint.this.setLayoutX(x);
                MovablePoint.this.setLayoutY(y);
            }

            @Override
            protected double[] get() {
                return new double[]{MovablePoint.this.getLayoutX(), MovablePoint.this.getLayoutY()};
            }
        };
        Group pointAndDotGroup = new Group(new Node[]{point, dot});
        pointAndDotGroup.setOnMousePressed((EventHandler)handler);
        pointAndDotGroup.setOnMouseDragged((EventHandler)handler);
        this.getChildren().addAll((Object[])new Node[]{label, pointAndDotGroup});
    }

    public Point makePoint() {
        Point point = new Point();
        point.x = this.getLayoutX();
        point.y = this.getLayoutY();
        return point;
    }

    public void from(Point point) {
        this.setX(point.x);
        this.setY(point.y);
    }

    public void setX(double x) {
        this.setLayoutX(x);
    }

    public void setY(double y) {
        this.setLayoutY(y);
    }
}

