/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.shapes;

import io.vproxy.vfx.control.drag.DragHandler;
import io.vproxy.vfx.entity.Rect;
import io.vproxy.vfx.manager.font.FontManager;
import io.vproxy.vfx.manager.font.FontUsages;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;

public class MovableRect
extends Group {
    private final Rectangle rect = new Rectangle();

    public MovableRect(String labelText) {
        this.rect.setFill((Paint)Color.TRANSPARENT);
        this.rect.setStroke((Paint)Color.RED);
        this.rect.setStrokeWidth(5.0);
        this.rect.setCursor(Cursor.MOVE);
        Rectangle pointRightBottom = new Rectangle();
        pointRightBottom.setWidth(10.0);
        pointRightBottom.setHeight(10.0);
        pointRightBottom.setFill((Paint)Color.RED);
        pointRightBottom.setStrokeWidth(0.0);
        pointRightBottom.setStroke((Paint)Color.TRANSPARENT);
        pointRightBottom.setCursor(Cursor.SE_RESIZE);
        this.rect.widthProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            pointRightBottom.setLayoutX(now.doubleValue() - 10.0);
        });
        this.rect.heightProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            pointRightBottom.setLayoutY(now.doubleValue() - 10.0);
        });
        Label label = new Label(labelText){
            {
                FontManager.get().setFont(FontUsages.movableShapeLabel, (Labeled)this);
            }
        };
        label.setTextFill((Paint)Color.RED);
        label.setLayoutX(0.0);
        this.rect.heightProperty().addListener((arg_0, arg_1, arg_2) -> MovableRect.lambda$new$2(label, arg_0, arg_1, arg_2));
        DragHandler dragHandler = new DragHandler(){

            @Override
            protected void set(double x, double y) {
                MovableRect.this.setLayoutX(x);
                MovableRect.this.setLayoutY(y);
            }

            @Override
            protected double[] get() {
                return new double[]{MovableRect.this.getLayoutX(), MovableRect.this.getLayoutY()};
            }
        };
        this.rect.setOnMousePressed((EventHandler)dragHandler);
        this.rect.setOnMouseDragged((EventHandler)dragHandler);
        DragHandler resizeHandler = new DragHandler(){

            @Override
            protected void set(double x, double y) {
                if (x > 5.0) {
                    MovableRect.this.rect.setWidth(x);
                }
                if (y > 5.0) {
                    MovableRect.this.rect.setHeight(y);
                }
            }

            @Override
            protected double[] get() {
                return new double[]{MovableRect.this.rect.getWidth(), MovableRect.this.rect.getHeight()};
            }
        };
        pointRightBottom.setOnMousePressed((EventHandler)resizeHandler);
        pointRightBottom.setOnMouseDragged((EventHandler)resizeHandler);
        this.getChildren().addAll((Object[])new Node[]{label, this.rect, pointRightBottom});
    }

    public void from(Rect rect) {
        this.setLayoutX(rect.x);
        this.setLayoutY(rect.y);
        this.setWidth(rect.w);
        this.setHeight(rect.h);
    }

    public Rect makeRect() {
        Rect rect = new Rect();
        rect.x = this.getLayoutX();
        rect.y = this.getLayoutY();
        rect.w = this.getWidth();
        rect.h = this.getHeight();
        return rect;
    }

    public double getWidth() {
        return this.rect.getWidth();
    }

    public double getHeight() {
        return this.rect.getHeight();
    }

    public void setWidth(double width) {
        this.rect.setWidth(width);
    }

    public void setHeight(double height) {
        this.rect.setHeight(height);
    }

    private static /* synthetic */ void lambda$new$2(1 label, ObservableValue ob, Number old, Number now) {
        if (now == null) {
            return;
        }
        label.setLayoutY(now.doubleValue() + 5.0);
    }
}

