/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.shapes;

import io.vproxy.vfx.ui.shapes.Arrow;
import io.vproxy.vfx.ui.shapes.EndpointStyle;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.transform.Rotate;

public class VLine
extends Group {
    private final Circle beginDot;
    private final Line line;
    private final Circle endDot;
    private final double width;
    private final double radius;
    private double startX;
    private double startY;
    private double endX;
    private double endY;
    private Paint fill;
    private Arrow arrowImageStart = null;
    private Arrow arrowImageEnd = null;

    public VLine(double width) {
        this.width = width;
        this.radius = width / 2.0;
        this.beginDot = new Circle(this.radius);
        this.beginDot.setStrokeWidth(0.0);
        this.line = new Line();
        this.line.setStrokeWidth(width);
        this.endDot = new Circle(this.radius);
        this.endDot.setStrokeWidth(0.0);
        this.getChildren().addAll((Object[])new Node[]{this.beginDot, this.line, this.endDot});
    }

    public void setStartStyle(EndpointStyle style) {
        if (style == EndpointStyle.ARROW) {
            Arrow arrowImage = this.loadOrMakeArrowImage();
            this.calcDirection((Node)arrowImage, false);
            arrowImage.setLayoutX(this.getStartX());
            arrowImage.setLayoutY(this.getStartY());
            this.arrowImageStart = arrowImage;
            this.getChildren().add((Object)arrowImage);
        } else if (this.arrowImageStart != null) {
            this.getChildren().remove((Object)this.arrowImageStart);
            this.arrowImageStart = null;
        }
    }

    public void setEndStyle(EndpointStyle style) {
        if (style == EndpointStyle.ARROW) {
            Arrow arrowImage = this.loadOrMakeArrowImage();
            this.calcDirection((Node)arrowImage, true);
            arrowImage.setLayoutX(this.getEndX());
            arrowImage.setLayoutY(this.getEndY());
            this.arrowImageEnd = arrowImage;
            this.getChildren().add((Object)arrowImage);
        } else if (this.arrowImageEnd != null) {
            this.getChildren().remove((Object)this.arrowImageEnd);
            this.arrowImageEnd = null;
        }
    }

    private void calcDirection(Node n, boolean toEnd) {
        double dy;
        double dx;
        if (toEnd) {
            dx = this.getEndX() - this.getStartX();
            dy = this.getEndY() - this.getStartY();
        } else {
            dx = this.getStartX() - this.getEndX();
            dy = this.getStartY() - this.getEndY();
        }
        if (dx == 0.0 && dy == 0.0) {
            return;
        }
        double l = Math.sqrt(dx * dx + dy * dy);
        double r = Math.acos(dx / l);
        if (dy < 0.0) {
            r = -r;
        }
        double d = r * 180.0 / Math.PI;
        Rotate rotation = new Rotate(d);
        n.getTransforms().add((Object)rotation);
    }

    private Arrow loadOrMakeArrowImage() {
        Arrow arrow = new Arrow();
        arrow.setFill(this.fill);
        double ratio = this.width / 32.0;
        arrow.setScale(ratio);
        return arrow;
    }

    public void setStroke(Paint fill) {
        this.fill = fill;
        this.beginDot.setFill(fill);
        this.line.setStroke(fill);
        this.endDot.setFill(fill);
        if (this.arrowImageStart != null) {
            this.arrowImageStart.setFill(fill);
        }
        if (this.arrowImageEnd != null) {
            this.arrowImageEnd.setFill(fill);
        }
    }

    public double getStartX() {
        return this.startX;
    }

    public void setStartX(double startX) {
        this.startX = startX;
        this.beginDot.setLayoutX(startX);
        this.updateLine();
    }

    public double getStartY() {
        return this.startY;
    }

    public void setStartY(double startY) {
        this.startY = startY;
        this.beginDot.setLayoutY(startY);
        this.updateLine();
    }

    public double getEndX() {
        return this.endX;
    }

    public void setEndX(double endX) {
        this.endX = endX;
        this.endDot.setLayoutX(endX);
        this.updateLine();
    }

    public double getEndY() {
        return this.endY;
    }

    public void setEndY(double endY) {
        this.endY = endY;
        this.endDot.setLayoutY(endY);
        this.updateLine();
    }

    private void updateLine() {
        double dx = this.endX - this.startX;
        double dy = this.endY - this.startY;
        if (dx == 0.0 && dy == 0.0) {
            this.line.setVisible(false);
            return;
        }
        this.line.setVisible(true);
        double l = Math.sqrt(dx * dx + dy * dy);
        dx = dx * this.radius / l;
        dy = dy * this.radius / l;
        this.line.setStartX(this.startX + dx);
        this.line.setStartY(this.startY + dy);
        this.line.setEndX(this.endX - dx);
        this.line.setEndY(this.endY - dy);
        if (this.arrowImageStart != null) {
            this.arrowImageStart.setLayoutX(this.startX);
            this.arrowImageStart.setLayoutY(this.startY);
        }
        if (this.arrowImageEnd != null) {
            this.arrowImageEnd.setLayoutX(this.endX);
            this.arrowImageEnd.setLayoutY(this.endY);
        }
    }

    public void setStart(double x, double y) {
        this.setStartX(x);
        this.setStartY(y);
    }

    public void setEnd(double x, double y) {
        this.setEndX(x);
        this.setEndY(y);
    }
}

