/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.slider;

import io.vproxy.vfx.animation.AnimationGraph;
import io.vproxy.vfx.animation.AnimationGraphBuilder;
import io.vproxy.vfx.animation.AnimationNode;
import io.vproxy.vfx.control.drag.DragHandler;
import io.vproxy.vfx.theme.Theme;
import io.vproxy.vfx.ui.shapes.ClickableCircle;
import io.vproxy.vfx.ui.shapes.VLine;
import io.vproxy.vfx.ui.slider.SliderDirection;
import io.vproxy.vfx.ui.wrapper.ThemeLabel;
import io.vproxy.vfx.util.FXUtils;
import io.vproxy.vfx.util.MiscUtils;
import io.vproxy.vfx.util.algebradata.DoubleData;
import java.util.function.DoubleFunction;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Rotate;

public class VRangeSlider
extends Pane {
    private static final double lineRadius = 1.0;
    private static final double lineWidth = 2.0;
    public static final int BUTTON_RADIUS = 15;
    private final SliderDirection sliderDirection;
    private final Group positionGroup = new Group();
    private final Pane rotatePane = new Pane();
    private final Rotate rotate = new Rotate();
    private double length;
    private double rangeMin;
    private double rangeMax;
    private final VLine backgroundLine = new VLine(2.0);
    private final VLine rangeLine = new VLine(2.0);
    private final ClickableCircle buttonMin = new ClickableCircle(Theme.current().rangeSliderButtonNormalColor(), Theme.current().rangeSliderButtonHoverColor(), Theme.current().rangeSliderButtonDownColor()){
        {
            this.setStroke((Paint)Theme.current().rangeSliderButtonBorderColor());
        }
    };
    private final ClickableCircle buttonMax = new ClickableCircle(Theme.current().rangeSliderButtonNormalColor(), Theme.current().rangeSliderButtonHoverColor(), Theme.current().rangeSliderButtonDownColor()){
        {
            this.setStroke((Paint)Theme.current().rangeSliderButtonBorderColor());
        }
    };
    private EventHandler<Event> minOnAction = null;
    private EventHandler<Event> maxOnAction = null;
    private final ThemeLabel minButtonLabel = new ThemeLabel();
    private final ThemeLabel maxButtonLabel = new ThemeLabel();
    private DoubleFunction<String> minValueTransform = MiscUtils.roughFloatValueFormat::format;
    private DoubleFunction<String> maxValueTransform = MiscUtils.roughFloatValueFormat::format;
    private final AnimationNode<DoubleData> labelInvisible = new AnimationNode<DoubleData>("invisible", new DoubleData(0.0));
    private final AnimationNode<DoubleData> labelVisible = new AnimationNode<DoubleData>("visible", new DoubleData(1.0));
    private final AnimationGraph<DoubleData> labelAnimation = AnimationGraphBuilder.simpleTwoNodeGraph(this.labelInvisible, this.labelVisible, 300L).setApply((from, to, d) -> {
        this.minButtonLabel.setOpacity(d.value);
        this.maxButtonLabel.setOpacity(d.value);
    }).build(this.labelInvisible);
    private final DoublePropertyBase minPercentageProperty = new DoublePropertyBase(){

        protected void invalidated() {
            VRangeSlider.this.setMinPercentage(VRangeSlider.this.minPercentageProperty.get());
        }

        public Object getBean() {
            return VRangeSlider.this;
        }

        public String getName() {
            return "minPercentageProperty";
        }
    };
    private final DoublePropertyBase maxPercentageProperty = new DoublePropertyBase(){

        protected void invalidated() {
            VRangeSlider.this.setMaxPercentage(VRangeSlider.this.maxPercentageProperty.get());
        }

        public Object getBean() {
            return VRangeSlider.this;
        }

        public String getName() {
            return "maxPercentageProperty";
        }
    };

    public VRangeSlider() {
        this(SliderDirection.LEFT_TO_RIGHT);
    }

    public VRangeSlider(final SliderDirection sliderDirection) {
        this.sliderDirection = sliderDirection;
        this.rotate.setAngle((double)sliderDirection.rotation);
        this.rotatePane.getTransforms().add((Object)this.rotate);
        this.positionGroup.getChildren().add((Object)this.rotatePane);
        this.getChildren().add((Object)this.positionGroup);
        this.getChildren().addAll((Object[])new Node[]{this.minButtonLabel, this.maxButtonLabel});
        if (sliderDirection.isHorizontal) {
            this.setMinHeight(30.0);
            this.setPrefHeight(30.0);
            this.setMaxHeight(30.0);
        } else {
            this.setMinWidth(30.0);
            this.setPrefWidth(30.0);
            this.setMaxWidth(30.0);
        }
        this.rotatePane.setMinHeight(30.0);
        this.rotatePane.setPrefHeight(30.0);
        this.rotatePane.setMaxHeight(30.0);
        this.rotatePane.getChildren().addAll((Object[])new Node[]{this.backgroundLine, this.rangeLine});
        this.backgroundLine.setStartX(16.0);
        this.backgroundLine.setStroke((Paint)Theme.current().progressBarBackgroundColor());
        this.rangeLine.setStroke((Paint)Theme.current().progressBarProgressColor());
        this.buttonMin.setRadius(15.0);
        this.buttonMax.setRadius(15.0);
        this.rotatePane.getChildren().addAll((Object[])new Node[]{this.buttonMin, this.buttonMax});
        FXUtils.setOnMouseEntered((Node)this.buttonMin, (EventHandler<? super MouseEvent>)((EventHandler)e -> this.labelAnimation.play(this.labelVisible)));
        FXUtils.setOnMouseExited((Node)this.buttonMin, (EventHandler<? super MouseEvent>)((EventHandler)e -> this.labelAnimation.play(this.labelInvisible)));
        FXUtils.setOnMouseEntered((Node)this.buttonMax, (EventHandler<? super MouseEvent>)((EventHandler)e -> this.labelAnimation.play(this.labelVisible)));
        FXUtils.setOnMouseExited((Node)this.buttonMax, (EventHandler<? super MouseEvent>)((EventHandler)e -> this.labelAnimation.play(this.labelInvisible)));
        this.buttonMin.layoutXProperty().addListener(ob -> this.updateLabels());
        this.buttonMax.layoutXProperty().addListener(ob -> this.updateLabels());
        this.updateLabels();
        DragHandler dragMin = new DragHandler(){

            @Override
            protected void set(double x, double y) {
                VRangeSlider.this.setMinPercentage((x - 15.0) / (VRangeSlider.this.length - 30.0));
            }

            @Override
            protected double[] get() {
                return new double[]{VRangeSlider.this.buttonMin.getLayoutX(), 0.0};
            }

            @Override
            protected double calculateDeltaX(double deltaX, double deltaY) {
                switch (sliderDirection) {
                    case LEFT_TO_RIGHT: {
                        return deltaX;
                    }
                    case RIGHT_TO_LEFT: {
                        return -deltaX;
                    }
                    case TOP_TO_BOTTOM: {
                        return deltaY;
                    }
                    case BOTTOM_TO_TOP: {
                        return -deltaY;
                    }
                }
                throw new IllegalStateException("should not reach here");
            }

            @Override
            protected void consume(MouseEvent e) {
                e.consume();
            }
        };
        double[] tmp = new double[]{0.0};
        FXUtils.setOnMousePressed((Node)this.buttonMin, (EventHandler<? super MouseEvent>)((EventHandler)arg_0 -> this.lambda$new$7(tmp, dragMin, arg_0)));
        this.buttonMin.setOnAction(e -> {
            if (tmp[0] != this.buttonMin.getLayoutX()) {
                return;
            }
            if (this.minOnAction != null) {
                this.minOnAction.handle(e);
            }
        });
        this.buttonMin.setOnMouseDragged(dragMin);
        DragHandler dragMax = new DragHandler(){

            @Override
            protected void set(double x, double y) {
                VRangeSlider.this.setMaxPercentage((x - 15.0) / (VRangeSlider.this.length - 30.0));
            }

            @Override
            protected double[] get() {
                return new double[]{VRangeSlider.this.buttonMax.getLayoutX(), 0.0};
            }

            @Override
            protected double calculateDeltaX(double deltaX, double deltaY) {
                switch (sliderDirection) {
                    case LEFT_TO_RIGHT: {
                        return deltaX;
                    }
                    case RIGHT_TO_LEFT: {
                        return -deltaX;
                    }
                    case TOP_TO_BOTTOM: {
                        return deltaY;
                    }
                    case BOTTOM_TO_TOP: {
                        return -deltaY;
                    }
                }
                throw new IllegalStateException("should not reach here");
            }

            @Override
            protected void consume(MouseEvent e) {
                e.consume();
            }
        };
        double[] tmp2 = new double[]{0.0};
        FXUtils.setOnMousePressed((Node)this.buttonMax, (EventHandler<? super MouseEvent>)((EventHandler)arg_0 -> this.lambda$new$9(tmp2, dragMax, arg_0)));
        this.buttonMax.setOnAction(e -> {
            if (tmp2[0] != this.buttonMax.getLayoutX()) {
                return;
            }
            if (this.maxOnAction != null) {
                this.maxOnAction.handle(e);
            }
        });
        this.buttonMax.setOnMouseDragged(dragMax);
    }

    public DoubleProperty minPercentageProperty() {
        return this.minPercentageProperty;
    }

    public double getMinPercentage() {
        return this.rangeMin;
    }

    public void setMinPercentage(double minPercentage) {
        if (minPercentage < 0.0) {
            minPercentage = 0.0;
        }
        if (minPercentage > 1.0) {
            minPercentage = 1.0;
        }
        this.rangeMin = minPercentage;
        if (minPercentage > this.rangeMax) {
            this.rangeMax = minPercentage;
            this.maxPercentageProperty.set(minPercentage);
        }
        this.minPercentageProperty.set(minPercentage);
        this.updateRange();
    }

    public DoubleProperty maxPercentageProperty() {
        return this.maxPercentageProperty;
    }

    public double getMaxPercentage() {
        return this.rangeMax;
    }

    public void setMaxPercentage(double maxPercentage) {
        if (maxPercentage > 1.0) {
            maxPercentage = 1.0;
        }
        if (maxPercentage < 0.0) {
            maxPercentage = 0.0;
        }
        this.rangeMax = maxPercentage;
        if (maxPercentage < this.rangeMin) {
            this.rangeMin = maxPercentage;
            this.minPercentageProperty.set(maxPercentage);
        }
        this.maxPercentageProperty.set(maxPercentage);
        this.updateRange();
        this.updateLabels();
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
        this.backgroundLine.setEndX(length - 15.0 - 1.0);
        if (this.sliderDirection.isHorizontal) {
            this.setMinWidth(length);
            this.setPrefWidth(length);
            this.setMaxWidth(length);
        } else {
            this.setMinHeight(length);
            this.setPrefHeight(length);
            this.setMaxHeight(length);
        }
        this.rotatePane.setMinWidth(length);
        this.rotatePane.setPrefWidth(length);
        this.rotatePane.setMaxWidth(length);
        this.rotate.setPivotX(length / 2.0);
        if (this.sliderDirection.isVertical) {
            this.positionGroup.setLayoutX(-length / 2.0 + 15.0);
            this.positionGroup.setLayoutY(length / 2.0);
        } else {
            this.positionGroup.setLayoutY(15.0);
        }
        this.updateRange();
        this.updateLabels();
    }

    public void setMinOnAction(EventHandler<Event> minOnAction) {
        this.minOnAction = minOnAction;
    }

    public void setMaxOnAction(EventHandler<Event> maxOnAction) {
        this.maxOnAction = maxOnAction;
    }

    private void updateRange() {
        double barLen = this.length - 30.0;
        this.buttonMin.setLayoutX(15.0 + barLen * this.rangeMin);
        this.buttonMax.setLayoutX(15.0 + barLen * this.rangeMax);
        this.rangeLine.setStartX(1.0 + this.buttonMin.getLayoutX());
        this.rangeLine.setEndX(1.0 + this.buttonMax.getLayoutX());
    }

    public void setMinValueTransform(DoubleFunction<String> minValueTransform) {
        if (minValueTransform == null) {
            minValueTransform = MiscUtils.roughFloatValueFormat::format;
        }
        this.minValueTransform = minValueTransform;
        this.updateLabels();
    }

    public void setMaxValueTransform(DoubleFunction<String> maxValueTransform) {
        if (maxValueTransform == null) {
            maxValueTransform = MiscUtils.roughFloatValueFormat::format;
        }
        this.maxValueTransform = maxValueTransform;
        this.updateLabels();
    }

    private void updateLabels() {
        String minStr = this.minValueTransform.apply(this.getMinPercentage());
        String maxStr = this.maxValueTransform.apply(this.getMaxPercentage());
        this.minButtonLabel.setText(minStr);
        this.maxButtonLabel.setText(maxStr);
        if (this.sliderDirection.isHorizontal) {
            if (this.sliderDirection == SliderDirection.LEFT_TO_RIGHT) {
                this.minButtonLabel.setLayoutX(this.buttonMin.getLayoutX() + 15.0 + 5.0);
                this.maxButtonLabel.setLayoutX(this.buttonMax.getLayoutX() + 15.0 + 5.0);
            } else {
                this.minButtonLabel.setLayoutX(this.getLength() - this.buttonMin.getLayoutX() + 15.0 + 5.0);
                this.maxButtonLabel.setLayoutX(this.getLength() - this.buttonMax.getLayoutX() + 15.0 + 5.0);
            }
            this.minButtonLabel.setLayoutY(20.0);
            this.maxButtonLabel.setLayoutY(20.0);
        } else {
            this.minButtonLabel.setLayoutX(20.0);
            this.maxButtonLabel.setLayoutX(20.0);
            if (this.sliderDirection == SliderDirection.TOP_TO_BOTTOM) {
                this.minButtonLabel.setLayoutY(this.buttonMin.getLayoutX() + 15.0 + 5.0);
                this.maxButtonLabel.setLayoutY(this.buttonMax.getLayoutX() + 15.0 + 5.0);
            } else {
                this.minButtonLabel.setLayoutY(this.getLength() - this.buttonMin.getLayoutX() + 15.0 + 5.0);
                this.maxButtonLabel.setLayoutY(this.getLength() - this.buttonMax.getLayoutX() + 15.0 + 5.0);
            }
        }
    }

    private /* synthetic */ void lambda$new$9(double[] tmp, 4 dragMax, MouseEvent e) {
        tmp[0] = this.buttonMax.getLayoutX();
        dragMax.handle(e);
    }

    private /* synthetic */ void lambda$new$7(double[] tmp, 3 dragMin, MouseEvent e) {
        tmp[0] = this.buttonMin.getLayoutX();
        dragMin.handle(e);
    }
}

