/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.slider;

import io.vproxy.vfx.animation.AnimationGraph;
import io.vproxy.vfx.animation.AnimationGraphBuilder;
import io.vproxy.vfx.animation.AnimationNode;
import io.vproxy.vfx.control.drag.DragHandler;
import io.vproxy.vfx.theme.Theme;
import io.vproxy.vfx.ui.loading.VProgressBar;
import io.vproxy.vfx.ui.shapes.ClickableCircle;
import io.vproxy.vfx.ui.slider.SliderDirection;
import io.vproxy.vfx.ui.wrapper.ThemeLabel;
import io.vproxy.vfx.util.FXUtils;
import io.vproxy.vfx.util.MiscUtils;
import io.vproxy.vfx.util.algebradata.DoubleData;
import java.util.function.DoubleFunction;
import javafx.beans.property.DoubleProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Rotate;

public class VSlider
extends Pane {
    public static final int BUTTON_RADIUS = 15;
    private final SliderDirection sliderDirection;
    private final Group positionGroup = new Group();
    private final Pane rotatePane = new Pane();
    private final Rotate rotate = new Rotate();
    private final VProgressBar bar = new VProgressBar();
    private final ClickableCircle button = new ClickableCircle(Theme.current().sliderButtonNormalColor(), Theme.current().sliderButtonHoverColor(), Theme.current().sliderButtonDownColor()){
        {
            this.setStroke((Paint)Theme.current().sliderButtonBorderColor());
        }
    };
    private EventHandler<Event> onAction = null;
    private final ThemeLabel buttonLabel = new ThemeLabel();
    private DoubleFunction<String> valueTransform = MiscUtils.roughFloatValueFormat::format;
    private final AnimationNode<DoubleData> labelInvisible = new AnimationNode<DoubleData>("invisible", new DoubleData(0.0));
    private final AnimationNode<DoubleData> labelVisible = new AnimationNode<DoubleData>("visible", new DoubleData(1.0));
    private final AnimationGraph<DoubleData> labelAnimation = AnimationGraphBuilder.simpleTwoNodeGraph(this.labelInvisible, this.labelVisible, 300L).setApply((from, to, d) -> this.buttonLabel.setOpacity(d.value)).build(this.labelInvisible);

    public VSlider() {
        this(SliderDirection.LEFT_TO_RIGHT);
    }

    public VSlider(final SliderDirection sliderDirection) {
        this.sliderDirection = sliderDirection;
        this.rotate.setAngle((double)sliderDirection.rotation);
        this.rotatePane.getTransforms().add((Object)this.rotate);
        this.positionGroup.getChildren().add((Object)this.rotatePane);
        this.getChildren().add((Object)this.positionGroup);
        this.getChildren().add((Object)this.buttonLabel);
        if (sliderDirection.isHorizontal) {
            this.setMinHeight(30.0);
            this.setPrefHeight(30.0);
            this.setMaxHeight(30.0);
        } else {
            this.setMinWidth(30.0);
            this.setPrefWidth(30.0);
            this.setMaxWidth(30.0);
        }
        this.rotatePane.setMinHeight(30.0);
        this.rotatePane.setPrefHeight(30.0);
        this.rotatePane.setMaxHeight(30.0);
        this.button.setRadius(15.0);
        this.button.setLayoutX(15.0);
        FXUtils.setOnMouseEntered((Node)this.button, (EventHandler<? super MouseEvent>)((EventHandler)e -> this.labelAnimation.play(this.labelVisible)));
        FXUtils.setOnMouseExited((Node)this.button, (EventHandler<? super MouseEvent>)((EventHandler)e -> this.labelAnimation.play(this.labelInvisible)));
        this.button.layoutXProperty().addListener(ob -> this.updateLabel());
        this.bar.progressProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            double p = now.doubleValue();
            this.button.setLayoutX(this.bar.getLength() * p + 15.0);
        });
        this.bar.setLayoutX(15.0);
        DragHandler dragHandler = new DragHandler(){

            @Override
            protected void set(double x, double y) {
                VSlider.this.setPercentage((x - 15.0) / VSlider.this.bar.getLength());
            }

            @Override
            protected double[] get() {
                return new double[]{VSlider.this.button.getLayoutX(), 0.0};
            }

            @Override
            protected double calculateDeltaX(double deltaX, double deltaY) {
                switch (sliderDirection) {
                    case LEFT_TO_RIGHT: {
                        return deltaX;
                    }
                    case RIGHT_TO_LEFT: {
                        return -deltaX;
                    }
                    case TOP_TO_BOTTOM: {
                        return deltaY;
                    }
                    case BOTTOM_TO_TOP: {
                        return -deltaY;
                    }
                }
                throw new IllegalStateException("should not reach here");
            }

            @Override
            protected void consume(MouseEvent e) {
                e.consume();
            }
        };
        double[] tmp = new double[]{0.0};
        FXUtils.setOnMousePressed((Node)this.button, (EventHandler<? super MouseEvent>)((EventHandler)arg_0 -> this.lambda$new$5(tmp, dragHandler, arg_0)));
        this.button.setOnAction(e -> {
            if (tmp[0] != this.button.getLayoutX()) {
                return;
            }
            if (this.onAction != null) {
                this.onAction.handle(e);
            }
        });
        this.button.setOnMouseDragged(dragHandler);
        this.rotatePane.getChildren().addAll((Object[])new Node[]{this.bar, this.button});
    }

    public double getLength() {
        return this.bar.getLength() + 30.0;
    }

    public void setLength(double length) {
        this.bar.setLength(length - 30.0);
        if (this.sliderDirection.isHorizontal) {
            this.setMinWidth(length);
            this.setPrefWidth(length);
            this.setMaxWidth(length);
        } else {
            this.setMinHeight(length);
            this.setPrefHeight(length);
            this.setMaxHeight(length);
        }
        this.rotatePane.setMinWidth(length);
        this.rotatePane.setPrefWidth(length);
        this.rotatePane.setMaxWidth(length);
        this.rotate.setPivotX(length / 2.0);
        if (this.sliderDirection.isVertical) {
            this.positionGroup.setLayoutX(-length / 2.0 + 15.0);
            this.positionGroup.setLayoutY(length / 2.0);
        } else {
            this.positionGroup.setLayoutY(15.0);
        }
        this.updateLabel();
    }

    public void setValueTransform(DoubleFunction<String> valueTransform) {
        if (valueTransform == null) {
            valueTransform = MiscUtils.roughFloatValueFormat::format;
        }
        this.valueTransform = valueTransform;
        this.updateLabel();
    }

    private void updateLabel() {
        String str = this.valueTransform.apply(this.getPercentage());
        this.buttonLabel.setText(str);
        if (this.sliderDirection.isHorizontal) {
            if (this.sliderDirection == SliderDirection.LEFT_TO_RIGHT) {
                this.buttonLabel.setLayoutX(this.button.getLayoutX() + 15.0 + 5.0);
            } else {
                this.buttonLabel.setLayoutX(this.getLength() - this.button.getLayoutX() + 15.0 + 5.0);
            }
            this.buttonLabel.setLayoutY(20.0);
        } else {
            this.buttonLabel.setLayoutX(20.0);
            if (this.sliderDirection == SliderDirection.TOP_TO_BOTTOM) {
                this.buttonLabel.setLayoutY(this.button.getLayoutX() + 15.0 + 5.0);
            } else {
                this.buttonLabel.setLayoutY(this.getLength() - this.button.getLayoutX() + 15.0 + 5.0);
            }
        }
    }

    public DoubleProperty percentageProperty() {
        return this.bar.progressProperty();
    }

    public double getPercentage() {
        return this.bar.getProgress();
    }

    public void setPercentage(double p) {
        this.bar.setProgress(p);
    }

    public void setOnAction(EventHandler<Event> onAction) {
        this.onAction = onAction;
    }

    private /* synthetic */ void lambda$new$5(double[] tmp, 2 dragHandler, MouseEvent e) {
        tmp[0] = this.button.getLayoutX();
        dragHandler.handle(e);
    }
}

