/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.stage;

import io.vproxy.vfx.theme.Theme;
import io.vproxy.vfx.ui.stage.VStage;
import io.vproxy.vfx.ui.stage.VStageInitParams;
import io.vproxy.vfx.ui.stage.WindowControlButton;
import javafx.scene.image.Image;
import javafx.scene.layout.CornerRadii;

public class MaxResetButton
extends WindowControlButton {
    private final Image[] maxImg = new Image[]{Theme.current().windowMaximizeButtonNormalImage(), Theme.current().windowMaximizeButtonHoverImage()};
    private final Image[] rstImg = new Image[]{Theme.current().windowResetWindowSizeButtonNormalImage(), Theme.current().windowResetWindowSizeButtonHoverImage()};
    private CornerRadii cornerRadii;

    public MaxResetButton(VStage stage, VStageInitParams initParams) {
        super(stage, initParams);
        this.updateImage();
    }

    @Override
    protected void init(VStageInitParams initParams) {
        this.cornerRadii = initParams.iconifyButton ? CornerRadii.EMPTY : new CornerRadii(0.0, 0.0, 0.0, 4.0, false);
    }

    @Override
    protected void onMouseEntered() {
        super.onMouseEntered();
        this.imageView.setImage(this.currentImageGroup()[1]);
    }

    @Override
    protected void onMouseExited() {
        super.onMouseExited();
        this.imageView.setImage(this.currentImageGroup()[0]);
    }

    @Override
    protected void onMouseClicked() {
        this.stage.setMaximized(!this.stage.isMaximized());
    }

    @Override
    protected CornerRadii getCornerRadii() {
        return this.cornerRadii;
    }

    @Override
    protected Image getNormalImage() {
        return Theme.current().windowMaximizeButtonNormalImage();
    }

    @Override
    protected Image getHoverImage() {
        return Theme.current().windowMaximizeButtonHoverImage();
    }

    private Image[] currentImageGroup() {
        if (this.stage.isMaximized()) {
            return this.rstImg;
        }
        return this.maxImg;
    }

    void updateImage() {
        if (this.stage.isMaximized()) {
            this.imageView.setFitWidth(22.0);
            this.imageView.setFitHeight(22.0);
            this.imageView.setLayoutX(21.0);
            this.imageView.setLayoutY(3.0);
            this.imageView.setScaleX(-1.0);
        } else {
            this.imageView.setFitWidth(20.0);
            this.imageView.setFitHeight(20.0);
            this.imageView.setLayoutX(22.0);
            this.imageView.setLayoutY(4.0);
            this.imageView.setScaleX(-1.0);
        }
        if (this.clickHandler.isMouseEntered()) {
            this.imageView.setImage(this.currentImageGroup()[1]);
        } else {
            this.imageView.setImage(this.currentImageGroup()[0]);
        }
    }
}

