/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.stage;

import io.vproxy.base.util.OS;
import io.vproxy.vfx.control.drag.DragHandler;
import io.vproxy.vfx.manager.font.FontManager;
import io.vproxy.vfx.manager.font.FontUsages;
import io.vproxy.vfx.theme.Theme;
import io.vproxy.vfx.ui.scene.VScene;
import io.vproxy.vfx.ui.scene.VSceneGroup;
import io.vproxy.vfx.ui.scene.VSceneGroupInitParams;
import io.vproxy.vfx.ui.scene.VSceneRole;
import io.vproxy.vfx.ui.stage.CloseButton;
import io.vproxy.vfx.ui.stage.IconifyButton;
import io.vproxy.vfx.ui.stage.MaxResetButton;
import io.vproxy.vfx.ui.stage.VStageInitParams;
import io.vproxy.vfx.util.FXUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class VStage {
    public static final int TITLE_BAR_HEIGHT = 28;
    private final Stage stage;
    private final Pane rootContainer = new Pane();
    private final VScene rootContent = new VScene(VSceneRole.MAIN){
        {
            this.enableAutoContentWidthHeight();
        }
    };
    private final VSceneGroup rootSceneGroup = new VSceneGroup(this.rootContent, new VSceneGroupInitParams().setUseClip(false));
    private final VScene content;
    private final VSceneGroup sceneGroup;
    private final Label title = new Label(){
        {
            FontManager.get().setFont(FontUsages.windowTitle, (Labeled)this);
            this.setTextFill((Paint)Theme.current().normalTextColor());
            this.setMouseTransparent(true);
        }
    };
    private final Circle resizeButton = new Circle(){
        {
            this.setStrokeWidth(0.0);
            this.setFill((Paint)Color.TRANSPARENT);
            this.setRadius(8.0);
            this.setCursor(Cursor.NW_RESIZE);
        }
    };
    private boolean maximized = false;
    private final MaxResetButton maxrstBtn;
    private double stageOriginalX;
    private double stageOriginalY;
    private double stageOriginalW;
    private double stageOriginalH;

    public VStage() {
        this(new VStageInitParams());
    }

    public VStage(VStageInitParams initParams) {
        this(new Stage(), initParams);
    }

    public VStage(Stage stage) {
        this(stage, new VStageInitParams());
    }

    public VStage(final Stage stage, VStageInitParams initParams) {
        this.stage = stage;
        stage.initStyle(StageStyle.TRANSPARENT);
        this.content = initParams.initialScene == null ? new VScene(VSceneRole.MAIN) : initParams.initialScene;
        this.sceneGroup = new VSceneGroup(this.content, new VSceneGroupInitParams().setGradientCover(true).setUseClip(false));
        Scene scene = new Scene((Parent)this.rootContainer);
        scene.setFill((Paint)Color.TRANSPARENT);
        stage.setScene(scene);
        this.rootSceneGroup.getNode().setLayoutX(0.5);
        this.rootSceneGroup.getNode().setLayoutY(0.5);
        FXUtils.makeClipFor(this.rootSceneGroup.getNode(), 8.0);
        stage.widthProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            double w = now.doubleValue();
            this.rootContainer.setPrefWidth(w);
            this.rootSceneGroup.getNode().setPrefWidth(w - 1.0);
        });
        stage.heightProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            double h = now.doubleValue();
            this.rootContainer.setPrefHeight(h);
            this.rootSceneGroup.getNode().setPrefHeight(h - 1.0);
        });
        this.rootContainer.setBackground(Background.EMPTY);
        this.useDefaultBorder();
        this.setBackground((Paint)Theme.current().sceneBackgroundColor());
        Pane movingPane = new Pane();
        movingPane.setPrefHeight(28.0);
        DragHandler moveWindowHandler = new DragHandler(){

            @Override
            protected void set(double x, double y) {
                if (VStage.this.maximized) {
                    return;
                }
                stage.setX(x);
                stage.setY(y);
            }

            @Override
            protected double[] get() {
                return new double[]{stage.getX(), stage.getY()};
            }
        };
        movingPane.setOnMousePressed((EventHandler)moveWindowHandler);
        movingPane.setOnMouseDragged((EventHandler)moveWindowHandler);
        this.rootContent.getContentPane().getChildren().add((Object)movingPane);
        CloseButton closeBtn = new CloseButton(this, initParams);
        if (initParams.closeButton) {
            this.rootContent.getContentPane().getChildren().add((Object)closeBtn);
        }
        this.maxrstBtn = new MaxResetButton(this, initParams);
        if (initParams.maximizeAndResetButton) {
            this.rootContent.getContentPane().getChildren().add((Object)this.maxrstBtn);
        }
        IconifyButton iconifyBtn = new IconifyButton(this, initParams);
        if (initParams.iconifyButton) {
            this.rootContent.getContentPane().getChildren().add((Object)iconifyBtn);
        }
        this.sceneGroup.getNode().setLayoutX(0.5);
        this.sceneGroup.getNode().setLayoutY(28.0);
        this.rootContent.getContentPane().getChildren().add((Object)this.sceneGroup.getNode());
        this.rootContent.getContentPane().getChildren().add((Object)this.title);
        DragHandler resizeHandler = new DragHandler(){

            @Override
            protected void set(double x, double y) {
                if (x < 256.0) {
                    x = 256.0;
                }
                if (y < 128.0) {
                    y = 128.0;
                }
                stage.setWidth(x);
                stage.setHeight(y);
            }

            @Override
            protected double[] get() {
                return new double[]{stage.getWidth(), stage.getHeight()};
            }
        };
        this.resizeButton.setOnMousePressed((EventHandler)resizeHandler);
        this.resizeButton.setOnMouseDragged((EventHandler)resizeHandler);
        this.title.textProperty().addListener((ob, old, now) -> this.updateTitlePosition());
        stage.widthProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            double w = now.doubleValue();
            double padRight = 0.0;
            double controlButtonsOffset = w - 0.0;
            if (initParams.closeButton) {
                closeBtn.setLayoutX(controlButtonsOffset -= 64.0);
            }
            if (initParams.maximizeAndResetButton) {
                this.maxrstBtn.setLayoutX(controlButtonsOffset -= 64.0);
            }
            if (initParams.iconifyButton) {
                iconifyBtn.setLayoutX(controlButtonsOffset -= 64.0);
            }
            movingPane.setPrefWidth(w);
            this.rootSceneGroup.getNode().setPrefWidth(w - 1.0);
            this.resizeButton.setLayoutX(w - 8.0);
            this.updateTitlePosition();
        });
        stage.heightProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            double h = now.doubleValue();
            this.rootSceneGroup.getNode().setPrefHeight(h - 1.0);
            this.resizeButton.setLayoutY(h - 8.0);
        });
        FXUtils.observeWidthHeight((Region)this.rootContent.getContentPane(), this.sceneGroup.getNode(), 0.0, -28.0);
        this.rootContainer.getChildren().add((Object)this.rootSceneGroup.getNode());
        if (initParams.resizable) {
            this.rootContainer.getChildren().add((Object)this.resizeButton);
        }
        stage.setOnCloseRequest(e -> this.close());
    }

    public void useDefaultBorder() {
        this.useLightBorder();
    }

    public void useLightBorder() {
        this.rootContainer.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Theme.current().windowBorderColorLight(), BorderStrokeStyle.SOLID, new CornerRadii(8.0), new BorderWidths(0.5))}));
    }

    public void useDarkBorder() {
        this.rootContainer.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Theme.current().windowBorderColorDark(), BorderStrokeStyle.SOLID, new CornerRadii(8.0), new BorderWidths(0.5))}));
    }

    private void updateTitlePosition() {
        if (this.title.getText() == null || this.title.getText().isBlank()) {
            this.title.setVisible(false);
            return;
        }
        this.title.setVisible(true);
        Rectangle2D bounds = FXUtils.calculateTextBounds(this.title);
        double tWidth = bounds.getWidth();
        double tHeight = bounds.getHeight();
        double sWidth = this.stage.getWidth();
        this.title.setLayoutX((sWidth - tWidth) / 2.0);
        this.title.setLayoutY((28.0 - tHeight) / 2.0);
    }

    public void setBackground(Paint paint) {
        this.rootSceneGroup.getNode().setBackground(new Background(new BackgroundFill[]{new BackgroundFill(paint, CornerRadii.EMPTY, Insets.EMPTY)}));
    }

    public Stage getStage() {
        return this.stage;
    }

    public VSceneGroup getRootSceneGroup() {
        return this.rootSceneGroup;
    }

    public VScene getRoot() {
        return this.rootContent;
    }

    public VSceneGroup getSceneGroup() {
        return this.sceneGroup;
    }

    public VScene getInitialScene() {
        return this.content;
    }

    public void setTitle(String title) {
        this.title.setText(title);
        this.stage.setTitle(title);
    }

    private boolean supportsIconify() {
        int v;
        String version;
        if (!OS.isMac()) {
            return true;
        }
        Pattern pattern = Pattern.compile("^(\\d+)(.*)$");
        Matcher matcher = pattern.matcher(version = System.getProperty("javafx.runtime.version", ""));
        if (!matcher.find() || matcher.groupCount() < 1) {
            return false;
        }
        try {
            v = Integer.parseInt(matcher.group(1));
        }
        catch (NumberFormatException e) {
            return false;
        }
        return v >= 17;
    }

    public void setIconified(boolean iconified) {
        if (this.supportsIconify()) {
            this.stage.setIconified(iconified);
        } else if (iconified) {
            this.stage.toBack();
        }
    }

    public void setMaximized(boolean maximized) {
        if (this.maximized == maximized) {
            return;
        }
        this.maximized = maximized;
        this.maxrstBtn.updateImage();
        if (OS.isMac()) {
            if (maximized) {
                this.stageOriginalX = this.stage.getX();
                this.stageOriginalY = this.stage.getY();
                this.stageOriginalW = this.stage.getWidth();
                this.stageOriginalH = this.stage.getHeight();
                Screen screen = FXUtils.getScreenOf((Window)this.stage);
                if (screen == null) {
                    return;
                }
                Rectangle2D bounds = screen.getBounds();
                this.stage.setX(bounds.getMinX());
                this.stage.setY(bounds.getMinY() + 24.0);
                this.stage.setWidth(bounds.getWidth());
                this.stage.setHeight(bounds.getHeight() - 24.0);
            } else {
                this.stage.setX(this.stageOriginalX);
                this.stage.setY(this.stageOriginalY);
                this.stage.setWidth(this.stageOriginalW);
                this.stage.setHeight(this.stageOriginalH);
            }
        } else {
            this.stage.setMaximized(maximized);
        }
    }

    public boolean isMaximized() {
        return this.maximized;
    }

    public void close() {
        this.stage.close();
    }

    public void show() {
        this.stage.show();
    }

    public void showAndWait() {
        this.stage.showAndWait();
    }

    public void temporaryOnTop() {
        if (this.stage.isAlwaysOnTop()) {
            return;
        }
        this.stage.setAlwaysOnTop(true);
        FXUtils.runDelay(500, () -> this.stage.setAlwaysOnTop(false));
    }
}

