/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.table;

import io.vproxy.vfx.ui.table.VTableRow;
import io.vproxy.vfx.ui.table.VTableSharedData;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.StackPane;

public class VTableCellPane<S>
extends StackPane {
    private final VTableRow<S> row;
    final ChangeListener<? super Number> heightWatcher = (ob, old, now) -> {
        if (now == null) {
            return;
        }
        double dNow = now.doubleValue();
        double thisHeight = this.getHeight();
        if (thisHeight < dNow) {
            this.setPrefHeight(dNow);
        }
    };
    private Background backgroundSetByUser = null;

    public VTableCellPane(Node node, VTableRow<S> row, VTableSharedData<S> shared) {
        this.row = row;
        if (node != null) {
            this.getChildren().add((Object)node);
        }
        this.setMinHeight(30.0);
        this.setAlignment(Pos.CENTER_LEFT);
        this.setPadding(new Insets(2.0, 5.0, 2.0, 5.0));
        this.setOnMouseClicked(e -> shared.tableView.selectRow(row));
    }

    public void resetBg() {
        this.backgroundSetByUser = null;
        this.row.setBgColor();
    }

    void setBackground0(Background bg) {
        if (this.backgroundSetByUser != null) {
            this.setBackground(this.backgroundSetByUser);
        } else {
            this.setBackground(bg);
        }
    }

    public void setBg(Background bg) {
        this.backgroundSetByUser = bg;
        this.row.setBgColor();
    }
}

