/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.table;

import io.vproxy.vfx.manager.font.FontManager;
import io.vproxy.vfx.manager.font.FontUsages;
import io.vproxy.vfx.theme.Theme;
import io.vproxy.vfx.ui.layout.HPadding;
import io.vproxy.vfx.ui.table.VTableCellPane;
import io.vproxy.vfx.ui.table.VTableSharedData;
import io.vproxy.vfx.ui.table.VTableSortOrder;
import io.vproxy.vfx.util.FXUtils;
import java.util.Comparator;
import java.util.function.Function;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;

public class VTableColumn<S, T> {
    private static final Color COLOR_TOP = Theme.current().tableHeaderTopBackgroundColor();
    private static final Color COLOR_BOT = Theme.current().tableHeaderBottomBackgroundColor();
    static final Background BG = new Background(new BackgroundFill[]{new BackgroundFill((Paint)new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, COLOR_TOP), new Stop(1.0, COLOR_BOT)}), CornerRadii.EMPTY, Insets.EMPTY)});
    private static final int sortWidth = 15;
    public final String name;
    final Function<S, T> valueRetriever;
    Comparator<T> comparator;
    final HBox columnNode = new HBox();
    private final Label sortLabel;
    Function<T, ? extends Node> nodeBuilder = null;
    VTableSharedData<S> shared;
    final VBox vbox = new VBox();
    double minWidth = 0.0;
    double maxWidth = 0.0;
    double prefWidth = 0.0;
    Pos alignment;
    private int sortPriority = 0;
    private VTableSortOrder sortOrder = VTableSortOrder.DESC;

    public VTableColumn(String name, Function<S, T> valueRetriever) {
        this(name, (Region)new Label(name){
            {
                this.setAlignment(Pos.CENTER);
                this.setTextFill((Paint)Theme.current().tableHeaderTextColor());
                this.setPrefHeight(25.0);
            }
        }, valueRetriever);
    }

    public VTableColumn(String name, Region columnContentNode, Function<S, T> valueRetriever) {
        this.name = name;
        this.valueRetriever = valueRetriever;
        this.sortLabel = new Label(){
            {
                this.setPadding(new Insets(0.0, 4.0, 0.0, 4.0));
                this.setPrefWidth(15.0);
                this.setTextFill((Paint)Theme.current().tableSortLabelColor());
            }
        };
        this.columnNode.getChildren().addAll((Object[])new Node[]{new HPadding(15.0), columnContentNode, this.sortLabel});
        this.columnNode.setBackground(BG);
        FXUtils.observeHeight(columnContentNode, (Region)this.columnNode);
        this.columnNode.setAlignment(Pos.CENTER);
        this.columnNode.setOnMouseClicked(e -> {
            if (this.comparator == null) {
                if (this.sortPriority != 0) {
                    this.shared.tableView.clearSort(this);
                }
                return;
            }
            if (this.shared != null) {
                if (this.sortPriority != 0 && this.sortOrder == VTableSortOrder.DESC) {
                    this.shared.tableView.clearSort(this);
                } else {
                    this.shared.tableView.sortBy(this, this.sortOrder == VTableSortOrder.ASC ? VTableSortOrder.DESC : VTableSortOrder.ASC);
                }
            }
        });
        this.columnNode.widthProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            columnContentNode.setPrefWidth(now.doubleValue() - 30.0);
        });
        this.vbox.widthProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            this.columnNode.setPrefWidth(now.doubleValue());
            this.columnNode.setMinWidth(now.doubleValue());
            this.columnNode.setMaxWidth(now.doubleValue());
        });
    }

    public void setComparator(Comparator<T> comparator) {
        this.comparator = comparator;
        if (this.sortPriority > 0 && this.shared != null) {
            if (comparator == null) {
                this.shared.tableView.clearSort(this);
            } else {
                this.shared.tableView.sort();
            }
        }
    }

    public void setMinWidth(double minWidth) {
        this.minWidth = minWidth;
        if (this.shared != null) {
            this.shared.tableView.updateWidth();
        }
    }

    public void setMaxWidth(double maxWidth) {
        this.maxWidth = maxWidth;
        if (this.shared != null) {
            this.shared.tableView.updateWidth();
        }
    }

    public void setPrefWidth(double prefWidth) {
        this.prefWidth = prefWidth;
        if (this.shared != null) {
            this.shared.tableView.updateWidth();
        }
    }

    public void setAlignment(Pos alignment) {
        this.alignment = alignment;
        if (this.shared != null) {
            this.shared.tableView.updateRowNodeForColumn(this);
        }
    }

    public void setTextBuilder(Function<T, String> textBuilder) {
        this.setNodeBuilder(t -> {
            String str = (String)textBuilder.apply(t);
            return new Label(str){
                {
                    this.setTextFill((Paint)Theme.current().tableTextColor());
                    FontManager.get().setFont(FontUsages.tableCellText, (Labeled)this);
                }
            };
        });
    }

    public void setNodeBuilder(Function<T, ? extends Node> nodeBuilder) {
        this.nodeBuilder = nodeBuilder;
        if (this.shared != null) {
            this.shared.tableView.refresh();
        }
    }

    void initCell(VTableCellPane<S> cell) {
        if (this.alignment != null) {
            cell.setAlignment(this.alignment);
        }
    }

    public int getSortPriority() {
        return this.sortPriority;
    }

    public VTableSortOrder getSortOrder() {
        return this.sortOrder;
    }

    void setSort(int priority, VTableSortOrder order) {
        this.sortPriority = priority;
        this.sortOrder = order;
        this.updateSortLabel();
    }

    private void updateSortLabel() {
        if (this.sortPriority == 0) {
            this.sortLabel.setText("");
            return;
        }
        if (this.sortOrder == VTableSortOrder.ASC) {
            this.sortLabel.setRotate(0.0);
            this.sortLabel.setAlignment(Pos.CENTER_RIGHT);
        } else {
            this.sortLabel.setRotate(180.0);
            this.sortLabel.setAlignment(Pos.CENTER_LEFT);
        }
        this.sortLabel.setText("" + this.sortPriority);
    }

    void resetSortOrder() {
        this.sortOrder = VTableSortOrder.DESC;
    }

    void resetSortPriority() {
        this.sortPriority = 0;
        this.sortLabel.setText("");
    }

    void decSortPriority() {
        --this.sortPriority;
        this.updateSortLabel();
    }
}

