/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.table;

import io.vproxy.vfx.manager.font.FontManager;
import io.vproxy.vfx.manager.font.FontUsages;
import io.vproxy.vfx.theme.Theme;
import io.vproxy.vfx.ui.table.CellAware;
import io.vproxy.vfx.ui.table.RowInformer;
import io.vproxy.vfx.ui.table.RowInformerAware;
import io.vproxy.vfx.ui.table.VTableCellPane;
import io.vproxy.vfx.ui.table.VTableColumn;
import io.vproxy.vfx.ui.table.VTableSharedData;
import io.vproxy.vfx.util.FXUtils;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class VTableRow<S>
implements RowInformer {
    private static final Color COLOR_SELECTED = Theme.current().tableCellSelectedBackgroundColor();
    private static final Color COLOR_1 = Theme.current().tableCellBackgroundColor1();
    private static final Color COLOR_2 = Theme.current().tableCellBackgroundColor2();
    private static final Background BG_SELECTED = new Background(new BackgroundFill[]{new BackgroundFill((Paint)COLOR_SELECTED, CornerRadii.EMPTY, Insets.EMPTY)});
    private static final Background BG_1 = new Background(new BackgroundFill[]{new BackgroundFill((Paint)COLOR_1, CornerRadii.EMPTY, Insets.EMPTY)});
    private static final Background BG_2 = new Background(new BackgroundFill[]{new BackgroundFill((Paint)COLOR_2, CornerRadii.EMPTY, Insets.EMPTY)});
    final long rowId;
    final S item;
    final VTableSharedData<S> shared;
    final ObservableList<VTableCellPane<S>> nodes = FXCollections.observableArrayList();
    private boolean selected = false;

    VTableRow(S item, VTableSharedData<S> shared) {
        this.rowId = ++shared.rowAdder;
        this.item = item;
        this.shared = shared;
        if (item instanceof RowInformerAware) {
            ((RowInformerAware)item).setRowInformer(this);
        }
        this.nodes.addListener(c -> {
            while (c.next()) {
                List added = c.getAddedSubList();
                List removed = c.getRemoved();
                for (VTableCellPane r : removed) {
                    for (VTableCellPane n : this.nodes) {
                        n.heightProperty().removeListener(r.heightWatcher);
                    }
                }
                for (VTableCellPane a : added) {
                    for (VTableCellPane n : this.nodes) {
                        if (a == n) continue;
                        n.heightProperty().addListener(a.heightWatcher);
                        a.heightProperty().addListener(n.heightWatcher);
                    }
                }
            }
        });
    }

    public void add() {
        ObservableList columns = this.shared.tableView.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            VTableColumn col = (VTableColumn)columns.get(i);
            col.vbox.getChildren().add((Object)((Node)this.nodes.get(i)));
        }
    }

    public void add(int index) {
        ObservableList columns = this.shared.tableView.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            VTableColumn col = (VTableColumn)columns.get(i);
            col.vbox.getChildren().add(index, (Object)((Node)this.nodes.get(i)));
        }
    }

    public void remove() {
        ObservableList columns = this.shared.tableView.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            VTableColumn col = (VTableColumn)columns.get(i);
            col.vbox.getChildren().remove(this.nodes.get(i));
        }
    }

    public void removeCol(int index) {
        this.nodes.remove(index);
    }

    public void addCol(int index, VTableColumn<S, ?> col) {
        VTableCellPane<S> cell = new VTableCellPane<S>(this.buildNode(col), this, this.shared);
        this.nodes.add(index, cell);
        if (this.item instanceof CellAware) {
            ((CellAware)this.item).setCell(col, cell);
        }
    }

    public void setCols(List<VTableColumn<S, ?>> cols) {
        this.nodes.clear();
        for (VTableColumn<S, ?> col : cols) {
            VTableCellPane<S> cell = this.buildCell(col);
            this.nodes.add(cell);
        }
    }

    public void updateRowNodeForColumn(VTableColumn<S, ?> col) {
        int rowIndex = this.shared.tableView.items.indexOf((Object)this);
        int colIndex = this.shared.tableView.getColumns().indexOf(col);
        VTableCellPane n = (VTableCellPane)((Object)this.nodes.remove(colIndex));
        col.vbox.getChildren().remove((Object)n);
        VTableCellPane<S> cell = this.buildCell(col);
        this.nodes.add(colIndex, cell);
        col.vbox.getChildren().add(rowIndex, cell);
    }

    private VTableCellPane<S> buildCell(VTableColumn<S, ?> col) {
        VTableCellPane<S> cell = new VTableCellPane<S>(this.buildNode(col), this, this.shared);
        if (this.item instanceof CellAware) {
            ((CellAware)this.item).setCell(col, cell);
        }
        col.initCell(cell);
        return cell;
    }

    private Node buildNode(VTableColumn<S, ?> col) {
        Object v = col.valueRetriever.apply(this.item);
        if (col.nodeBuilder == null) {
            if (v == null) {
                return new Label();
            }
            return new Label(v.toString()){
                {
                    this.setTextFill((Paint)Theme.current().tableTextColor());
                    FontManager.get().setFont(FontUsages.tableCellText, (Labeled)this);
                }
            };
        }
        return col.nodeBuilder.apply(v);
    }

    @Override
    public void informRowUpdate() {
        FXUtils.runOnFX(this::informRowUpdate0);
    }

    private void informRowUpdate0() {
        for (int i = 0; i < this.shared.tableView.getColumns().size(); ++i) {
            VTableColumn col = (VTableColumn)this.shared.tableView.getColumns().get(i);
            Node node = this.buildNode(col);
            VTableCellPane pane = (VTableCellPane)((Object)this.nodes.get(i));
            pane.getChildren().clear();
            if (node == null) continue;
            pane.getChildren().add((Object)node);
        }
    }

    public void updateColWidth(int i, double w) {
        ((VTableCellPane)((Object)this.nodes.get(i))).setPrefWidth(w);
        ((VTableCellPane)((Object)this.nodes.get(i))).setMinWidth(w);
        ((VTableCellPane)((Object)this.nodes.get(i))).setMaxWidth(w);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        if (selected) {
            this.setBgColor(-1);
        }
    }

    public void setBgColor() {
        int rowIndex = this.shared.tableView.items.indexOf((Object)this);
        this.setBgColor(rowIndex);
    }

    public void setBgColor(int rowNumber) {
        for (VTableCellPane n : this.nodes) {
            if (this.selected) {
                n.setBackground(BG_SELECTED);
                continue;
            }
            if (rowNumber % 2 == 0) {
                n.setBackground0(BG_1);
                continue;
            }
            n.setBackground0(BG_2);
        }
    }
}

