/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.table;

import io.vproxy.vfx.ui.table.VTableRow;
import io.vproxy.vfx.ui.table.VTableRowIteratorDelegate;
import io.vproxy.vfx.ui.table.VTableSharedData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;

public class VTableRowListDelegate<E>
implements List<E> {
    private final List<VTableRow<E>> ls;
    private final VTableSharedData<E> shared;

    public VTableRowListDelegate(List<VTableRow<E>> ls, VTableSharedData<E> shared) {
        this.ls = ls;
        this.shared = shared;
    }

    @Override
    public int size() {
        return this.ls.size();
    }

    @Override
    public boolean isEmpty() {
        return this.ls.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.ls.stream().anyMatch(e -> Objects.equals(e.item, o));
    }

    @Override
    public Iterator<E> iterator() {
        return new VTableRowIteratorDelegate<E>(this.ls.listIterator(), this.shared);
    }

    @Override
    public Object[] toArray() {
        return this.ls.stream().map(s -> s.item).toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.ls.stream().map(s -> s.item).collect(Collectors.toList()).toArray(a);
    }

    @Override
    public boolean add(E e) {
        this.ls.add(new VTableRow<E>(e, this.shared));
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index == -1) {
            return false;
        }
        this.ls.remove(index);
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.ls.stream().map(e -> e.item).collect(Collectors.toSet()).containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        ArrayList<VTableRow<E>> all = new ArrayList<VTableRow<E>>(c.size());
        for (E e : c) {
            all.add(new VTableRow<E>(e, this.shared));
        }
        return this.ls.addAll(all);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        ArrayList<VTableRow<E>> all = new ArrayList<VTableRow<E>>(c.size());
        for (E e : c) {
            all.add(new VTableRow<E>(e, this.shared));
        }
        return this.ls.addAll(index, all);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.ls.removeIf(e -> c.contains(e.item));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.ls.removeIf(e -> !c.contains(e.item));
    }

    @Override
    public void clear() {
        this.ls.clear();
    }

    @Override
    public E get(int index) {
        return (E)this.ls.get((int)index).item;
    }

    @Override
    public E set(int index, E element) {
        return (E)this.ls.set((int)index, new VTableRow<E>(element, this.shared)).item;
    }

    @Override
    public void add(int index, E element) {
        this.ls.add(index, new VTableRow<E>(element, this.shared));
    }

    @Override
    public E remove(int index) {
        return (E)this.ls.remove((int)index).item;
    }

    @Override
    public int indexOf(Object o) {
        int index = -1;
        for (int i = 0; i < this.ls.size(); ++i) {
            VTableRow<E> e = this.ls.get(i);
            if (!Objects.equals(e.item, o)) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public int lastIndexOf(Object o) {
        int index = -1;
        for (int i = this.ls.size() - 1; i >= 0; --i) {
            VTableRow<E> e = this.ls.get(i);
            if (!Objects.equals(e.item, o)) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new VTableRowIteratorDelegate<E>(this.ls.listIterator(), this.shared);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new VTableRowIteratorDelegate<E>(this.ls.listIterator(index), this.shared);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.ls.subList(fromIndex, toIndex).stream().map(e -> e.item).collect(Collectors.toList());
    }
}

