/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.table;

import io.vproxy.vfx.control.scroll.NodeWithVScrollPane;
import io.vproxy.vfx.control.scroll.VScrollPane;
import io.vproxy.vfx.manager.font.FontManager;
import io.vproxy.vfx.manager.font.FontUsages;
import io.vproxy.vfx.manager.internal_i18n.InternalI18n;
import io.vproxy.vfx.theme.Theme;
import io.vproxy.vfx.ui.table.VTableColumn;
import io.vproxy.vfx.ui.table.VTableRow;
import io.vproxy.vfx.ui.table.VTableRowListDelegate;
import io.vproxy.vfx.ui.table.VTableSharedData;
import io.vproxy.vfx.ui.table.VTableSortOrder;
import io.vproxy.vfx.util.FXUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class VTableView<S>
implements NodeWithVScrollPane {
    private final Pane root = new Pane();
    private final VBox rootVBox = new VBox();
    final HBox columnPane = new HBox();
    private final Pane fixColumnWidthColum = new Pane(){
        {
            this.setBackground(VTableColumn.BG);
            this.setPrefWidth(0.0);
        }
    };
    private final VScrollPane scrollPane = new VScrollPane();
    private final HBox dataPane = new HBox();
    private final Label emptyTableLabel = new Label(InternalI18n.get().emptyTableLabel()){
        {
            FontManager.get().setFont(FontUsages.tableEmptyTableLabel, (Labeled)this);
            this.setTextFill((Paint)Theme.current().tableTextColor());
            this.setAlignment(Pos.CENTER);
            this.setTextFill((Paint)Color.GRAY);
        }
    };
    private final VTableSharedData<S> shared = new VTableSharedData(this);
    private final ObservableList<VTableColumn<S, ?>> columns = FXCollections.observableArrayList();
    private final ArrayList<VTableColumn<S, ?>> lastColumns = new ArrayList();
    final ObservableList<VTableRow<S>> items = FXCollections.observableArrayList();
    private final VTableRowListDelegate<S> itemsDelegate = new VTableRowListDelegate<S>(this.items, this.shared);
    private VTableRow<S> selectedRow = null;
    private final ListChangeListener<VTableColumn<S, ?>> colsListener = c -> {
        while (c.next()) {
            int index;
            List added = c.getAddedSubList();
            List removed = c.getRemoved();
            for (int i = removed.size() - 1; i >= 0; --i) {
                VTableColumn col = (VTableColumn)removed.get(i);
                index = this.lastColumns.indexOf(col);
                this.lastColumns.remove(index);
                assert (index != -1);
                for (VTableRow row : this.items) {
                    row.removeCol(index);
                }
                this.dataPane.getChildren().remove(index);
                this.columnPane.getChildren().remove(index);
                this.clearSort(col);
                col.shared = null;
            }
            for (VTableColumn col : added) {
                index = this.columns.indexOf((Object)col);
                this.lastColumns.add(index, col);
                for (VTableRow row : this.items) {
                    row.addCol(index, col);
                }
                this.dataPane.getChildren().add(index, (Object)col.vbox);
                this.columnPane.getChildren().add(index, (Object)col.columnNode);
                col.shared = this.shared;
            }
        }
        this.updateWidth();
    };
    private final ListChangeListener<VTableRow<S>> itemsListener = c -> {
        while (c.next()) {
            List added = c.getAddedSubList();
            List removed = c.getRemoved();
            for (VTableRow row : removed) {
                row.remove();
            }
            for (VTableRow row : added) {
                row.setCols(this.columns);
                int index = this.items.indexOf((Object)row);
                row.add(index);
            }
        }
        for (int i = 0; i < this.items.size(); ++i) {
            VTableRow row = (VTableRow)this.items.get(i);
            row.setBgColor(i);
        }
        if (this.items.isEmpty()) {
            this.scrollPane.setContent((Node)this.emptyTableLabel);
        } else {
            this.scrollPane.setContent((Node)this.dataPane);
            this.updateWidth();
        }
        boolean hasSort = false;
        for (VTableColumn col : this.columns) {
            if (col.getSortPriority() <= 0) continue;
            hasSort = true;
            break;
        }
        if (hasSort) {
            this.sort();
        }
    };

    public VTableView() {
        this.scrollPane.setContent((Node)this.emptyTableLabel);
        this.columns.addListener(this.colsListener);
        this.items.addListener(this.itemsListener);
        this.root.getChildren().add((Object)this.rootVBox);
        FXUtils.observeWidthHeightWithPreferred((Region)this.root, (Region)this.rootVBox);
        HBox columnPane = new HBox();
        this.rootVBox.getChildren().addAll((Object[])new Node[]{columnPane, this.scrollPane.getNode()});
        ChangeListener rootVBoxWidthChange = (ob, old, now) -> {
            if (now == null) {
                return;
            }
            this.scrollPane.getNode().setPrefWidth(now.doubleValue());
            if (this.rootVBox.getPrefWidth() != 0.0) {
                this.updateWidth(this.rootVBox.getPrefWidth());
            } else {
                this.updateWidth();
            }
            this.columnWidthFix();
        };
        this.rootVBox.widthProperty().addListener(rootVBoxWidthChange);
        this.rootVBox.prefWidthProperty().addListener(rootVBoxWidthChange);
        this.columnPane.widthProperty().addListener((ob, old, now) -> this.columnWidthFix());
        this.scrollPane.getNode().widthProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            this.emptyTableLabel.setPrefWidth(now.doubleValue());
            this.columnWidthFix();
        });
        this.scrollPane.getNode().heightProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            this.emptyTableLabel.setPrefHeight(now.doubleValue() - 10.0);
        });
        this.rootVBox.heightProperty().addListener((ob, old, now) -> this.scrollPane.getNode().setPrefHeight(this.rootVBox.getHeight() - columnPane.getHeight()));
        columnPane.heightProperty().addListener((ob, old, now) -> this.scrollPane.getNode().setPrefHeight(this.rootVBox.getHeight() - columnPane.getHeight()));
        columnPane.getChildren().addAll((Object[])new Node[]{this.columnPane, this.fixColumnWidthColum});
        FXUtils.makeTopOnlyRoundedClipFor((Region)columnPane, 4.0);
        FXUtils.makeBottomOnlyRoundedClipFor((Region)this.dataPane, 4.0);
    }

    public Region getNode() {
        return this.root;
    }

    public ObservableList<VTableColumn<S, ?>> getColumns() {
        return this.columns;
    }

    public List<S> getItems() {
        return this.itemsDelegate;
    }

    public void setItems(List<S> items) {
        this.items.removeListener(this.itemsListener);
        this.items.clear();
        for (S item : items) {
            VTableRow<S> row = new VTableRow<S>(item, this.shared);
            row.setCols((List<VTableColumn<S, ?>>)this.columns);
            this.items.add(row);
        }
        this.items.addListener(this.itemsListener);
        this.sort();
        this.updateWidth();
        if (items.isEmpty()) {
            this.scrollPane.setContent((Node)this.emptyTableLabel);
        } else {
            this.scrollPane.setContent((Node)this.dataPane);
        }
    }

    private void columnWidthFix() {
        double columnW = this.columnPane.getWidth();
        double scrollW = this.scrollPane.getNode().getWidth();
        if (scrollW > columnW) {
            this.fixColumnWidthColum.setPrefWidth(scrollW - columnW);
        } else {
            this.fixColumnWidthColum.setPrefWidth(0.0);
        }
    }

    void updateWidth() {
        this.updateWidth(this.scrollPane.getNode().getWidth());
    }

    private void updateWidth(double width) {
        if (width <= 0.0) {
            return;
        }
        if (this.columns.isEmpty()) {
            return;
        }
        Map<VTableColumn<S, ?>, Double> plan = this.buildUpdateWithPrefWidthPlan(width);
        if (plan != null) {
            this.updateWidth(plan);
            return;
        }
        plan = this.buildUpdateAvgConsiderMinMaxPlan(width);
        if (plan != null) {
            this.updateWidth(plan);
            return;
        }
        plan = this.buildAvgPlan(width);
        this.updateWidth(plan);
    }

    private Map<VTableColumn<S, ?>, Double> buildUpdateWithPrefWidthPlan(double width) {
        HashMap ret = new HashMap();
        ArrayList prefWCols = new ArrayList();
        double remain = width;
        int remainCnt = this.columns.size();
        for (VTableColumn c : this.columns) {
            if (!(c.prefWidth > 0.0)) continue;
            remain -= c.prefWidth;
            ret.put(c, c.prefWidth);
            prefWCols.add(c);
            --remainCnt;
        }
        if (remain < 0.0) {
            return null;
        }
        if (prefWCols.size() == this.columns.size()) {
            return ret;
        }
        return this.buildUpdateAvgConsiderMinMaxPlan(ret, prefWCols, remain, remainCnt);
    }

    private Map<VTableColumn<S, ?>, Double> buildUpdateAvgConsiderMinMaxPlan(double width) {
        HashMap ret = new HashMap();
        return this.buildUpdateAvgConsiderMinMaxPlan(ret, Collections.emptyList(), width, this.columns.size());
    }

    private Map<VTableColumn<S, ?>, Double> buildUpdateAvgConsiderMinMaxPlan(HashMap<VTableColumn<S, ?>, Double> ret, List<VTableColumn<S, ?>> prefWCols, double remain, int remainCnt) {
        ArrayList<VTableColumn> exceedsMax0;
        ArrayList<VTableColumn> exceedsMin0;
        ArrayList exceedsMin = new ArrayList();
        ArrayList exceedsMax = new ArrayList();
        double avg = remain / (double)remainCnt;
        do {
            exceedsMin0 = new ArrayList<VTableColumn>();
            exceedsMax0 = new ArrayList<VTableColumn>();
            for (VTableColumn c : this.columns) {
                if (prefWCols.contains(c) || exceedsMin.contains(c) || exceedsMax.contains(c)) continue;
                if (c.minWidth > 0.0 && c.minWidth > avg) {
                    if (remain < c.minWidth) {
                        return null;
                    }
                    remain -= c.minWidth;
                    --remainCnt;
                    exceedsMin0.add(c);
                    ret.put(c, c.minWidth);
                    continue;
                }
                if (!(c.maxWidth > 0.0) || !(c.maxWidth < avg)) continue;
                if (remain < c.maxWidth) {
                    return null;
                }
                remain -= c.maxWidth;
                --remainCnt;
                exceedsMax0.add(c);
                ret.put(c, c.maxWidth);
            }
            exceedsMin.addAll(exceedsMin0);
            exceedsMax.addAll(exceedsMax0);
            if (remainCnt == 0) {
                return ret;
            }
            avg = remain / (double)remainCnt;
        } while (exceedsMin0.size() != 0 || exceedsMax0.size() != 0);
        for (VTableColumn c : this.columns) {
            if (prefWCols.contains(c) || exceedsMin.contains(c) || exceedsMax.contains(c)) continue;
            ret.put(c, avg);
        }
        return ret;
    }

    private Map<VTableColumn<S, ?>, Double> buildAvgPlan(double width) {
        double avg = width / (double)this.columns.size();
        HashMap ret = new HashMap();
        for (VTableColumn c : this.columns) {
            ret.put(c, avg);
        }
        return ret;
    }

    private void updateWidth(Map<VTableColumn<S, ?>, Double> plan) {
        for (int i = 0; i < this.columns.size(); ++i) {
            VTableColumn c = (VTableColumn)this.columns.get(i);
            Double w = plan.get(c);
            assert (w != null);
            if (this.items.isEmpty()) {
                c.columnNode.setPrefWidth(w.doubleValue());
            }
            for (VTableRow row : this.items) {
                row.updateColWidth(i, w);
            }
        }
    }

    void refresh() {
        for (VTableColumn c : this.columns) {
            c.vbox.getChildren().clear();
        }
        for (int i = 0; i < this.items.size(); ++i) {
            VTableRow row = (VTableRow)this.items.get(i);
            row.add();
            row.setBgColor(i);
        }
    }

    void updateRowNodeForColumn(VTableColumn<S, ?> col) {
        for (VTableRow row : this.items) {
            row.updateRowNodeForColumn(col);
        }
    }

    void selectRow(VTableRow<S> r) {
        int index;
        if (this.selectedRow != null && (index = this.items.indexOf(this.selectedRow)) != -1) {
            this.selectedRow.setSelected(false);
            this.selectedRow.setBgColor(index);
        }
        r.setSelected(true);
        this.selectedRow = r;
    }

    public S getSelectedItem() {
        if (this.selectedRow == null) {
            return null;
        }
        if (!this.items.contains(this.selectedRow)) {
            return null;
        }
        return this.selectedRow.item;
    }

    public void sortBy(VTableColumn<S, ?> c, VTableSortOrder order) {
        if (c.comparator == null) {
            return;
        }
        if (c.getSortPriority() == 0) {
            int p = 0;
            for (VTableColumn col : this.columns) {
                if (col.getSortPriority() <= p) continue;
                p = col.getSortPriority();
            }
            c.setSort(++p, order);
        } else {
            c.setSort(c.getSortPriority(), order);
        }
        this.sort();
    }

    public void clearSort(VTableColumn<S, ?> c) {
        c.resetSortOrder();
        if (c.getSortPriority() == 0) {
            return;
        }
        for (VTableColumn col : this.columns) {
            if (col == c || col.getSortPriority() < c.getSortPriority()) continue;
            col.decSortPriority();
        }
        c.resetSortPriority();
        this.sort();
    }

    void sort() {
        List cols = new ArrayList(this.columns).stream().filter(c -> c.getSortPriority() > 0 && c.comparator != null).sorted(Comparator.comparingInt(VTableColumn::getSortPriority)).collect(Collectors.toList());
        ArrayList<VTableRow<S>> tmp = new ArrayList<VTableRow<S>>(this.items);
        tmp.sort((a, b) -> {
            for (VTableColumn c : cols) {
                Object vb;
                Object va = c.valueRetriever.apply(a.item);
                int res = c.comparator.compare(va, vb = c.valueRetriever.apply(b.item));
                if (res == 0) continue;
                if (c.getSortOrder() == VTableSortOrder.ASC) {
                    return res;
                }
                return -res;
            }
            return Long.compare(a.rowId, b.rowId);
        });
        this.items.removeListener(this.itemsListener);
        this.items.clear();
        this.items.addAll(tmp);
        this.items.addListener(this.itemsListener);
        this.refresh();
    }

    @Override
    public VScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @Override
    public Region getSelfNode() {
        return this.getNode();
    }
}

