/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.toggle;

import io.vproxy.vfx.animation.AnimationGraph;
import io.vproxy.vfx.animation.AnimationGraphBuilder;
import io.vproxy.vfx.animation.AnimationNode;
import io.vproxy.vfx.control.click.ClickEventHandler;
import io.vproxy.vfx.theme.Theme;
import io.vproxy.vfx.ui.shapes.VLine;
import io.vproxy.vfx.util.algebradata.ColorData;
import io.vproxy.vfx.util.algebradata.DoubleData;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;

public class ToggleSwitch {
    public final double buttonRadius;
    public final double trayLength;
    private final Pane root = new Pane();
    private final Circle button;
    private boolean selected = false;
    private final AnimationNode<ColorData> unselectedColorNode;
    private final AnimationNode<ColorData> unselectedHoverColorNode;
    private final AnimationNode<ColorData> selectedColorNode;
    private final AnimationGraph<ColorData> colorAnimation;
    private final AnimationNode<DoubleData> unselectedPosNode;
    private final AnimationNode<DoubleData> selectedPosNode;
    private final AnimationGraph<DoubleData> posAnimation;
    private final AnimationNode<ColorData> trayUnselectedNode;
    private final AnimationNode<ColorData> traySelectedNode;
    private final AnimationGraph<ColorData> trayAnimation;
    private final BooleanPropertyBase selectedProperty = new BooleanPropertyBase(){

        protected void invalidated() {
            ToggleSwitch.this.setSelected(ToggleSwitch.this.selectedProperty.get());
        }

        public Object getBean() {
            return ToggleSwitch.this;
        }

        public String getName() {
            return "selectedProperty";
        }
    };

    public ToggleSwitch() {
        this(15.0, 60.0);
    }

    public ToggleSwitch(double radius, double length) {
        if (length < radius * 2.0) {
            throw new IllegalArgumentException("length = " + length + " < radius = " + radius);
        }
        this.buttonRadius = radius;
        this.trayLength = length;
        this.root.setPrefWidth(radius + length + radius);
        this.root.setPrefHeight(radius * 2.0);
        this.root.setMinWidth(radius + length + radius);
        this.root.setMinHeight(radius * 2.0);
        this.root.setMaxWidth(radius + length + radius);
        this.root.setMaxHeight(radius * 2.0);
        this.button = new Circle(radius);
        this.button.setStrokeWidth(0.5);
        this.button.setStroke((Paint)Theme.current().toggleSwitchBorderColor());
        this.button.setCursor(Cursor.HAND);
        this.button.setLayoutY(radius);
        VLine tray = new VLine(2.0);
        tray.setEndX(length);
        tray.setLayoutX(radius);
        tray.setLayoutY(radius);
        tray.setCursor(Cursor.HAND);
        this.root.getChildren().addAll((Object[])new Node[]{tray, this.button});
        this.unselectedColorNode = new AnimationNode<ColorData>("unselected", new ColorData(Theme.current().toggleSwitchUnselectedButtonColor()));
        this.unselectedHoverColorNode = new AnimationNode<ColorData>("hover", new ColorData(Theme.current().toggleSwitchUnselectedButtonHoverColor()));
        this.selectedColorNode = new AnimationNode<ColorData>("selected", new ColorData(Theme.current().toggleSwitchSelectedButtonColor()));
        this.colorAnimation = new AnimationGraphBuilder<ColorData>().addNode(this.unselectedColorNode).addNode(this.unselectedHoverColorNode).addNode(this.selectedColorNode).addTwoWayEdge(this.unselectedColorNode, this.unselectedHoverColorNode, 150L).addTwoWayEdge(this.unselectedColorNode, this.selectedColorNode, 150L).addEdge(this.unselectedHoverColorNode, this.selectedColorNode, 150L).setApply((from, to, d) -> this.button.setFill((Paint)d.getColor())).build(this.unselectedColorNode);
        this.unselectedPosNode = new AnimationNode<DoubleData>("unselected", new DoubleData(radius));
        this.selectedPosNode = new AnimationNode<DoubleData>("selected", new DoubleData(radius + length));
        this.posAnimation = AnimationGraphBuilder.simpleTwoNodeGraph(this.unselectedPosNode, this.selectedPosNode, 150L).setApply((from, to, d) -> this.button.setLayoutX(d.value)).build(this.unselectedPosNode);
        this.trayUnselectedNode = new AnimationNode<ColorData>("unselected", new ColorData(Theme.current().toggleSwitchUnselectedTrayColor()));
        this.traySelectedNode = new AnimationNode<ColorData>("selected", new ColorData(Theme.current().toggleSwitchSelectedTrayColor()));
        this.trayAnimation = AnimationGraphBuilder.simpleTwoNodeGraph(this.trayUnselectedNode, this.traySelectedNode, 150L).setApply((from, to, d) -> tray.setStroke((Paint)d.getColor())).build(this.trayUnselectedNode);
        ClickEventHandler clickHandler = new ClickEventHandler(){

            @Override
            protected void onMouseEntered() {
                if (ToggleSwitch.this.isSelected()) {
                    return;
                }
                ToggleSwitch.this.colorAnimation.play(ToggleSwitch.this.unselectedHoverColorNode);
            }

            @Override
            protected void onMouseExited() {
                ToggleSwitch.this.colorAnimation.play(ToggleSwitch.this.isSelected() ? ToggleSwitch.this.selectedColorNode : ToggleSwitch.this.unselectedColorNode);
            }

            @Override
            protected void onMousePressed() {
                ToggleSwitch.this.colorAnimation.play(ToggleSwitch.this.selectedColorNode);
            }

            @Override
            protected void onMouseClicked() {
                ToggleSwitch.this.setSelected(!ToggleSwitch.this.isSelected());
            }
        };
        this.button.setOnMouseEntered((EventHandler)clickHandler);
        this.button.setOnMouseExited((EventHandler)clickHandler);
        this.button.setOnMousePressed((EventHandler)clickHandler);
        this.button.setOnMouseReleased((EventHandler)clickHandler);
    }

    public BooleanProperty selectedProperty() {
        return this.selectedProperty;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.selectedProperty.set(selected);
        this.animate();
    }

    private void animate() {
        if (this.selected) {
            this.colorAnimation.play(this.selectedColorNode);
            this.posAnimation.play(this.selectedPosNode);
            this.trayAnimation.play(this.traySelectedNode);
        } else {
            this.colorAnimation.play(this.unselectedColorNode);
            this.posAnimation.play(this.unselectedPosNode);
            this.trayAnimation.play(this.trayUnselectedNode);
        }
    }

    public Region getNode() {
        return this.root;
    }
}

