/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.wrapper;

import io.vproxy.vfx.animation.AnimationGraph;
import io.vproxy.vfx.animation.AnimationGraphBuilder;
import io.vproxy.vfx.animation.AnimationNode;
import io.vproxy.vfx.theme.Theme;
import io.vproxy.vfx.util.FXUtils;
import io.vproxy.vfx.util.algebradata.DoubleData;
import java.util.function.Function;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Paint;
import javafx.util.StringConverter;

public class FusionW
extends StackPane {
    public final Node node;
    public final StringProperty property;
    private final Label label = new Label(){
        {
            this.setTextFill((Paint)Theme.current().normalTextColor());
        }
    };
    private final AnimationNode<DoubleData> showLabel = new AnimationNode<DoubleData>("label", new DoubleData(0.0));
    private final AnimationNode<DoubleData> showNode = new AnimationNode<DoubleData>("node", new DoubleData(1.0));
    private final AnimationGraph<DoubleData> animation;

    public FusionW(Labeled node) {
        this(node, Labeled::textProperty);
    }

    public FusionW(TextInputControl node) {
        this(node, TextInputControl::textProperty);
    }

    public FusionW(ComboBox<?> node) {
        this(node, n -> {
            SimpleStringProperty p = new SimpleStringProperty();
            n.setOnMouseExited(e -> node.commitValue());
            n.valueProperty().addListener((ob, old, now) -> FusionW.updateComboBox(p, node));
            n.converterProperty().addListener((ob, old, now) -> FusionW.updateComboBox(p, node));
            FusionW.updateComboBox(p, node);
            return p;
        });
    }

    private static void updateComboBox(SimpleStringProperty p, ComboBox node) {
        StringConverter converter = node.getConverter();
        if (converter == null) {
            p.set(FusionW.toStringOrEmpty(node.getValue()));
        } else {
            p.set(converter.toString(node.getValue()));
        }
    }

    private static String toStringOrEmpty(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    public <T extends Node> FusionW(T node, Function<T, StringProperty> fluentPropertyGetter) {
        this.node = node;
        this.property = fluentPropertyGetter.apply(node);
        FXUtils.disableFocusColor(this.node);
        node.layoutBoundsProperty().addListener((ob, old, now) -> this.update());
        this.update();
        this.property.addListener((ob, old, now) -> {
            if (now == null) {
                now = "";
            }
            this.label.setText(now);
        });
        this.label.textProperty().addListener((ob, old, now) -> this.update());
        this.animation = AnimationGraphBuilder.simpleTwoNodeGraph(this.showLabel, this.showNode, 300L).setApply((from, to, d) -> {
            node.setOpacity(d.value);
            this.label.setOpacity(1.0 - d.value);
        }).build(this.showLabel);
        this.getChildren().add((Object)this.label);
        this.getChildren().add(node);
        this.setOnMouseEntered(e -> this.animation.play(this.showNode));
        this.setOnMouseExited(e -> this.animation.play(this.showLabel));
        this.label.setText((String)this.property.get());
    }

    public Label getLabel() {
        return this.label;
    }

    private void update() {
        Bounds bounds = this.node.getLayoutBounds();
        if (bounds.getWidth() > 0.0) {
            this.setPrefWidth(bounds.getWidth());
            this.label.setPrefWidth(bounds.getWidth());
        }
        if (bounds.getHeight() > 0.0) {
            this.setPrefHeight(bounds.getHeight());
            this.label.setPrefHeight(bounds.getHeight());
        }
    }

    public void enableLabelBackground() {
        this.label.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Theme.current().fusionWrapperBackgroundColor(), new CornerRadii(4.0), Insets.EMPTY)}));
    }
}

