/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.util;

import io.vproxy.base.util.LogType;
import io.vproxy.base.util.Logger;
import io.vproxy.base.util.OS;
import io.vproxy.vfx.manager.internal_i18n.InternalI18n;
import io.vproxy.vfx.ui.alert.SimpleAlert;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.util.List;
import java.util.function.Supplier;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;

public class FXUtils {
    private static final int overlapLen = 1;

    public static void generalInitialization(String[] args) {
        Font defaultFont = null;
        if (OS.isWindows()) {
            defaultFont = Font.font((String)"Microsoft YaHei UI", (double)12.0);
        }
        if (defaultFont != null) {
            FXUtils.setDefaultFont(defaultFont);
        }
    }

    public static void setDefaultFont(Font defaultFont) {
        try {
            Field field = Font.class.getDeclaredField("DEFAULT");
            field.setAccessible(true);
            field.set(null, defaultFont);
            Logger.alert((String)("The default font is set to " + defaultFont));
        }
        catch (InaccessibleObjectException e) {
            Logger.warn((LogType)LogType.SYS_ERROR, (String)"unable to set default font, you may need to add the following jvm argument:\n\t\t--add-opens=javafx.graphics/javafx.scene.text=io.vproxy.vfx");
        }
        catch (Throwable t) {
            Logger.error((LogType)LogType.SYS_ERROR, (String)("failed setting default font to " + defaultFont), (Throwable)t);
        }
    }

    public static void runOnFX(Runnable r) {
        if (Platform.isFxApplicationThread()) {
            r.run();
        } else {
            Platform.runLater((Runnable)r);
        }
    }

    public static <T> T runOnFXAndReturn(Supplier<T> f) {
        boolean[] finished = new boolean[]{false};
        Object[] obj = new Object[]{null};
        Runnable r = () -> {
            obj[0] = f.get();
            finished[0] = true;
        };
        if (Platform.isFxApplicationThread()) {
            r.run();
        } else {
            Platform.runLater((Runnable)r);
        }
        while (!finished[0]) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return (T)obj[0];
    }

    public static void runDelay(final int millis, final Runnable r) {
        AnimationTimer[] ptr;
        ptr = new AnimationTimer[]{new AnimationTimer(){
            private long begin;

            public void handle(long now) {
                if (this.begin == 0L) {
                    this.begin = now;
                    return;
                }
                if (now - this.begin < (long)millis * 1000000L) {
                    return;
                }
                ptr[0].stop();
                Platform.runLater((Runnable)r);
            }
        }};
        ptr[0].start();
    }

    public static Rectangle2D calculateTextBounds(Label label) {
        Text text = new Text(label.getText());
        text.setFont(label.getFont());
        return FXUtils.calculateTextBounds(text);
    }

    public static Rectangle2D calculateTextBounds(Text text) {
        double textWidth = text.getLayoutBounds().getWidth();
        double textHeight = text.getLayoutBounds().getHeight();
        return new Rectangle2D(0.0, 0.0, textWidth, textHeight);
    }

    public static void showWindow(Window window) {
        try {
            ((Stage)window).setIconified(false);
            ((Stage)window).setAlwaysOnTop(true);
            Platform.runLater(() -> ((Stage)window).setAlwaysOnTop(false));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void iconifyWindow(Window window) {
        try {
            ((Stage)window).setIconified(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void toBackWindow(Window window) {
        try {
            ((Stage)window).toBack();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void toFrontWindow(Window window) {
        try {
            ((Stage)window).toFront();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static float[] toHSB(javafx.scene.paint.Color color) {
        float[] ff = new float[3];
        Color.RGBtoHSB((int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0), ff);
        return ff;
    }

    public static javafx.scene.paint.Color fromHSB(float[] hsb, double alpha) {
        int rgb = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return new javafx.scene.paint.Color((double)r / 255.0, (double)g / 255.0, (double)b / 255.0, alpha);
    }

    public static javafx.scene.paint.Color fromHSB(float h, float s, float b, double alpha) {
        return FXUtils.fromHSB(new float[]{h, s, b}, alpha);
    }

    public static Screen getScreenOf(Window window) {
        if (window == null) {
            return null;
        }
        ObservableList screenOb = Screen.getScreensForRectangle((double)window.getX(), (double)window.getY(), (double)window.getWidth(), (double)window.getHeight());
        Screen screen = screenOb.isEmpty() ? Screen.getPrimary() : (Screen)screenOb.get(0);
        if (screen == null) {
            SimpleAlert.showAndWait(Alert.AlertType.WARNING, InternalI18n.get().cannotFindAnyDisplay());
            return null;
        }
        return screen;
    }

    public static BufferedImage convertToBufferedImage(Image awtImage) {
        if (awtImage instanceof BufferedImage) {
            return (BufferedImage)awtImage;
        }
        BufferedImage bImage = new BufferedImage(awtImage.getWidth(null), awtImage.getHeight(null), 2);
        Graphics2D bGr = bImage.createGraphics();
        bGr.drawImage(awtImage, 0, 0, null);
        bGr.dispose();
        return bImage;
    }

    public static List<ChangeListener<? super Number>> observeWidthHeight(Region observed, Region modified) {
        return FXUtils.observeWidthHeight(observed, modified, 0.0, 0.0);
    }

    public static List<ChangeListener<? super Number>> observeWidthHeight(Region observed, Region modified, double wDelta, double hDelta) {
        return List.of(FXUtils.observeWidth(observed, modified, wDelta), FXUtils.observeHeight(observed, modified, hDelta));
    }

    public static ChangeListener<? super Number> observeWidth(Region observed, Region modified) {
        return FXUtils.observeWidth(observed, modified, 0.0);
    }

    public static ChangeListener<? super Number> observeWidth(Region observed, Region modified, double wDelta) {
        ChangeListener lsn = (ob, old, now) -> {
            if (now == null) {
                return;
            }
            double w = now.doubleValue();
            modified.setPrefWidth(w + wDelta);
        };
        observed.widthProperty().addListener(lsn);
        double current = observed.getWidth();
        if (current > 0.0) {
            lsn.changed(null, null, (Object)current);
        }
        return lsn;
    }

    public static ChangeListener<? super Number> observeHeight(Region observed, Region modified) {
        return FXUtils.observeHeight(observed, modified, 0.0);
    }

    public static ChangeListener<? super Number> observeHeight(Region observed, Region modified, double hDelta) {
        ChangeListener lsn = (ob, old, now) -> {
            if (now == null) {
                return;
            }
            double h = now.doubleValue();
            modified.setPrefHeight(h + hDelta);
        };
        observed.heightProperty().addListener(lsn);
        double current = observed.getHeight();
        if (current > 0.0) {
            lsn.changed(null, null, (Object)current);
        }
        return lsn;
    }

    public static List<ChangeListener<? super Number>> observeWidthHeightWithPreferred(Region observed, Region modified) {
        return FXUtils.observeWidthHeightWithPreferred(observed, modified, 0.0, 0.0);
    }

    public static List<ChangeListener<? super Number>> observeWidthHeightWithPreferred(Region observed, Region modified, double wDelta, double hDelta) {
        return List.of(FXUtils.observeWidthWithPreferred(observed, modified, wDelta), FXUtils.observeHeightWithPreferred(observed, modified, hDelta));
    }

    public static ChangeListener<? super Number> observeWidthWithPreferred(Region observed, Region modified) {
        return FXUtils.observeWidthWithPreferred(observed, modified, 0.0);
    }

    public static ChangeListener<? super Number> observeWidthWithPreferred(Region observed, Region modified, double wDelta) {
        ChangeListener lsn = (ob, old, now) -> {
            if (now == null) {
                return;
            }
            double w = now.doubleValue();
            modified.setPrefWidth(w + wDelta);
        };
        observed.widthProperty().addListener(lsn);
        observed.prefWidthProperty().addListener(lsn);
        double current = observed.getWidth();
        if (current <= 0.0) {
            current = observed.getPrefWidth();
        }
        if (current > 0.0) {
            lsn.changed(null, null, (Object)current);
        }
        return lsn;
    }

    public static ChangeListener<? super Number> observeHeightWithPreferred(Region observed, Region modified) {
        return FXUtils.observeHeightWithPreferred(observed, modified, 0.0);
    }

    public static ChangeListener<? super Number> observeHeightWithPreferred(Region observed, Region modified, double hDelta) {
        ChangeListener lsn = (ob, old, now) -> {
            if (now == null) {
                return;
            }
            double h = now.doubleValue();
            modified.setPrefHeight(h + hDelta);
        };
        observed.heightProperty().addListener(lsn);
        observed.prefHeightProperty().addListener(lsn);
        double current = observed.getHeight();
        if (current <= 0.0) {
            current = observed.getWidth();
        }
        if (current > 0.0) {
            lsn.changed(null, null, (Object)current);
        }
        return lsn;
    }

    public static List<ChangeListener<? super Number>> observeWidthHeightCenter(Region observed, Region modified) {
        return List.of(FXUtils.observeWidthCenter(observed, modified), FXUtils.observeHeightCenter(observed, modified));
    }

    public static ChangeListener<? super Number> observeWidthCenter(Region observed, Region modified) {
        ChangeListener lsn = (ob, old, now) -> modified.setLayoutX((observed.getWidth() - modified.getWidth()) / 2.0);
        observed.widthProperty().addListener(lsn);
        modified.widthProperty().addListener(lsn);
        lsn.changed(null, null, null);
        return lsn;
    }

    public static ChangeListener<? super Number> observeHeightCenter(Region observed, Region modified) {
        ChangeListener lsn = (ob, old, now) -> modified.setLayoutY((observed.getHeight() - modified.getHeight()) / 2.0);
        observed.heightProperty().addListener(lsn);
        modified.heightProperty().addListener(lsn);
        lsn.changed(null, null, null);
        return lsn;
    }

    public static Node makeClipFor(Region node) {
        Rectangle cut = new Rectangle();
        node.setClip((Node)cut);
        node.widthProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            double w = now.doubleValue();
            cut.setWidth(w);
        });
        node.heightProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            double h = now.doubleValue();
            cut.setHeight(h);
        });
        cut.setWidth(node.getWidth());
        cut.setHeight(node.getHeight());
        return cut;
    }

    public static Group makeClipFor(Region node, final double cornerRadii) {
        Circle nodeCutTL = new Circle(){
            {
                this.setLayoutX(cornerRadii);
                this.setLayoutY(cornerRadii);
                this.setRadius(cornerRadii);
            }
        };
        Circle nodeCutTR = new Circle(){
            {
                this.setLayoutY(cornerRadii);
                this.setRadius(cornerRadii);
            }
        };
        Rectangle nodeCutTopMid = new Rectangle(){
            {
                this.setLayoutX(cornerRadii);
                this.setHeight(cornerRadii + 1.0);
            }
        };
        Circle nodeCutBL = new Circle(){
            {
                this.setLayoutX(cornerRadii);
                this.setRadius(cornerRadii);
            }
        };
        Circle nodeCutBR = new Circle(){
            {
                this.setRadius(cornerRadii);
            }
        };
        Rectangle nodeCutBotMid = new Rectangle(){
            {
                this.setLayoutX(cornerRadii);
                this.setHeight(cornerRadii + 1.0);
            }
        };
        Rectangle nodeCutMid = new Rectangle(){
            {
                this.setLayoutY(cornerRadii);
            }
        };
        Group nodeCut = new Group(new Node[]{nodeCutTL, nodeCutTR, nodeCutTopMid, nodeCutBL, nodeCutBR, nodeCutBotMid, nodeCutMid});
        node.setClip((Node)nodeCut);
        ChangeListener widthListener = (arg_0, arg_1, arg_2) -> FXUtils.lambda$makeClipFor$10(nodeCutTR, cornerRadii, nodeCutTopMid, nodeCutBR, nodeCutBotMid, nodeCutMid, arg_0, arg_1, arg_2);
        node.widthProperty().addListener(widthListener);
        ChangeListener heightListener = (arg_0, arg_1, arg_2) -> FXUtils.lambda$makeClipFor$11(nodeCutBL, cornerRadii, nodeCutBR, nodeCutBotMid, nodeCutMid, arg_0, arg_1, arg_2);
        node.heightProperty().addListener(heightListener);
        widthListener.changed(null, null, (Object)node.getWidth());
        heightListener.changed(null, null, (Object)node.getHeight());
        return nodeCut;
    }

    public static Group makeBottomOnlyRoundedClipFor(Region node, final double cornerRadii) {
        Circle nodeCutBL = new Circle(){
            {
                this.setLayoutX(cornerRadii);
                this.setRadius(cornerRadii);
            }
        };
        Circle nodeCutBR = new Circle(){
            {
                this.setRadius(cornerRadii);
            }
        };
        Rectangle nodeCutBotMid = new Rectangle(){
            {
                this.setLayoutX(cornerRadii);
                this.setHeight(cornerRadii + 1.0);
            }
        };
        Rectangle nodeCutMid = new Rectangle();
        Group nodeCut = new Group(new Node[]{nodeCutBL, nodeCutBR, nodeCutBotMid, nodeCutMid});
        node.setClip((Node)nodeCut);
        ChangeListener widthListener = (arg_0, arg_1, arg_2) -> FXUtils.lambda$makeBottomOnlyRoundedClipFor$12(nodeCutBR, cornerRadii, nodeCutBotMid, nodeCutMid, arg_0, arg_1, arg_2);
        node.widthProperty().addListener(widthListener);
        ChangeListener heightListener = (arg_0, arg_1, arg_2) -> FXUtils.lambda$makeBottomOnlyRoundedClipFor$13(nodeCutBL, cornerRadii, nodeCutBR, nodeCutBotMid, nodeCutMid, arg_0, arg_1, arg_2);
        node.heightProperty().addListener(heightListener);
        widthListener.changed(null, null, (Object)node.getWidth());
        heightListener.changed(null, null, (Object)node.getHeight());
        return nodeCut;
    }

    public static Group makeTopOnlyRoundedClipFor(Region node, final double cornerRadii) {
        Circle nodeCutTL = new Circle(){
            {
                this.setLayoutX(cornerRadii);
                this.setLayoutY(cornerRadii);
                this.setRadius(cornerRadii);
            }
        };
        Circle nodeCutTR = new Circle(){
            {
                this.setLayoutY(cornerRadii);
                this.setRadius(cornerRadii);
            }
        };
        Rectangle nodeCutTopMid = new Rectangle(){
            {
                this.setLayoutX(cornerRadii);
                this.setHeight(cornerRadii + 1.0);
            }
        };
        Rectangle nodeCutMid = new Rectangle(){
            {
                this.setLayoutY(cornerRadii);
            }
        };
        Group nodeCut = new Group(new Node[]{nodeCutTL, nodeCutTR, nodeCutTopMid, nodeCutMid});
        node.setClip((Node)nodeCut);
        ChangeListener widthListener = (arg_0, arg_1, arg_2) -> FXUtils.lambda$makeTopOnlyRoundedClipFor$14(nodeCutTR, cornerRadii, nodeCutTopMid, nodeCutMid, arg_0, arg_1, arg_2);
        node.widthProperty().addListener(widthListener);
        ChangeListener heightListener = (arg_0, arg_1, arg_2) -> FXUtils.lambda$makeTopOnlyRoundedClipFor$15(nodeCutMid, cornerRadii, arg_0, arg_1, arg_2);
        node.heightProperty().addListener(heightListener);
        widthListener.changed(null, null, (Object)node.getWidth());
        heightListener.changed(null, null, (Object)node.getHeight());
        return nodeCut;
    }

    public static double getWidthOrPref(Region r) {
        double w = r.getWidth();
        if (w == 0.0) {
            return r.getPrefWidth();
        }
        return w;
    }

    public static double getHeightOrPref(Region r) {
        double h = r.getHeight();
        if (h == 0.0) {
            return r.getPrefHeight();
        }
        return h;
    }

    public static void forceUpdate(Stage stage) {
        FXUtils.runDelay(50, () -> {
            double w = stage.getWidth();
            stage.setWidth(w + 0.001);
            FXUtils.runDelay(50, () -> stage.setWidth(w));
        });
    }

    public static void forceUpdate(Region region) {
        FXUtils.runDelay(50, () -> {
            double w = region.getPrefWidth();
            region.setPrefWidth(w + 0.001);
            FXUtils.runDelay(50, () -> region.setPrefWidth(w));
        });
    }

    public static WritableImage changeColorOfBlackImage(javafx.scene.image.Image img, int setArgb) {
        int w = (int)img.getWidth();
        int h = (int)img.getHeight();
        PixelReader reader = img.getPixelReader();
        WritableImage wImg = new WritableImage(w, h);
        PixelWriter writer = wImg.getPixelWriter();
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int argb = reader.getArgb(x, y);
                if (argb != 0) {
                    javafx.scene.paint.Color color = reader.getColor(x, y);
                    int r = setArgb >> 16 & 0xFF;
                    int g = setArgb >> 8 & 0xFF;
                    int b = setArgb & 0xFF;
                    writer.setArgb(x, y, (int)color.getOpacity() * 255 << 24 | (int)((double)r * (1.0 - color.getRed())) << 16 | (int)((double)g * (1.0 - color.getGreen())) << 8 | (int)((double)b * (1.0 - color.getBlue())));
                    continue;
                }
                writer.setArgb(x, y, argb);
            }
        }
        return wImg;
    }

    public static void disableFocusColor(Node node) {
        node.setStyle("-fx-focus-color: transparent; -fx-faint-focus-color: transparent;");
    }

    public static void setOnMouseEntered(Node node, EventHandler<? super MouseEvent> f) {
        EventHandler ff = node.getOnMouseEntered();
        if (ff == null) {
            node.setOnMouseEntered(f);
        } else {
            node.setOnMouseEntered(e -> {
                f.handle(e);
                ff.handle(e);
            });
        }
    }

    public static void setOnMouseExited(Node node, EventHandler<? super MouseEvent> f) {
        EventHandler ff = node.getOnMouseExited();
        if (ff == null) {
            node.setOnMouseExited(f);
        } else {
            node.setOnMouseExited(e -> {
                f.handle(e);
                ff.handle(e);
            });
        }
    }

    public static void setOnMousePressed(Node node, EventHandler<? super MouseEvent> f) {
        EventHandler ff = node.getOnMousePressed();
        if (ff == null) {
            node.setOnMousePressed(f);
        } else {
            node.setOnMousePressed(e -> {
                f.handle(e);
                ff.handle(e);
            });
        }
    }

    public static void setOnMouseReleased(Node node, EventHandler<? super MouseEvent> f) {
        EventHandler ff = node.getOnMouseReleased();
        if (ff == null) {
            node.setOnMouseReleased(f);
        } else {
            node.setOnMouseReleased(e -> {
                f.handle(e);
                ff.handle(e);
            });
        }
    }

    private static /* synthetic */ void lambda$makeTopOnlyRoundedClipFor$15(15 nodeCutMid, double cornerRadii, ObservableValue ob, Number old, Number now) {
        if (now == null) {
            return;
        }
        double h = now.doubleValue();
        nodeCutMid.setHeight(h - cornerRadii);
    }

    private static /* synthetic */ void lambda$makeTopOnlyRoundedClipFor$14(13 nodeCutTR, double cornerRadii, 14 nodeCutTopMid, 15 nodeCutMid, ObservableValue ob, Number old, Number now) {
        if (now == null) {
            return;
        }
        double w = now.doubleValue();
        nodeCutTR.setLayoutX(w - cornerRadii);
        nodeCutTopMid.setWidth(w - cornerRadii * 2.0);
        nodeCutMid.setWidth(w);
    }

    private static /* synthetic */ void lambda$makeBottomOnlyRoundedClipFor$13(9 nodeCutBL, double cornerRadii, 10 nodeCutBR, 11 nodeCutBotMid, Rectangle nodeCutMid, ObservableValue ob, Number old, Number now) {
        if (now == null) {
            return;
        }
        double h = now.doubleValue();
        nodeCutBL.setLayoutY(h - cornerRadii);
        nodeCutBR.setLayoutY(h - cornerRadii);
        nodeCutBotMid.setLayoutY(h - cornerRadii - 1.0);
        nodeCutMid.setHeight(h - cornerRadii);
    }

    private static /* synthetic */ void lambda$makeBottomOnlyRoundedClipFor$12(10 nodeCutBR, double cornerRadii, 11 nodeCutBotMid, Rectangle nodeCutMid, ObservableValue ob, Number old, Number now) {
        if (now == null) {
            return;
        }
        double w = now.doubleValue();
        nodeCutBR.setLayoutX(w - cornerRadii);
        nodeCutBotMid.setWidth(w - cornerRadii * 2.0);
        nodeCutMid.setWidth(w);
    }

    private static /* synthetic */ void lambda$makeClipFor$11(5 nodeCutBL, double cornerRadii, 6 nodeCutBR, 7 nodeCutBotMid, 8 nodeCutMid, ObservableValue ob, Number old, Number now) {
        if (now == null) {
            return;
        }
        double h = now.doubleValue();
        nodeCutBL.setLayoutY(h - cornerRadii);
        nodeCutBR.setLayoutY(h - cornerRadii);
        nodeCutBotMid.setLayoutY(h - cornerRadii - 1.0);
        nodeCutMid.setHeight(h - cornerRadii * 2.0);
    }

    private static /* synthetic */ void lambda$makeClipFor$10(3 nodeCutTR, double cornerRadii, 4 nodeCutTopMid, 6 nodeCutBR, 7 nodeCutBotMid, 8 nodeCutMid, ObservableValue ob, Number old, Number now) {
        if (now == null) {
            return;
        }
        double w = now.doubleValue();
        nodeCutTR.setLayoutX(w - cornerRadii);
        nodeCutTopMid.setWidth(w - cornerRadii * 2.0);
        nodeCutBR.setLayoutX(w - cornerRadii);
        nodeCutBotMid.setWidth(w - cornerRadii * 2.0);
        nodeCutMid.setWidth(w);
    }
}

