/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.util.algebradata;

import io.vproxy.vfx.util.FXUtils;
import io.vproxy.vfx.util.algebradata.AlgebraData;
import javafx.scene.paint.Color;

public class ColorData
implements AlgebraData<ColorData> {
    private Color color;
    private final float h;
    private final float s;
    private final float b;
    private final double alpha;

    public ColorData(Color color) {
        this.color = color;
        float[] hsb = FXUtils.toHSB(color);
        this.h = hsb[0];
        this.s = hsb[1];
        this.b = hsb[2];
        this.alpha = color.getOpacity();
    }

    public ColorData(float h, float s, float b, double alpha) {
        this.h = h;
        this.s = s;
        this.b = b;
        this.alpha = alpha;
    }

    public ColorData(float[] hsb, double alpha) {
        this.h = hsb[0];
        this.s = hsb[1];
        this.b = hsb[2];
        this.alpha = alpha;
    }

    public Color getColor() {
        if (this.color == null) {
            double alpha = this.alpha;
            if (alpha > 1.0) {
                alpha = 1.0;
            } else if (alpha < 0.0) {
                alpha = 0.0;
            }
            this.color = FXUtils.fromHSB(this.h, this.s, this.b, alpha);
        }
        return this.color;
    }

    @Override
    public ColorData plus(ColorData other) {
        return new ColorData(this.h + other.h, this.s + other.s, this.b + other.b, this.alpha + other.alpha);
    }

    @Override
    public ColorData minus(ColorData other) {
        return new ColorData(this.h - other.h, this.s - other.s, this.b - other.b, this.alpha - other.alpha);
    }

    @Override
    public ColorData multiply(double v) {
        return new ColorData((float)((double)this.h * v), (float)((double)this.s * v), (float)((double)this.b * v), this.alpha * v);
    }

    @Override
    public ColorData dividedBy(double v) {
        return new ColorData((float)((double)this.h / v), (float)((double)this.s / v), (float)((double)this.b / v), this.alpha / v);
    }
}

