/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.util.imagewrapper;

import io.vproxy.vfx.util.imagewrapper.BufferedImageCanvasBox;
import io.vproxy.vfx.util.imagewrapper.CanvasBox;
import java.awt.image.BufferedImage;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;

public class FX2BufferedImageCanvasBox
implements CanvasBox {
    private final WritableImage img;
    private final BufferedImage bImg;
    private final BufferedImageCanvasBox box;
    private final double scale;

    public FX2BufferedImageCanvasBox(WritableImage img, double scale) {
        this.img = img;
        this.bImg = SwingFXUtils.fromFXImage((Image)img, null);
        this.box = new BufferedImageCanvasBox(this.bImg, this.bImg.createGraphics());
        this.scale = scale;
    }

    @Override
    public void setPaint(int rgb) {
        this.box.setPaint(rgb);
    }

    @Override
    public void fillOval(int x, int y, int w, int h) {
        this.box.fillOval((int)((double)x / this.scale), (int)((double)y / this.scale), (int)((double)w / this.scale), (int)((double)h / this.scale));
    }

    @Override
    public void setFont(String name, boolean bold, int size) {
        this.box.setFont(name, bold, (int)((double)size / this.scale));
    }

    @Override
    public void drawString(String s, int x, int y) {
        this.box.drawString(s, (int)((double)x / this.scale), (int)((double)y / this.scale));
    }

    @Override
    public void flush() {
        this.box.flush();
        SwingFXUtils.toFXImage((BufferedImage)this.bImg, (WritableImage)this.img);
    }
}

