/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.util.imagewrapper;

import io.vproxy.vfx.util.imagewrapper.CanvasBox;
import io.vproxy.vfx.util.imagewrapper.FX2BufferedImageCanvasBox;
import io.vproxy.vfx.util.imagewrapper.ImageBox;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.WritableImage;

public class FXWritableImageBox
implements ImageBox {
    private final WritableImage img;
    private final PixelReader reader;
    private final double scale;

    public FXWritableImageBox(WritableImage img) {
        this(img, 1.0);
    }

    public FXWritableImageBox(WritableImage img, double scale) {
        this.img = img;
        this.reader = img.getPixelReader();
        this.scale = scale;
    }

    @Override
    public int getWidth() {
        return (int)(this.img.getWidth() * this.scale);
    }

    @Override
    public int getHeight() {
        return (int)(this.img.getHeight() * this.scale);
    }

    @Override
    public int getRGB(int x, int y) {
        return this.reader.getArgb((int)Math.round((double)x / this.scale), (int)Math.round((double)y / this.scale));
    }

    @Override
    public CanvasBox createGraphics() {
        return new FX2BufferedImageCanvasBox(this.img, this.scale);
    }

    @Override
    public Image toFXImage() {
        return this.img;
    }
}

