/*
 * Decompiled with CFR 0.152.
 */
package vjson;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.JvmDefault;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.CharStream;
import vjson.Stringifier;
import vjson.cs.LineCol;
import vjson.deserializer.DeserializeParserListener;
import vjson.deserializer.rule.Rule;
import vjson.parser.ParserMode;
import vjson.parser.ParserOptions;
import vjson.parser.ParserUtils;
import vjson.pl.ScriptifyContext;
import vjson.util.CastUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\r\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00040\bH\u0007\u00a2\u0006\u0002\u0010\tJ)\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00040\bH\u0007\u00a2\u0006\u0002\u0010\fJ1\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00040\b2\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0014\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006 "}, d2={"Lvjson/JSON;", "", "()V", "deserialize", "T", "json", "", "rule", "Lvjson/deserializer/rule/Rule;", "(Ljava/lang/String;Lvjson/deserializer/rule/Rule;)Ljava/lang/Object;", "cs", "Lvjson/CharStream;", "(Lvjson/CharStream;Lvjson/deserializer/rule/Rule;)Ljava/lang/Object;", "opts", "Lvjson/parser/ParserOptions;", "(Lvjson/CharStream;Lvjson/deserializer/rule/Rule;Lvjson/parser/ParserOptions;)Ljava/lang/Object;", "parse", "Lvjson/JSON$Instance;", "parseToJavaObject", "Array", "Bool", "Double", "Exp", "Instance", "Integer", "IntegerNumber", "Long", "Null", "Number", "Object", "ObjectEntry", "String", "vjson"})
public final class JSON {
    @NotNull
    public static final JSON INSTANCE = new JSON();

    private JSON() {
    }

    @JvmStatic
    @NotNull
    public static final Instance<?> parse(@NotNull java.lang.String json) throws RuntimeException {
        Intrinsics.checkNotNullParameter((java.lang.Object)json, (java.lang.String)"json");
        return JSON.parse(CharStream.Companion.from(json));
    }

    @JvmStatic
    @NotNull
    public static final Instance<?> parse(@NotNull CharStream cs) throws RuntimeException {
        Intrinsics.checkNotNullParameter((java.lang.Object)cs, (java.lang.String)"cs");
        return ParserUtils.buildFrom(cs);
    }

    @JvmStatic
    public static final <T> T deserialize(@NotNull java.lang.String json, @NotNull Rule<T> rule) throws RuntimeException {
        Intrinsics.checkNotNullParameter((java.lang.Object)json, (java.lang.String)"json");
        Intrinsics.checkNotNullParameter(rule, (java.lang.String)"rule");
        return JSON.deserialize(CharStream.Companion.from(json), rule);
    }

    @JvmStatic
    public static final <T> T deserialize(@NotNull CharStream cs, @NotNull Rule<T> rule) throws RuntimeException {
        Intrinsics.checkNotNullParameter((java.lang.Object)cs, (java.lang.String)"cs");
        Intrinsics.checkNotNullParameter(rule, (java.lang.String)"rule");
        return JSON.deserialize(cs, rule, new ParserOptions());
    }

    @JvmStatic
    public static final <T> T deserialize(@NotNull CharStream cs, @NotNull Rule<T> rule, @NotNull ParserOptions opts) throws RuntimeException {
        Intrinsics.checkNotNullParameter((java.lang.Object)cs, (java.lang.String)"cs");
        Intrinsics.checkNotNullParameter(rule, (java.lang.String)"rule");
        Intrinsics.checkNotNullParameter((java.lang.Object)opts, (java.lang.String)"opts");
        DeserializeParserListener<T> listener = new DeserializeParserListener<T>(rule);
        ParserUtils.buildFrom(cs, opts.setListener(listener).setMode(ParserMode.JAVA_OBJECT).setNullArraysAndObjects(true));
        T t = listener.get();
        Intrinsics.checkNotNull(t);
        return t;
    }

    @JvmStatic
    @Nullable
    public static final java.lang.Object parseToJavaObject(@NotNull java.lang.String json) throws RuntimeException {
        Intrinsics.checkNotNullParameter((java.lang.Object)json, (java.lang.String)"json");
        return JSON.parseToJavaObject(CharStream.Companion.from(json));
    }

    @JvmStatic
    @Nullable
    public static final java.lang.Object parseToJavaObject(@NotNull CharStream cs) throws RuntimeException {
        Intrinsics.checkNotNullParameter((java.lang.Object)cs, (java.lang.String)"cs");
        return ParserUtils.buildJavaObject(cs);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\b\u0010\u0005\u001a\u00020\u0006H&J\u001c\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\rH&J\b\u0010\u000e\u001a\u00020\u0006H&J\u001c\u0010\u000e\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H&J\u000f\u0010\u0011\u001a\u0004\u0018\u00018\u0000H&\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lvjson/JSON$Instance;", "T", "", "lineCol", "Lvjson/cs/LineCol;", "pretty", "", "scriptify", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "ctx", "Lvjson/pl/ScriptifyContext;", "stringify", "sfr", "Lvjson/Stringifier;", "toJavaObject", "()Ljava/lang/Object;", "vjson"})
    public static interface Instance<T> {
        @Nullable
        public T toJavaObject();

        @NotNull
        public java.lang.String stringify();

        @NotNull
        public java.lang.String pretty();

        public void stringify(@NotNull StringBuilder var1, @NotNull Stringifier var2);

        public void scriptify(@NotNull StringBuilder var1, @NotNull ScriptifyContext var2);

        @JvmDefault
        @NotNull
        default public LineCol lineCol() {
            return LineCol.Companion.getEMPTY();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J+\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\b\u0010\u0018\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lvjson/JSON$ObjectEntry;", "", "key", "", "value", "Lvjson/JSON$Instance;", "lineCol", "Lvjson/cs/LineCol;", "(Ljava/lang/String;Lvjson/JSON$Instance;Lvjson/cs/LineCol;)V", "getKey", "()Ljava/lang/String;", "getLineCol", "()Lvjson/cs/LineCol;", "getValue", "()Lvjson/JSON$Instance;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "vjson"})
    public static final class ObjectEntry {
        @NotNull
        private final java.lang.String key;
        @NotNull
        private final Instance<?> value;
        @NotNull
        private final LineCol lineCol;

        @JvmOverloads
        public ObjectEntry(@NotNull java.lang.String key, @NotNull Instance<?> value, @NotNull LineCol lineCol) {
            Intrinsics.checkNotNullParameter((java.lang.Object)key, (java.lang.String)"key");
            Intrinsics.checkNotNullParameter(value, (java.lang.String)"value");
            Intrinsics.checkNotNullParameter((java.lang.Object)lineCol, (java.lang.String)"lineCol");
            this.key = key;
            this.value = value;
            this.lineCol = lineCol;
        }

        public /* synthetic */ ObjectEntry(java.lang.String string, Instance instance, LineCol lineCol, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                lineCol = LineCol.Companion.getEMPTY();
            }
            this(string, instance, lineCol);
        }

        @NotNull
        public final java.lang.String getKey() {
            return this.key;
        }

        @NotNull
        public final Instance<?> getValue() {
            return this.value;
        }

        @NotNull
        public final LineCol getLineCol() {
            return this.lineCol;
        }

        @NotNull
        public java.lang.String toString() {
            return '(' + this.key + ": " + this.value + ')';
        }

        @NotNull
        public final java.lang.String component1() {
            return this.key;
        }

        @NotNull
        public final Instance<?> component2() {
            return this.value;
        }

        @NotNull
        public final LineCol component3() {
            return this.lineCol;
        }

        @NotNull
        public final ObjectEntry copy(@NotNull java.lang.String key, @NotNull Instance<?> value, @NotNull LineCol lineCol) {
            Intrinsics.checkNotNullParameter((java.lang.Object)key, (java.lang.String)"key");
            Intrinsics.checkNotNullParameter(value, (java.lang.String)"value");
            Intrinsics.checkNotNullParameter((java.lang.Object)lineCol, (java.lang.String)"lineCol");
            return new ObjectEntry(key, value, lineCol);
        }

        public static /* synthetic */ ObjectEntry copy$default(ObjectEntry objectEntry, java.lang.String string, Instance instance, LineCol lineCol, int n, java.lang.Object object) {
            if ((n & 1) != 0) {
                string = objectEntry.key;
            }
            if ((n & 2) != 0) {
                instance = objectEntry.value;
            }
            if ((n & 4) != 0) {
                lineCol = objectEntry.lineCol;
            }
            return objectEntry.copy(string, instance, lineCol);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = result * 31 + this.value.hashCode();
            result = result * 31 + this.lineCol.hashCode();
            return result;
        }

        public boolean equals(@Nullable java.lang.Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ObjectEntry)) {
                return false;
            }
            ObjectEntry objectEntry = (ObjectEntry)other;
            if (!Intrinsics.areEqual((java.lang.Object)this.key, (java.lang.Object)objectEntry.key)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.value, objectEntry.value)) {
                return false;
            }
            return Intrinsics.areEqual((java.lang.Object)this.lineCol, (java.lang.Object)objectEntry.lineCol);
        }

        @JvmOverloads
        public ObjectEntry(@NotNull java.lang.String key, @NotNull Instance<?> value) {
            Intrinsics.checkNotNullParameter((java.lang.Object)key, (java.lang.String)"key");
            Intrinsics.checkNotNullParameter(value, (java.lang.String)"value");
            this(key, value, null, 4, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002(\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0002j\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0004`\u00050\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H&J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH&J\u0015\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010\b\u001a\u00020\u0003H\u00a6\u0002J\u001a\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\n2\u0006\u0010\b\u001a\u00020\u0003H&J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u0003H\u0017J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0017J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u0003H\u0017J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0003H\u0017J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\u0003H\u0017J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\u0003H\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00002\u0006\u0010\b\u001a\u00020\u0003H\u0017J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0017J\u0010\u0010\u001a\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0003H\u0017J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0017J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\nH&J\u0018\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u001ej\b\u0012\u0004\u0012\u00020\u0003`\u001fH&J\b\u0010 \u001a\u00020\u0014H&J(\u0010!\u001a\"\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0002j\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0004`\u0005H&\u00a8\u0006\""}, d2={"Lvjson/JSON$Object;", "Lvjson/JSON$Instance;", "Ljava/util/LinkedHashMap;", "", "", "Lkotlin/collections/LinkedHashMap;", "containsKey", "", "key", "entryList", "", "Lvjson/JSON$ObjectEntry;", "get", "getAll", "getArray", "Lvjson/JSON$Array;", "getBool", "getDouble", "", "getInt", "", "getLong", "", "getNullableArray", "getNullableObject", "getNullableString", "getObject", "getString", "keyList", "keySet", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "size", "toJavaObject", "vjson"})
    public static interface Object
    extends Instance<LinkedHashMap<java.lang.String, java.lang.Object>> {
        @NotNull
        public LinkedHashSet<java.lang.String> keySet();

        @NotNull
        public List<java.lang.String> keyList();

        @NotNull
        public List<ObjectEntry> entryList();

        public int size();

        public boolean containsKey(@NotNull java.lang.String var1);

        @Override
        @NotNull
        public LinkedHashMap<java.lang.String, java.lang.Object> toJavaObject();

        @NotNull
        public Instance<?> get(@NotNull java.lang.String var1) throws NoSuchElementException;

        @NotNull
        public List<Instance<?>> getAll(@NotNull java.lang.String var1) throws NoSuchElementException;

        /*
         * WARNING - void declaration
         */
        @JvmDefault
        default public boolean getBool(@NotNull java.lang.String key) {
            void var3_3;
            Intrinsics.checkNotNullParameter((java.lang.Object)key, (java.lang.String)"key");
            CastUtils castUtils = CastUtils.INSTANCE;
            Instance<?> t$iv = this.get(key);
            boolean $i$f$cast = false;
            return ((Bool)var3_3).booleanValue();
        }

        @JvmDefault
        default public int getInt(@NotNull java.lang.String key) {
            Intrinsics.checkNotNullParameter((java.lang.Object)key, (java.lang.String)"key");
            Instance<?> inst = this.get(key);
            if (inst instanceof Integer) {
                return ((Integer)inst).intValue();
            }
            if (inst instanceof Double) {
                return (int)((Double)inst).doubleValue();
            }
            if (inst instanceof Long) {
                return (int)((Long)inst).longValue();
            }
            if (inst instanceof Number) {
                return ((java.lang.Number)((Number)inst).toJavaObject()).intValue();
            }
            throw new ClassCastException(Reflection.getOrCreateKotlinClass(inst.getClass()).getQualifiedName() + " cannot be cast to " + Reflection.getOrCreateKotlinClass(Number.class).getQualifiedName());
        }

        @JvmDefault
        default public double getDouble(@NotNull java.lang.String key) {
            Intrinsics.checkNotNullParameter((java.lang.Object)key, (java.lang.String)"key");
            Instance<?> inst = this.get(key);
            if (inst instanceof Integer) {
                return ((Integer)inst).intValue();
            }
            if (inst instanceof Double) {
                return ((Double)inst).doubleValue();
            }
            if (inst instanceof Long) {
                return ((Long)inst).longValue();
            }
            if (inst instanceof Number) {
                return ((java.lang.Number)((Number)inst).toJavaObject()).doubleValue();
            }
            throw new ClassCastException(Reflection.getOrCreateKotlinClass(inst.getClass()).getQualifiedName() + " cannot be cast to " + Reflection.getOrCreateKotlinClass(Number.class).getQualifiedName());
        }

        @JvmDefault
        default public long getLong(@NotNull java.lang.String key) {
            Intrinsics.checkNotNullParameter((java.lang.Object)key, (java.lang.String)"key");
            Instance<?> inst = this.get(key);
            if (inst instanceof Integer) {
                return ((Integer)inst).intValue();
            }
            if (inst instanceof Double) {
                return (long)((Double)inst).doubleValue();
            }
            if (inst instanceof Long) {
                return ((Long)inst).longValue();
            }
            if (inst instanceof Number) {
                return ((java.lang.Number)((Number)inst).toJavaObject()).longValue();
            }
            throw new ClassCastException(Reflection.getOrCreateKotlinClass(inst.getClass()).getQualifiedName() + " cannot be cast to " + Reflection.getOrCreateKotlinClass(Number.class).getQualifiedName());
        }

        /*
         * WARNING - void declaration
         */
        @JvmDefault
        @NotNull
        default public java.lang.String getString(@NotNull java.lang.String key) {
            void var3_3;
            Intrinsics.checkNotNullParameter((java.lang.Object)key, (java.lang.String)"key");
            CastUtils castUtils = CastUtils.INSTANCE;
            Instance<?> t$iv = this.get(key);
            boolean $i$f$cast = false;
            return ((String)var3_3).toJavaObject();
        }

        @JvmDefault
        @Nullable
        default public java.lang.String getNullableString(@NotNull java.lang.String key) {
            Intrinsics.checkNotNullParameter((java.lang.Object)key, (java.lang.String)"key");
            Instance<?> inst = this.get(key);
            if (inst instanceof Null) {
                return null;
            }
            CastUtils this_$iv = CastUtils.INSTANCE;
            boolean $i$f$cast = false;
            return ((String)inst).toJavaObject();
        }

        /*
         * WARNING - void declaration
         */
        @JvmDefault
        @NotNull
        default public Object getObject(@NotNull java.lang.String key) {
            void var3_3;
            Intrinsics.checkNotNullParameter((java.lang.Object)key, (java.lang.String)"key");
            CastUtils castUtils = CastUtils.INSTANCE;
            Instance<?> t$iv = this.get(key);
            boolean $i$f$cast = false;
            return (Object)var3_3;
        }

        @JvmDefault
        @Nullable
        default public Object getNullableObject(@NotNull java.lang.String key) {
            Intrinsics.checkNotNullParameter((java.lang.Object)key, (java.lang.String)"key");
            Instance<?> inst = this.get(key);
            if (inst instanceof Null) {
                return null;
            }
            CastUtils this_$iv = CastUtils.INSTANCE;
            boolean $i$f$cast = false;
            return (Object)inst;
        }

        /*
         * WARNING - void declaration
         */
        @JvmDefault
        @NotNull
        default public Array getArray(@NotNull java.lang.String key) {
            void var3_3;
            Intrinsics.checkNotNullParameter((java.lang.Object)key, (java.lang.String)"key");
            CastUtils castUtils = CastUtils.INSTANCE;
            Instance<?> t$iv = this.get(key);
            boolean $i$f$cast = false;
            return (Array)var3_3;
        }

        @JvmDefault
        @Nullable
        default public Array getNullableArray(@NotNull java.lang.String key) {
            Intrinsics.checkNotNullParameter((java.lang.Object)key, (java.lang.String)"key");
            Instance<?> inst = this.get(key);
            if (inst instanceof Null) {
                return null;
            }
            CastUtils this_$iv = CastUtils.INSTANCE;
            boolean $i$f$cast = false;
            return (Array)inst;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00020\u0001J\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u00a6\u0002J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u0016\u001a\u00020\u0006H&J\u0010\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002H&\u00a8\u0006\u0018"}, d2={"Lvjson/JSON$Array;", "Lvjson/JSON$Instance;", "", "", "get", "idx", "", "getArray", "getBool", "", "getDouble", "", "getInt", "getLong", "", "getNullableArray", "getNullableObject", "Lvjson/JSON$Object;", "getNullableString", "", "getObject", "getString", "length", "toJavaObject", "vjson"})
    public static interface Array
    extends Instance<List<? extends java.lang.Object>> {
        public int length();

        @Override
        @NotNull
        public List<java.lang.Object> toJavaObject();

        @NotNull
        public Instance<?> get(int var1) throws IndexOutOfBoundsException;

        /*
         * WARNING - void declaration
         */
        @JvmDefault
        default public boolean getBool(int idx) {
            void var3_3;
            CastUtils castUtils = CastUtils.INSTANCE;
            Instance<?> t$iv = this.get(idx);
            boolean $i$f$cast = false;
            return ((Bool)var3_3).booleanValue();
        }

        @JvmDefault
        default public int getInt(int idx) {
            Instance<?> inst = this.get(idx);
            if (inst instanceof Integer) {
                return ((Integer)inst).intValue();
            }
            if (inst instanceof Double) {
                return (int)((Double)inst).doubleValue();
            }
            if (inst instanceof Long) {
                return (int)((Long)inst).longValue();
            }
            if (inst instanceof Number) {
                return ((java.lang.Number)((Number)inst).toJavaObject()).intValue();
            }
            throw new ClassCastException(Reflection.getOrCreateKotlinClass(inst.getClass()).getQualifiedName() + " cannot be cast to " + Reflection.getOrCreateKotlinClass(Number.class).getQualifiedName());
        }

        @JvmDefault
        default public double getDouble(int idx) {
            Instance<?> inst = this.get(idx);
            if (inst instanceof Integer) {
                return ((Integer)inst).intValue();
            }
            if (inst instanceof Double) {
                return ((Double)inst).doubleValue();
            }
            if (inst instanceof Long) {
                return ((Long)inst).longValue();
            }
            if (inst instanceof Number) {
                return ((java.lang.Number)((Number)inst).toJavaObject()).doubleValue();
            }
            throw new ClassCastException(Reflection.getOrCreateKotlinClass(inst.getClass()).getQualifiedName() + " cannot be cast to " + Reflection.getOrCreateKotlinClass(Number.class).getQualifiedName());
        }

        @JvmDefault
        default public long getLong(int idx) {
            Instance<?> inst = this.get(idx);
            if (inst instanceof Integer) {
                return ((Integer)inst).intValue();
            }
            if (inst instanceof Double) {
                return (long)((Double)inst).doubleValue();
            }
            if (inst instanceof Long) {
                return ((Long)inst).longValue();
            }
            if (inst instanceof Number) {
                return ((java.lang.Number)((Number)inst).toJavaObject()).longValue();
            }
            throw new ClassCastException(Reflection.getOrCreateKotlinClass(inst.getClass()).getQualifiedName() + " cannot be cast to " + Reflection.getOrCreateKotlinClass(Number.class).getQualifiedName());
        }

        /*
         * WARNING - void declaration
         */
        @JvmDefault
        @NotNull
        default public java.lang.String getString(int idx) {
            void var3_3;
            CastUtils castUtils = CastUtils.INSTANCE;
            Instance<?> t$iv = this.get(idx);
            boolean $i$f$cast = false;
            return ((String)var3_3).toJavaObject();
        }

        @JvmDefault
        @Nullable
        default public java.lang.String getNullableString(int idx) {
            Instance<?> inst = this.get(idx);
            if (inst instanceof Null) {
                return null;
            }
            CastUtils this_$iv = CastUtils.INSTANCE;
            boolean $i$f$cast = false;
            return ((String)inst).toJavaObject();
        }

        /*
         * WARNING - void declaration
         */
        @JvmDefault
        @NotNull
        default public Object getObject(int idx) {
            void var3_3;
            CastUtils castUtils = CastUtils.INSTANCE;
            Instance<?> t$iv = this.get(idx);
            boolean $i$f$cast = false;
            return (Object)var3_3;
        }

        @JvmDefault
        @Nullable
        default public Object getNullableObject(int idx) {
            Instance<?> inst = this.get(idx);
            if (inst instanceof Null) {
                return null;
            }
            CastUtils this_$iv = CastUtils.INSTANCE;
            boolean $i$f$cast = false;
            return (Object)inst;
        }

        /*
         * WARNING - void declaration
         */
        @JvmDefault
        @NotNull
        default public Array getArray(int idx) {
            void var3_3;
            CastUtils castUtils = CastUtils.INSTANCE;
            Instance<?> t$iv = this.get(idx);
            boolean $i$f$cast = false;
            return (Array)var3_3;
        }

        @JvmDefault
        @Nullable
        default public Array getNullableArray(int idx) {
            Instance<?> inst = this.get(idx);
            if (inst instanceof Null) {
                return null;
            }
            CastUtils this_$iv = CastUtils.INSTANCE;
            boolean $i$f$cast = false;
            return (Array)inst;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u0000 \u00042\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0004J\b\u0010\u0003\u001a\u00020\u0002H&\u00a8\u0006\u0005"}, d2={"Lvjson/JSON$String;", "Lvjson/JSON$Instance;", "", "toJavaObject", "Companion", "vjson"})
    public static interface String
    extends Instance<java.lang.String> {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @Override
        @NotNull
        public java.lang.String toJavaObject();

        @JvmStatic
        @JvmOverloads
        @NotNull
        public static java.lang.String stringify(@NotNull java.lang.String s, @Nullable Stringifier.StringOptions stringOptions) {
            return Companion.stringify(s, stringOptions);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public static java.lang.String stringify(@NotNull java.lang.String s) {
            return Companion.stringify(s);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007\u00a8\u0006\b"}, d2={"Lvjson/JSON$String$Companion;", "", "()V", "stringify", "", "s", "stringOptions", "Lvjson/Stringifier$StringOptions;", "vjson"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public final java.lang.String stringify(@NotNull java.lang.String s, @Nullable Stringifier.StringOptions stringOptions) {
                Intrinsics.checkNotNullParameter((java.lang.Object)s, (java.lang.String)"s");
                StringBuilder sb = new StringBuilder();
                sb.append("\"");
                java.lang.Object object = s;
                int n = 0;
                char[] cArray = ((java.lang.String)object).toCharArray();
                Intrinsics.checkNotNullExpressionValue((java.lang.Object)cArray, (java.lang.String)"(this as java.lang.String).toCharArray()");
                char[] chars = cArray;
                object = chars;
                n = 0;
                int n2 = ((java.lang.Object)object).length;
                while (n < n2) {
                    java.lang.String foo;
                    int n3;
                    java.lang.Object object2;
                    java.lang.Object c;
                    block17: {
                        java.lang.Object object3;
                        block16: {
                            Function1<Character, Boolean> printableChar;
                            block15: {
                                c = object[n];
                                ++n;
                                Stringifier.StringOptions stringOptions2 = stringOptions;
                                Function1<Character, Boolean> function1 = printableChar = stringOptions2 == null ? null : stringOptions2.getPrintableChar();
                                if (printableChar != null) break block15;
                                java.lang.Object object4 = c;
                                if (32 <= object4 ? object4 <= 126 : false) break block16;
                            }
                            if (printableChar == null || !((Boolean)printableChar.invoke((java.lang.Object)Character.valueOf((char)c))).booleanValue()) break block17;
                        }
                        if ((object3 = c) == 34) {
                            sb.append("\\\"");
                            continue;
                        }
                        if (object3 == 92) {
                            sb.append("\\\\");
                            continue;
                        }
                        sb.append((char)c);
                        continue;
                    }
                    if (c < 128) {
                        java.lang.String foo2;
                        java.lang.Object object5 = c;
                        if (object5 == 8) {
                            sb.append("\\b");
                            continue;
                        }
                        if (object5 == 12) {
                            sb.append("\\f");
                            continue;
                        }
                        if (object5 == 10) {
                            sb.append("\\n");
                            continue;
                        }
                        if (object5 == 13) {
                            sb.append("\\r");
                            continue;
                        }
                        if (object5 == 9) {
                            sb.append("\\t");
                            continue;
                        }
                        object2 = c;
                        n3 = 16;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((java.lang.Object)java.lang.Integer.toString(object2, CharsKt.checkRadix((int)n3)), (java.lang.String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
                        if (foo2.length() < 2) {
                            sb.append("\\u000").append(foo2);
                            continue;
                        }
                        sb.append("\\u00").append(foo2);
                        continue;
                    }
                    java.lang.Object object6 = c;
                    object2 = 16;
                    n3 = 0;
                    Intrinsics.checkNotNullExpressionValue((java.lang.Object)java.lang.Integer.toString((int)object6, CharsKt.checkRadix((int)object2)), (java.lang.String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
                    if (foo.length() < 3) {
                        sb.append("\\u00").append(foo);
                        continue;
                    }
                    if (foo.length() < 4) {
                        sb.append("\\u0").append(foo);
                        continue;
                    }
                    sb.append("\\u").append(foo);
                }
                sb.append("\"");
                object = sb.toString();
                Intrinsics.checkNotNullExpressionValue((java.lang.Object)object, (java.lang.String)"sb.toString()");
                return object;
            }

            public static /* synthetic */ java.lang.String stringify$default(Companion companion, java.lang.String string, Stringifier.StringOptions stringOptions, int n, java.lang.Object object) {
                if ((n & 2) != 0) {
                    stringOptions = null;
                }
                return companion.stringify(string, stringOptions);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public final java.lang.String stringify(@NotNull java.lang.String s) {
                Intrinsics.checkNotNullParameter((java.lang.Object)s, (java.lang.String)"s");
                return vjson.JSON$String$Companion.stringify$default(this, s, null, 2, null);
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003J\r\u0010\u0004\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lvjson/JSON$Number;", "T", "", "Lvjson/JSON$Instance;", "toJavaObject", "()Ljava/lang/Number;", "vjson"})
    public static interface Number<T extends java.lang.Number>
    extends Instance<T> {
        @Override
        @NotNull
        public T toJavaObject();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0000\bf\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003\u00a8\u0006\u0004"}, d2={"Lvjson/JSON$IntegerNumber;", "T", "", "Lvjson/JSON$Number;", "vjson"})
    public static interface IntegerNumber<T extends java.lang.Number>
    extends Number<T> {
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001J\b\u0010\u0003\u001a\u00020\u0002H&\u00a8\u0006\u0004"}, d2={"Lvjson/JSON$Integer;", "Lvjson/JSON$IntegerNumber;", "", "intValue", "vjson"})
    public static interface Integer
    extends IntegerNumber<java.lang.Integer> {
        public int intValue();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001J\b\u0010\u0003\u001a\u00020\u0002H&\u00a8\u0006\u0004"}, d2={"Lvjson/JSON$Long;", "Lvjson/JSON$IntegerNumber;", "", "longValue", "vjson"})
    public static interface Long
    extends IntegerNumber<java.lang.Long> {
        public long longValue();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001J\b\u0010\u0003\u001a\u00020\u0002H&\u00a8\u0006\u0004"}, d2={"Lvjson/JSON$Double;", "Lvjson/JSON$Number;", "", "doubleValue", "vjson"})
    public static interface Double
    extends Number<java.lang.Double> {
        public double doubleValue();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lvjson/JSON$Exp;", "Lvjson/JSON$Double;", "base", "", "exponent", "", "vjson"})
    public static interface Exp
    extends Double {
        public double base();

        public int exponent();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001J\b\u0010\u0003\u001a\u00020\u0002H&J\r\u0010\u0004\u001a\u00020\u0002H&\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lvjson/JSON$Bool;", "Lvjson/JSON$Instance;", "", "booleanValue", "toJavaObject", "()Ljava/lang/Boolean;", "vjson"})
    public static interface Bool
    extends Instance<Boolean> {
        public boolean booleanValue();

        @Override
        @NotNull
        public Boolean toJavaObject();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\bf\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0017\u00a8\u0006\u0004"}, d2={"Lvjson/JSON$Null;", "Lvjson/JSON$Instance;", "", "toJavaObject", "vjson"})
    public static interface Null
    extends Instance<java.lang.Object> {
        @Override
        @JvmDefault
        @Nullable
        default public java.lang.Object toJavaObject() {
            return null;
        }
    }
}

