/*
 * Decompiled with CFR 0.152.
 */
package vjson.cs;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.CharStream;
import vjson.cs.LineCol;
import vjson.cs.LineColCharStream;
import vjson.cs.PeekCharStream;
import vjson.ex.ParserException;
import vjson.parser.ParserOptions;
import vjson.parser.StringParser;
import vjson.util.Manager;
import vjson.util.collection.VList;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000 &2\u00020\u0001:\u0003&'(B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0011H\u0002J\u001a\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\"\u001a\u00020\u0018H\u0016J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u001aH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\nj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lvjson/cs/IncludeCharStream;", "Lvjson/CharStream;", "csMap", "Lvjson/util/Manager;", "", "mainCSName", "(Lvjson/util/Manager;Ljava/lang/String;)V", "actualCurrent", "Lvjson/cs/IncludeCharStream$StackedCS;", "csMapCache", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "current", "peekChars", "Lvjson/util/collection/VList;", "Lvjson/cs/IncludeCharStream$PeekChar;", "checkCurrentAndSkipBlank", "", "checkRecursiveInclude", "name", "lineCol", "Lvjson/cs/LineCol;", "checkStackAndSkipBlank", "currentMoveNextAndGet", "", "isPeek", "", "currentSkipBlank", "formatCS", "parent", "getContent", "hasNext", "i", "", "moveNextAndGet", "peekNext", "skipBlank", "skipComments", "Companion", "PeekChar", "StackedCS", "vjson"})
public final class IncludeCharStream
implements CharStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Manager<String> csMap;
    @NotNull
    private final HashMap<String, String> csMapCache;
    @NotNull
    private StackedCS current;
    @NotNull
    private StackedCS actualCurrent;
    @NotNull
    private final VList<PeekChar> peekChars;
    @NotNull
    private static final char[] includeStr;

    public IncludeCharStream(@NotNull Manager<String> csMap, @NotNull String mainCSName) {
        Intrinsics.checkNotNullParameter(csMap, (String)"csMap");
        Intrinsics.checkNotNullParameter((Object)mainCSName, (String)"mainCSName");
        this.csMap = csMap;
        this.csMapCache = new HashMap();
        this.actualCurrent = this.current = this.formatCS(mainCSName, null);
        this.peekChars = new VList();
    }

    private final String getContent(String name) {
        String cacheStr = this.csMapCache.get(name);
        if (cacheStr == null) {
            Function0<String> function0 = this.csMap.provide(name);
            Intrinsics.checkNotNull(function0);
            Function0<String> f = function0;
            cacheStr = (String)f.invoke();
            Map map = this.csMapCache;
            boolean bl = false;
            map.put(name, cacheStr);
        }
        return cacheStr;
    }

    private final StackedCS formatCS(String name, StackedCS parent) {
        return new StackedCS(name, new PeekCharStream(new LineColCharStream(CharStream.Companion.from(this.getContent(name)), name, null, 4, null), 0, 2, null), 0, parent);
    }

    private final void checkStackAndSkipBlank() {
        if (this.current.getParent() == null) {
            return;
        }
        StackedCS stackedCS = this.current.getParent();
        Intrinsics.checkNotNull((Object)stackedCS);
        this.current = stackedCS;
        this.currentSkipBlank();
    }

    private final void checkCurrentAndSkipBlank() {
        this.current.skipBlank(true);
        if (!StackedCS.hasNext$default(this.current, 0, 1, null)) {
            this.checkStackAndSkipBlank();
        }
    }

    private final void checkRecursiveInclude(String name, LineCol lineCol) {
        for (StackedCS cs = this.current; cs != null; cs = cs.getParent()) {
            if (!Intrinsics.areEqual((Object)cs.getName(), (Object)name)) continue;
            throw new ParserException(Intrinsics.stringPlus((String)"recursive include: ", (Object)name), lineCol);
        }
    }

    private final void currentSkipBlank() {
        Function0<String> function0;
        this.current.skipBlank(false);
        if (!StackedCS.hasNext$default(this.current, 0, 1, null)) {
            this.checkStackAndSkipBlank();
            return;
        }
        LineCol includeLineCol = this.current.lineCol();
        int n = 1;
        int n2 = includeStr.length;
        if (n <= n2) {
            int i;
            do {
                if (!this.current.hasNext(i = n++)) {
                    this.checkCurrentAndSkipBlank();
                    return;
                }
                char c = this.current.peekNext(i);
                if (c == includeStr[i - 1]) continue;
                this.checkCurrentAndSkipBlank();
                return;
            } while (i != n2);
        }
        if (!this.current.hasNext(includeStr.length + 1)) {
            throw new ParserException("invalid #include statement: reaches eof", includeLineCol);
        }
        StringParser parser = new StringParser(new ParserOptions().setEnd(false));
        PeekCharStream pcs = new PeekCharStream(this.current.getCs(), includeStr.length);
        try {
            function0 = (Function0<String>)parser.feed(pcs);
        }
        catch (ParserException e) {
            throw new ParserException(Intrinsics.stringPlus((String)"invalid #include statement: ", (Object)e.getMessage()), includeLineCol);
        }
        Function0<String> c = function0;
        if (c == null) {
            throw new ParserException("invalid #include statement: missing char stream name to be included", includeLineCol);
        }
        Function0<String> includeNameObj = c;
        this.current.skip(pcs.getCursor());
        String includeName = includeNameObj.toJavaObject();
        function0 = this.csMap.provide(includeName);
        if (function0 == null) {
            throw new ParserException("unable to #include " + includeNameObj.stringify() + ": char stream not found", includeLineCol);
        }
        this.checkRecursiveInclude(includeName, includeLineCol);
        this.current = this.formatCS(includeName, this.current);
        this.currentSkipBlank();
    }

    @Override
    public void skipBlank(boolean skipComments) {
        this.current = this.actualCurrent;
        this.current.getCs().setCursor(this.current.getLastRetrievedOffset());
        this.peekChars.clear();
        if (skipComments) {
            this.currentSkipBlank();
        } else {
            while (true) {
                this.current.skipBlank(false);
                if (StackedCS.hasNext$default(this.current, 0, 1, null) || this.current.getParent() == null) break;
                Intrinsics.checkNotNull((Object)this.current.getParent());
                this.current = this.current;
            }
        }
        this.actualCurrent = this.current;
    }

    @Override
    public boolean hasNext(int i) {
        if (this.peekChars.size() >= i) {
            return true;
        }
        while (this.peekChars.size() < i) {
            if (!StackedCS.hasNext$default(this.current, 0, 1, null)) {
                return false;
            }
            this.peekNext(i);
        }
        return true;
    }

    private final char currentMoveNextAndGet(boolean isPeek) {
        while (!StackedCS.hasNext$default(this.current, 0, 1, null)) {
            if (this.current.getParent() == null) {
                throw new IndexOutOfBoundsException();
            }
            Intrinsics.checkNotNull((Object)this.current.getParent());
            this.current = this.current;
            if (isPeek) continue;
            this.actualCurrent = this.current;
        }
        return isPeek ? this.current.moveNextAndGet() : this.current.moveNextAndGetAndMoveOffset();
    }

    @Override
    public char moveNextAndGet() {
        if (!this.peekChars.isEmpty()) {
            PeekChar pc = this.peekChars.removeFirst();
            StackedCS stackedCS = pc.getCs();
            stackedCS.setLastRetrievedOffset(stackedCS.getLastRetrievedOffset() + 1);
            this.actualCurrent = pc.getCs();
            return pc.getC();
        }
        return this.currentMoveNextAndGet(false);
    }

    @Override
    public char peekNext(int i) {
        if (this.peekChars.size() >= i) {
            return this.peekChars.get(i - 1).getC();
        }
        while (this.peekChars.size() < i) {
            char c = this.currentMoveNextAndGet(true);
            this.peekChars.add(new PeekChar(c, this.current));
        }
        return this.peekChars.last().getC();
    }

    @Override
    @NotNull
    public LineCol lineCol() {
        return this.current.lineCol();
    }

    static {
        String string = "#include";
        boolean bl = false;
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        includeStr = cArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lvjson/cs/IncludeCharStream$Companion;", "", "()V", "includeStr", "", "vjson"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0007J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aJ\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0007J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0007J\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lvjson/cs/IncludeCharStream$StackedCS;", "", "name", "", "cs", "Lvjson/cs/PeekCharStream;", "lastRetrievedOffset", "", "parent", "(Ljava/lang/String;Lvjson/cs/PeekCharStream;ILvjson/cs/IncludeCharStream$StackedCS;)V", "getCs", "()Lvjson/cs/PeekCharStream;", "getLastRetrievedOffset", "()I", "setLastRetrievedOffset", "(I)V", "getName", "()Ljava/lang/String;", "getParent", "()Lvjson/cs/IncludeCharStream$StackedCS;", "hasNext", "", "i", "lineCol", "Lvjson/cs/LineCol;", "moveNextAndGet", "", "moveNextAndGetAndMoveOffset", "peekNext", "skip", "", "n", "skipBlank", "skipComments", "vjson"})
    private static final class StackedCS {
        @NotNull
        private final String name;
        @NotNull
        private final PeekCharStream cs;
        private int lastRetrievedOffset;
        @Nullable
        private final StackedCS parent;

        public StackedCS(@NotNull String name, @NotNull PeekCharStream cs, int lastRetrievedOffset, @Nullable StackedCS parent) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
            this.name = name;
            this.cs = cs;
            this.lastRetrievedOffset = lastRetrievedOffset;
            this.parent = parent;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final PeekCharStream getCs() {
            return this.cs;
        }

        public final int getLastRetrievedOffset() {
            return this.lastRetrievedOffset;
        }

        public final void setLastRetrievedOffset(int n) {
            this.lastRetrievedOffset = n;
        }

        @Nullable
        public final StackedCS getParent() {
            return this.parent;
        }

        public final boolean hasNext(int i) {
            return this.cs.hasNext(i);
        }

        public static /* synthetic */ boolean hasNext$default(StackedCS stackedCS, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return stackedCS.hasNext(n);
        }

        public final char peekNext(int i) {
            return this.cs.peekNext(i);
        }

        @NotNull
        public final LineCol lineCol() {
            return this.cs.lineCol();
        }

        public final char moveNextAndGet() {
            return this.cs.moveNextAndGet();
        }

        public final char moveNextAndGetAndMoveOffset() {
            char c = this.cs.moveNextAndGet();
            StackedCS stackedCS = this;
            ++stackedCS.lastRetrievedOffset;
            return c;
        }

        public final void skipBlank(boolean skipComments) {
            this.cs.skipBlank(skipComments);
            this.lastRetrievedOffset = this.cs.getCursor();
        }

        public final void skip(int n) {
            this.cs.skip(n);
            StackedCS stackedCS = this;
            stackedCS.lastRetrievedOffset += n;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lvjson/cs/IncludeCharStream$PeekChar;", "", "c", "", "cs", "Lvjson/cs/IncludeCharStream$StackedCS;", "(CLvjson/cs/IncludeCharStream$StackedCS;)V", "getC", "()C", "getCs", "()Lvjson/cs/IncludeCharStream$StackedCS;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "vjson"})
    private static final class PeekChar {
        private final char c;
        @NotNull
        private final StackedCS cs;

        public PeekChar(char c, @NotNull StackedCS cs) {
            Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
            this.c = c;
            this.cs = cs;
        }

        public final char getC() {
            return this.c;
        }

        @NotNull
        public final StackedCS getCs() {
            return this.cs;
        }

        public final char component1() {
            return this.c;
        }

        @NotNull
        public final StackedCS component2() {
            return this.cs;
        }

        @NotNull
        public final PeekChar copy(char c, @NotNull StackedCS cs) {
            Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
            return new PeekChar(c, cs);
        }

        public static /* synthetic */ PeekChar copy$default(PeekChar peekChar, char c, StackedCS stackedCS, int n, Object object) {
            if ((n & 1) != 0) {
                c = peekChar.c;
            }
            if ((n & 2) != 0) {
                stackedCS = peekChar.cs;
            }
            return peekChar.copy(c, stackedCS);
        }

        @NotNull
        public String toString() {
            return "PeekChar(c=" + this.c + ", cs=" + this.cs + ')';
        }

        public int hashCode() {
            int result = Character.hashCode(this.c);
            result = result * 31 + this.cs.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PeekChar)) {
                return false;
            }
            PeekChar peekChar = (PeekChar)other;
            if (this.c != peekChar.c) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.cs, (Object)peekChar.cs);
        }
    }
}

