/*
 * Decompiled with CFR 0.152.
 */
package vjson.cs;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.CharStream;
import vjson.cs.LineCol;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lvjson/cs/LineColCharStream;", "Lvjson/CharStream;", "cs", "filename", "", "offset", "Lvjson/cs/LineCol;", "(Lvjson/CharStream;Ljava/lang/String;Lvjson/cs/LineCol;)V", "currentCol", "", "currentLine", "hasNext", "", "i", "lineCol", "moveNextAndGet", "", "newLine", "", "peekNext", "vjson"})
public final class LineColCharStream
implements CharStream {
    @NotNull
    private final CharStream cs;
    @NotNull
    private final String filename;
    @Nullable
    private final LineCol offset;
    private int currentLine;
    private int currentCol;

    @JvmOverloads
    public LineColCharStream(@NotNull CharStream cs, @NotNull String filename, @Nullable LineCol offset) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.cs = cs;
        this.filename = filename;
        this.offset = offset;
        this.currentLine = 1;
        this.currentCol = 1;
    }

    public /* synthetic */ LineColCharStream(CharStream charStream, String string, LineCol lineCol, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            lineCol = null;
        }
        this(charStream, string, lineCol);
    }

    @Override
    public boolean hasNext(int i) {
        return this.cs.hasNext(i);
    }

    @Override
    public char moveNextAndGet() {
        char c = this.cs.moveNextAndGet();
        if (c == '\r') {
            if (!this.cs.hasNext() || this.cs.peekNext() != '\n') {
                this.newLine();
            } else {
                LineColCharStream lineColCharStream = this;
                ++lineColCharStream.currentCol;
            }
        } else if (c == '\n') {
            this.newLine();
        } else {
            LineColCharStream lineColCharStream = this;
            ++lineColCharStream.currentCol;
        }
        return c;
    }

    private final void newLine() {
        LineColCharStream lineColCharStream = this;
        ++lineColCharStream.currentLine;
        this.currentCol = 1;
    }

    @Override
    public char peekNext(int i) {
        return this.cs.peekNext(i);
    }

    @Override
    @NotNull
    public LineCol lineCol() {
        return this.offset == null ? new LineCol(this.filename, this.currentLine, this.currentCol, 0, 8, null) : new LineCol(this.filename, this.currentLine + this.offset.getLine() - 1, this.currentCol + this.offset.getCol() - 1, 0, 8, null);
    }

    @JvmOverloads
    public LineColCharStream(@NotNull CharStream cs, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this(cs, filename, null, 4, null);
    }
}

