/*
 * Decompiled with CFR 0.152.
 */
package vjson.cs;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import vjson.CharStream;
import vjson.cs.LineCol;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lvjson/cs/PeekCharStream;", "Lvjson/CharStream;", "cs", "cursor", "", "(Lvjson/CharStream;I)V", "getCursor", "hasNext", "", "i", "lineCol", "Lvjson/cs/LineCol;", "moveNextAndGet", "", "peekNext", "rollback", "", "setCursor", "vjson"})
public final class PeekCharStream
implements CharStream {
    @NotNull
    private final CharStream cs;
    private int cursor;

    public PeekCharStream(@NotNull CharStream cs, int cursor) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        this.cursor = cursor;
    }

    public /* synthetic */ PeekCharStream(CharStream charStream, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(charStream, n);
    }

    @Override
    public boolean hasNext(int i) {
        return this.cs.hasNext(this.cursor + i);
    }

    @Override
    public char moveNextAndGet() {
        PeekCharStream peekCharStream = this;
        ++peekCharStream.cursor;
        return this.cs.peekNext(this.cursor);
    }

    @Override
    public char peekNext(int i) {
        return this.cs.peekNext(this.cursor + i);
    }

    public final int getCursor() {
        return this.cursor;
    }

    public final void setCursor(int cursor) {
        this.cursor = cursor;
    }

    @Override
    @NotNull
    public LineCol lineCol() {
        LineCol lineCol = this.cs.lineCol();
        if (lineCol.isEmpty()) {
            return lineCol;
        }
        int line = lineCol.getLine();
        int col = lineCol.getCol();
        int n = 1;
        int n2 = this.cursor;
        if (n <= n2) {
            int i;
            do {
                char c;
                if ((c = this.cs.peekNext(i = n++)) == '\n') {
                    ++line;
                    col = 1;
                    continue;
                }
                if (c == '\r') {
                    if (this.cs.hasNext(i + 1)) {
                        char cc = this.cs.peekNext(i + 1);
                        if (cc != '\n') {
                            ++line;
                            col = 1;
                            continue;
                        }
                    } else {
                        ++line;
                        col = 1;
                        continue;
                    }
                }
                ++col;
            } while (i != n2);
        }
        return new LineCol(lineCol.getFilename(), line, col, 0, 8, null);
    }

    public final void rollback() {
        if (this.cursor == 0) {
            throw new IllegalStateException();
        }
        PeekCharStream peekCharStream = this;
        peekCharStream.cursor += -1;
        int cfr_ignored_0 = peekCharStream.cursor;
    }
}

