/*
 * Decompiled with CFR 0.152.
 */
package vjson.deserializer;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.JSON;
import vjson.deserializer.ParseContext;
import vjson.deserializer.rule.ArrayRule;
import vjson.deserializer.rule.BoolRule;
import vjson.deserializer.rule.DoubleRule;
import vjson.deserializer.rule.IntRule;
import vjson.deserializer.rule.LongRule;
import vjson.deserializer.rule.NothingRule;
import vjson.deserializer.rule.NullableRule;
import vjson.deserializer.rule.ObjectField;
import vjson.deserializer.rule.ObjectRule;
import vjson.deserializer.rule.Rule;
import vjson.deserializer.rule.StringRule;
import vjson.deserializer.rule.TypeRule;
import vjson.ex.JsonParseException;
import vjson.listener.AbstractParserListener;
import vjson.parser.ArrayParser;
import vjson.parser.ObjectParser;
import vjson.simple.SimpleNull;
import vjson.util.CastUtils;
import vjson.util.collection.Stack;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0010\u001a\u00020\r2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0007J\r\u0010\u0014\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001c\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0016J\u001a\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0007H\u0016J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0016J\u0017\u0010\"\u001a\u00020\u00172\b\u0010#\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010$J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(H\u0016J\u0014\u0010&\u001a\u00020\u00172\n\u0010'\u001a\u0006\u0012\u0002\b\u00030)H\u0016J\u0010\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00172\u0006\u0010+\u001a\u00020,H\u0016J\u0018\u0010.\u001a\u00020\u00172\u0006\u0010+\u001a\u00020,2\u0006\u0010/\u001a\u000200H\u0016J$\u00101\u001a\u00020\u00172\u0006\u0010+\u001a\u00020,2\u0006\u0010/\u001a\u0002002\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0016J\"\u00102\u001a\u00020\u00172\u0006\u0010+\u001a\u00020,2\u0006\u0010/\u001a\u0002002\b\u0010\u001c\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u00103\u001a\u00020\u00172\u0006\u00104\u001a\u000200H\u0016J\u0010\u00103\u001a\u00020\u00172\u0006\u00104\u001a\u000205H\u0016JC\u00106\u001a\u00020\u00172\n\u00107\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u00108\u001a\u00020\t2\u001a\u00106\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\u0017092\b\u0010\u001c\u001a\u0004\u0018\u00010\tH\u0082\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lvjson/deserializer/DeserializeParserListener;", "T", "Lvjson/listener/AbstractParserListener;", "rule", "Lvjson/deserializer/rule/Rule;", "(Lvjson/deserializer/rule/Rule;)V", "begin", "", "lastObject", "", "nextRuleStack", "Lvjson/util/collection/Stack;", "parseStack", "Lvjson/deserializer/ParseContext;", "skip", "", "applyObjectRuleForTypeRule", "orule", "Lvjson/deserializer/rule/ObjectRule;", "completed", "get", "()Ljava/lang/Object;", "onArrayBegin", "", "array", "Lvjson/parser/ArrayParser;", "onArrayEnd", "onArrayValue", "value", "Lvjson/JSON$Instance;", "onArrayValueJavaObject", "onBool", "bool", "Lvjson/JSON$Bool;", "onNull", "n", "(Lkotlin/Unit;)V", "Lvjson/JSON$Null;", "onNumber", "number", "", "Lvjson/JSON$Number;", "onObjectBegin", "obj", "Lvjson/parser/ObjectParser;", "onObjectEnd", "onObjectKey", "key", "", "onObjectValue", "onObjectValueJavaObject", "onString", "string", "Lvjson/JSON$String;", "set", "_rule", "holder", "Lkotlin/Function2;", "vjson"})
public final class DeserializeParserListener<T>
extends AbstractParserListener {
    @NotNull
    private final Stack<ParseContext> parseStack;
    @NotNull
    private final Stack<Rule<?>> nextRuleStack;
    private boolean begin;
    private int skip;
    @Nullable
    private Object lastObject;

    public DeserializeParserListener(@NotNull Rule<T> rule) {
        Intrinsics.checkNotNullParameter(rule, (String)"rule");
        this.parseStack = new Stack();
        this.nextRuleStack = new Stack();
        Rule<?> real = rule.real();
        boolean bl = real instanceof ObjectRule || real instanceof ArrayRule || real instanceof TypeRule;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "can only accept ObjectRule or ArrayRule or TypeRule";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.nextRuleStack.push(rule);
    }

    @Override
    public void onObjectBegin(@NotNull ObjectParser obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (this.skip != 0) {
            DeserializeParserListener deserializeParserListener = this;
            ++deserializeParserListener.skip;
            int cfr_ignored_0 = deserializeParserListener.skip;
            return;
        }
        Rule<?> rule = this.nextRuleStack.peek().real();
        if (rule instanceof TypeRule) {
            this.parseStack.push(new ParseContext(rule, null));
        } else if (rule instanceof NothingRule) {
            this.skip = 1;
        } else {
            if (!(rule instanceof ObjectRule)) {
                throw new JsonParseException("expect: array, actual: object");
            }
            this.parseStack.push(new ParseContext(rule, ((ObjectRule)rule).getConstruct().invoke()));
        }
        this.begin = true;
    }

    private final ParseContext applyObjectRuleForTypeRule(ObjectRule<?> orule) {
        this.parseStack.pop();
        ParseContext newCtx = new ParseContext((Rule)orule, orule.getConstruct().invoke());
        this.parseStack.push(newCtx);
        return newCtx;
    }

    @Override
    public void onObjectKey(@NotNull ObjectParser obj, @NotNull String key) {
        ObjectRule objectRule;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.skip != 0) {
            return;
        }
        ParseContext ctx = this.parseStack.peek();
        if (ctx.getRule() instanceof TypeRule) {
            if (Intrinsics.areEqual((Object)key, (Object)"@type")) {
                return;
            }
            CastUtils castUtils = CastUtils.INSTANCE;
            Rule<?> t$iv = ctx.getRule();
            boolean $i$f$cast = false;
            objectRule = ((TypeRule)t$iv).getDefaultRule();
            if (objectRule == null) {
                throw new JsonParseException(Intrinsics.stringPlus((String)"cannot determine type for ", ctx.getRule()));
            }
            ObjectRule orule = objectRule;
            ctx = this.applyObjectRuleForTypeRule(orule);
        }
        objectRule = CastUtils.INSTANCE;
        Rule<?> t$iv = ctx.getRule();
        boolean $i$f$cast = false;
        ObjectRule rule = (ObjectRule)t$iv;
        ObjectField<?, ?> field2 = rule.getRule(key);
        if (field2 == null) {
            this.nextRuleStack.push(NothingRule.INSTANCE);
        } else {
            this.nextRuleStack.push(field2.getRule());
        }
    }

    private final void set(Rule<?> _rule, Object holder, Function2<Object, Object, Unit> set, Object value) {
        Rule<?> rule = _rule.real();
        if (value == null) {
            if (_rule instanceof NullableRule) {
                set.invoke(holder, ((NullableRule)_rule).getOpIfNull().invoke());
                return;
            }
            if (rule instanceof ArrayRule || rule instanceof ObjectRule) {
                set.invoke(holder, null);
                return;
            }
        } else if (value instanceof Boolean) {
            if (rule instanceof BoolRule) {
                set.invoke(holder, value);
                return;
            }
        } else {
            if (rule instanceof DoubleRule && value instanceof Number) {
                set.invoke(holder, (Object)((Number)value).doubleValue());
                return;
            }
            if (rule instanceof LongRule && value instanceof Number) {
                if (value instanceof Long || value instanceof Integer) {
                    set.invoke(holder, (Object)((Number)value).longValue());
                    return;
                }
            } else if (rule instanceof IntRule && value instanceof Number) {
                if (value instanceof Integer) {
                    set.invoke(holder, value);
                    return;
                }
            } else if (value instanceof String) {
                if (rule instanceof StringRule) {
                    set.invoke(holder, value);
                    return;
                }
            } else {
                set.invoke(holder, value);
                return;
            }
        }
        throw new JsonParseException("invalid type: expecting: " + rule + ", value=" + value + '(' + (value == null ? "nil" : Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()) + ')');
    }

    @Override
    public void onObjectValue(@NotNull ObjectParser obj, @NotNull String key, @NotNull JSON.Instance<?> value) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (this.skip != 0) {
            return;
        }
        ParseContext ctx = this.parseStack.peek();
        if (ctx.getRule() instanceof TypeRule) {
            if (!(this.lastObject instanceof String)) {
                throw new JsonParseException("invalid type: expecting type name for " + ctx.getRule() + " but got " + this.lastObject);
            }
            CastUtils castUtils = CastUtils.INSTANCE;
            ObjectRule t$iv = this.lastObject;
            boolean bl = false;
            String type = (String)((Object)t$iv);
            t$iv = ((TypeRule)ctx.getRule()).getRule(type);
            if (t$iv == null) {
                throw new JsonParseException("cannot find type " + type + " in " + ctx.getRule());
            }
            ObjectRule orule = t$iv;
            this.applyObjectRuleForTypeRule(orule);
            return;
        }
        CastUtils orule = CastUtils.INSTANCE;
        Object t$iv = ctx.getRule();
        boolean bl = false;
        ObjectRule rule = (ObjectRule)t$iv;
        ObjectField<?, ?> field2 = rule.getRule(key);
        if (field2 == null) {
            for (Function3 function3 : rule.getExtraRules()) {
                CastUtils this_$iv = CastUtils.INSTANCE;
                boolean $i$f$cast2 = false;
                Object object = ctx.getObject();
                Intrinsics.checkNotNull((Object)object);
                function3.invoke(object, (Object)key, this.lastObject);
            }
            this.nextRuleStack.pop();
            return;
        }
        Rule<?> rule2 = field2.getRule();
        Object object = ctx.getObject();
        Intrinsics.checkNotNull((Object)object);
        t$iv = CastUtils.INSTANCE;
        Function2<?, ?, Unit> function2 = field2.getSet();
        boolean $i$f$cast3 = false;
        this.set(rule2, object, function2, this.lastObject);
        this.nextRuleStack.pop();
    }

    @Override
    public void onObjectValueJavaObject(@NotNull ObjectParser obj, @NotNull String key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.onObjectValue(obj, key, SimpleNull.Null);
    }

    @Override
    public void onObjectEnd(@NotNull ObjectParser obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (this.skip != 0) {
            DeserializeParserListener deserializeParserListener = this;
            deserializeParserListener.skip += -1;
            int cfr_ignored_0 = deserializeParserListener.skip;
            return;
        }
        ParseContext ctx = this.parseStack.pop();
        if (ctx.getRule() instanceof TypeRule) {
            ObjectRule objectRule = ((TypeRule)ctx.getRule()).getDefaultRule();
            if (objectRule == null) {
                throw new JsonParseException("type for " + ctx.getRule() + " is still not determined when reaching the object end");
            }
            ObjectRule orule = objectRule;
            Object constructed = orule.getConstruct().invoke();
            this.lastObject = orule.getBuild().invoke(constructed);
        } else {
            Object lastObject = ctx.getObject();
            CastUtils constructed = CastUtils.INSTANCE;
            Rule<?> t$iv = ctx.getRule();
            boolean $i$f$cast = false;
            CastUtils this_$iv = CastUtils.INSTANCE;
            boolean $i$f$cast2 = false;
            this.lastObject = ((ObjectRule)t$iv).getBuild().invoke(lastObject);
        }
    }

    @Override
    public void onArrayBegin(@NotNull ArrayParser array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (this.skip != 0) {
            DeserializeParserListener deserializeParserListener = this;
            ++deserializeParserListener.skip;
            int cfr_ignored_0 = deserializeParserListener.skip;
            return;
        }
        Rule<?> rule = this.nextRuleStack.peek().real();
        if (rule instanceof NothingRule) {
            this.skip = 1;
            return;
        }
        if (!(rule instanceof ArrayRule)) {
            throw new JsonParseException("expect: object, actual: array");
        }
        this.parseStack.push(new ParseContext(rule, ((ArrayRule)rule).getConstruct().invoke()));
        this.nextRuleStack.push(((ArrayRule)rule).getElementRule());
        this.begin = true;
    }

    @Override
    public void onArrayValue(@NotNull ArrayParser array, @NotNull JSON.Instance<?> value) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (this.skip != 0) {
            return;
        }
        ParseContext ctx = this.parseStack.peek();
        CastUtils castUtils = CastUtils.INSTANCE;
        Rule<?> t$iv = ctx.getRule();
        boolean $i$f$cast = false;
        ArrayRule rule = (ArrayRule)t$iv;
        Rule rule2 = rule.getElementRule();
        Object object = ctx.getObject();
        Intrinsics.checkNotNull((Object)object);
        this.set(rule2, object, rule.getAdd(), this.lastObject);
    }

    @Override
    public void onArrayValueJavaObject(@NotNull ArrayParser array, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.onArrayValue(array, SimpleNull.Null);
    }

    @Override
    public void onArrayEnd(@NotNull ArrayParser array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (this.skip != 0) {
            DeserializeParserListener deserializeParserListener = this;
            --deserializeParserListener.skip;
            return;
        }
        ParseContext ctx = this.parseStack.pop();
        this.nextRuleStack.pop();
        Object lastObject = ctx.getObject();
        CastUtils castUtils = CastUtils.INSTANCE;
        Rule<?> t$iv = ctx.getRule();
        boolean $i$f$cast = false;
        CastUtils this_$iv = CastUtils.INSTANCE;
        boolean $i$f$cast2 = false;
        this.lastObject = ((ArrayRule)t$iv).getBuild().invoke(lastObject);
    }

    @Override
    public void onBool(@NotNull JSON.Bool bool) {
        Intrinsics.checkNotNullParameter((Object)bool, (String)"bool");
        if (this.skip != 0) {
            return;
        }
        this.lastObject = bool.toJavaObject();
    }

    @Override
    public void onBool(boolean bool) {
        if (this.skip != 0) {
            return;
        }
        this.lastObject = bool;
    }

    @Override
    public void onNull(@NotNull JSON.Null n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        if (this.skip != 0) {
            return;
        }
        this.lastObject = null;
    }

    @Override
    public void onNull(@Nullable Unit n) {
        if (this.skip != 0) {
            return;
        }
        this.lastObject = null;
    }

    @Override
    public void onNumber(@NotNull JSON.Number<?> number) {
        Intrinsics.checkNotNullParameter(number, (String)"number");
        if (this.skip != 0) {
            return;
        }
        this.lastObject = number.toJavaObject();
    }

    @Override
    public void onNumber(@NotNull Number number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        if (this.skip != 0) {
            return;
        }
        this.lastObject = number;
    }

    @Override
    public void onString(@NotNull JSON.String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (this.skip != 0) {
            return;
        }
        this.lastObject = string.toJavaObject();
    }

    @Override
    public void onString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (this.skip != 0) {
            return;
        }
        this.lastObject = string;
    }

    public final boolean completed() {
        return this.begin && this.parseStack.isEmpty();
    }

    @Nullable
    public final T get() throws IllegalStateException {
        boolean bl = this.completed();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "not completed yet";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return (T)this.lastObject;
    }
}

