/*
 * Decompiled with CFR 0.152.
 */
package vjson.deserializer.rule;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.deserializer.rule.ObjectRule;
import vjson.deserializer.rule.Rule;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B\u001f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tB#\b\u0016\u0012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0011\u001a\f\u0012\u0006\b\u0001\u0012\u00028\u0000\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0006J&\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u00172\u0010\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0019H\u0016J*\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0012\u001a\u00020\u00062\u0014\u0010\u001b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\b0\u001cJ$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0012\u001a\u00020\u00062\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\bJ2\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u000b2\u0014\u0010\u001b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\b0\u001cJ,\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u000b2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\bR\u001b\u0010\u0007\u001a\f\u0012\u0006\b\u0001\u0012\u00028\u0000\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\"\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lvjson/deserializer/rule/TypeRule;", "T", "", "Lvjson/deserializer/rule/Rule;", "()V", "defaultTypeName", "", "defaultRule", "Lvjson/deserializer/rule/ObjectRule;", "(Ljava/lang/String;Lvjson/deserializer/rule/ObjectRule;)V", "kClass", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;Lvjson/deserializer/rule/ObjectRule;)V", "getDefaultRule", "()Lvjson/deserializer/rule/ObjectRule;", "rules", "", "getRule", "typeName", "toString", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "processedListsOrObjects", "", "type", "ruleFunc", "Lkotlin/Function0;", "rule", "vjson"})
public final class TypeRule<T>
extends Rule<T> {
    @Nullable
    private final ObjectRule<? extends T> defaultRule;
    @NotNull
    private final Map<String, ObjectRule<? extends T>> rules;

    @Nullable
    public final ObjectRule<? extends T> getDefaultRule() {
        return this.defaultRule;
    }

    public TypeRule() {
        this.rules = new LinkedHashMap();
        this.defaultRule = null;
    }

    public TypeRule(@NotNull String defaultTypeName, @NotNull ObjectRule<? extends T> defaultRule) {
        Intrinsics.checkNotNullParameter((Object)defaultTypeName, (String)"defaultTypeName");
        Intrinsics.checkNotNullParameter(defaultRule, (String)"defaultRule");
        this.rules = new LinkedHashMap();
        this.defaultRule = defaultRule;
        Map<String, ObjectRule<T>> map = this.rules;
        boolean bl = false;
        map.put(defaultTypeName, defaultRule);
    }

    public TypeRule(@NotNull KClass<?> kClass, @NotNull ObjectRule<? extends T> defaultRule) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        Intrinsics.checkNotNullParameter(defaultRule, (String)"defaultRule");
        String string = kClass.getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        this(string, defaultRule);
    }

    @NotNull
    public final TypeRule<T> type(@NotNull String typeName, @NotNull ObjectRule<? extends T> rule) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter(rule, (String)"rule");
        Map<String, ObjectRule<T>> map = this.rules;
        boolean bl = false;
        map.put(typeName, rule);
        return this;
    }

    @NotNull
    public final TypeRule<T> type(@NotNull String typeName, @NotNull Function0<? extends ObjectRule<? extends T>> ruleFunc) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter(ruleFunc, (String)"ruleFunc");
        return this.type(typeName, (ObjectRule)ruleFunc.invoke());
    }

    @NotNull
    public final TypeRule<T> type(@NotNull KClass<? extends T> kClass, @NotNull ObjectRule<? extends T> rule) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        Intrinsics.checkNotNullParameter(rule, (String)"rule");
        String string = kClass.getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        return this.type(string, rule);
    }

    @NotNull
    public final TypeRule<T> type(@NotNull KClass<? extends T> kClass, @NotNull Function0<? extends ObjectRule<? extends T>> ruleFunc) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        Intrinsics.checkNotNullParameter(ruleFunc, (String)"ruleFunc");
        return this.type(kClass, (ObjectRule)ruleFunc.invoke());
    }

    @Nullable
    public final ObjectRule<? extends T> getRule(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        return this.rules.get(typeName);
    }

    @Override
    public void toString(@NotNull StringBuilder sb, @NotNull Set<Rule<?>> processedListsOrObjects) {
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        Intrinsics.checkNotNullParameter(processedListsOrObjects, (String)"processedListsOrObjects");
        if (!processedListsOrObjects.add(this)) {
            sb.append("TypeRule{...recursive...}");
            return;
        }
        sb.append("TypeRule{");
        boolean isFirst = true;
        Object object = this.rules;
        boolean bl = false;
        Iterator<Map.Entry<String, ObjectRule<T>>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            String key = (String)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            ObjectRule value = (ObjectRule)object3.getValue();
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append("@type[").append(key);
            if (Intrinsics.areEqual((Object)value, this.defaultRule)) {
                sb.append("*");
            }
            sb.append("]=>");
            value.toString(sb, processedListsOrObjects);
        }
        sb.append("}");
    }
}

