/*
 * Decompiled with CFR 0.152.
 */
package vjson.parser;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.CharStream;
import vjson.JSON;
import vjson.Parser;
import vjson.cs.LineCol;
import vjson.ex.JsonParseException;
import vjson.ex.ParserFinishedException;
import vjson.parser.CompositeParser;
import vjson.parser.ParserMode;
import vjson.parser.ParserOptions;
import vjson.parser.ParserUtils;
import vjson.parser.TrustedFlag;
import vjson.simple.SimpleArray;
import vjson.util.CastUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\"\u0010\u001a\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001c\u001a\u00020\u0019H\u0016J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\u001eH\u0016J\u0018\u0010$\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\n2\u0010\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR6\u0010\u0010\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0018\u00010\n2\u0012\u0010\t\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lvjson/parser/ArrayParser;", "Lvjson/parser/CompositeParser;", "Lvjson/Parser;", "Lvjson/JSON$Array;", "opts", "Lvjson/parser/ParserOptions;", "(Lvjson/parser/ParserOptions;)V", "arrayLineCol", "Lvjson/cs/LineCol;", "<set-?>", "", "", "javaList", "getJavaList", "()Ljava/util/List;", "Lvjson/JSON$Instance;", "list", "getList", "state", "", "subParser", "build", "cs", "Lvjson/CharStream;", "isComplete", "", "buildJavaObject", "", "completed", "handleSubParser", "", "tryGetNewSubParser", "isComma", "c", "", "reset", "tryParse", "vjson"})
public final class ArrayParser
extends CompositeParser
implements Parser<JSON.Array> {
    @NotNull
    private final ParserOptions opts;
    private int state;
    @Nullable
    private List<JSON.Instance<?>> list;
    @Nullable
    private List<Object> javaList;
    @Nullable
    private Parser<?> subParser;
    @NotNull
    private LineCol arrayLineCol;

    @JvmOverloads
    public ArrayParser(@NotNull ParserOptions opts) {
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        super(opts);
        this.opts = ParserOptions.Companion.ensureNotModifiedByOutside(opts);
        this.arrayLineCol = LineCol.Companion.getEMPTY();
        this.reset();
    }

    public /* synthetic */ ArrayParser(ParserOptions parserOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            parserOptions = ParserOptions.DEFAULT;
        }
        this(parserOptions);
    }

    @Nullable
    public final List<JSON.Instance<?>> getList() {
        return this.list;
    }

    @Nullable
    public final List<Object> getJavaList() {
        return this.javaList;
    }

    @Override
    public void reset() {
        this.state = 0;
        if (this.opts.getMode() == ParserMode.JAVA_OBJECT) {
            this.javaList = this.opts.isNullArraysAndObjects() ? null : (List)new ArrayList();
        } else {
            this.list = new ArrayList();
        }
        this.subParser = null;
        this.arrayLineCol = LineCol.Companion.getEMPTY();
    }

    private final void handleSubParser(boolean tryGetNewSubParser, CharStream cs, boolean isComplete) {
        try {
            if (this.subParser == null) {
                if (tryGetNewSubParser) {
                    this.subParser = this.getSubParser(cs);
                } else {
                    return;
                }
            }
            if (this.opts.getMode() == ParserMode.JAVA_OBJECT) {
                Parser<?> parser = this.subParser;
                Intrinsics.checkNotNull(parser);
                Object o = parser.buildJavaObject(cs, isComplete);
                Parser<?> parser2 = this.subParser;
                Intrinsics.checkNotNull(parser2);
                if (parser2.completed()) {
                    this.state = 2;
                    if (!this.opts.isNullArraysAndObjects()) {
                        List<Object> list = this.javaList;
                        Intrinsics.checkNotNull(list);
                        list.add(o);
                    }
                    this.subParser = null;
                    this.opts.getListener().onArrayValueJavaObject(this, o);
                }
            } else {
                Parser<?> parser = this.subParser;
                Intrinsics.checkNotNull(parser);
                Object inst = parser.build(cs, isComplete);
                if (inst != null) {
                    this.state = 2;
                    List<JSON.Instance<?>> list = this.list;
                    Intrinsics.checkNotNull(list);
                    list.add((JSON.Instance<?>)inst);
                    this.subParser = null;
                    this.opts.getListener().onArrayValue(this, (JSON.Instance<?>)inst);
                }
            }
        }
        catch (JsonParseException e) {
            throw new JsonParseException("invalid json array: failed when parsing element: (" + e.getMessage() + ')', e, cs.lineCol());
        }
    }

    private final boolean tryParse(CharStream cs, boolean isComplete) {
        ArrayParser arrayParser;
        this.handleSubParser(false, cs, isComplete);
        char c = '\u0000';
        String err = null;
        if (this.state == 0) {
            cs.skipBlank();
            if (cs.hasNext()) {
                this.arrayLineCol = cs.lineCol();
                this.opts.getListener().onArrayBegin(this);
                c = cs.moveNextAndGet();
                if (c != '[') {
                    err = Intrinsics.stringPlus((String)"invalid character for json array: not starts with `[`: ", (Object)Character.valueOf(c));
                    throw ParserUtils.err$vjson(cs, this.opts, err);
                }
                arrayParser = this;
                ++arrayParser.state;
                int cfr_ignored_0 = arrayParser.state;
            }
        }
        if (this.state == 1) {
            cs.skipBlank();
            if (cs.hasNext()) {
                char peek = cs.peekNext();
                if (peek == ']') {
                    cs.moveNextAndGet();
                    this.state = 4;
                } else {
                    this.handleSubParser(true, cs, isComplete);
                }
            }
        }
        while (cs.hasNext()) {
            if (this.state == 2) {
                cs.skipBlank();
                if (cs.hasNext()) {
                    c = cs.peekNext();
                    if (c == ']') {
                        cs.moveNextAndGet();
                        this.state = 4;
                    } else if (this.isComma(c)) {
                        cs.moveNextAndGet();
                        this.state = 3;
                    } else if (this.opts.isAllowSkippingCommas()) {
                        this.state = 3;
                    } else {
                        err = Intrinsics.stringPlus((String)"invalid character for json array, expecting `]` or `,`, but got ", (Object)Character.valueOf(c));
                        throw ParserUtils.err$vjson(cs, this.opts, err);
                    }
                }
            }
            if (this.state == 3) {
                cs.skipBlank();
                if (cs.hasNext()) {
                    this.handleSubParser(true, cs, isComplete);
                }
            }
            if (this.state != 4 && this.state != 5) continue;
        }
        if (this.state == 4) {
            arrayParser = this;
            ++arrayParser.state;
            int cfr_ignored_1 = arrayParser.state;
            return true;
        }
        if (this.state == 5) {
            cs.skipBlank();
            if (cs.hasNext()) {
                throw new ParserFinishedException();
            }
            return false;
        }
        if (isComplete) {
            err = "expecting more characters to build array";
            throw ParserUtils.err$vjson(cs, this.opts, err);
        }
        return false;
    }

    private final boolean isComma(char c) {
        return c == ',' || this.opts.isSemicolonAsComma() && c == ';';
    }

    @Override
    @Nullable
    public JSON.Array build(@NotNull CharStream cs, boolean isComplete) throws JsonParseException, ParserFinishedException {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        if (this.tryParse(cs, isComplete)) {
            List<JSON.Instance<?>> list;
            this.opts.getListener().onArrayEnd(this);
            if (this.list == null) {
                list = CollectionsKt.emptyList();
            } else {
                CastUtils castUtils = CastUtils.INSTANCE;
                List<JSON.Instance<?>> t$iv = this.list;
                boolean $i$f$cast = false;
                list = t$iv;
            }
            List<JSON.Instance<?>> list2 = list;
            TrustedFlag trustedFlag = TrustedFlag.FLAG;
            LineCol lineCol = this.arrayLineCol;
            SimpleArray ret2 = new SimpleArray(list2, trustedFlag, lineCol){
                final /* synthetic */ List<JSON.Instance<?>> $list;
                {
                    this.$list = $list;
                    super($list, $super_call_param$1, $super_call_param$2);
                }
            };
            this.opts.getListener().onArray(ret2);
            ParserUtils.checkEnd$vjson(cs, this.opts, "array");
            return ret2;
        }
        return null;
    }

    @Override
    @Nullable
    public List<Object> buildJavaObject(@NotNull CharStream cs, boolean isComplete) throws JsonParseException, ParserFinishedException {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        if (this.tryParse(cs, isComplete)) {
            this.opts.getListener().onArrayEnd(this);
            this.opts.getListener().onArray(this.javaList);
            ParserUtils.checkEnd$vjson(cs, this.opts, "array");
            return this.javaList;
        }
        return null;
    }

    @Override
    public boolean completed() {
        return this.state == 5;
    }

    @JvmOverloads
    public ArrayParser() {
        this(null, 1, null);
    }
}

