/*
 * Decompiled with CFR 0.152.
 */
package vjson.parser;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.CharStream;
import vjson.JSON;
import vjson.Parser;
import vjson.cs.LineCol;
import vjson.ex.JsonParseException;
import vjson.ex.ParserFinishedException;
import vjson.parser.ParserOptions;
import vjson.parser.ParserUtils;
import vjson.simple.SimpleBool;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u001f\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\tH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lvjson/parser/BoolParser;", "Lvjson/Parser;", "Lvjson/JSON$Bool;", "opts", "Lvjson/parser/ParserOptions;", "(Lvjson/parser/ParserOptions;)V", "boolLineCol", "Lvjson/cs/LineCol;", "result", "", "state", "", "build", "cs", "Lvjson/CharStream;", "isComplete", "buildJavaObject", "(Lvjson/CharStream;Z)Ljava/lang/Boolean;", "completed", "reset", "", "tryParse", "vjson"})
public final class BoolParser
implements Parser<JSON.Bool> {
    @NotNull
    private final ParserOptions opts;
    private int state;
    private boolean result;
    @NotNull
    private LineCol boolLineCol;

    @JvmOverloads
    public BoolParser(@NotNull ParserOptions opts) {
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        this.opts = ParserOptions.Companion.ensureNotModifiedByOutside(opts);
        this.boolLineCol = LineCol.Companion.getEMPTY();
    }

    public /* synthetic */ BoolParser(ParserOptions parserOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            parserOptions = ParserOptions.DEFAULT;
        }
        this(parserOptions);
    }

    @Override
    public void reset() {
        this.state = 0;
        this.boolLineCol = LineCol.Companion.getEMPTY();
    }

    private final boolean tryParse(CharStream cs, boolean isComplete) {
        BoolParser boolParser;
        char c = '\u0000';
        String err = null;
        if (this.state == 0) {
            cs.skipBlank();
            if (cs.hasNext()) {
                this.boolLineCol = cs.lineCol();
                this.opts.getListener().onBoolBegin(this);
                c = cs.moveNextAndGet();
                if (c == 't') {
                    this.result = true;
                    this.state = 1;
                } else if (c == 'f') {
                    this.result = false;
                    this.state = 4;
                } else {
                    err = Intrinsics.stringPlus((String)"invalid character for [t]rue|[f]alse: ", (Object)Character.valueOf(c));
                    throw ParserUtils.err$vjson(cs, this.opts, err);
                }
            }
        }
        if (this.state == 1 && cs.hasNext()) {
            c = cs.moveNextAndGet();
            if (c != 'r') {
                err = Intrinsics.stringPlus((String)"invalid character for t[r]ue: ", (Object)Character.valueOf(c));
                throw ParserUtils.err$vjson(cs, this.opts, err);
            }
            boolParser = this;
            ++boolParser.state;
            int cfr_ignored_0 = boolParser.state;
        }
        if (this.state == 2 && cs.hasNext()) {
            c = cs.moveNextAndGet();
            if (c != 'u') {
                err = Intrinsics.stringPlus((String)"invalid character for tr[u]e: ", (Object)Character.valueOf(c));
                throw ParserUtils.err$vjson(cs, this.opts, err);
            }
            boolParser = this;
            ++boolParser.state;
            int cfr_ignored_1 = boolParser.state;
        }
        if (this.state == 3 && cs.hasNext()) {
            c = cs.moveNextAndGet();
            if (c != 'e') {
                err = Intrinsics.stringPlus((String)"invalid character for tru[e]: ", (Object)Character.valueOf(c));
                throw ParserUtils.err$vjson(cs, this.opts, err);
            }
            this.state = 8;
        }
        if (this.state == 4 && cs.hasNext()) {
            c = cs.moveNextAndGet();
            if (c != 'a') {
                err = Intrinsics.stringPlus((String)"invalid character for f[a]lse: ", (Object)Character.valueOf(c));
                throw ParserUtils.err$vjson(cs, this.opts, err);
            }
            boolParser = this;
            ++boolParser.state;
            int cfr_ignored_2 = boolParser.state;
        }
        if (this.state == 5 && cs.hasNext()) {
            c = cs.moveNextAndGet();
            if (c != 'l') {
                err = Intrinsics.stringPlus((String)"invalid character for fa[l]se: ", (Object)Character.valueOf(c));
                throw ParserUtils.err$vjson(cs, this.opts, err);
            }
            boolParser = this;
            ++boolParser.state;
            int cfr_ignored_3 = boolParser.state;
        }
        if (this.state == 6 && cs.hasNext()) {
            c = cs.moveNextAndGet();
            if (c != 's') {
                err = Intrinsics.stringPlus((String)"invalid character for fal[s]e: ", (Object)Character.valueOf(c));
                throw ParserUtils.err$vjson(cs, this.opts, err);
            }
            boolParser = this;
            ++boolParser.state;
            int cfr_ignored_4 = boolParser.state;
        }
        if (this.state == 7 && cs.hasNext()) {
            c = cs.moveNextAndGet();
            if (c != 'e') {
                err = Intrinsics.stringPlus((String)"invalid character for fals[e]: ", (Object)Character.valueOf(c));
                throw ParserUtils.err$vjson(cs, this.opts, err);
            }
            boolParser = this;
            ++boolParser.state;
            int cfr_ignored_5 = boolParser.state;
        }
        if (this.state == 8) {
            boolParser = this;
            ++boolParser.state;
            int cfr_ignored_6 = boolParser.state;
            return true;
        }
        if (this.state == 9) {
            cs.skipBlank();
            if (cs.hasNext()) {
                throw new ParserFinishedException();
            }
            return false;
        }
        if (isComplete) {
            err = "expecting more characters to build `true` or `false`";
            throw ParserUtils.err$vjson(cs, this.opts, err);
        }
        return false;
    }

    @Override
    @Nullable
    public JSON.Bool build(@NotNull CharStream cs, boolean isComplete) throws JsonParseException, ParserFinishedException {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        if (this.tryParse(cs, isComplete)) {
            this.opts.getListener().onBoolEnd(this);
            SimpleBool ret2 = new SimpleBool(this.result, this.boolLineCol);
            this.opts.getListener().onBool(ret2);
            ParserUtils.checkEnd$vjson(cs, this.opts, "`true|false`");
            return ret2;
        }
        return null;
    }

    @Override
    @Nullable
    public Boolean buildJavaObject(@NotNull CharStream cs, boolean isComplete) throws JsonParseException, ParserFinishedException {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        if (this.tryParse(cs, isComplete)) {
            this.opts.getListener().onBoolEnd(this);
            boolean ret2 = this.result;
            this.opts.getListener().onBool(ret2);
            ParserUtils.checkEnd$vjson(cs, this.opts, "`true|false`");
            return ret2;
        }
        return null;
    }

    @Override
    public boolean completed() {
        return this.state == 9;
    }

    @JvmOverloads
    public BoolParser() {
        this(null, 1, null);
    }
}

