/*
 * Decompiled with CFR 0.152.
 */
package vjson.parser;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.CharStream;
import vjson.JSON;
import vjson.Parser;
import vjson.ex.JsonParseException;
import vjson.parser.ArrayParser;
import vjson.parser.BoolParser;
import vjson.parser.NullParser;
import vjson.parser.NumberParser;
import vjson.parser.ObjectParser;
import vjson.parser.ParserMode;
import vjson.parser.ParserOptions;
import vjson.parser.ParserUtils;
import vjson.parser.StringParser;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0006H\u0004J\b\u0010\u0013\u001a\u00020\bH\u0004J\u0006\u0010\u0014\u001a\u00020\nJ\b\u0010\u0015\u001a\u00020\fH\u0004J\b\u0010\u0016\u001a\u00020\u000eH\u0004J\b\u0010\u0017\u001a\u00020\u0010H\u0004J\b\u0010\u0018\u001a\u00020\nH\u0004J\u0014\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0004J\u0014\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lvjson/parser/CompositeParser;", "", "opts", "Lvjson/parser/ParserOptions;", "(Lvjson/parser/ParserOptions;)V", "arrayParser", "Lvjson/parser/ArrayParser;", "boolParser", "Lvjson/parser/BoolParser;", "keyParser", "Lvjson/parser/StringParser;", "nullParser", "Lvjson/parser/NullParser;", "numberParser", "Lvjson/parser/NumberParser;", "objectParser", "Lvjson/parser/ObjectParser;", "stringParser", "getArrayParser", "getBoolParser", "getKeyParser", "getNullParser", "getNumberParser", "getObjectParser", "getStringParser", "getSubParser", "Lvjson/Parser;", "cs", "Lvjson/CharStream;", "parserForValueNoQuotes", "vjson"})
public class CompositeParser {
    @NotNull
    private final ParserOptions opts;
    @Nullable
    private ArrayParser arrayParser;
    @Nullable
    private BoolParser boolParser;
    @Nullable
    private NullParser nullParser;
    @Nullable
    private NumberParser numberParser;
    @Nullable
    private ObjectParser objectParser;
    @Nullable
    private StringParser stringParser;
    @Nullable
    private StringParser keyParser;

    protected CompositeParser(@NotNull ParserOptions opts) {
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        this.opts = opts;
    }

    @NotNull
    protected final ArrayParser getArrayParser() {
        if (this.arrayParser == null) {
            this.arrayParser = new ArrayParser(ParserUtils.subParserOptions$vjson(this.opts));
        } else {
            ArrayParser arrayParser = this.arrayParser;
            Intrinsics.checkNotNull((Object)arrayParser);
            arrayParser.reset();
        }
        ArrayParser arrayParser = this.arrayParser;
        Intrinsics.checkNotNull((Object)arrayParser);
        return arrayParser;
    }

    @NotNull
    protected final BoolParser getBoolParser() {
        if (this.boolParser == null) {
            this.boolParser = new BoolParser(ParserUtils.subParserOptions$vjson(this.opts));
        } else {
            BoolParser boolParser = this.boolParser;
            Intrinsics.checkNotNull((Object)boolParser);
            boolParser.reset();
        }
        BoolParser boolParser = this.boolParser;
        Intrinsics.checkNotNull((Object)boolParser);
        return boolParser;
    }

    @NotNull
    protected final NullParser getNullParser() {
        if (this.nullParser == null) {
            this.nullParser = new NullParser(ParserUtils.subParserOptions$vjson(this.opts));
        } else {
            NullParser nullParser = this.nullParser;
            Intrinsics.checkNotNull((Object)nullParser);
            nullParser.reset();
        }
        NullParser nullParser = this.nullParser;
        Intrinsics.checkNotNull((Object)nullParser);
        return nullParser;
    }

    @NotNull
    protected final NumberParser getNumberParser() {
        if (this.numberParser == null) {
            this.numberParser = new NumberParser(ParserUtils.subParserOptions$vjson(this.opts));
        } else {
            NumberParser numberParser = this.numberParser;
            Intrinsics.checkNotNull((Object)numberParser);
            numberParser.reset();
        }
        NumberParser numberParser = this.numberParser;
        Intrinsics.checkNotNull((Object)numberParser);
        return numberParser;
    }

    @NotNull
    protected final ObjectParser getObjectParser() {
        if (this.objectParser == null) {
            this.objectParser = new ObjectParser(ParserUtils.subParserOptions$vjson(this.opts));
        } else {
            ObjectParser objectParser = this.objectParser;
            Intrinsics.checkNotNull((Object)objectParser);
            objectParser.reset();
        }
        ObjectParser objectParser = this.objectParser;
        Intrinsics.checkNotNull((Object)objectParser);
        return objectParser;
    }

    @NotNull
    protected final StringParser getStringParser() {
        if (this.stringParser == null) {
            this.stringParser = new StringParser(ParserUtils.subParserOptions$vjson(this.opts));
        } else {
            StringParser stringParser = this.stringParser;
            Intrinsics.checkNotNull((Object)stringParser);
            stringParser.reset();
        }
        StringParser stringParser = this.stringParser;
        Intrinsics.checkNotNull((Object)stringParser);
        return stringParser;
    }

    @NotNull
    protected final Parser<?> getSubParser(@NotNull CharStream cs) {
        Parser parser;
        char first;
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        if (this.opts.isStringValueNoQuotes() && (first = cs.peekNext()) != '{' && first != '[' && first != '\'' && first != '\"') {
            return this.parserForValueNoQuotes(cs);
        }
        first = cs.peekNext();
        if (first == '{') {
            parser = this.getObjectParser();
        } else if (first == '[') {
            parser = this.getArrayParser();
        } else if (first == '\'') {
            if (!this.opts.isStringSingleQuotes()) {
                throw new JsonParseException("not valid json string", cs.lineCol());
            }
            parser = this.getStringParser();
        } else if (first == '\"') {
            parser = this.getStringParser();
        } else if (first == 'n') {
            parser = this.getNullParser();
        } else if (first == 't') {
            parser = this.getBoolParser();
        } else if (first == 'f') {
            parser = this.getBoolParser();
        } else if (first == '-') {
            parser = this.getNumberParser();
        } else {
            boolean bl = '0' <= first ? first <= '9' : false;
            if (bl) {
                return this.getNumberParser();
            }
            throw new JsonParseException("not valid json string", cs.lineCol());
        }
        return parser;
    }

    @NotNull
    public final StringParser getKeyParser() {
        if (this.keyParser == null) {
            ParserOptions opts = null;
            if (ParserOptions.Companion.isDefaultOptions(this.opts)) {
                opts = ParserOptions.DEFAULT_JAVA_OBJECT_NO_END;
            } else {
                opts = new ParserOptions(this.opts).setEnd(false).setMode(ParserMode.JAVA_OBJECT).setListener(null);
                if (this.opts.isKeyNoQuotes()) {
                    opts.setStringValueNoQuotes(true);
                } else {
                    opts.setStringValueNoQuotes(false);
                }
            }
            this.keyParser = new StringParser(opts, ParserUtils.getThreadLocalKeyDictionary(), true);
        } else {
            StringParser stringParser = this.keyParser;
            Intrinsics.checkNotNull((Object)stringParser);
            stringParser.reset();
        }
        StringParser stringParser = this.keyParser;
        Intrinsics.checkNotNull((Object)stringParser);
        return stringParser;
    }

    private final Parser<?> parserForValueNoQuotes(CharStream cs) {
        JSON.Instance res;
        CharStream newCS2;
        Pair<String, Integer> pair = ParserUtils.INSTANCE.extractNoQuotesString(cs, this.opts, false);
        String str = (String)pair.component1();
        try {
            newCS2 = CharStream.Companion.from(str);
            res = (JSON.Number)this.getNumberParser().last(newCS2);
            newCS2.skipBlank();
            if (res != null && !newCS2.hasNext()) {
                return this.getNumberParser();
            }
        }
        catch (JsonParseException newCS2) {
            // empty catch block
        }
        try {
            newCS2 = CharStream.Companion.from(str);
            res = (JSON.Bool)this.getBoolParser().last(newCS2);
            newCS2.skipBlank();
            if (res != null && !newCS2.hasNext()) {
                return this.getBoolParser();
            }
        }
        catch (JsonParseException newCS3) {
            // empty catch block
        }
        try {
            newCS2 = CharStream.Companion.from(str);
            res = (JSON.Null)this.getNullParser().last(newCS2);
            newCS2.skipBlank();
            if (res != null && !newCS2.hasNext()) {
                return this.getNullParser();
            }
        }
        catch (JsonParseException jsonParseException) {
            // empty catch block
        }
        return this.getStringParser();
    }
}

