/*
 * Decompiled with CFR 0.152.
 */
package vjson.parser;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.CharStream;
import vjson.JSON;
import vjson.Parser;
import vjson.cs.LineCol;
import vjson.ex.JsonParseException;
import vjson.ex.ParserFinishedException;
import vjson.parser.ParserOptions;
import vjson.parser.ParserUtils;
import vjson.simple.SimpleNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lvjson/parser/NullParser;", "Lvjson/Parser;", "Lvjson/JSON$Null;", "opts", "Lvjson/parser/ParserOptions;", "(Lvjson/parser/ParserOptions;)V", "nullLineCol", "Lvjson/cs/LineCol;", "state", "", "build", "cs", "Lvjson/CharStream;", "isComplete", "", "buildJavaObject", "", "completed", "reset", "", "tryParse", "vjson"})
public final class NullParser
implements Parser<JSON.Null> {
    @NotNull
    private final ParserOptions opts;
    private int state;
    @NotNull
    private LineCol nullLineCol;

    @JvmOverloads
    public NullParser(@NotNull ParserOptions opts) {
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        this.opts = ParserOptions.Companion.ensureNotModifiedByOutside(opts);
        this.nullLineCol = LineCol.Companion.getEMPTY();
    }

    public /* synthetic */ NullParser(ParserOptions parserOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            parserOptions = ParserOptions.DEFAULT;
        }
        this(parserOptions);
    }

    @Override
    public void reset() {
        this.state = 0;
        this.nullLineCol = LineCol.Companion.getEMPTY();
    }

    private final boolean tryParse(CharStream cs, boolean isComplete) {
        NullParser nullParser;
        char c = '\u0000';
        String err = null;
        if (this.state == 0) {
            cs.skipBlank();
            if (cs.hasNext()) {
                this.nullLineCol = cs.lineCol();
                this.opts.getListener().onNullBegin(this);
                c = cs.moveNextAndGet();
                if (c != 'n') {
                    err = Intrinsics.stringPlus((String)"invalid character for `[n]ull`: ", (Object)Character.valueOf(c));
                    throw ParserUtils.err$vjson(cs, this.opts, err);
                }
                nullParser = this;
                ++nullParser.state;
                int cfr_ignored_0 = nullParser.state;
            }
        }
        if (this.state == 1 && cs.hasNext()) {
            c = cs.moveNextAndGet();
            if (c != 'u') {
                err = Intrinsics.stringPlus((String)"invalid character for `n[u]ll`: ", (Object)Character.valueOf(c));
                throw ParserUtils.err$vjson(cs, this.opts, err);
            }
            nullParser = this;
            ++nullParser.state;
            int cfr_ignored_1 = nullParser.state;
        }
        if (this.state == 2 && cs.hasNext()) {
            c = cs.moveNextAndGet();
            if (c != 'l') {
                err = Intrinsics.stringPlus((String)"invalid character for `nu[l]l`: ", (Object)Character.valueOf(c));
                throw ParserUtils.err$vjson(cs, this.opts, err);
            }
            nullParser = this;
            ++nullParser.state;
            int cfr_ignored_2 = nullParser.state;
        }
        if (this.state == 3 && cs.hasNext()) {
            c = cs.moveNextAndGet();
            if (c != 'l') {
                err = Intrinsics.stringPlus((String)"invalid character for `nul[l]`: ", (Object)Character.valueOf(c));
                throw ParserUtils.err$vjson(cs, this.opts, err);
            }
            nullParser = this;
            ++nullParser.state;
            int cfr_ignored_3 = nullParser.state;
        }
        if (this.state == 4) {
            nullParser = this;
            ++nullParser.state;
            int cfr_ignored_4 = nullParser.state;
            return true;
        }
        if (this.state == 5) {
            cs.skipBlank();
            if (cs.hasNext()) {
                throw new ParserFinishedException();
            }
            return false;
        }
        if (isComplete) {
            err = "expecting more characters to build `null`";
            throw ParserUtils.err$vjson(cs, this.opts, err);
        }
        return false;
    }

    @Override
    @Nullable
    public JSON.Null build(@NotNull CharStream cs, boolean isComplete) throws JsonParseException, ParserFinishedException {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        if (this.tryParse(cs, isComplete)) {
            this.opts.getListener().onNullEnd(this);
            SimpleNull n = new SimpleNull(this.nullLineCol);
            this.opts.getListener().onNull(n);
            ParserUtils.checkEnd$vjson(cs, this.opts, "`null`");
            return n;
        }
        return null;
    }

    @Override
    @Nullable
    public Object buildJavaObject(@NotNull CharStream cs, boolean isComplete) throws JsonParseException, ParserFinishedException {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        if (this.tryParse(cs, isComplete)) {
            this.opts.getListener().onNullEnd(this);
            this.opts.getListener().onNull((Unit)null);
            ParserUtils.checkEnd$vjson(cs, this.opts, "`null`");
            return null;
        }
        return null;
    }

    @Override
    public boolean completed() {
        return this.state == 5;
    }

    @JvmOverloads
    public NullParser() {
        this(null, 1, null);
    }
}

