/*
 * Decompiled with CFR 0.152.
 */
package vjson.parser;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.CharStream;
import vjson.JSON;
import vjson.Parser;
import vjson.cs.LineCol;
import vjson.ex.JsonParseException;
import vjson.ex.ParserFinishedException;
import vjson.parser.ParserOptions;
import vjson.parser.ParserUtils;
import vjson.simple.SimpleDouble;
import vjson.simple.SimpleExp;
import vjson.simple.SimpleInteger;
import vjson.simple.SimpleLong;
import vjson.util.CastUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\f\n\u0002\b\u0007\u0018\u0000 :2\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001:\u0001:B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0012H\u0016J\u001a\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0012H\u0016J\b\u0010)\u001a\u00020*H\u0002J\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020,J\b\u0010.\u001a\u00020\u0012H\u0016J\b\u0010/\u001a\u00020,H\u0002J\b\u00100\u001a\u00020,H\u0002J\u0018\u00101\u001a\u00020,2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0012H\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0010\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u000204H\u0002J\b\u00105\u001a\u00020,H\u0016J\u000e\u00106\u001a\u00020,2\u0006\u0010\b\u001a\u00020\u0007J\u0016\u00107\u001a\u00020,2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u00108\u001a\u00020\u0007J\u0018\u00109\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0012H\u0002R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000e\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001a\"\u0004\b\u001e\u0010\u001cR\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lvjson/parser/NumberParser;", "Lvjson/Parser;", "Lvjson/JSON$Number;", "opts", "Lvjson/parser/ParserOptions;", "(Lvjson/parser/ParserOptions;)V", "<set-?>", "", "exponent", "getExponent", "()I", "", "fraction", "getFraction", "()J", "fractionDivisorZeros", "getFractionDivisorZeros", "hasExponent", "", "hasFraction", "value", "integer", "getInteger", "setInteger", "(J)V", "isExponentNegative", "()Z", "setExponentNegative", "(Z)V", "isNegative", "setNegative", "numberLineCol", "Lvjson/cs/LineCol;", "state", "wantPeek", "build", "cs", "Lvjson/CharStream;", "isComplete", "buildJavaObject", "", "calcFraction", "", "clearExponent", "", "clearFraction", "completed", "exponentBegin", "fractionBegin", "gotoFractionExponentEnd", "parseDigit", "c", "", "reset", "setExponent", "setFraction", "divisorZeros", "tryParse", "Companion", "vjson"})
public final class NumberParser
implements Parser<JSON.Number<?>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ParserOptions opts;
    private int state;
    private boolean wantPeek;
    private boolean isNegative;
    private long integer;
    private boolean hasFraction;
    private long fraction;
    private int fractionDivisorZeros;
    private boolean hasExponent;
    private boolean isExponentNegative;
    private int exponent;
    @NotNull
    private LineCol numberLineCol;
    private static final int MAX_DIVISOR_ZEROS = 9;
    private static final long MAX_DIVISOR = 1000000000L;

    @JvmOverloads
    public NumberParser(@NotNull ParserOptions opts) {
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        this.opts = ParserOptions.Companion.ensureNotModifiedByOutside(opts);
        this.numberLineCol = LineCol.Companion.getEMPTY();
        this.reset();
    }

    public /* synthetic */ NumberParser(ParserOptions parserOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            parserOptions = ParserOptions.DEFAULT;
        }
        this(parserOptions);
    }

    public final boolean isNegative() {
        return this.isNegative;
    }

    public final void setNegative(boolean bl) {
        this.isNegative = bl;
    }

    public final long getInteger() {
        return this.integer;
    }

    public final void setInteger(long value) {
        boolean bl = value >= 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.integer = value;
    }

    public final long getFraction() {
        return this.fraction;
    }

    public final int getFractionDivisorZeros() {
        return this.fractionDivisorZeros;
    }

    public final boolean isExponentNegative() {
        return this.isExponentNegative;
    }

    public final void setExponentNegative(boolean bl) {
        this.isExponentNegative = bl;
    }

    public final int getExponent() {
        return this.exponent;
    }

    @Override
    public void reset() {
        this.state = 0;
        this.wantPeek = false;
        this.isNegative = false;
        this.setInteger(0L);
        this.hasFraction = false;
        this.fraction = 0L;
        this.fractionDivisorZeros = 0;
        this.hasExponent = false;
        this.isExponentNegative = false;
        this.exponent = 0;
        this.numberLineCol = LineCol.Companion.getEMPTY();
    }

    public final boolean hasFraction() {
        return this.hasFraction;
    }

    public final void clearFraction() {
        this.hasFraction = false;
        this.fraction = 0L;
        this.fractionDivisorZeros = 0;
    }

    public final void setFraction(long fraction, int divisorZeros) {
        boolean bl = fraction >= 0L && divisorZeros >= 1;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.hasFraction = true;
        this.fraction = fraction;
        this.fractionDivisorZeros = divisorZeros;
    }

    public final boolean hasExponent() {
        return this.hasExponent;
    }

    public final void setExponent(int exponent) {
        boolean bl = exponent >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.hasExponent = true;
        this.exponent = exponent;
    }

    public final void clearExponent() {
        this.hasExponent = false;
        this.isExponentNegative = false;
        this.exponent = 0;
    }

    private final int parseDigit(char c) {
        boolean bl = 48 <= c ? c <= 57 : false;
        if (bl) {
            int n = c;
            boolean bl2 = false;
            int n2 = n;
            n = 48;
            bl2 = false;
            return n2 - n;
        }
        return -1;
    }

    private final void fractionBegin() {
        this.hasFraction = true;
        this.state = 3;
        this.opts.getListener().onNumberFractionBegin(this, this.integer);
    }

    private final void exponentBegin() {
        this.hasExponent = true;
        this.state = 5;
        this.opts.getListener().onNumberExponentBegin(this, (double)this.integer + (this.hasFraction ? this.calcFraction() : 0.0));
    }

    /*
     * WARNING - void declaration
     */
    private final double calcFraction() {
        if (this.fractionDivisorZeros < 9) {
            void startInclusive$iv;
            long divisor = 0L;
            divisor = 1L;
            CastUtils castUtils = CastUtils.INSTANCE;
            boolean bl = false;
            int endExclusive$iv = this.fractionDivisorZeros;
            boolean $i$f$forIndex = false;
            void var6_8 = startInclusive$iv;
            if (var6_8 < endExclusive$iv) {
                do {
                    void i$iv;
                    void it = i$iv = var6_8++;
                    boolean bl2 = false;
                    divisor *= (long)10;
                } while (var6_8 < endExclusive$iv);
            }
            return (double)this.fraction / (double)divisor;
        }
        double fraction = (double)this.fraction / 1.0E9;
        int fractionDivisorZeros = this.fractionDivisorZeros - 9;
        while (true) {
            if (fractionDivisorZeros < 9) {
                long divisor = 1L;
                int n = 0;
                if (n < fractionDivisorZeros) {
                    do {
                        int i = n++;
                        divisor *= (long)10;
                    } while (n < fractionDivisorZeros);
                }
                return fraction / (double)divisor;
            }
            fraction /= 1.0E9;
            fractionDivisorZeros -= 9;
        }
    }

    private final void gotoFractionExponentEnd(CharStream cs, boolean isComplete) {
        if (cs.hasNext()) {
            char peek = cs.peekNext();
            if (peek == '.') {
                cs.moveNextAndGet();
                this.fractionBegin();
            } else if (peek == 'e' || peek == 'E') {
                cs.moveNextAndGet();
                this.exponentBegin();
            } else {
                this.state = 8;
            }
        } else if (isComplete) {
            this.state = 8;
        } else {
            this.wantPeek = true;
        }
    }

    private final boolean tryParse(CharStream cs, boolean isComplete) {
        int d;
        if (this.wantPeek) {
            this.wantPeek = false;
            this.gotoFractionExponentEnd(cs, isComplete);
        }
        char c = '\u0000';
        String err = null;
        if (this.state == 0) {
            cs.skipBlank();
            if (cs.hasNext()) {
                this.numberLineCol = cs.lineCol();
                this.opts.getListener().onNumberBegin(this);
                c = cs.moveNextAndGet();
                if (c == '-') {
                    this.isNegative = true;
                    this.state = 1;
                } else {
                    d = this.parseDigit(c);
                    if (d == -1) {
                        err = Intrinsics.stringPlus((String)"invalid digit in number: ", (Object)Character.valueOf(c));
                        throw ParserUtils.err$vjson(cs, this.opts, err);
                    }
                    if (d == 0) {
                        this.setInteger(0L);
                        this.gotoFractionExponentEnd(cs, isComplete);
                    } else {
                        this.setInteger(d);
                        this.state = 2;
                    }
                }
            }
        }
        if (this.state == 1 && cs.hasNext()) {
            c = cs.moveNextAndGet();
            d = this.parseDigit(c);
            if (d == -1) {
                err = Intrinsics.stringPlus((String)"invalid digit in number: ", (Object)Character.valueOf(c));
                throw ParserUtils.err$vjson(cs, this.opts, err);
            }
            if (d == 0) {
                this.setInteger(0L);
                this.gotoFractionExponentEnd(cs, isComplete);
            } else {
                this.setInteger(d);
                this.state = 2;
            }
        }
        while (cs.hasNext()) {
            NumberParser nextFraction2;
            NumberParser numberParser;
            if (this.state == 2) {
                c = cs.peekNext();
                if (c == '.') {
                    cs.moveNextAndGet();
                    this.fractionBegin();
                } else if (c == 'e' || c == 'E') {
                    cs.moveNextAndGet();
                    this.exponentBegin();
                } else {
                    d = this.parseDigit(c);
                    if (d == -1) {
                        this.state = 8;
                    } else {
                        cs.moveNextAndGet();
                        numberParser = this;
                        numberParser.setInteger(numberParser.integer * (long)10);
                        numberParser = this;
                        numberParser.setInteger(numberParser.integer + (long)d);
                        this.state = 2;
                    }
                }
            }
            if (this.state == 3 && cs.hasNext()) {
                c = cs.moveNextAndGet();
                d = this.parseDigit(c);
                if (d == -1) {
                    err = Intrinsics.stringPlus((String)"invalid digit in fraction: ", (Object)Character.valueOf(c));
                    throw ParserUtils.err$vjson(cs, this.opts, err);
                }
                this.fraction = d;
                numberParser = this;
                ++numberParser.fractionDivisorZeros;
                int cfr_ignored_0 = numberParser.fractionDivisorZeros;
                this.state = 4;
            }
            if (this.state == 4 && cs.hasNext()) {
                c = cs.peekNext();
                if (c == 'e' || c == 'E') {
                    cs.moveNextAndGet();
                    this.exponentBegin();
                } else {
                    d = this.parseDigit(c);
                    if (d == -1) {
                        this.state = 8;
                    } else {
                        cs.moveNextAndGet();
                        long nextFraction2 = this.fraction * (long)10;
                        if (nextFraction2 >= 0L) {
                            this.fraction = nextFraction2;
                            NumberParser numberParser2 = this;
                            numberParser2.fraction += (long)d;
                            numberParser2 = this;
                            ++numberParser2.fractionDivisorZeros;
                            int cfr_ignored_1 = numberParser2.fractionDivisorZeros;
                        }
                        this.state = 4;
                        continue;
                    }
                }
            }
            if (this.state == 5 && cs.hasNext()) {
                c = cs.moveNextAndGet();
                if (c == '+') {
                    this.isExponentNegative = false;
                    this.state = 6;
                } else if (c == '-') {
                    this.isExponentNegative = true;
                    this.state = 6;
                } else {
                    d = this.parseDigit(c);
                    if (d == -1) {
                        err = Intrinsics.stringPlus((String)"invalid digit in exponent: ", (Object)Character.valueOf(c));
                        throw ParserUtils.err$vjson(cs, this.opts, err);
                    }
                    nextFraction2 = this;
                    nextFraction2.exponent *= 10;
                    nextFraction2 = this;
                    nextFraction2.exponent += d;
                    this.state = 7;
                }
            }
            if (this.state == 6 && cs.hasNext()) {
                c = cs.moveNextAndGet();
                d = this.parseDigit(c);
                if (d == -1) {
                    err = Intrinsics.stringPlus((String)"invalid digit in exponent: ", (Object)Character.valueOf(c));
                    throw ParserUtils.err$vjson(cs, this.opts, err);
                }
                nextFraction2 = this;
                nextFraction2.exponent *= 10;
                nextFraction2 = this;
                nextFraction2.exponent += d;
                this.state = 7;
            }
            if (this.state == 7 && cs.hasNext()) {
                char peek = cs.peekNext();
                int d2 = this.parseDigit(peek);
                if (d2 == -1) {
                    this.state = 8;
                } else {
                    cs.moveNextAndGet();
                    NumberParser numberParser3 = this;
                    numberParser3.exponent *= 10;
                    numberParser3 = this;
                    numberParser3.exponent += d2;
                    this.state = 7;
                }
            }
            if (this.state != 8 && this.state != 9) continue;
        }
        if (this.state == 8) {
            NumberParser numberParser = this;
            ++numberParser.state;
            int cfr_ignored_2 = numberParser.state;
            return true;
        }
        if (this.state == 9) {
            cs.skipBlank();
            if (cs.hasNext()) {
                throw new ParserFinishedException();
            }
            return false;
        }
        if (isComplete) {
            if (this.state == 2 || this.state == 4 || this.state == 7) {
                this.state = 9;
                return true;
            }
            err = "expecting more characters to build number";
            throw ParserUtils.err$vjson(cs, this.opts, err);
        }
        return false;
    }

    @Override
    @Nullable
    public JSON.Number<?> build(@NotNull CharStream cs, boolean isComplete) throws JsonParseException, ParserFinishedException {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        if (this.tryParse(cs, isComplete)) {
            this.opts.getListener().onNumberEnd(this);
            JSON.Number ret2 = null;
            if (this.hasFraction) {
                double num = (double)this.integer + this.calcFraction();
                double d = num = this.isNegative ? -num : num;
                ret2 = this.hasExponent ? (JSON.Number)new SimpleExp(num, this.isExponentNegative ? -this.exponent : this.exponent, this.numberLineCol) : (JSON.Number)new SimpleDouble(num, this.numberLineCol);
            } else {
                long num;
                long l = num = this.isNegative ? -this.integer : this.integer;
                ret2 = this.hasExponent ? (JSON.Number)new SimpleExp(num, this.isExponentNegative ? -this.exponent : this.exponent, this.numberLineCol) : (this.isNegative ? (num < Integer.MIN_VALUE ? (JSON.Number)new SimpleLong(num, this.numberLineCol) : (JSON.Number)new SimpleInteger((int)num, this.numberLineCol)) : (num > Integer.MAX_VALUE ? (JSON.Number)new SimpleLong(num, this.numberLineCol) : (JSON.Number)new SimpleInteger((int)num, this.numberLineCol)));
            }
            this.opts.getListener().onNumber(ret2);
            ParserUtils.checkEnd$vjson(cs, this.opts, "number");
            return ret2;
        }
        return null;
    }

    @Override
    @Nullable
    public Number buildJavaObject(@NotNull CharStream cs, boolean isComplete) throws JsonParseException, ParserFinishedException {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        if (this.tryParse(cs, isComplete)) {
            this.opts.getListener().onNumberEnd(this);
            Number ret2 = null;
            if (this.hasFraction) {
                double num = (double)this.integer + this.calcFraction();
                double d = num = this.isNegative ? -num : num;
                if (this.hasExponent) {
                    double d2 = 10.0;
                    double d3 = this.isExponentNegative ? -((double)this.exponent) : (double)this.exponent;
                    boolean bl = false;
                    ret2 = num * Math.pow(d2, d3);
                } else {
                    ret2 = num;
                }
            } else {
                long num;
                long l = num = this.isNegative ? -this.integer : this.integer;
                if (this.hasExponent) {
                    double d = 10.0;
                    double d4 = this.isExponentNegative ? -((double)this.exponent) : (double)this.exponent;
                    boolean bl = false;
                    ret2 = (double)num * Math.pow(d, d4);
                } else {
                    ret2 = this.isNegative ? (Number)(num < Integer.MIN_VALUE ? (Number)num : (Number)((int)num)) : (Number)(num > Integer.MAX_VALUE ? (Number)num : (Number)((int)num));
                }
            }
            this.opts.getListener().onNumber(ret2);
            ParserUtils.checkEnd$vjson(cs, this.opts, "number");
            return ret2;
        }
        return null;
    }

    @Override
    public boolean completed() {
        return this.state == 9;
    }

    @JvmOverloads
    public NumberParser() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lvjson/parser/NumberParser$Companion;", "", "()V", "MAX_DIVISOR", "", "MAX_DIVISOR_ZEROS", "", "vjson"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

