/*
 * Decompiled with CFR 0.152.
 */
package vjson.parser;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.CharStream;
import vjson.JSON;
import vjson.Parser;
import vjson.ParserListener;
import vjson.cs.LineCol;
import vjson.ex.JsonParseException;
import vjson.ex.ParserFinishedException;
import vjson.parser.CompositeParser;
import vjson.parser.ParserMode;
import vjson.parser.ParserOptions;
import vjson.parser.ParserUtils;
import vjson.parser.StringParser;
import vjson.parser.TrustedFlag;
import vjson.simple.SimpleNull;
import vjson.simple.SimpleObject;
import vjson.simple.SimpleObjectEntry;
import vjson.util.StringDictionary;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0006\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010#\u001a\u0004\u0018\u00010\u00032\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J(\u0010(\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010)2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010*\u001a\u00020'H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010$\u001a\u00020%H\u0002J \u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020'2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J \u0010/\u001a\u00020,2\u0006\u0010.\u001a\u00020'2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u00100\u001a\u00020'2\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020'2\u0006\u00101\u001a\u000202H\u0002J\b\u00104\u001a\u00020,H\u0016J\u000e\u00105\u001a\u00020,2\u0006\u00106\u001a\u00020\nJ\u0018\u00107\u001a\u00020'2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rRf\u0010\u0011\u001a&\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010\u000ej\u0012\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u0001`\u00102*\u0010\t\u001a&\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010\u000ej\u0012\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u0001`\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0018\u00010\u0015R\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000RB\u0010\u001a\u001a\u0014\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u0018\u0018\u00010\u00172\u0018\u0010\t\u001a\u0014\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u0018\u0018\u00010\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lvjson/parser/ObjectParser;", "Lvjson/parser/CompositeParser;", "Lvjson/Parser;", "Lvjson/JSON$Object;", "opts", "Lvjson/parser/ParserOptions;", "(Lvjson/parser/ParserOptions;)V", "_keyParser", "Lvjson/parser/StringParser;", "<set-?>", "", "currentKey", "getCurrentKey", "()Ljava/lang/String;", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "javaMap", "getJavaMap", "()Ljava/util/LinkedHashMap;", "keyBuilder", "Lvjson/util/StringDictionary$Traveler;", "Lvjson/util/StringDictionary;", "", "Lvjson/simple/SimpleObjectEntry;", "Lvjson/JSON$Instance;", "map", "getMap", "()Ljava/util/List;", "objectEntryLineCol", "Lvjson/cs/LineCol;", "objectLineCol", "state", "", "valueParser", "build", "cs", "Lvjson/CharStream;", "isComplete", "", "buildJavaObject", "", "completed", "fillEntryWithoutValue", "", "handleKeyParser", "tryGetNewParser", "handleValueParser", "isColon", "c", "", "isComma", "reset", "setCurrentKey", "key", "tryParse", "vjson"})
public final class ObjectParser
extends CompositeParser
implements Parser<JSON.Object> {
    @NotNull
    private final ParserOptions opts;
    private int state;
    @Nullable
    private List<SimpleObjectEntry<JSON.Instance<?>>> map;
    @Nullable
    private LinkedHashMap<String, Object> javaMap;
    @Nullable
    private StringParser _keyParser;
    @Nullable
    private StringDictionary.Traveler keyBuilder;
    @Nullable
    private String currentKey;
    @Nullable
    private Parser<?> valueParser;
    @NotNull
    private LineCol objectLineCol;
    @NotNull
    private LineCol objectEntryLineCol;

    @JvmOverloads
    public ObjectParser(@NotNull ParserOptions opts) {
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        super(opts);
        this.opts = ParserOptions.Companion.ensureNotModifiedByOutside(opts);
        this.objectLineCol = LineCol.Companion.getEMPTY();
        this.objectEntryLineCol = LineCol.Companion.getEMPTY();
        this.reset();
    }

    public /* synthetic */ ObjectParser(ParserOptions parserOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            parserOptions = ParserOptions.DEFAULT;
        }
        this(parserOptions);
    }

    @Nullable
    public final List<SimpleObjectEntry<JSON.Instance<?>>> getMap() {
        return this.map;
    }

    @Nullable
    public final LinkedHashMap<String, Object> getJavaMap() {
        return this.javaMap;
    }

    @Nullable
    public final String getCurrentKey() {
        return this.currentKey;
    }

    @Override
    public void reset() {
        this.state = 0;
        if (this.opts.getMode() == ParserMode.JAVA_OBJECT) {
            if (this.opts.isNullArraysAndObjects()) {
                this.javaMap = null;
            } else if (this.javaMap == null) {
                this.javaMap = new LinkedHashMap(16);
            } else {
                int n = 16;
                LinkedHashMap<String, Object> linkedHashMap = this.javaMap;
                Intrinsics.checkNotNull(linkedHashMap);
                int n2 = linkedHashMap.size();
                boolean bl = false;
                this.javaMap = new LinkedHashMap(Math.max(n, n2));
            }
        } else {
            this.map = new ArrayList();
        }
        if (this.keyBuilder == null) {
            this.keyBuilder = ParserUtils.getThreadLocalKeyDictionary().traveler();
        }
        StringDictionary.Traveler traveler = this.keyBuilder;
        Intrinsics.checkNotNull((Object)traveler);
        traveler.done();
        this._keyParser = null;
        this.currentKey = null;
        this.valueParser = null;
        this.objectLineCol = LineCol.Companion.getEMPTY();
        this.objectEntryLineCol = LineCol.Companion.getEMPTY();
    }

    public final void setCurrentKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.currentKey = key;
    }

    private final void handleKeyParser(boolean tryGetNewParser, CharStream cs, boolean isComplete) {
        try {
            if (this._keyParser == null) {
                if (tryGetNewParser) {
                    this.objectEntryLineCol = new LineCol(cs.lineCol(), 1);
                    this._keyParser = this.getKeyParser();
                } else {
                    return;
                }
            }
            StringParser stringParser = this._keyParser;
            Intrinsics.checkNotNull((Object)stringParser);
            String ret2 = stringParser.buildJavaObject(cs, isComplete);
            if (ret2 != null) {
                this.state = 2;
                this.currentKey = ret2;
                this._keyParser = null;
                ParserListener parserListener = this.opts.getListener();
                String string = this.currentKey;
                Intrinsics.checkNotNull((Object)string);
                parserListener.onObjectKey(this, string);
            }
        }
        catch (JsonParseException e) {
            String err = "invalid json object: failed when parsing key: (" + e.getMessage() + ')';
            throw ParserUtils.err$vjson(cs, this.opts, err);
        }
    }

    private final void handleValueParser(boolean tryGetNewParser, CharStream cs, boolean isComplete) {
        try {
            if (this.valueParser == null) {
                if (tryGetNewParser) {
                    this.valueParser = this.getSubParser(cs);
                } else {
                    return;
                }
            }
            if (this.opts.getMode() == ParserMode.JAVA_OBJECT) {
                Parser<?> parser = this.valueParser;
                Intrinsics.checkNotNull(parser);
                Object o = parser.buildJavaObject(cs, isComplete);
                Parser<?> parser2 = this.valueParser;
                Intrinsics.checkNotNull(parser2);
                if (parser2.completed()) {
                    this.state = 4;
                    String string = this.currentKey;
                    Intrinsics.checkNotNull((Object)string);
                    String key = string;
                    this.valueParser = null;
                    this.currentKey = null;
                    if (!this.opts.isNullArraysAndObjects()) {
                        LinkedHashMap<String, Object> linkedHashMap = this.javaMap;
                        Intrinsics.checkNotNull(linkedHashMap);
                        Map map = linkedHashMap;
                        boolean bl = false;
                        map.put(key, o);
                    }
                    this.opts.getListener().onObjectValueJavaObject(this, key, o);
                }
            } else {
                Parser<?> parser = this.valueParser;
                Intrinsics.checkNotNull(parser);
                Object inst = parser.build(cs, isComplete);
                if (inst != null) {
                    this.state = 4;
                    String string = this.currentKey;
                    Intrinsics.checkNotNull((Object)string);
                    String key = string;
                    this.valueParser = null;
                    this.currentKey = null;
                    List<SimpleObjectEntry<JSON.Instance<?>>> list = this.map;
                    Intrinsics.checkNotNull(list);
                    list.add(new SimpleObjectEntry(key, inst, this.objectEntryLineCol));
                    this.opts.getListener().onObjectValue(this, key, (JSON.Instance<?>)inst);
                }
            }
        }
        catch (JsonParseException e) {
            throw new JsonParseException("invalid json object: failed when parsing value: (" + e.getMessage() + ')', e, cs.lineCol());
        }
    }

    private final boolean tryParse(CharStream cs, boolean isComplete) {
        char peek;
        this.handleKeyParser(false, cs, isComplete);
        this.handleValueParser(false, cs, isComplete);
        char c = '\u0000';
        String err = null;
        if (this.state == 0) {
            cs.skipBlank();
            if (cs.hasNext()) {
                this.objectLineCol = cs.lineCol();
                this.opts.getListener().onObjectBegin(this);
                c = cs.moveNextAndGet();
                if (c == '{') {
                    this.state = 1;
                } else {
                    err = Intrinsics.stringPlus((String)"invalid character for json object: not starts with `{`: ", (Object)Character.valueOf(c));
                    throw ParserUtils.err$vjson(cs, this.opts, err);
                }
            }
        }
        if (this.state == 1) {
            cs.skipBlank();
            if (cs.hasNext()) {
                peek = cs.peekNext();
                if (peek == '}') {
                    cs.moveNextAndGet();
                    this.state = 6;
                } else if (peek == '\"' || peek == '\'' || peek == '(') {
                    this.handleKeyParser(true, cs, isComplete);
                } else if (this.opts.isKeyNoQuotes()) {
                    this.objectEntryLineCol = cs.lineCol();
                    this.state = 8;
                } else {
                    err = Intrinsics.stringPlus((String)"invalid character for json object key: ", (Object)Character.valueOf(peek));
                    throw ParserUtils.err$vjson(cs, this.opts, err);
                }
            }
        }
        while (cs.hasNext()) {
            if (this.state == 2) {
                cs.skipBlank();
                if (cs.hasNext()) {
                    c = cs.peekNext();
                    if (c == '{' && this.opts.isAllowOmittingColonBeforeBraces()) {
                        this.state = 3;
                    } else if (!this.isColon(c) && this.opts.isAllowObjectEntryWithoutValue()) {
                        this.fillEntryWithoutValue(cs);
                        this.state = 4;
                    } else {
                        if (!this.isColon(c)) {
                            err = Intrinsics.stringPlus((String)"invalid key-value separator for json object, expecting `:`, but got ", (Object)Character.valueOf(c));
                            throw ParserUtils.err$vjson(cs, this.opts, err);
                        }
                        cs.moveNextAndGet();
                        this.state = 3;
                    }
                }
            }
            if (this.state == 3) {
                cs.skipBlank();
                if (cs.hasNext()) {
                    this.handleValueParser(true, cs, isComplete);
                }
            }
            if (this.state == 4) {
                cs.skipBlank();
                if (cs.hasNext()) {
                    c = cs.peekNext();
                    if (c == '}') {
                        cs.moveNextAndGet();
                        this.state = 6;
                    } else if (this.isComma(c)) {
                        cs.moveNextAndGet();
                        this.state = 5;
                    } else if (this.opts.isAllowSkippingCommas()) {
                        this.state = 5;
                    } else {
                        err = Intrinsics.stringPlus((String)"invalid character for json object, expecting `}` or `,`, but got ", (Object)Character.valueOf(c));
                        throw ParserUtils.err$vjson(cs, this.opts, err);
                    }
                }
            }
            if (this.state == 5) {
                cs.skipBlank();
                if (cs.hasNext()) {
                    peek = cs.peekNext();
                    if (peek == '\"' || peek == '\'' || peek == '(') {
                        this.handleKeyParser(true, cs, isComplete);
                    } else if (this.opts.isKeyNoQuotes()) {
                        this.objectEntryLineCol = cs.lineCol();
                        this.state = 8;
                    } else {
                        err = Intrinsics.stringPlus((String)"invalid character for json object key: ", (Object)Character.valueOf(peek));
                        throw ParserUtils.err$vjson(cs, this.opts, err);
                    }
                }
            }
            if (this.state == 8) {
                peek = cs.peekNext();
                if (this.isColon(peek) || peek == ',' || ParserUtils.isWhiteSpace(peek) || peek == '}' && this.opts.isAllowObjectEntryWithoutValue()) {
                    String key = String.valueOf(this.keyBuilder);
                    CharSequence charSequence = key;
                    boolean bl = false;
                    if (charSequence.length() == 0) {
                        err = "empty key is not allowed when parsing object key without quotes";
                        throw ParserUtils.err$vjson(cs, this.opts, err);
                    }
                    this.state = 9;
                    this.currentKey = key;
                    StringDictionary.Traveler traveler = this.keyBuilder;
                    Intrinsics.checkNotNull((Object)traveler);
                    traveler.done();
                    ParserListener parserListener = this.opts.getListener();
                    String string = this.currentKey;
                    Intrinsics.checkNotNull((Object)string);
                    parserListener.onObjectKey(this, string);
                } else {
                    c = cs.moveNextAndGet();
                    if (ParserUtils.isVarName(c)) {
                        StringDictionary.Traveler traveler = this.keyBuilder;
                        Intrinsics.checkNotNull((Object)traveler);
                        traveler.next(c);
                    } else if (this.opts.isKeyNoQuotesAnyChar()) {
                        StringDictionary.Traveler traveler = this.keyBuilder;
                        Intrinsics.checkNotNull((Object)traveler);
                        traveler.next(c);
                    } else {
                        err = Intrinsics.stringPlus((String)"invalid character for json object key without quotes: ", (Object)Character.valueOf(c));
                        throw ParserUtils.err$vjson(cs, this.opts, err);
                    }
                }
            }
            if (this.state == 9) {
                cs.skipBlank();
                if (cs.hasNext()) {
                    peek = cs.peekNext();
                    if (this.isColon(peek)) {
                        this.state = 2;
                    } else {
                        boolean ok = false;
                        if (this.opts.isAllowOmittingColonBeforeBraces() && peek == '{') {
                            this.state = 3;
                            ok = true;
                        }
                        if (!ok && this.opts.isAllowObjectEntryWithoutValue()) {
                            this.state = 2;
                            ok = true;
                        }
                        if (!ok) {
                            err = Intrinsics.stringPlus((String)"invalid character after json object key without quotes: ", (Object)Character.valueOf(peek));
                            throw ParserUtils.err$vjson(cs, this.opts, err);
                        }
                    }
                }
            }
            if (this.state != 6 && this.state != 7) continue;
        }
        if (this.state == 6) {
            ObjectParser objectParser = this;
            ++objectParser.state;
            int cfr_ignored_0 = objectParser.state;
            return true;
        }
        if (this.state == 7) {
            cs.skipBlank();
            if (cs.hasNext()) {
                throw new ParserFinishedException();
            }
            return false;
        }
        if (isComplete) {
            err = "expecting more characters to build object";
            throw ParserUtils.err$vjson(cs, this.opts, err);
        }
        return false;
    }

    private final boolean isColon(char c) {
        return c == ':' || this.opts.isEqualAsColon() && c == '=';
    }

    private final boolean isComma(char c) {
        return c == ',' || this.opts.isSemicolonAsComma() && c == ';';
    }

    private final void fillEntryWithoutValue(CharStream cs) {
        if (this.opts.getMode() == ParserMode.JAVA_OBJECT) {
            String string = this.currentKey;
            Intrinsics.checkNotNull((Object)string);
            String key = string;
            this.currentKey = null;
            if (!this.opts.isNullArraysAndObjects()) {
                LinkedHashMap<String, Object> linkedHashMap = this.javaMap;
                Intrinsics.checkNotNull(linkedHashMap);
                Map map = linkedHashMap;
                Object v = null;
                boolean bl = false;
                map.put(key, v);
            }
            this.opts.getListener().onObjectValueJavaObject(this, key, null);
        } else {
            String string = this.currentKey;
            Intrinsics.checkNotNull((Object)string);
            String key = string;
            this.currentKey = null;
            SimpleNull value = new SimpleNull(cs.lineCol());
            List<SimpleObjectEntry<JSON.Instance<?>>> list = this.map;
            Intrinsics.checkNotNull(list);
            list.add(new SimpleObjectEntry<SimpleNull>(key, value, this.objectEntryLineCol));
            this.opts.getListener().onObjectValue(this, key, value);
        }
    }

    @Override
    @Nullable
    public JSON.Object build(@NotNull CharStream cs, boolean isComplete) throws JsonParseException, ParserFinishedException {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        if (this.tryParse(cs, isComplete)) {
            List list;
            this.opts.getListener().onObjectEnd(this);
            if (this.map == null) {
                list = new ArrayList(0);
            } else {
                List list2 = this.map;
                list = list2;
                Intrinsics.checkNotNull(list2);
            }
            List map = list;
            TrustedFlag trustedFlag = TrustedFlag.FLAG;
            LineCol lineCol = this.objectLineCol;
            SimpleObject ret2 = new SimpleObject(map, trustedFlag, lineCol){
                final /* synthetic */ List<SimpleObjectEntry<JSON.Instance<?>>> $map;
                {
                    this.$map = $map;
                    super($map, $super_call_param$1, $super_call_param$2);
                }
            };
            this.opts.getListener().onObject(ret2);
            ParserUtils.checkEnd$vjson(cs, this.opts, "object");
            return ret2;
        }
        return null;
    }

    @Override
    @Nullable
    public Map<String, Object> buildJavaObject(@NotNull CharStream cs, boolean isComplete) throws JsonParseException, ParserFinishedException {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        if (this.tryParse(cs, isComplete)) {
            this.opts.getListener().onObjectEnd(this);
            this.opts.getListener().onObject((Map<String, ? extends Object>)this.javaMap);
            ParserUtils.checkEnd$vjson(cs, this.opts, "object");
            return this.javaMap;
        }
        return null;
    }

    @Override
    public boolean completed() {
        return this.state == 7;
    }

    @JvmOverloads
    public ObjectParser() {
        this(null, 1, null);
    }
}

