/*
 * Decompiled with CFR 0.152.
 */
package vjson.parser;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.CharStream;
import vjson.JSON;
import vjson.Parser;
import vjson.cs.LineCol;
import vjson.cs.PeekCharStream;
import vjson.ex.JsonParseException;
import vjson.parser.ArrayParser;
import vjson.parser.BoolParser;
import vjson.parser.DefaultParserCacheHolder;
import vjson.parser.NullParser;
import vjson.parser.NumberParser;
import vjson.parser.ObjectParser;
import vjson.parser.ParserCacheHolder;
import vjson.parser.ParserMode;
import vjson.parser.ParserOptions;
import vjson.parser.StringParser;
import vjson.util.CastUtils;
import vjson.util.StringDictionary;
import vjson.util.collection.Stack;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001c\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J%\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0001\u00a2\u0006\u0002\b\u0012J%\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0011H\u0001\u00a2\u0006\u0002\b\u0016J*\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u001c\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010%\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u0004H\u0007J\u0015\u0010(\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b)R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lvjson/parser/ParserUtils;", "", "()V", "holder", "Lvjson/parser/ParserCacheHolder;", "build", "Lvjson/JSON$Instance;", "cs", "Lvjson/CharStream;", "opts", "Lvjson/parser/ParserOptions;", "buildFrom", "buildJ", "buildJavaObject", "checkEnd", "", "type", "", "checkEnd$vjson", "err", "Lvjson/ex/JsonParseException;", "msg", "err$vjson", "extractNoQuotesString", "Lkotlin/Pair;", "", "isObjectKey", "", "getThreadLocalKeyDictionary", "Lvjson/util/StringDictionary;", "isInitialVarName", "c", "", "isVarName", "isWhiteSpace", "parser", "Lvjson/Parser;", "parserForValueNoQuotes", "setParserCacheHolder", "parserCacheHolder", "subParserOptions", "subParserOptions$vjson", "vjson"})
public final class ParserUtils {
    @NotNull
    public static final ParserUtils INSTANCE = new ParserUtils();
    @NotNull
    private static ParserCacheHolder holder = new DefaultParserCacheHolder();

    private ParserUtils() {
    }

    /*
     * Unable to fully structure code
     */
    @JvmStatic
    public static final void setParserCacheHolder(@NotNull ParserCacheHolder parserCacheHolder) throws IllegalStateException {
        Intrinsics.checkNotNullParameter((Object)parserCacheHolder, (String)"parserCacheHolder");
        if (!(ParserUtils.holder instanceof DefaultParserCacheHolder)) ** GOTO lbl-1000
        var1_1 = CastUtils.INSTANCE;
        t$iv = ParserUtils.holder;
        $i$f$cast = false;
        if (!((DefaultParserCacheHolder)var2_3).isStarted()) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        var1_2 = v0;
        var2_4 = false;
        var3_5 = false;
        if (!var1_2) {
            $i$a$-check-ParserUtils$setParserCacheHolder$1 = false;
            var3_6 = "parser cache holder already set";
            throw (Throwable)new IllegalStateException(var3_6.toString());
        }
        ParserUtils.holder = parserCacheHolder;
    }

    @JvmStatic
    @NotNull
    public static final StringDictionary getThreadLocalKeyDictionary() {
        StringDictionary dic = holder.threadLocalKeyDictionary();
        if (dic == null) {
            dic = new StringDictionary(16);
            holder.threadLocalKeyDictionary(dic);
        }
        return dic;
    }

    @JvmStatic
    public static final boolean isWhiteSpace(char c) {
        return c == '\n' || c == '\r' || c == ' ' || c == '\t';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isInitialVarName(char c) {
        boolean bl;
        boolean bl2;
        if ('a' <= c) {
            if (c <= 'z') {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        if ('A' <= c) {
            if (c <= 'Z') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (c == '_') return true;
        if (c != '$') return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isVarName(char c) {
        if (ParserUtils.isInitialVarName(c)) return true;
        if ('0' > c) return false;
        if (c > '9') return false;
        return true;
    }

    @JvmStatic
    public static final void checkEnd$vjson(@NotNull CharStream cs, @NotNull ParserOptions opts, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (opts.isEnd()) {
            cs.skipBlank();
            if (cs.hasNext()) {
                String err = Intrinsics.stringPlus((String)"input stream contains extra characters other than ", (Object)type);
                opts.getListener().onError(err);
                throw new JsonParseException(err, cs.lineCol());
            }
        }
    }

    @JvmStatic
    @NotNull
    public static final JsonParseException err$vjson(@NotNull CharStream cs, @NotNull ParserOptions opts, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        opts.getListener().onError(msg);
        return new JsonParseException(msg, cs.lineCol());
    }

    @JvmStatic
    @NotNull
    public static final ParserOptions subParserOptions$vjson(@NotNull ParserOptions opts) {
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        if (Intrinsics.areEqual((Object)opts, (Object)ParserOptions.DEFAULT) || Intrinsics.areEqual((Object)opts, (Object)ParserOptions.DEFAULT_NO_END)) {
            return ParserOptions.DEFAULT_NO_END;
        }
        if (Intrinsics.areEqual((Object)opts, (Object)ParserOptions.DEFAULT_JAVA_OBJECT) || Intrinsics.areEqual((Object)opts, (Object)ParserOptions.DEFAULT_JAVA_OBJECT_NO_END)) {
            return ParserOptions.DEFAULT_JAVA_OBJECT_NO_END;
        }
        if (!opts.isEnd()) {
            return opts;
        }
        return new ParserOptions(opts).setEnd(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final JSON.Instance<?> buildFrom(@NotNull CharStream cs) throws JsonParseException {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        ParserOptions opts = ParserOptions.DEFAULT;
        cs.skipBlank();
        if (!cs.hasNext()) {
            throw new JsonParseException("empty input string", cs.lineCol());
        }
        char c = cs.peekNext();
        if (c == '{') {
            ObjectParser p = holder.threadLocalObjectParser();
            if (p == null) {
                p = new ObjectParser(opts);
                holder.threadLocalObjectParser(p);
            }
            JSON.Object ret2 = null;
            try {
                Object t = p.last(cs);
                Intrinsics.checkNotNull(t);
                ret2 = (JSON.Object)t;
            }
            finally {
                p.reset();
            }
            return ret2;
        }
        if (c == '[') {
            ArrayParser p = holder.threadLocalArrayParser();
            if (p == null) {
                p = new ArrayParser(opts);
                holder.threadLocalArrayParser(p);
            }
            JSON.Array ret3 = null;
            try {
                Object t = p.last(cs);
                Intrinsics.checkNotNull(t);
                ret3 = (JSON.Array)t;
            }
            finally {
                p.reset();
            }
            return ret3;
        }
        if (c == '\'') {
            throw new JsonParseException("not valid json string: stringSingleQuotes not enabled", cs.lineCol());
        }
        if (c == '\"') {
            StringParser p = holder.threadLocalStringParser();
            if (p == null) {
                p = new StringParser(opts);
                holder.threadLocalStringParser(p);
            }
            JSON.String ret4 = null;
            try {
                Object t = p.last(cs);
                Intrinsics.checkNotNull(t);
                ret4 = (JSON.String)t;
            }
            finally {
                p.reset();
            }
            return ret4;
        }
        return INSTANCE.build(cs, opts);
    }

    @JvmStatic
    @NotNull
    public static final JSON.Instance<?> buildFrom(@NotNull CharStream cs, @NotNull ParserOptions opts) throws JsonParseException {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        return INSTANCE.build(cs, opts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final Object buildJavaObject(@NotNull CharStream cs) throws JsonParseException {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        ParserOptions opts = ParserOptions.DEFAULT_JAVA_OBJECT;
        cs.skipBlank();
        if (!cs.hasNext()) {
            throw new JsonParseException("empty input string", cs.lineCol());
        }
        char c = cs.peekNext();
        if (c == '{') {
            ObjectParser p = holder.threadLocalObjectParserJavaObject();
            if (p == null) {
                p = new ObjectParser(opts);
                holder.threadLocalObjectParserJavaObject(p);
            }
            Object ret2 = null;
            try {
                Object object = p.buildJavaObject(cs, true);
                Intrinsics.checkNotNull((Object)object);
                ret2 = object;
            }
            finally {
                p.reset();
            }
            return ret2;
        }
        if (c == '[') {
            ArrayParser p = holder.threadLocalArrayParserJavaObject();
            if (p == null) {
                p = new ArrayParser(opts);
                holder.threadLocalArrayParserJavaObject(p);
            }
            Object ret3 = null;
            try {
                Object object = p.buildJavaObject(cs, true);
                Intrinsics.checkNotNull((Object)object);
                ret3 = object;
            }
            finally {
                p.reset();
            }
            return ret3;
        }
        if (c == '\'') {
            throw new JsonParseException("not valid json string: stringSingleQuotes not enabled", cs.lineCol());
        }
        if (c == '\"') {
            StringParser p = holder.threadLocalStringParserJavaObject();
            if (p == null) {
                p = new StringParser(opts);
                holder.threadLocalStringParserJavaObject(p);
            }
            String ret4 = null;
            try {
                String string = p.buildJavaObject(cs, true);
                Intrinsics.checkNotNull((Object)string);
                ret4 = string;
            }
            finally {
                p.reset();
            }
            return ret4;
        }
        return INSTANCE.buildJ(cs, opts);
    }

    @JvmStatic
    @Nullable
    public static final Object buildJavaObject(@NotNull CharStream cs, @NotNull ParserOptions opts) throws JsonParseException {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        return INSTANCE.buildJ(cs, opts);
    }

    private final Parser<?> parser(CharStream cs, ParserOptions opts) throws JsonParseException {
        Parser parser;
        char first;
        cs.skipBlank();
        if (!cs.hasNext()) {
            throw new JsonParseException("empty input string", cs.lineCol());
        }
        if (opts.isStringValueNoQuotes() && (first = cs.peekNext()) != '{' && first != '[' && first != '\'' && first != '\"') {
            return this.parserForValueNoQuotes(cs, opts);
        }
        first = cs.peekNext();
        if (first == '{') {
            parser = new ObjectParser(opts);
        } else if (first == '[') {
            parser = new ArrayParser(opts);
        } else {
            if (first == '\'') {
                if (!opts.isStringSingleQuotes()) {
                    throw new JsonParseException("not valid json string: stringSingleQuotes not enabled", cs.lineCol());
                }
                return new StringParser(opts);
            }
            if (first == '\"') {
                parser = new StringParser(opts);
            } else if (first == 'n') {
                parser = new NullParser(opts);
            } else if (first == 't') {
                parser = new BoolParser(opts);
            } else if (first == 'f') {
                parser = new BoolParser(opts);
            } else if (first == '-') {
                parser = new NumberParser(opts);
            } else {
                boolean bl = '0' <= first ? first <= '9' : false;
                if (bl) {
                    return new NumberParser(opts);
                }
                throw new JsonParseException("not valid json string", cs.lineCol());
            }
        }
        return parser;
    }

    private final JSON.Instance<?> build(CharStream cs, ParserOptions opts) throws IllegalArgumentException, JsonParseException {
        Object obj = this.parser(cs, opts).build(cs, true);
        Intrinsics.checkNotNull(obj);
        return obj;
    }

    private final Object buildJ(CharStream cs, ParserOptions opts) throws IllegalArgumentException, JsonParseException {
        opts.setMode(ParserMode.JAVA_OBJECT);
        return this.parser(cs, opts).buildJavaObject(cs, true);
    }

    @NotNull
    public final Pair<String, Integer> extractNoQuotesString(@NotNull CharStream cs, @NotNull ParserOptions opts, boolean isObjectKey) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        cs.skipBlank();
        LineCol beginLineCol = cs.lineCol();
        StringBuilder sb = new StringBuilder();
        Stack<Character> symbolStack = new Stack<Character>();
        int cursor = 0;
        boolean singleLineComment = false;
        boolean multiLineComments = false;
        while (cs.hasNext(cursor + 1)) {
            char c = cs.peekNext(++cursor);
            if (singleLineComment) {
                if (c != '\r' && c != '\n') continue;
                singleLineComment = false;
            } else if (multiLineComments) {
                char cc;
                if (c != '*' || !cs.hasNext(cursor + 1) || (cc = cs.peekNext(cursor + 1)) != '/') continue;
                ++cursor;
                multiLineComments = false;
                continue;
            }
            char c2 = c;
            if ((((c2 == ',' ? true : c2 == ';') ? true : c2 == '\n') ? true : c2 == '\r') ? true : c2 == ':') {
                if (c == ':' && !isObjectKey) {
                    sb.append(c);
                    continue;
                }
                if (c == ';' && !opts.isSemicolonAsComma()) {
                    sb.append(c);
                    continue;
                }
                if (symbolStack.isEmpty()) {
                    --cursor;
                    break;
                }
                sb.append(c);
                continue;
            }
            if (c2 == '#') {
                singleLineComment = true;
                continue;
            }
            if (c2 == '/') {
                if (cs.hasNext(cursor + 1)) {
                    char cc = cs.peekNext(cursor + 1);
                    if (cc == '/') {
                        ++cursor;
                        singleLineComment = true;
                        continue;
                    }
                    if (cc == '*') {
                        ++cursor;
                        multiLineComments = true;
                        continue;
                    }
                }
                sb.append('/');
                continue;
            }
            if (c2 == '(') {
                sb.append(c);
                symbolStack.push(Character.valueOf(')'));
                continue;
            }
            if (c2 == '[') {
                sb.append(c);
                symbolStack.push(Character.valueOf(']'));
                continue;
            }
            if (c2 == '{') {
                sb.append(c);
                symbolStack.push(Character.valueOf('}'));
                continue;
            }
            if ((c2 == ')' ? true : c2 == ']') ? true : c2 == '}') {
                if (symbolStack.isEmpty()) {
                    --cursor;
                    break;
                }
                char last = ((Character)symbolStack.pop()).charValue();
                if (last == c) {
                    sb.append(c);
                    continue;
                }
                cs.skip(cursor);
                char c3 = c;
                boolean bl = false;
                throw new JsonParseException("unexpected char code=" + c3 + ", expecting " + last + (beginLineCol.isEmpty() ? "" : Intrinsics.stringPlus((String)", reading noQuotesString starting from ", (Object)beginLineCol)), cs.lineCol());
            }
            if (c2 == '\'' ? true : c2 == '\"') {
                JSON.String string;
                PeekCharStream pcs = new PeekCharStream(cs, cursor - 1);
                try {
                    string = (JSON.String)new StringParser(new ParserOptions().setStringSingleQuotes(true).setEnd(false)).last(pcs);
                }
                catch (JsonParseException e) {
                    cs.skip(pcs.getCursor());
                    throw new JsonParseException("" + e.getMessage() + (beginLineCol.isEmpty() ? "" : Intrinsics.stringPlus((String)", reading noQuotesString starting from ", (Object)beginLineCol)), e, cs.lineCol());
                }
                JSON.String jsonStr = string;
                Intrinsics.checkNotNull((Object)jsonStr);
                int _cursor = pcs.getCursor();
                int n = cursor;
                if (n <= _cursor) {
                    int i;
                    do {
                        i = n++;
                        sb.append(cs.peekNext(i));
                    } while (i != _cursor);
                }
                cursor = _cursor;
                continue;
            }
            sb.append(c);
        }
        if (!symbolStack.isEmpty()) {
            throw new JsonParseException("unexpected eof, expecting symbols: " + symbolStack + (beginLineCol.isEmpty() ? "" : Intrinsics.stringPlus((String)", reading noQuotesString starting from ", (Object)beginLineCol)));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return new Pair((Object)string, (Object)cursor);
    }

    private final Parser<?> parserForValueNoQuotes(CharStream cs, ParserOptions opts) {
        JSON.Instance res;
        CharStream newCS;
        Pair<String, Integer> pair = this.extractNoQuotesString(cs, opts, false);
        String str = (String)pair.getFirst();
        try {
            NumberParser numParser = new NumberParser(opts);
            newCS = CharStream.Companion.from(str);
            res = (JSON.Number)numParser.last(newCS);
            newCS.skipBlank();
            if (res != null && !newCS.hasNext()) {
                numParser.reset();
                return numParser;
            }
        }
        catch (JsonParseException numParser) {
            // empty catch block
        }
        try {
            BoolParser boolParser = new BoolParser(opts);
            newCS = CharStream.Companion.from(str);
            res = (JSON.Bool)boolParser.last(newCS);
            newCS.skipBlank();
            if (res != null && !newCS.hasNext()) {
                boolParser.reset();
                return boolParser;
            }
        }
        catch (JsonParseException boolParser) {
            // empty catch block
        }
        try {
            NullParser nullParser = new NullParser(opts);
            newCS = CharStream.Companion.from(str);
            res = (JSON.Null)nullParser.last(newCS);
            newCS.skipBlank();
            if (res != null && !newCS.hasNext()) {
                nullParser.reset();
                return nullParser;
            }
        }
        catch (JsonParseException jsonParseException) {
            // empty catch block
        }
        return new StringParser(opts);
    }
}

