/*
 * Decompiled with CFR 0.152.
 */
package vjson.parser;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.CharStream;
import vjson.JSON;
import vjson.Parser;
import vjson.cs.LineCol;
import vjson.ex.JsonParseException;
import vjson.ex.ParserException;
import vjson.ex.ParserFinishedException;
import vjson.parser.ParserOptions;
import vjson.parser.ParserUtils;
import vjson.simple.SimpleString;
import vjson.util.StringDictionary;
import vjson.util.TextBuilder;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\b\u0017\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\fH\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\tH\u0016J\u001a\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\tH\u0016J\b\u0010$\u001a\u00020#H\u0002J\b\u0010%\u001a\u00020\tH\u0016J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\fH\u0002J\b\u0010'\u001a\u00020\u001cH\u0016J\u0018\u0010(\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\tH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0018\u00010\u0017R\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lvjson/parser/StringParser;", "Lvjson/Parser;", "Lvjson/JSON$String;", "opts", "Lvjson/parser/ParserOptions;", "(Lvjson/parser/ParserOptions;)V", "dictionary", "Lvjson/util/StringDictionary;", "isKeyParser", "", "(Lvjson/parser/ParserOptions;Lvjson/util/StringDictionary;Z)V", "beginning", "", "builder", "Lvjson/util/TextBuilder;", "getBuilder", "()Lvjson/util/TextBuilder;", "()Z", "state", "", "stringLineCol", "Lvjson/cs/LineCol;", "traveler", "Lvjson/util/StringDictionary$Traveler;", "u1", "u2", "u3", "append", "", "c", "build", "cs", "Lvjson/CharStream;", "isComplete", "buildJavaObject", "", "buildResultString", "completed", "parseHex", "reset", "tryParse", "vjson"})
public final class StringParser
implements Parser<JSON.String> {
    private final boolean isKeyParser;
    @NotNull
    private final ParserOptions opts;
    private int state;
    @NotNull
    private final TextBuilder builder;
    @Nullable
    private final StringDictionary.Traveler traveler;
    private char beginning;
    private int u1;
    private int u2;
    private int u3;
    @NotNull
    private LineCol stringLineCol;

    public StringParser(@NotNull ParserOptions opts, @Nullable StringDictionary dictionary, boolean isKeyParser) {
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        this.isKeyParser = isKeyParser;
        this.opts = ParserOptions.Companion.ensureNotModifiedByOutside(opts);
        this.builder = new TextBuilder(opts.getBufLen());
        StringDictionary stringDictionary = dictionary;
        this.traveler = stringDictionary == null ? null : stringDictionary.traveler();
        this.u1 = -1;
        this.u2 = -1;
        this.u3 = -1;
        this.stringLineCol = LineCol.Companion.getEMPTY();
    }

    public final boolean isKeyParser() {
        return this.isKeyParser;
    }

    @NotNull
    public final TextBuilder getBuilder() {
        return this.builder;
    }

    @JvmOverloads
    public StringParser(@NotNull ParserOptions opts) {
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        this(opts, null, false);
    }

    public /* synthetic */ StringParser(ParserOptions parserOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            parserOptions = ParserOptions.DEFAULT;
        }
        this(parserOptions);
    }

    @Override
    public void reset() {
        this.state = 0;
        this.builder.clear();
        StringDictionary.Traveler traveler = this.traveler;
        if (traveler != null) {
            traveler.done();
        }
        this.stringLineCol = LineCol.Companion.getEMPTY();
    }

    private final int parseHex(char c) {
        boolean bl = 48 <= c ? c <= 57 : false;
        if (bl) {
            int n = c;
            boolean bl2 = false;
            int n2 = n;
            n = 48;
            bl2 = false;
            return n2 - n;
        }
        boolean bl3 = 65 <= c ? c <= 70 : false;
        if (bl3) {
            int n = c;
            boolean bl4 = false;
            int n3 = n;
            n = 65;
            bl4 = false;
            return n3 - (n - 10);
        }
        boolean bl5 = 97 <= c ? c <= 102 : false;
        if (bl5) {
            int n = c;
            boolean bl6 = false;
            int n4 = n;
            n = 97;
            bl6 = false;
            return n4 - (n - 10);
        }
        return -1;
    }

    private final void append(char c) {
        Unit unit;
        Unit unit2;
        StringDictionary.Traveler traveler = this.traveler;
        if (traveler == null) {
            unit2 = null;
        } else {
            traveler.next(c);
            unit2 = unit = Unit.INSTANCE;
        }
        if (unit == null) {
            this.builder.append(c);
        }
        this.opts.getListener().onStringChar(this, c);
    }

    private final boolean tryParse(CharStream cs, boolean isComplete) {
        char c = '\u0000';
        String err = null;
        if (this.state == 0) {
            cs.skipBlank();
            if (cs.hasNext()) {
                Pair<String, Integer> pair;
                this.stringLineCol = new LineCol(cs.lineCol(), 1);
                this.opts.getListener().onStringBegin((StringParser)this);
                c = cs.peekNext();
                if (c == '\"') {
                    cs.moveNextAndGet();
                    this.beginning = (char)34;
                } else if (c == '\'' && this.opts.isStringSingleQuotes()) {
                    cs.moveNextAndGet();
                    this.beginning = (char)39;
                } else if (this.opts.isStringValueNoQuotes()) {
                    pair = ParserUtils.INSTANCE.extractNoQuotesString(cs, this.opts, this.isKeyParser);
                    String str = (String)pair.component1();
                    int cursor = ((Number)pair.component2()).intValue();
                    if (cursor == 0 && c == ']' || c == '}' || c == ')') {
                        throw new ParserException("unexpected token " + c + " when trying to read string no quotes", cs.lineCol());
                    }
                    cs.skip(cursor);
                    String string = str;
                    int n = 0;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                    n = 0;
                    String string3 = string;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    char[] cArray = string3.toCharArray();
                    Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                    for (char ch : cArray) {
                        super.append(ch);
                    }
                    this.state = 6;
                    this.stringLineCol = new LineCol(this.stringLineCol, -1);
                } else {
                    err = Intrinsics.stringPlus((String)"invalid character for string: not starts with \": ", (Object)Character.valueOf(c));
                    throw ParserUtils.err$vjson(cs, this.opts, err);
                }
                pair = this;
                ++pair.state;
                int cfr_ignored_0 = pair.state;
            }
        }
        while (cs.hasNext()) {
            if (this.state == 1) {
                c = cs.moveNextAndGet();
                if (c == '\\') {
                    this.state = 2;
                } else {
                    if (c == this.beginning) {
                        this.state = 7;
                        break;
                    }
                    char c2 = c;
                    boolean bl = false;
                    if (c2 > '\u001f') {
                        this.append(c);
                        continue;
                    }
                    c2 = c;
                    bl = false;
                    err = Intrinsics.stringPlus((String)"invalid character in string: code is: ", (Object)c2);
                    throw ParserUtils.err$vjson(cs, this.opts, err);
                }
            }
            if (this.state == 2 && cs.hasNext()) {
                c = cs.moveNextAndGet();
                char c3 = c;
                if (c3 == '\"') {
                    this.append('\"');
                    this.state = 1;
                } else if (c3 == '\'') {
                    if (!this.opts.isStringSingleQuotes()) {
                        err = Intrinsics.stringPlus((String)"invalid escape character: ", (Object)Character.valueOf(c));
                        throw ParserUtils.err$vjson(cs, this.opts, err);
                    }
                    this.append('\'');
                    this.state = 1;
                } else if (c3 == '\\') {
                    this.append('\\');
                    this.state = 1;
                } else if (c3 == '/') {
                    this.append('/');
                    this.state = 1;
                } else if (c3 == 'b') {
                    this.append('\b');
                    this.state = 1;
                } else if (c3 == 'f') {
                    super.append('\f');
                    this.state = 1;
                } else if (c3 == 'n') {
                    super.append('\n');
                    this.state = 1;
                } else if (c3 == 'r') {
                    super.append('\r');
                    this.state = 1;
                } else if (c3 == 't') {
                    super.append('\t');
                    this.state = 1;
                } else if (c3 == 'u') {
                    this.state = 3;
                } else {
                    err = Intrinsics.stringPlus((String)"invalid escape character: ", (Object)Character.valueOf(c));
                    throw ParserUtils.err$vjson(cs, this.opts, err);
                }
                if (this.state == 1) continue;
            }
            if (this.state == 3 && cs.hasNext()) {
                c = cs.moveNextAndGet();
                this.u1 = this.parseHex(c);
                if (this.u1 == -1) {
                    err = Intrinsics.stringPlus((String)"invalid hex character in \\u[H]HHH: ", (Object)Character.valueOf(c));
                    throw ParserUtils.err$vjson(cs, this.opts, err);
                }
                Pair<String, Integer> pair = this;
                ++pair.state;
                int cfr_ignored_1 = pair.state;
            }
            if (this.state == 4 && cs.hasNext()) {
                c = cs.moveNextAndGet();
                this.u2 = this.parseHex(c);
                if (this.u2 == -1) {
                    err = "invalid hex character in \\u" + this.u1 + "[H]HH: " + c;
                    throw ParserUtils.err$vjson(cs, this.opts, err);
                }
                Pair<String, Integer> pair = this;
                ++pair.state;
                int cfr_ignored_2 = pair.state;
            }
            if (this.state == 5 && cs.hasNext()) {
                c = cs.moveNextAndGet();
                this.u3 = this.parseHex(c);
                if (this.u3 == -1) {
                    err = "invalid hex character in \\u" + this.u1 + this.u2 + "[H]H: " + c;
                    throw ParserUtils.err$vjson(cs, this.opts, err);
                }
                Pair<String, Integer> pair = this;
                ++pair.state;
                int cfr_ignored_3 = pair.state;
            }
            if (this.state == 6 && cs.hasNext()) {
                c = cs.moveNextAndGet();
                int u4 = this.parseHex(c);
                if (u4 == -1) {
                    err = "invalid hex character in \\u" + this.u1 + this.u2 + this.u3 + "[H]: " + c;
                    throw ParserUtils.err$vjson(cs, this.opts, err);
                }
                super.append((char)(this.u1 << 12 | this.u2 << 8 | this.u3 << 4 | u4));
                this.state = 1;
            }
            if (this.state != 7 && this.state != 8) continue;
        }
        if (this.state == 7) {
            Pair<String, Integer> pair = this;
            ++pair.state;
            int cfr_ignored_4 = pair.state;
            return true;
        }
        if (this.state == 8) {
            cs.skipBlank();
            if (cs.hasNext()) {
                throw new ParserFinishedException();
            }
            return false;
        }
        if (isComplete) {
            err = "expecting more characters to build string";
            throw ParserUtils.err$vjson(cs, this.opts, err);
        }
        return false;
    }

    private final String buildResultString() {
        StringDictionary.Traveler traveler = this.traveler;
        String string = traveler == null ? null : traveler.done();
        return string == null ? this.builder.toString() : string;
    }

    @Override
    @Nullable
    public JSON.String build(@NotNull CharStream cs, boolean isComplete) throws JsonParseException, ParserFinishedException {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        if (this.tryParse(cs, isComplete)) {
            this.opts.getListener().onStringEnd(this);
            String s = this.buildResultString();
            SimpleString ret2 = new SimpleString(s, this.stringLineCol);
            this.opts.getListener().onString(ret2);
            ParserUtils.checkEnd$vjson(cs, this.opts, "string");
            return ret2;
        }
        return null;
    }

    @Override
    @Nullable
    public String buildJavaObject(@NotNull CharStream cs, boolean isComplete) throws JsonParseException, ParserFinishedException {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        if (this.tryParse(cs, isComplete)) {
            this.opts.getListener().onStringEnd(this);
            String s = this.buildResultString();
            this.opts.getListener().onString(s);
            ParserUtils.checkEnd$vjson(cs, this.opts, "string");
            return s;
        }
        return null;
    }

    @Override
    public boolean completed() {
        return this.state == 8;
    }

    @JvmOverloads
    public StringParser() {
        this(null, 1, null);
    }
}

