/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import vjson.JSON;
import vjson.cs.LineCol;
import vjson.ex.ParserException;
import vjson.pl.ExprParser;
import vjson.pl.ExprTokenizer;
import vjson.pl.ast.Access;
import vjson.pl.ast.AssignableExpr;
import vjson.pl.ast.Assignment;
import vjson.pl.ast.BinOp;
import vjson.pl.ast.BinOpType;
import vjson.pl.ast.BoolLiteral;
import vjson.pl.ast.BreakStatement;
import vjson.pl.ast.ClassDefinition;
import vjson.pl.ast.ContinueStatement;
import vjson.pl.ast.ErrorHandlingStatement;
import vjson.pl.ast.Expr;
import vjson.pl.ast.FloatLiteral;
import vjson.pl.ast.ForLoop;
import vjson.pl.ast.FunctionDefinition;
import vjson.pl.ast.FunctionInvocation;
import vjson.pl.ast.IfStatement;
import vjson.pl.ast.IntegerLiteral;
import vjson.pl.ast.ModifierEnum;
import vjson.pl.ast.Modifiers;
import vjson.pl.ast.NewArray;
import vjson.pl.ast.NewInstance;
import vjson.pl.ast.NewInstanceWithJson;
import vjson.pl.ast.NullLiteral;
import vjson.pl.ast.OpAssignment;
import vjson.pl.ast.Param;
import vjson.pl.ast.ParamType;
import vjson.pl.ast.ReturnStatement;
import vjson.pl.ast.Statement;
import vjson.pl.ast.StringLiteral;
import vjson.pl.ast.TemplateClassDefinition;
import vjson.pl.ast.TemplateTypeInstantiation;
import vjson.pl.ast.ThrowStatement;
import vjson.pl.ast.Type;
import vjson.pl.ast.VariableDefinition;
import vjson.pl.ast.WhileLoop;
import vjson.util.CastUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0015\u001a\u00020*H\u0002J\u0014\u0010+\u001a\u00020\u00192\n\u0010,\u001a\u0006\u0012\u0002\b\u00030-H\u0002J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00190/2\u0006\u0010,\u001a\u00020&H\u0002J\u0010\u00100\u001a\u00020\u00192\u0006\u00101\u001a\u00020\u0007H\u0002J\u0010\u00102\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u0003H\u0002J\u0018\u00103\u001a\u00020\u00192\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0018\u0010:\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010:\u001a\u00020;H\u0002J \u0010<\u001a\u0012\u0012\u0004\u0012\u00020\u00010\tj\b\u0012\u0004\u0012\u00020\u0001`\u000b2\u0006\u0010=\u001a\u00020&H\u0002J\u0014\u0010<\u001a\u00020\u00012\n\u0010>\u001a\u0006\u0012\u0002\b\u00030-H\u0002J,\u0010<\u001a\u001e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\u00010?j\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\u0001`@2\u0006\u0010A\u001a\u00020\u0003H\u0002J\u0010\u0010<\u001a\u00020\u00192\u0006\u0010B\u001a\u00020CH\u0002J\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\n0/J \u0010E\u001a\u00020\u00192\u0006\u0010A\u001a\u00020\u00032\u0006\u0010F\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J\u0010\u0010G\u001a\u00020H2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lvjson/pl/ASTGen;", "", "_prog", "Lvjson/JSON$Object;", "(Lvjson/JSON$Object;)V", "prog", "", "Lvjson/JSON$ObjectEntry;", "result", "Ljava/util/ArrayList;", "Lvjson/pl/ast/Statement;", "Lkotlin/collections/ArrayList;", "aBreak", "Lvjson/pl/ast/BreakStatement;", "entry", "aClass", "Lvjson/pl/ast/ClassDefinition;", "aContinue", "Lvjson/pl/ast/ContinueStatement;", "aFor", "Lvjson/pl/ast/ForLoop;", "aIf", "aLet", "Lvjson/pl/ast/TemplateTypeInstantiation;", "aNew", "Lvjson/pl/ast/Expr;", "aReturn", "Lvjson/pl/ast/ReturnStatement;", "aThrow", "Lvjson/pl/ast/ThrowStatement;", "aVar", "Lvjson/pl/ast/VariableDefinition;", "aWhile", "Lvjson/pl/ast/WhileLoop;", "callFunction", "Lvjson/pl/ast/FunctionInvocation;", "funcExpr", "args", "Lvjson/JSON$Array;", "checkAndGenerateErrorHandling", "isErrorHandling", "", "Lvjson/pl/ast/IfStatement;", "expr", "json", "Lvjson/JSON$Instance;", "exprArray", "", "exprKey", "_entry", "exprObject", "exprString", "input", "", "lineCol", "Lvjson/cs/LineCol;", "function", "Lvjson/pl/ast/FunctionDefinition;", "modifier", "Lvjson/pl/ast/ModifierEnum;", "newJsonConvert", "jsonArr", "v", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "jsonObj", "jsonStr", "Lvjson/JSON$String;", "parse", "parseNewInstanceWithJson", "typeStr", "template", "Lvjson/pl/ast/TemplateClassDefinition;", "vjson"})
public final class ASTGen {
    @NotNull
    private final ListIterator<JSON.ObjectEntry> prog;
    @NotNull
    private final ArrayList<Statement> result;

    public ASTGen(@NotNull JSON.Object _prog) {
        Intrinsics.checkNotNullParameter((Object)_prog, (String)"_prog");
        this.prog = _prog.entryList().listIterator();
        this.result = new ArrayList();
    }

    @NotNull
    public final List<Statement> parse() {
        while (this.prog.hasNext()) {
            Statement statement;
            JSON.ObjectEntry entry = this.prog.next();
            switch (entry.getKey()) {
                case "class": {
                    statement = this.aClass(entry);
                    break;
                }
                case "public": {
                    statement = this.modifier(entry, ModifierEnum.PUBLIC);
                    break;
                }
                case "private": {
                    statement = this.modifier(entry, ModifierEnum.PRIVATE);
                    break;
                }
                case "const": {
                    statement = this.modifier(entry, ModifierEnum.CONST);
                    break;
                }
                case "executable": {
                    statement = this.modifier(entry, ModifierEnum.EXECUTABLE);
                    break;
                }
                case "function": {
                    statement = this.function(entry);
                    break;
                }
                case "var": {
                    statement = this.aVar(entry);
                    break;
                }
                case "new": {
                    statement = this.aNew(entry);
                    break;
                }
                case "for": {
                    statement = this.aFor(entry);
                    break;
                }
                case "while": {
                    statement = this.aWhile(entry);
                    break;
                }
                case "if": {
                    statement = this.aIf(entry);
                    break;
                }
                case "break": {
                    statement = this.aBreak(entry);
                    break;
                }
                case "continue": {
                    statement = this.aContinue(entry);
                    break;
                }
                case "return": {
                    statement = this.aReturn(entry);
                    break;
                }
                case "throw": {
                    statement = this.aThrow(entry);
                    break;
                }
                case "template": {
                    statement = this.template(entry);
                    break;
                }
                case "let": {
                    statement = this.aLet(entry);
                    break;
                }
                default: {
                    statement = this.exprKey(entry);
                }
            }
            Statement stmt = statement;
            stmt.setLineCol(entry.getLineCol());
            this.result.add(stmt);
        }
        return this.result;
    }

    /*
     * WARNING - void declaration
     */
    private final ClassDefinition aClass(JSON.ObjectEntry entry) {
        if (!(entry.getValue() instanceof JSON.Null)) {
            throw new ParserException("unexpected token " + entry.getValue() + ", expecting null as value for key `class`", entry.getValue().lineCol());
        }
        if (!this.prog.hasNext()) {
            throw new ParserException("unexpected end of object, expecting class name", entry.getLineCol());
        }
        JSON.ObjectEntry nameAndParams = this.prog.next();
        String className = nameAndParams.getKey();
        if (!(nameAndParams.getValue() instanceof JSON.Object)) {
            throw new ParserException("expecting parameters for class `" + className + "`, but got " + nameAndParams.getValue(), nameAndParams.getValue().lineCol());
        }
        JSON.Instance<?> params = nameAndParams.getValue();
        if (((JSON.Object)params).keySet().size() != ((JSON.Object)params).keyList().size()) {
            throw new ParserException("duplicated parameter name for class `" + className + '`', nameAndParams.getValue().lineCol());
        }
        ArrayList<Param> astParams = new ArrayList<Param>();
        Iterable $this$forEachIndexed$iv = ((JSON.Object)params).entryList();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void e;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JSON.ObjectEntry objectEntry = (JSON.ObjectEntry)item$iv;
            int idx = n;
            boolean bl2 = false;
            if (!(e.getValue() instanceof JSON.String)) {
                throw new ParserException("parameter type must be a string, type for parameters[" + idx + "] is " + e.getValue() + " in class `" + className + '`', e.getValue().lineCol());
            }
            String type = ((JSON.String)e.getValue()).toJavaObject();
            Expr defaultValue = null;
            if (StringsKt.contains$default((CharSequence)type, (CharSequence)"=", (boolean)false, (int)2, null)) {
                int index = StringsKt.indexOf$default((CharSequence)type, (String)"=", (int)0, (boolean)false, (int)6, null);
                String string = type;
                int n2 = index + 1;
                boolean bl3 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                string = string3;
                n2 = 0;
                String string4 = string;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String defaultValueExprStr = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                string = type;
                n2 = 0;
                bl3 = false;
                String string5 = string;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n2, index);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string = string6;
                n2 = 0;
                String string7 = string;
                if (string7 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                type = ((Object)StringsKt.trim((CharSequence)string7)).toString();
                defaultValue = this.exprString(defaultValueExprStr, e.getValue().lineCol().addCol(index));
            }
            Type typeObj = new Type(type);
            astParams.add(new Param(e.getKey(), typeObj, defaultValue));
        }
        if (!this.prog.hasNext()) {
            throw new ParserException("unexpected end of object, expecting class content", entry.getLineCol());
        }
        JSON.ObjectEntry doAndCode = this.prog.next();
        if (!Intrinsics.areEqual((Object)doAndCode.getKey(), (Object)"do")) {
            throw new ParserException("unexpected token " + doAndCode + ", expecting `do` and class content", doAndCode.getLineCol());
        }
        if (!(doAndCode.getValue() instanceof JSON.Object)) {
            throw new ParserException("class content must be encapsulated into a json object, but got " + doAndCode.getValue() + " for class `" + className + '`', doAndCode.getValue().lineCol());
        }
        List<Statement> astCode = new ASTGen((JSON.Object)doAndCode.getValue()).parse();
        return new ClassDefinition(className, (List<Param>)astParams, astCode);
    }

    private final Statement modifier(JSON.ObjectEntry entry, ModifierEnum modifier) {
        Statement statement;
        String string;
        if (!(entry.getValue() instanceof JSON.Null)) {
            throw new ParserException("unexpected token " + entry.getValue() + ", expecting null as value for key `public`", entry.getValue().lineCol());
        }
        Modifiers modifiers = new Modifiers(modifier.getNum());
        JSON.ObjectEntry nextEntry = null;
        while (true) {
            if (!this.prog.hasNext()) {
                throw new ParserException("unexpected end of object, expecting variable or function definition", entry.getLineCol());
            }
            nextEntry = this.prog.next();
            if (!ModifierEnum.Companion.isModifier(nextEntry.getKey())) break;
            int n = modifiers.getModifiers();
            string = nextEntry.getKey();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
            modifiers.setModifiers(n | ModifierEnum.valueOf(string3).getNum());
        }
        if (modifiers.isPublic() && modifiers.isPrivate()) {
            throw new ParserException("invalid modifiers: " + modifiers + ", cannot set public and private at the same time", nextEntry.getLineCol());
        }
        string = nextEntry.getKey();
        if (Intrinsics.areEqual((Object)string, (Object)"var")) {
            VariableDefinition res = this.aVar(nextEntry);
            statement = new VariableDefinition(res.getName(), res.getValue(), modifiers);
        } else if (Intrinsics.areEqual((Object)string, (Object)"function")) {
            FunctionDefinition res = this.function(nextEntry);
            statement = new FunctionDefinition(res.getName(), res.getParams(), res.getReturnType(), res.getCode(), modifiers);
        } else {
            throw new ParserException("unexpected token " + nextEntry + ", expecting variable or function definition", nextEntry.getLineCol());
        }
        return statement;
    }

    /*
     * WARNING - void declaration
     */
    private final FunctionDefinition function(JSON.ObjectEntry entry) {
        if (!(entry.getValue() instanceof JSON.Null)) {
            throw new ParserException("unexpected token " + entry.getValue() + ", expecting null as value for key `function`", entry.getValue().lineCol());
        }
        if (!this.prog.hasNext()) {
            throw new ParserException("unexpected end of object, expecting function name", entry.getLineCol());
        }
        JSON.ObjectEntry nameAndParams = this.prog.next();
        String funcName = nameAndParams.getKey();
        if (!(nameAndParams.getValue() instanceof JSON.Object)) {
            throw new ParserException("expecting parameters for function `" + funcName + "`, but got " + nameAndParams.getValue(), nameAndParams.getValue().lineCol());
        }
        JSON.Instance<?> params = nameAndParams.getValue();
        if (((JSON.Object)params).keySet().size() != ((JSON.Object)params).keyList().size()) {
            throw new ParserException("duplicated parameter name for function `" + funcName + '`', nameAndParams.getValue().lineCol());
        }
        ArrayList<Param> astParams = new ArrayList<Param>();
        Iterable $this$forEachIndexed$iv = ((JSON.Object)params).entryList();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void e;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JSON.ObjectEntry objectEntry = (JSON.ObjectEntry)item$iv;
            int idx = n;
            boolean bl2 = false;
            if (!(e.getValue() instanceof JSON.String)) {
                throw new ParserException("parameter type must be a string, type for parameters[" + idx + "] is " + e.getValue() + " in function `" + funcName + '`', e.getValue().lineCol());
            }
            String type = ((JSON.String)e.getValue()).toJavaObject();
            astParams.add(new Param(e.getKey(), new Type(type), null, 4, null));
        }
        if (!this.prog.hasNext()) {
            throw new ParserException("unexpected end of object, expecting function return type", entry.getLineCol());
        }
        JSON.ObjectEntry returnTypeAndCode = this.prog.next();
        Type astReturnType = new Type(returnTypeAndCode.getKey());
        if (!(returnTypeAndCode.getValue() instanceof JSON.Object)) {
            throw new ParserException("function payload must be encapsulated into a json object, but got " + returnTypeAndCode.getValue() + " for function `" + funcName + '`', returnTypeAndCode.getValue().lineCol());
        }
        List<Statement> astCode = new ASTGen((JSON.Object)returnTypeAndCode.getValue()).parse();
        return new FunctionDefinition(funcName, astParams, astReturnType, astCode, null, 16, null);
    }

    private final VariableDefinition aVar(JSON.ObjectEntry entry) {
        if (!(entry.getValue() instanceof JSON.Null)) {
            throw new ParserException("unexpected token " + entry.getValue() + ", expecting null as value for key `var`", entry.getValue().lineCol());
        }
        if (!this.prog.hasNext()) {
            throw new ParserException("unexpected end of object, expecting variable name", entry.getLineCol());
        }
        JSON.ObjectEntry nextEntry = this.prog.next();
        String varname = nextEntry.getKey();
        Expr value = this.expr(nextEntry.getValue());
        return new VariableDefinition(varname, value, null, 4, null);
    }

    private final Expr aNew(JSON.ObjectEntry entry) {
        Expr expr;
        int n;
        int n2;
        int n3;
        JSON.Instance<?> instance;
        if (!(entry.getValue() instanceof JSON.Null)) {
            throw new ParserException("unexpected token " + entry.getValue() + ", expecting null as value for key `new`", entry.getValue().lineCol());
        }
        if (!this.prog.hasNext()) {
            throw new ParserException("unexpected end of object, expecting the type to be instantiated", entry.getLineCol());
        }
        JSON.ObjectEntry nextEntry = this.prog.next();
        String typeStr = nextEntry.getKey();
        if (StringsKt.startsWith$default((String)typeStr, (String)"(", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)typeStr, (String)")", (boolean)false, (int)2, null)) {
            instance = typeStr;
            n3 = 1;
            n2 = typeStr.length() - 1;
            n = 0;
            JSON.Instance<?> instance2 = instance;
            if (instance2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)((Object)instance2)).substring(n3, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            typeStr = string;
        }
        if (StringsKt.contains$default((CharSequence)typeStr, (CharSequence)"[", (boolean)false, (int)2, null)) {
            if (!StringsKt.endsWith$default((String)typeStr, (String)"]", (boolean)false, (int)2, null)) {
                throw new ParserException(Intrinsics.stringPlus((String)"unexpected type for creating array: found `[` in type string but it does not end with `]`: ", (Object)typeStr), nextEntry.getLineCol());
            }
            String string = typeStr;
            n2 = 0;
            n = StringsKt.indexOf$default((CharSequence)typeStr, (String)"[", (int)0, (boolean)false, (int)6, null);
            int n4 = 0;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n2, n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String elementType = string3;
            int lenEndIndex = StringsKt.indexOf$default((CharSequence)typeStr, (String)"]", (int)(StringsKt.indexOf$default((CharSequence)typeStr, (String)"[", (int)0, (boolean)false, (int)6, null) + 1), (boolean)false, (int)4, null);
            String string4 = typeStr;
            n4 = StringsKt.indexOf$default((CharSequence)typeStr, (String)"[", (int)0, (boolean)false, (int)6, null) + 1;
            int n5 = 0;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n4, lenEndIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String lenStr = string6;
            Expr lenExpr = this.exprString(lenStr, nextEntry.getLineCol().inner().addCol(StringsKt.indexOf$default((CharSequence)typeStr, (String)"[", (int)0, (boolean)false, (int)6, null) + 1));
            if (!(nextEntry.getValue() instanceof JSON.Null)) {
                throw new ParserException("unexpected token " + nextEntry.getValue() + " for new array statement, expecting null value after key `" + typeStr + '`', nextEntry.getValue().lineCol());
            }
            StringBuilder stringBuilder = new StringBuilder().append(elementType).append("[]");
            String string7 = typeStr;
            n5 = lenEndIndex + 1;
            boolean bl = false;
            String string8 = string7;
            if (string8 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string9 = string8.substring(n5);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
            expr = new NewArray(new Type(stringBuilder.append(string9).toString()), lenExpr);
        } else {
            instance = nextEntry.getValue();
            if (instance instanceof JSON.Null) {
                n3 = 0;
                expr = new NewInstance(new Type(typeStr), CollectionsKt.emptyList());
            } else if (instance instanceof JSON.Array) {
                expr = new NewInstance(new Type(typeStr), this.exprArray((JSON.Array)nextEntry.getValue()));
            } else if (instance instanceof JSON.Object) {
                expr = this.parseNewInstanceWithJson((JSON.Object)nextEntry.getValue(), typeStr, entry.getLineCol());
            } else {
                throw new ParserException("unexpected token " + nextEntry.getValue() + " for new instance statement, expecting null or array value after key `" + typeStr + '`', nextEntry.getValue().lineCol());
            }
        }
        return expr;
    }

    private final Expr parseNewInstanceWithJson(JSON.Object jsonObj, String typeStr, LineCol lineCol) {
        NewInstanceWithJson expr = new NewInstanceWithJson(new Type(typeStr), (Map<String, ? extends Object>)this.newJsonConvert(jsonObj));
        expr.setLineCol(lineCol);
        return expr;
    }

    /*
     * WARNING - void declaration
     */
    private final Object newJsonConvert(JSON.Instance<?> v) {
        Object object;
        JSON.Instance<?> instance = v;
        if (instance instanceof JSON.Integer ? true : instance instanceof JSON.Long) {
            IntegerLiteral ret2 = new IntegerLiteral((JSON.Number)v);
            ret2.setLineCol(v.lineCol());
            object = ret2;
        } else if (instance instanceof JSON.Double) {
            FloatLiteral ret3 = new FloatLiteral((JSON.Double)v);
            ret3.setLineCol(v.lineCol());
            object = ret3;
        } else if (instance instanceof JSON.Bool) {
            BoolLiteral ret4 = new BoolLiteral(((JSON.Bool)v).booleanValue());
            ret4.setLineCol(v.lineCol());
            object = ret4;
        } else if (instance instanceof JSON.Null) {
            void var3_6;
            NullLiteral ret5 = new NullLiteral(null, 1, null);
            ret5.setLineCol(v.lineCol());
            object = var3_6;
        } else if (instance instanceof JSON.Object) {
            object = this.newJsonConvert((JSON.Object)v);
        } else if (instance instanceof JSON.Array) {
            object = this.newJsonConvert((JSON.Array)v);
        } else if (instance instanceof JSON.String) {
            object = this.newJsonConvert((JSON.String)v);
        } else {
            throw new ParserException(Intrinsics.stringPlus((String)"unknown json instance ", v), v.lineCol());
        }
        return object;
    }

    private final LinkedHashMap<String, Object> newJsonConvert(JSON.Object jsonObj) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String k : jsonObj.keyList()) {
            JSON.Instance<?> v = jsonObj.get(k);
            Map map2 = map;
            Object object = this.newJsonConvert(v);
            boolean bl = false;
            map2.put(k, object);
        }
        return map;
    }

    private final ArrayList<Object> newJsonConvert(JSON.Array jsonArr) {
        ArrayList<Object> ls = new ArrayList<Object>();
        int n = 0;
        int n2 = jsonArr.length();
        if (n < n2) {
            do {
                int i = n++;
                JSON.Instance<?> e = jsonArr.get(i);
                ls.add(this.newJsonConvert(e));
            } while (n < n2);
        }
        return ls;
    }

    private final Expr newJsonConvert(JSON.String jsonStr) {
        String str = jsonStr.toJavaObject();
        if (!StringsKt.startsWith$default((String)str, (String)"${", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)str, (String)"}", (boolean)false, (int)2, null)) {
            return new StringLiteral(str);
        }
        String string = str;
        int n = 2;
        int n2 = str.length() - 1;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        str = string3;
        return this.exprString(str, jsonStr.lineCol().inner());
    }

    private final ForLoop aFor(JSON.ObjectEntry entry) {
        List<Statement> astIncr;
        if (!(entry.getValue() instanceof JSON.Array)) {
            throw new ParserException("unexpected token " + entry.getValue() + ", expecting a 3-element array for `for` loop", entry.getValue().lineCol());
        }
        JSON.Instance<?> array = entry.getValue();
        if (((JSON.Array)array).length() != 3) {
            throw new ParserException("unexpected token " + entry.getValue() + ", expecting a 3-element array for `for` loop", entry.getValue().lineCol());
        }
        JSON.Instance<?> init = ((JSON.Array)array).get(0);
        JSON.Instance<?> cond = ((JSON.Array)array).get(1);
        JSON.Instance<?> incr = ((JSON.Array)array).get(2);
        List<Statement> astInit = init instanceof JSON.Object ? new ASTGen((JSON.Object)init).parse() : CollectionsKt.listOf((Object)this.expr(init));
        Expr astCond = this.expr(cond);
        List<Statement> list = astIncr = incr instanceof JSON.Object ? new ASTGen((JSON.Object)incr).parse() : CollectionsKt.listOf((Object)this.expr(incr));
        if (!this.prog.hasNext()) {
            throw new ParserException("unexpected end of object, expecting code for the `for` loop", entry.getLineCol());
        }
        JSON.ObjectEntry nextEntry = this.prog.next();
        if (!Intrinsics.areEqual((Object)nextEntry.getKey(), (Object)"do")) {
            throw new ParserException("unexpected token " + nextEntry + ", expecting `do` to begin the `for` loop code", nextEntry.getLineCol());
        }
        if (!(nextEntry.getValue() instanceof JSON.Object)) {
            throw new ParserException("unexpected token " + nextEntry.getValue() + ", expecting code block for the `for` loop", nextEntry.getValue().lineCol());
        }
        List<Statement> code = new ASTGen((JSON.Object)nextEntry.getValue()).parse();
        return new ForLoop(astInit, astCond, astIncr, code);
    }

    private final WhileLoop aWhile(JSON.ObjectEntry entry) {
        Expr astCond = this.expr(entry.getValue());
        if (!this.prog.hasNext()) {
            throw new ParserException("unexpected end of object, expecting code for the `while` loop", entry.getLineCol());
        }
        JSON.ObjectEntry nextEntry = this.prog.next();
        if (!Intrinsics.areEqual((Object)nextEntry.getKey(), (Object)"do")) {
            throw new ParserException("unexpected token " + nextEntry + ", expecting `do` to begin the `while` loop code", nextEntry.getLineCol());
        }
        if (!(nextEntry.getValue() instanceof JSON.Object)) {
            throw new ParserException("unexpected token " + nextEntry.getValue() + ", expecting code block for the `while` loop", nextEntry.getValue().lineCol());
        }
        List<Statement> code = new ASTGen((JSON.Object)nextEntry.getValue()).parse();
        return new WhileLoop(astCond, code);
    }

    private final Statement aIf(JSON.ObjectEntry entry) {
        boolean isErrorHandling;
        Expr astCond = this.expr(entry.getValue());
        boolean bl = isErrorHandling = Intrinsics.areEqual((Object)astCond, (Object)new BinOp(BinOpType.CMP_NE, new Access("err", null, 2, null), new NullLiteral(null, 1, null))) || Intrinsics.areEqual((Object)astCond, (Object)new BinOp(BinOpType.CMP_NE, new NullLiteral(null, 1, null), new Access("err", null, 2, null)));
        if (!this.prog.hasNext()) {
            throw new ParserException("unexpected end of object, expecting content for `if`", entry.getLineCol());
        }
        JSON.ObjectEntry nextEntry = this.prog.next();
        if (!Intrinsics.areEqual((Object)nextEntry.getKey(), (Object)"then")) {
            throw new ParserException("unexpected token " + nextEntry + ", expecting `then` after `if`", nextEntry.getLineCol());
        }
        if (!(nextEntry.getValue() instanceof JSON.Object)) {
            throw new ParserException("unexpected token " + nextEntry.getValue() + ", expecting code block for `if`", nextEntry.getValue().lineCol());
        }
        List<Statement> ifCode = new ASTGen((JSON.Object)nextEntry.getValue()).parse();
        if (!this.prog.hasNext()) {
            boolean bl2 = false;
            return this.checkAndGenerateErrorHandling(isErrorHandling, new IfStatement(astCond, ifCode, CollectionsKt.emptyList()));
        }
        JSON.ObjectEntry nextNextEntry = this.prog.next();
        if (Intrinsics.areEqual((Object)nextNextEntry.getKey(), (Object)"else")) {
            JSON.Instance<?> instance = nextNextEntry.getValue();
            if (instance instanceof JSON.Null) {
                if (!this.prog.hasNext()) {
                    throw new ParserException("unexpected end of object, found `else` without colon `:`, but not following another `if`", nextNextEntry.getLineCol());
                }
                JSON.ObjectEntry nextNextNextEntry = this.prog.next();
                if (!Intrinsics.areEqual((Object)nextNextNextEntry.getKey(), (Object)"if")) {
                    throw new ParserException("unexpected token " + nextNextNextEntry + ", found `else: null`, but not following another `if`, you need to use `else: {...}` for else block ", nextNextNextEntry.getLineCol());
                }
                if (isErrorHandling) {
                    throw new ParserException("unexpected else-if block, error handling can only have `else` block", nextNextEntry.getLineCol());
                }
                Statement nextIf = this.aIf(nextNextNextEntry);
                return new IfStatement(astCond, ifCode, CollectionsKt.listOf((Object)nextIf));
            }
            if (instance instanceof JSON.Object) {
                List<Statement> elseCode = new ASTGen((JSON.Object)nextNextEntry.getValue()).parse();
                return this.checkAndGenerateErrorHandling(isErrorHandling, new IfStatement(astCond, ifCode, elseCode));
            }
            throw new ParserException("unexpected token " + nextNextEntry.getValue() + ", expecting code block for `else`", nextNextEntry.getValue().lineCol());
        }
        this.prog.previous();
        boolean bl3 = false;
        return this.checkAndGenerateErrorHandling(isErrorHandling, new IfStatement(astCond, ifCode, CollectionsKt.emptyList()));
    }

    private final Statement checkAndGenerateErrorHandling(boolean isErrorHandling, IfStatement aIf) {
        if (!isErrorHandling) {
            return aIf;
        }
        int lastErrorHandlingIndex = -1;
        Iterator<Statement> iterator = this.result.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int idx = n++;
            Statement stmt = iterator.next();
            if (!(stmt instanceof ErrorHandlingStatement)) continue;
            lastErrorHandlingIndex = idx;
        }
        ArrayList ls = null;
        if (this.result.isEmpty()) {
            ls = new ArrayList();
        } else {
            ls = new ArrayList(this.result.subList(lastErrorHandlingIndex + 1, this.result.size()));
            ArrayList foo = new ArrayList(this.result.subList(0, lastErrorHandlingIndex + 1));
            this.result.clear();
            this.result.addAll(foo);
        }
        return new ErrorHandlingStatement(ls, aIf.getIfCode(), aIf.getElseCode());
    }

    private final BreakStatement aBreak(JSON.ObjectEntry entry) {
        if (!(entry.getValue() instanceof JSON.Null)) {
            throw new ParserException("unexpected token " + entry.getValue() + ", expecting null as value for key `break`", entry.getValue().lineCol());
        }
        return new BreakStatement(null, 1, null);
    }

    private final ContinueStatement aContinue(JSON.ObjectEntry entry) {
        if (!(entry.getValue() instanceof JSON.Null)) {
            throw new ParserException("unexpected token " + entry.getValue() + ", expecting null as value for key `continue`", entry.getValue().lineCol());
        }
        return new ContinueStatement(null, 1, null);
    }

    private final ReturnStatement aReturn(JSON.ObjectEntry entry) {
        return entry.getValue() instanceof JSON.Null ? new ReturnStatement(null, 1, null) : new ReturnStatement(this.expr(entry.getValue()));
    }

    private final ThrowStatement aThrow(JSON.ObjectEntry entry) {
        return entry.getValue() instanceof JSON.Null ? new ThrowStatement(null, 1, null) : new ThrowStatement(this.expr(entry.getValue()));
    }

    private final TemplateClassDefinition template(JSON.ObjectEntry entry) {
        if (!(entry.getValue() instanceof JSON.Object)) {
            throw new ParserException("unexpected token " + entry.getValue() + ", expecting { ... } for defining param type names", entry.getValue().lineCol());
        }
        JSON.Instance<?> paramTypesObj = entry.getValue();
        ArrayList<ParamType> types = new ArrayList<ParamType>();
        HashSet<String> typeNames = new HashSet<String>();
        for (JSON.ObjectEntry p : ((JSON.Object)paramTypesObj).entryList()) {
            if (!(p.getValue() instanceof JSON.Null)) {
                throw new ParserException("unexpected token " + p.getValue() + ", expecting null as value for the param type name", p.getValue().lineCol());
            }
            if (!typeNames.add(p.getKey())) {
                throw new ParserException("duplicated param type name", p.getLineCol());
            }
            types.add(new ParamType(p.getKey()));
        }
        if (!this.prog.hasNext()) {
            throw new ParserException("unexpected end of object, expecting class definition after `template`", entry.getLineCol());
        }
        JSON.ObjectEntry nextEntry = this.prog.next();
        if (!Intrinsics.areEqual((Object)nextEntry.getKey(), (Object)"class")) {
            throw new ParserException("unexpected token " + nextEntry + ", expecting class definition after `template`", entry.getLineCol());
        }
        ClassDefinition cls = this.aClass(nextEntry);
        return new TemplateClassDefinition((List<ParamType>)types, cls);
    }

    private final TemplateTypeInstantiation aLet(JSON.ObjectEntry entry) {
        if (!(entry.getValue() instanceof JSON.Null)) {
            throw new ParserException("unexpected token " + entry.getValue() + ", expecting null for key `let`", entry.getValue().lineCol());
        }
        if (!this.prog.hasNext()) {
            throw new ParserException("unexpected end of object, expecting the type to be defined from a template type", entry.getLineCol());
        }
        JSON.ObjectEntry next = this.prog.next();
        String typeName = next.getKey();
        if (!(next.getValue() instanceof JSON.Object)) {
            throw new ParserException("unexpected token " + entry.getValue() + ", expecting object for constructing the type", next.getValue().lineCol());
        }
        List<JSON.ObjectEntry> obj = ((JSON.Object)next.getValue()).entryList();
        if (obj.isEmpty()) {
            throw new ParserException("unexpected token " + entry.getValue() + ", expecting object for constructing the type", next.getValue().lineCol());
        }
        if (obj.size() != 1) {
            throw new ParserException("unexpected token " + entry.getValue() + ", expecting object for constructing the type, got extra tokens", next.getValue().lineCol());
        }
        String paramTypeName = obj.get(0).getKey();
        if (!(obj.get(0).getValue() instanceof JSON.Array)) {
            throw new ParserException("unexpected token " + obj.get(0).getValue() + ", expecting array for type parameters", obj.get(0).getValue().lineCol());
        }
        JSON.Array arr = (JSON.Array)obj.get(0).getValue();
        ArrayList<Type> typeParams = new ArrayList<Type>();
        int n = 0;
        int n2 = arr.length();
        if (n < n2) {
            do {
                int i;
                JSON.Instance<?> x;
                if (!((x = arr.get(i = n++)) instanceof JSON.String)) {
                    throw new ParserException("unexpected token " + x + ", expecting string for type parameters", x.lineCol());
                }
                typeParams.add(new Type(((JSON.String)x).toJavaObject()));
            } while (n < n2);
        }
        return new TemplateTypeInstantiation(typeName, new Type(paramTypeName), (List<Type>)typeParams);
    }

    private final Expr exprKey(JSON.ObjectEntry _entry) {
        Expr expr;
        String key;
        BinOpType binOp;
        JSON.ObjectEntry entry;
        block27: {
            block28: {
                BinOpType binOpType;
                block26: {
                    entry = _entry;
                    binOp = null;
                    key = entry.getKey();
                    if (!StringsKt.endsWith$default((String)key, (String)"+", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)key, (String)"-", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)key, (String)"*", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)key, (String)"/", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)key, (String)"%", (boolean)false, (int)2, null)) break block26;
                    char c = StringsKt.last((CharSequence)key);
                    binOp = c == '+' ? BinOpType.PLUS : (c == '-' ? BinOpType.MINUS : (c == '*' ? BinOpType.MULTIPLY : (c == '/' ? BinOpType.DIVIDE : BinOpType.MOD)));
                    String string = key;
                    int n = 0;
                    int n2 = key.length() - 1;
                    boolean bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(n, n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    key = string3;
                    break block27;
                }
                if (!(entry.getValue() instanceof JSON.Null) || !this.prog.hasNext()) break block27;
                JSON.ObjectEntry nxt = this.prog.next();
                if (!Intrinsics.areEqual((Object)nxt.getKey(), (Object)"+") && !Intrinsics.areEqual((Object)nxt.getKey(), (Object)"-") && !Intrinsics.areEqual((Object)nxt.getKey(), (Object)"*") && !Intrinsics.areEqual((Object)nxt.getKey(), (Object)"/") && !Intrinsics.areEqual((Object)nxt.getKey(), (Object)"%")) break block28;
                switch (nxt.getKey()) {
                    case "+": {
                        binOpType = BinOpType.PLUS;
                        break;
                    }
                    case "-": {
                        binOpType = BinOpType.MINUS;
                        break;
                    }
                    case "*": {
                        binOpType = BinOpType.MULTIPLY;
                        break;
                    }
                    case "/": {
                        binOpType = BinOpType.DIVIDE;
                        break;
                    }
                    default: {
                        binOpType = BinOpType.MOD;
                    }
                }
                binOp = binOpType;
                entry = nxt;
                break block27;
            }
            this.prog.previous();
        }
        ExprTokenizer tokenizer = new ExprTokenizer(key, entry.getLineCol().inner());
        ExprParser parser = new ExprParser(tokenizer);
        Expr expr2 = parser.parse();
        if (ExprTokenizer.peek$default(tokenizer, 0, 1, null) != null) {
            throw new ParserException(Intrinsics.stringPlus((String)"only one expression can be used, but multiple found, next token: ", (Object)ExprTokenizer.peek$default(tokenizer, 0, 1, null)), tokenizer.currentLineCol());
        }
        if (entry.getValue() instanceof JSON.Array) {
            if (binOp != null) {
                throw new ParserException("unexpected token " + entry.getValue() + ", cannot be used with " + (Object)((Object)binOp), entry.getValue().lineCol());
            }
            CastUtils castUtils = CastUtils.INSTANCE;
            JSON.Instance<?> t$iv = entry.getValue();
            boolean $i$f$cast = false;
            expr = this.callFunction(expr2, (JSON.Array)t$iv);
        } else if (expr2 instanceof NullLiteral) {
            if (!(entry.getValue() instanceof JSON.String)) {
                throw new ParserException("unexpected token " + entry.getValue() + ", expecting type for the `null` literal", entry.getValue().lineCol());
            }
            if (binOp != null) {
                throw new ParserException("unexpected token " + entry.getKey() + ", unexpected token " + (Object)((Object)binOp), entry.getLineCol());
            }
            CastUtils this_$iv = CastUtils.INSTANCE;
            Object t$iv = entry.getValue().toJavaObject();
            boolean $i$f$cast = false;
            expr = new NullLiteral(new Type((String)t$iv));
        } else {
            if (!(expr2 instanceof AssignableExpr)) {
                throw new ParserException(Intrinsics.stringPlus((String)"unable to assign value to ", (Object)expr2), expr2.getLineCol());
            }
            expr = binOp != null ? (Expr)new OpAssignment(binOp, (AssignableExpr)expr2, this.expr(entry.getValue())) : (Expr)new Assignment((AssignableExpr)expr2, this.expr(entry.getValue()));
        }
        return expr;
    }

    private final FunctionInvocation callFunction(Expr funcExpr, JSON.Array args) {
        ArrayList<Expr> exprArgs = new ArrayList<Expr>(args.length());
        int n = 0;
        int n2 = args.length();
        if (n < n2) {
            do {
                int i = n++;
                exprArgs.add(this.expr(args.get(i)));
            } while (n < n2);
        }
        return new FunctionInvocation(funcExpr, (List<? extends Expr>)exprArgs);
    }

    private final Expr expr(JSON.Instance<?> json) {
        Expr expr;
        JSON.Instance<?> instance = json;
        if (instance instanceof JSON.Object) {
            expr = this.exprObject((JSON.Object)json);
        } else if (instance instanceof JSON.String) {
            expr = this.exprString(((JSON.String)json).toJavaObject(), json.lineCol().inner());
        } else if (instance instanceof JSON.Bool) {
            expr = new BoolLiteral(((JSON.Bool)json).booleanValue());
        } else if (instance instanceof JSON.Integer ? true : instance instanceof JSON.Long) {
            CastUtils this_$iv = CastUtils.INSTANCE;
            boolean $i$f$cast = false;
            expr = new IntegerLiteral((JSON.Number)json);
        } else if (instance instanceof JSON.Double) {
            expr = new FloatLiteral((JSON.Double)json);
        } else if (instance instanceof JSON.Null) {
            expr = new NullLiteral(null, 1, null);
        } else {
            throw new ParserException(Intrinsics.stringPlus((String)"unexpected expression ", json), json.lineCol());
        }
        return expr;
    }

    private final Expr exprObject(JSON.Object json) {
        List<Statement> stmts = new ASTGen(json).parse();
        if (stmts.size() != 1) {
            throw new ParserException("unexpected ast " + stmts + ", expecting one and only one expression to be generated", json.lineCol());
        }
        Statement stmt = stmts.get(0);
        if (!(stmt instanceof Expr)) {
            throw new ParserException("unexpected ast " + stmt + ", expecting expression", stmt.getLineCol());
        }
        return (Expr)stmt;
    }

    private final List<Expr> exprArray(JSON.Array json) {
        ArrayList<Expr> res = new ArrayList<Expr>(json.length());
        int n = 0;
        int n2 = json.length();
        if (n < n2) {
            do {
                int i = n++;
                res.add(this.expr(json.get(i)));
            } while (n < n2);
        }
        return res;
    }

    private final Expr exprString(String input, LineCol lineCol) {
        ExprTokenizer tokenizer = new ExprTokenizer(input, lineCol);
        ExprParser parser = new ExprParser(tokenizer);
        Expr expr = parser.parse();
        if (ExprTokenizer.peek$default(tokenizer, 0, 1, null) != null) {
            throw new ParserException(Intrinsics.stringPlus((String)"only one expression can be used, but multiple found, next token: ", (Object)ExprTokenizer.peek$default(tokenizer, 0, 1, null)), lineCol);
        }
        return expr;
    }
}

