/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import vjson.JSON;
import vjson.cs.LineCol;
import vjson.ex.ParserException;
import vjson.pl.ExprTokenizer;
import vjson.pl.ParserContext;
import vjson.pl.ast.Access;
import vjson.pl.ast.AccessIndex;
import vjson.pl.ast.AssignableExpr;
import vjson.pl.ast.BinOpType;
import vjson.pl.ast.BoolLiteral;
import vjson.pl.ast.Expr;
import vjson.pl.ast.FloatLiteral;
import vjson.pl.ast.FunctionInvocation;
import vjson.pl.ast.IntegerLiteral;
import vjson.pl.ast.LogicNot;
import vjson.pl.ast.Negative;
import vjson.pl.ast.NewArray;
import vjson.pl.ast.NewInstance;
import vjson.pl.ast.NewInstanceWithJson;
import vjson.pl.ast.NullLiteral;
import vjson.pl.ast.OpAssignment;
import vjson.pl.ast.Positive;
import vjson.pl.ast.StringLiteral;
import vjson.pl.ast.Type;
import vjson.pl.token.Token;
import vjson.pl.token.TokenType;
import vjson.simple.SimpleString;
import vjson.util.CastUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u001fj\b\u0012\u0004\u0012\u00020\u0001` 2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"H\u0002J\u001c\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$H\u0002J4\u0010\u001e\u001a\u001e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u00010%j\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u0001`'2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010\u001e\u001a\u00020*2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010-\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010.\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010/\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u00100\u001a\u00020*J&\u00101\u001a\b\u0012\u0004\u0012\u00020*022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020&H\u0002J \u00106\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u00107\u001a\u00020&2\u0006\u00103\u001a\u000204H\u0002J\u0010\u00108\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u00109\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010:\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lvjson/pl/ExprParser;", "", "tokenizer", "Lvjson/pl/ExprTokenizer;", "(Lvjson/pl/ExprTokenizer;)V", "accessField", "", "ctx", "Lvjson/pl/ParserContext;", "accessIndex", "accessVar", "binOp", "op", "Lvjson/pl/ast/BinOpType;", "bool", "bracketEnd", "exprBinOp", "exprContinue", "exprEntry", "exprNew", "exprNull", "float", "integer", "isTerminator", "", "token", "Lvjson/pl/token/Token;", "logicNot", "methodInvocation", "negative", "newJsonConvert", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "jsonArr", "Lvjson/JSON$Array;", "v", "Lvjson/JSON$Instance;", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "jsonObj", "Lvjson/JSON$Object;", "Lvjson/pl/ast/Expr;", "jsonStr", "Lvjson/JSON$String;", "opAssign", "par", "parEnd", "parse", "parseArguments", "", "lineCol", "Lvjson/cs/LineCol;", "handlingTarget", "parseNewInstanceWithJson", "typeStr", "positive", "string", "terminate", "vjson"})
public final class ExprParser {
    @NotNull
    private final ExprTokenizer tokenizer;

    public ExprParser(@NotNull ExprTokenizer tokenizer) {
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        this.tokenizer = tokenizer;
    }

    @NotNull
    public final Expr parse() {
        ParserContext ctx = new ParserContext(null, null);
        this.exprEntry(ctx);
        return ctx.getExprStack().pop();
    }

    private final void exprEntry(ParserContext ctx) {
        Object object = ExprTokenizer.peek$default(this.tokenizer, 0, 1, null);
        if (object == null) {
            throw new ParserException("unexpected end of expression", this.tokenizer.getOffset());
        }
        Token token = object;
        object = token.getType();
        int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
        switch (n) {
            case 1: {
                this.integer(ctx);
                break;
            }
            case 2: {
                this.float(ctx);
                break;
            }
            case 3: {
                this.bool(ctx);
                break;
            }
            case 4: {
                this.bool(ctx);
                break;
            }
            case 5: {
                this.exprNull(ctx);
                break;
            }
            case 6: {
                this.exprNew(ctx);
                break;
            }
            case 7: {
                this.accessVar(ctx);
                break;
            }
            case 8: {
                this.par(ctx);
                break;
            }
            case 9: {
                this.positive(ctx);
                break;
            }
            case 10: {
                this.negative(ctx);
                break;
            }
            case 11: {
                this.logicNot(ctx);
                break;
            }
            case 12: {
                this.string(ctx);
                break;
            }
            default: {
                throw new ParserException(Intrinsics.stringPlus((String)"unexpected token ", (Object)token), token.getLineCol());
            }
        }
    }

    private final void exprBinOp(ParserContext ctx) {
        if (!ctx.getUnaryOpStack().isEmpty()) {
            return;
        }
        if (ctx.getExprStack().isEmpty()) {
            this.exprEntry(ctx);
            return;
        }
        Token token = ExprTokenizer.peek$default(this.tokenizer, 0, 1, null);
        if (token == null) {
            ctx.foldBinOp(0);
            return;
        }
        TokenType tokenType = token.getType();
        int n = WhenMappings.$EnumSwitchMapping$0[tokenType.ordinal()];
        switch (n) {
            case 9: {
                this.binOp(ctx, BinOpType.PLUS);
                break;
            }
            case 10: {
                this.binOp(ctx, BinOpType.MINUS);
                break;
            }
            case 13: {
                this.binOp(ctx, BinOpType.MULTIPLY);
                break;
            }
            case 14: {
                this.binOp(ctx, BinOpType.DIVIDE);
                break;
            }
            case 15: {
                this.binOp(ctx, BinOpType.MOD);
                break;
            }
            case 16: {
                this.binOp(ctx, BinOpType.CMP_GT);
                break;
            }
            case 17: {
                this.binOp(ctx, BinOpType.CMP_GE);
                break;
            }
            case 18: {
                this.binOp(ctx, BinOpType.CMP_LT);
                break;
            }
            case 19: {
                this.binOp(ctx, BinOpType.CMP_LE);
                break;
            }
            case 20: {
                this.binOp(ctx, BinOpType.CMP_NE);
                break;
            }
            case 21: {
                this.binOp(ctx, BinOpType.CMP_EQ);
                break;
            }
            case 22: {
                this.binOp(ctx, BinOpType.LOGIC_AND);
                break;
            }
            case 23: {
                this.binOp(ctx, BinOpType.LOGIC_OR);
                break;
            }
            default: {
                this.exprEntry(ctx);
            }
        }
    }

    private final void exprContinue(ParserContext ctx) {
        Token token = ExprTokenizer.peek$default(this.tokenizer, 0, 1, null);
        if (token == null) {
            ctx.foldBinOp(0);
            return;
        }
        TokenType tokenType = token.getType();
        int n = WhenMappings.$EnumSwitchMapping$0[tokenType.ordinal()];
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                this.exprBinOp(ctx);
                break;
            }
            case 24: {
                this.opAssign(ctx, BinOpType.PLUS);
                break;
            }
            case 25: {
                this.opAssign(ctx, BinOpType.MINUS);
                break;
            }
            case 26: {
                this.opAssign(ctx, BinOpType.MULTIPLY);
                break;
            }
            case 27: {
                this.opAssign(ctx, BinOpType.DIVIDE);
                break;
            }
            case 28: {
                this.opAssign(ctx, BinOpType.MOD);
                break;
            }
            case 29: {
                this.parEnd(ctx);
                break;
            }
            case 30: {
                this.bracketEnd(ctx);
                break;
            }
            case 31: {
                this.accessField(ctx);
                break;
            }
            case 32: {
                this.methodInvocation(ctx);
                break;
            }
            case 33: {
                this.accessIndex(ctx);
                break;
            }
            case 34: {
                this.terminate(ctx);
                break;
            }
            default: {
                throw new ParserException("unexpected token " + token + ", expecting bin-operators, assignments or dot", token.getLineCol());
            }
        }
    }

    private final void parEnd(ParserContext ctx) {
        if (ctx.getBeginToken() == null) {
            Token token = ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
            Intrinsics.checkNotNull((Object)token);
            throw new ParserException("unexpected `)`, no matching `(` found for it", token.getLineCol());
        }
        if (ctx.getBeginToken() != TokenType.LEFT_PAR) {
            String string = Intrinsics.stringPlus((String)"unexpected `)`, the begin token is not `(`: ", (Object)((Object)ctx.getBeginToken()));
            Token token = ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
            Intrinsics.checkNotNull((Object)token);
            throw new ParserException(string, token.getLineCol());
        }
        ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
        ctx.foldBinOp(0);
        ctx.setEnds(true);
    }

    private final void bracketEnd(ParserContext ctx) {
        if (ctx.getBeginToken() == null) {
            Token token = ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
            Intrinsics.checkNotNull((Object)token);
            throw new ParserException("unexpected `]`, no matching `[` found for it", token.getLineCol());
        }
        if (ctx.getBeginToken() != TokenType.LEFT_BRACKET) {
            String string = Intrinsics.stringPlus((String)"unexpected `]`, the begin token is not `[`: ", (Object)((Object)ctx.getBeginToken()));
            Token token = ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
            Intrinsics.checkNotNull((Object)token);
            throw new ParserException(string, token.getLineCol());
        }
        ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
        ctx.foldBinOp(0);
        ctx.setEnds(true);
    }

    private final void accessField(ParserContext ctx) {
        Token token = ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
        Intrinsics.checkNotNull((Object)token);
        Token token2 = token;
        Expr exp = ctx.getExprStack().pop();
        Token token3 = ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
        if (token3 == null) {
            throw new ParserException(Intrinsics.stringPlus((String)"unexpected end of expression when trying to get field of ", (Object)exp), token2.getLineCol());
        }
        Token next = token3;
        if (next.getType() != TokenType.VAR_NAME) {
            throw new ParserException("unexpected token " + next + ", expecting field name for accessing " + exp, next.getLineCol());
        }
        Access access = new Access(next.getRaw(), exp);
        access.setLineCol(token2.getLineCol());
        ctx.getExprStack().push(access);
        this.exprContinue(ctx);
    }

    private final void methodInvocation(ParserContext ctx) {
        Token token = ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
        Intrinsics.checkNotNull((Object)token);
        Token token2 = token;
        Expr exp = ctx.getExprStack().pop();
        Token token3 = ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
        if (token3 == null) {
            throw new ParserException(Intrinsics.stringPlus((String)"unexpected end of expression when trying to invoke function ", (Object)exp), token2.getLineCol());
        }
        Token next = token3;
        if (next.getType() != TokenType.LEFT_BRACKET) {
            throw new ParserException("unexpected token " + next + ", expecting `[` for invoking " + exp, next.getLineCol());
        }
        List<Expr> args = this.parseArguments(ctx, token2.getLineCol(), Intrinsics.stringPlus((String)"invoking function ", (Object)exp));
        FunctionInvocation funcInvoke = new FunctionInvocation(exp, args);
        funcInvoke.setLineCol(token2.getLineCol());
        ctx.getExprStack().push(funcInvoke);
        this.exprContinue(ctx);
    }

    private final List<Expr> parseArguments(ParserContext ctx, LineCol lineCol, String handlingTarget) {
        Token token = ExprTokenizer.peek$default(this.tokenizer, 0, 1, null);
        if (token == null) {
            throw new ParserException(Intrinsics.stringPlus((String)"unexpected end of expression when preparing arguments for ", (Object)handlingTarget), lineCol);
        }
        Token next = token;
        if (next.getType() == TokenType.RIGHT_BRACKET) {
            ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
            return CollectionsKt.emptyList();
        }
        ParserContext subCtx = new ParserContext(ctx, TokenType.LEFT_BRACKET);
        int argIdx = 0;
        ArrayList<Expr> args = new ArrayList<Expr>();
        while (true) {
            this.exprEntry(subCtx);
            Expr arg = subCtx.getExprStack().pop();
            args.add(arg);
            if (subCtx.getEnds()) break;
            Token token2 = ExprTokenizer.peek$default(this.tokenizer, 0, 1, null);
            if (token2 == null) {
                throw new ParserException("unexpected end of expression when preparing arguments[" + argIdx + "] for " + handlingTarget, next.getLineCol());
            }
            next = token2;
            if (next.getType() == TokenType.RIGHT_BRACKET) {
                ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
                break;
            }
            ++argIdx;
        }
        return args;
    }

    private final void accessIndex(ParserContext ctx) {
        Token token = ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
        Intrinsics.checkNotNull((Object)token);
        Token token2 = token;
        Expr expr = ctx.getExprStack().pop();
        Token token3 = ExprTokenizer.peek$default(this.tokenizer, 0, 1, null);
        if (token3 == null) {
            throw new ParserException(Intrinsics.stringPlus((String)"unexpected end of expression when trying to access index of ", (Object)expr), token2.getLineCol());
        }
        Token next = token3;
        if (next.getType() == TokenType.RIGHT_BRACKET) {
            throw new ParserException("unexpected token " + next + ", index must be specified for accessing " + expr, next.getLineCol());
        }
        ParserContext subCtx = new ParserContext(ctx, TokenType.LEFT_BRACKET);
        this.exprEntry(subCtx);
        if (!subCtx.getEnds()) {
            throw new ParserException("only one element can be used to access index of " + expr + ", the next token is " + (ExprTokenizer.peek$default(this.tokenizer, 0, 1, null) == null ? "eof" : ExprTokenizer.peek$default(this.tokenizer, 0, 1, null)), expr.getLineCol());
        }
        Expr indexExpr = subCtx.getExprStack().pop();
        AccessIndex accessIndex = new AccessIndex(expr, indexExpr);
        accessIndex.setLineCol(token2.getLineCol());
        ctx.getExprStack().push(accessIndex);
        this.exprContinue(ctx);
    }

    private final void terminate(ParserContext ctx) {
        ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
        ctx.foldBinOp(0);
    }

    private final void binOp(ParserContext ctx, BinOpType op) {
        Token token = ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
        Intrinsics.checkNotNull((Object)token);
        Token token2 = token;
        if (ctx.getOpStack().isEmpty() || ctx.getOpStack().peek().getType().getPrecedence() < op.getPrecedence()) {
            ctx.getOpStack().push(new ParserContext.OpInfo(op, token2.getLineCol()));
            this.exprEntry(ctx);
        } else {
            ctx.foldBinOp(op.getPrecedence());
            ctx.getOpStack().push(new ParserContext.OpInfo(op, token2.getLineCol()));
            this.exprEntry(ctx);
        }
    }

    private final void opAssign(ParserContext ctx, BinOpType op) {
        Token token = ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
        Intrinsics.checkNotNull((Object)token);
        Token token0 = token;
        if (ctx.getExprStack().size() != 1) {
            throw new ParserException(Intrinsics.stringPlus((String)"unable to handle assignment with multiple pending expressions ", ctx.getExprStack()), token0.getLineCol());
        }
        Expr variable = ctx.getExprStack().pop();
        this.exprEntry(ctx);
        Expr next = ctx.getExprStack().pop();
        if (!(variable instanceof AssignableExpr)) {
            throw new ParserException(variable + " is not assignable while trying to " + (Object)((Object)op) + '=' + next + " to it", token0.getLineCol());
        }
        OpAssignment opAssign = new OpAssignment(op, (AssignableExpr)variable, next);
        opAssign.setLineCol(token0.getLineCol());
        ctx.getExprStack().push(opAssign);
        Token token2 = ExprTokenizer.peek$default(this.tokenizer, 0, 1, null);
        if (!this.isTerminator(token2)) {
            if (token2 == null) {
                throw new ParserException("expression not terminating after parsing " + ctx.getExprStack().peek() + ", got eof");
            }
            throw new ParserException("expression not terminating after parsing " + ctx.getExprStack().peek() + ", got token " + token2, token2.getLineCol());
        }
    }

    private final void integer(ParserContext ctx) {
        Token token = ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
        Intrinsics.checkNotNull((Object)token);
        Token token2 = token;
        if (!(token2.getValue() instanceof JSON.Integer) && !(token2.getValue() instanceof JSON.Long)) {
            throw new ParserException("unexpected value in token " + token2 + ", expecting JSON.Integer or JSON.Long, but got " + token2.getValue(), token2.getLineCol());
        }
        CastUtils castUtils = CastUtils.INSTANCE;
        Object t$iv = token2.getValue();
        boolean $i$f$cast = false;
        IntegerLiteral intLiteral = new IntegerLiteral((JSON.Number)t$iv);
        intLiteral.setLineCol(token2.getLineCol());
        ctx.getExprStack().push(intLiteral);
        this.exprContinue(ctx);
    }

    private final void float(ParserContext ctx) {
        Token token = ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
        Intrinsics.checkNotNull((Object)token);
        Token token2 = token;
        if (!(token2.getValue() instanceof JSON.Double)) {
            throw new ParserException("unexpected value in token " + token2 + ", expecting JSON.Double, but got " + token2.getValue(), token2.getLineCol());
        }
        FloatLiteral floatLiteral = new FloatLiteral((JSON.Double)token2.getValue());
        floatLiteral.setLineCol(token2.getLineCol());
        ctx.getExprStack().push(floatLiteral);
        this.exprContinue(ctx);
    }

    private final void bool(ParserContext ctx) {
        Token token = ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
        Intrinsics.checkNotNull((Object)token);
        Token token2 = token;
        if (!(token2.getValue() instanceof JSON.Bool)) {
            throw new ParserException("unexpected value in token " + token2 + ", expecting JSON.Bool, but got " + token2.getValue(), token2.getLineCol());
        }
        BoolLiteral boolLiteral = new BoolLiteral(((JSON.Bool)token2.getValue()).booleanValue());
        boolLiteral.setLineCol(token2.getLineCol());
        ctx.getExprStack().push(boolLiteral);
        this.exprContinue(ctx);
    }

    private final void exprNull(ParserContext ctx) {
        Token token = ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
        Intrinsics.checkNotNull((Object)token);
        Token token2 = token;
        NullLiteral nullLiteral = new NullLiteral(null, 1, null);
        nullLiteral.setLineCol(token2.getLineCol());
        ctx.getExprStack().push(nullLiteral);
        this.exprContinue(ctx);
    }

    private final void exprNew(ParserContext ctx) {
        Token token = ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
        Intrinsics.checkNotNull((Object)token);
        LineCol lineCol = token.getLineCol();
        Token token2 = ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
        if (token2 == null) {
            throw new ParserException("unexpected end of expression when trying to get the type to be instantiated", lineCol);
        }
        Token typeToken = token2;
        if (typeToken.getType() != TokenType.VAR_NAME) {
            throw new ParserException("unexpected token " + typeToken + ", expecting the type to be instantiated", typeToken.getLineCol());
        }
        String typeStr = typeToken.getRaw();
        Token token3 = ExprTokenizer.peek$default(this.tokenizer, 0, 1, null);
        if (token3 == null) {
            throw new ParserException("unexpected end of expression when trying to identify type instantiation or array creation", lineCol);
        }
        Token mightBeBracketOrColon = token3;
        if (mightBeBracketOrColon.getType() == TokenType.COLON) {
            ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
            Token token4 = ExprTokenizer.peek$default(this.tokenizer, 0, 1, null);
            if (token4 == null) {
                throw new ParserException("unexpected end of expression when invoking constructor of " + typeStr + ", expecting `[`", lineCol);
            }
            Token bracket = token4;
            if (bracket.getType() == TokenType.LEFT_BRACE) {
                this.parseNewInstanceWithJson(ctx, typeStr, lineCol);
            } else {
                ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
                if (bracket.getType() != TokenType.LEFT_BRACKET) {
                    throw new ParserException("unexpected token " + bracket + ", expecting `[` for invoking constructor of " + typeStr, bracket.getLineCol());
                }
                List<Expr> args = this.parseArguments(ctx, lineCol, Intrinsics.stringPlus((String)"invoking constructor of ", (Object)typeStr));
                NewInstance newInst = new NewInstance(new Type(typeStr), args);
                newInst.setLineCol(lineCol);
                ctx.getExprStack().push(newInst);
            }
            this.exprContinue(ctx);
        } else if (mightBeBracketOrColon.getType() == TokenType.LEFT_BRACE) {
            this.parseNewInstanceWithJson(ctx, typeStr, lineCol);
        } else if (mightBeBracketOrColon.getType() == TokenType.LEFT_BRACKET) {
            Token nx;
            ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
            ParserContext subCtx = new ParserContext(ctx, TokenType.LEFT_BRACKET);
            this.exprEntry(subCtx);
            if (!subCtx.getEnds()) {
                throw new ParserException("only one element can be used to create " + typeStr + " array, the next token is " + (ExprTokenizer.peek$default(this.tokenizer, 0, 1, null) == null ? "eof" : ExprTokenizer.peek$default(this.tokenizer, 0, 1, null)), mightBeBracketOrColon.getLineCol());
            }
            Expr lenExpr = subCtx.getExprStack().pop();
            int dimension = 1;
            while ((nx = ExprTokenizer.peek$default(this.tokenizer, 0, 1, null)) != null && nx.getType() == TokenType.LEFT_BRACKET) {
                ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
                Token token5 = ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
                if (token5 == null) {
                    throw new ParserException("unexpected end of expression when trying to determine dimension of the new array", nx.getLineCol());
                }
                Token nxnx = token5;
                if (nxnx.getType() != TokenType.RIGHT_BRACKET) {
                    throw new ParserException("unexpected token " + nxnx + ", expecting `]` when trying to determine dimension of the new array", nxnx.getLineCol());
                }
                ++dimension;
            }
            NewArray newArray = new NewArray(new Type(Intrinsics.stringPlus((String)typeStr, (Object)StringsKt.repeat((CharSequence)"[]", (int)dimension))), lenExpr);
            newArray.setLineCol(lineCol);
            ctx.getExprStack().push(newArray);
            this.exprContinue(ctx);
        } else {
            throw new ParserException("unexpected token " + mightBeBracketOrColon + ", expecting `:` or `[` for the `new` expression", mightBeBracketOrColon.getLineCol());
        }
    }

    private final void parseNewInstanceWithJson(ParserContext ctx, String typeStr, LineCol lineCol) {
        JSON.Object jsonObj = this.tokenizer.nextJsonObject();
        NewInstanceWithJson expr = new NewInstanceWithJson(new Type(typeStr), (Map<String, ? extends Object>)this.newJsonConvert(ctx, jsonObj));
        expr.setLineCol(lineCol);
        ctx.getExprStack().push(expr);
    }

    private final Object newJsonConvert(ParserContext ctx, JSON.Instance<?> v) {
        Object object;
        JSON.Instance<?> instance = v;
        if (instance instanceof JSON.Integer ? true : instance instanceof JSON.Long) {
            IntegerLiteral ret2 = new IntegerLiteral((JSON.Number)v);
            ret2.setLineCol(v.lineCol());
            object = ret2;
        } else if (instance instanceof JSON.Double) {
            FloatLiteral ret3 = new FloatLiteral((JSON.Double)v);
            ret3.setLineCol(v.lineCol());
            object = ret3;
        } else if (instance instanceof JSON.Bool) {
            BoolLiteral ret4 = new BoolLiteral(((JSON.Bool)v).booleanValue());
            ret4.setLineCol(v.lineCol());
            object = ret4;
        } else if (instance instanceof JSON.Null) {
            NullLiteral ret5 = new NullLiteral(null, 1, null);
            ret5.setLineCol(v.lineCol());
            object = ret5;
        } else if (instance instanceof JSON.Object) {
            object = this.newJsonConvert(ctx, (JSON.Object)v);
        } else if (instance instanceof JSON.Array) {
            object = this.newJsonConvert(ctx, (JSON.Array)v);
        } else if (instance instanceof JSON.String) {
            object = this.newJsonConvert(ctx, (JSON.String)v);
        } else {
            throw new ParserException(Intrinsics.stringPlus((String)"unknown json instance ", v), v.lineCol());
        }
        return object;
    }

    private final LinkedHashMap<String, Object> newJsonConvert(ParserContext ctx, JSON.Object jsonObj) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String k : jsonObj.keyList()) {
            JSON.Instance<?> v = jsonObj.get(k);
            Map map2 = map;
            Object object = this.newJsonConvert(ctx, v);
            boolean bl = false;
            map2.put(k, object);
        }
        return map;
    }

    private final ArrayList<Object> newJsonConvert(ParserContext ctx, JSON.Array jsonArr) {
        ArrayList<Object> ls = new ArrayList<Object>();
        int n = 0;
        int n2 = jsonArr.length();
        if (n < n2) {
            do {
                int i = n++;
                JSON.Instance<?> e = jsonArr.get(i);
                ls.add(this.newJsonConvert(ctx, e));
            } while (n < n2);
        }
        return ls;
    }

    private final Expr newJsonConvert(ParserContext ctx, JSON.String jsonStr) {
        String str = jsonStr.toJavaObject();
        if (!StringsKt.startsWith$default((String)str, (String)"${", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)str, (String)"}", (boolean)false, (int)2, null)) {
            return new StringLiteral(str);
        }
        String string = str;
        int n = 2;
        int n2 = str.length() - 1;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        str = string3;
        ParserContext subCtx = new ParserContext(ctx, null);
        ExprParser parser = new ExprParser(new ExprTokenizer(str, jsonStr.lineCol().inner()));
        parser.exprEntry(subCtx);
        if (subCtx.getExprStack().isEmpty()) {
            throw new ParserException("empty expression", jsonStr.lineCol());
        }
        if (subCtx.getExprStack().size() > 1) {
            throw new ParserException("early end of expression before finishing parsing", jsonStr.lineCol());
        }
        return subCtx.getExprStack().pop();
    }

    private final void accessVar(ParserContext ctx) {
        Token token = ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
        Intrinsics.checkNotNull((Object)token);
        Token token2 = token;
        String varname = token2.getRaw();
        Access access = new Access(varname, null, 2, null);
        access.setLineCol(token2.getLineCol());
        ctx.getExprStack().push(access);
        this.exprContinue(ctx);
    }

    private final void par(ParserContext ctx) {
        Token token = ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
        Intrinsics.checkNotNull((Object)token);
        Token token2 = token;
        ParserContext nextCtx = new ParserContext(ctx, token2.getType());
        this.exprEntry(nextCtx);
        ctx.getExprStack().push(nextCtx.getExprStack().pop());
        this.exprContinue(ctx);
    }

    private final void positive(ParserContext ctx) {
        Token token = ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
        Intrinsics.checkNotNull((Object)token);
        Token token2 = token;
        ctx.getUnaryOpStack().push(1);
        this.exprEntry(ctx);
        Expr expr = ctx.getExprStack().pop();
        Positive positive = new Positive(expr);
        positive.setLineCol(token2.getLineCol());
        ctx.getExprStack().push(positive);
        ctx.getUnaryOpStack().pop();
        this.exprContinue(ctx);
    }

    private final void negative(ParserContext ctx) {
        Token token = ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
        Intrinsics.checkNotNull((Object)token);
        Token token2 = token;
        ctx.getUnaryOpStack().push(1);
        this.exprEntry(ctx);
        Expr expr = ctx.getExprStack().pop();
        Negative negative = new Negative(expr);
        negative.setLineCol(token2.getLineCol());
        ctx.getExprStack().push(negative);
        ctx.getUnaryOpStack().pop();
        this.exprContinue(ctx);
    }

    private final void logicNot(ParserContext ctx) {
        Token token = ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
        Intrinsics.checkNotNull((Object)token);
        Token token2 = token;
        ctx.getUnaryOpStack().push(1);
        this.exprEntry(ctx);
        Expr expr = ctx.getExprStack().pop();
        LogicNot logicNot = new LogicNot(expr);
        logicNot.setLineCol(token2.getLineCol());
        ctx.getExprStack().push(logicNot);
        ctx.getUnaryOpStack().pop();
        this.exprContinue(ctx);
    }

    private final void string(ParserContext ctx) {
        Token token;
        Token token2 = token = ExprTokenizer.next$default(this.tokenizer, 0, 1, null);
        Intrinsics.checkNotNull((Object)token2);
        Object object = token2.getValue();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type vjson.simple.SimpleString");
        }
        SimpleString str = (SimpleString)object;
        StringLiteral strLiteral = new StringLiteral(str.toJavaObject());
        strLiteral.setLineCol(token.getLineCol());
        ctx.getExprStack().push(strLiteral);
        this.exprContinue(ctx);
    }

    private final boolean isTerminator(Token token) {
        if (token == null) {
            return true;
        }
        return token.getType().isTerminator();
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TokenType.values().length];
            nArray[TokenType.INTEGER.ordinal()] = 1;
            nArray[TokenType.FLOAT.ordinal()] = 2;
            nArray[TokenType.BOOL_TRUE.ordinal()] = 3;
            nArray[TokenType.BOOL_FALSE.ordinal()] = 4;
            nArray[TokenType.KEY_NULL.ordinal()] = 5;
            nArray[TokenType.KEY_NEW.ordinal()] = 6;
            nArray[TokenType.VAR_NAME.ordinal()] = 7;
            nArray[TokenType.LEFT_PAR.ordinal()] = 8;
            nArray[TokenType.PLUS.ordinal()] = 9;
            nArray[TokenType.MINUS.ordinal()] = 10;
            nArray[TokenType.LOGIC_NOT.ordinal()] = 11;
            nArray[TokenType.STRING.ordinal()] = 12;
            nArray[TokenType.MULTIPLY.ordinal()] = 13;
            nArray[TokenType.DIVIDE.ordinal()] = 14;
            nArray[TokenType.MOD.ordinal()] = 15;
            nArray[TokenType.CMP_GT.ordinal()] = 16;
            nArray[TokenType.CMP_GE.ordinal()] = 17;
            nArray[TokenType.CMP_LT.ordinal()] = 18;
            nArray[TokenType.CMP_LE.ordinal()] = 19;
            nArray[TokenType.CMP_NE.ordinal()] = 20;
            nArray[TokenType.CMP_EQ.ordinal()] = 21;
            nArray[TokenType.LOGIC_AND.ordinal()] = 22;
            nArray[TokenType.LOGIC_OR.ordinal()] = 23;
            nArray[TokenType.PLUS_ASSIGN.ordinal()] = 24;
            nArray[TokenType.MINUS_ASSIGN.ordinal()] = 25;
            nArray[TokenType.MULTIPLY_ASSIGN.ordinal()] = 26;
            nArray[TokenType.DIVIDE_ASSIGN.ordinal()] = 27;
            nArray[TokenType.MOD_ASSIGN.ordinal()] = 28;
            nArray[TokenType.RIGHT_PAR.ordinal()] = 29;
            nArray[TokenType.RIGHT_BRACKET.ordinal()] = 30;
            nArray[TokenType.DOT.ordinal()] = 31;
            nArray[TokenType.COLON.ordinal()] = 32;
            nArray[TokenType.LEFT_BRACKET.ordinal()] = 33;
            nArray[TokenType.COMMA.ordinal()] = 34;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

