/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.CharStream;
import vjson.JSON;
import vjson.cs.LineCol;
import vjson.cs.LineColCharStream;
import vjson.ex.ParserException;
import vjson.parser.ObjectParser;
import vjson.parser.ParserOptions;
import vjson.parser.StringParser;
import vjson.pl.InterpreterBuilder;
import vjson.pl.token.FloatTokenHandler;
import vjson.pl.token.FullMatchTokenHandler;
import vjson.pl.token.IntTokenHandler;
import vjson.pl.token.Token;
import vjson.pl.token.TokenHandler;
import vjson.pl.token.TokenType;
import vjson.pl.token.VariableNameTokenHandler;
import vjson.simple.SimpleBool;
import vjson.simple.SimpleString;
import vjson.util.collection.VList;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0005JC\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\r0\u001cj\b\u0012\u0004\u0012\u00020\r`\u001d2\n\u0010\u001e\u001a\u00060\u001fj\u0002` 2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0002\u0010!J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020&J\u0012\u0010'\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010#\u001a\u00020$J\b\u0010(\u001a\u00020\u0012H\u0002J\b\u0010)\u001a\u00020\u0019H\u0002R\u000e\u0010\u0007\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lvjson/pl/ExprTokenizer;", "", "str", "", "offset", "Lvjson/cs/LineCol;", "(Ljava/lang/String;Lvjson/cs/LineCol;)V", "cs", "Lvjson/CharStream;", "(Lvjson/CharStream;Lvjson/cs/LineCol;)V", "Lvjson/cs/LineColCharStream;", "handlers", "", "Lvjson/pl/token/TokenHandler;", "getOffset", "()Lvjson/cs/LineCol;", "tokenBuffer", "Lvjson/util/collection/VList;", "Lvjson/pl/token/Token;", "canSplitTokens", "", "c", "", "currentLineCol", "finish", "", "lineCol", "last", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "traveled", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "(Lvjson/cs/LineCol;Ljava/util/ArrayList;Ljava/lang/StringBuilder;Ljava/lang/Character;)V", "next", "n", "", "nextJsonObject", "Lvjson/JSON$Object;", "peek", "readStringToken", "readToken", "vjson"})
public final class ExprTokenizer {
    @NotNull
    private final LineCol offset;
    @NotNull
    private final LineColCharStream cs;
    @NotNull
    private final List<TokenHandler> handlers;
    @NotNull
    private final VList<Token> tokenBuffer;

    public ExprTokenizer(@NotNull CharStream cs, @NotNull LineCol offset) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        this.offset = offset;
        this.cs = new LineColCharStream(cs, this.offset.getFilename(), this.offset);
        Object[] objectArray = new TokenHandler[]{new VariableNameTokenHandler(), new IntTokenHandler(), new FloatTokenHandler(), new FullMatchTokenHandler(TokenType.BOOL_TRUE, "true", 1, new SimpleBool(true, null, 2, null)), new FullMatchTokenHandler(TokenType.BOOL_FALSE, "false", 1, new SimpleBool(false, null, 2, null)), new FullMatchTokenHandler(TokenType.KEY_NULL, "null", 1, null, 8, null), new FullMatchTokenHandler(TokenType.KEY_NEW, "new", 1, null, 8, null), new FullMatchTokenHandler(TokenType.LEFT_PAR, "(", 0, null, 12, null), new FullMatchTokenHandler(TokenType.RIGHT_PAR, ")", 0, null, 12, null), new FullMatchTokenHandler(TokenType.LEFT_BRACKET, "[", 0, null, 12, null), new FullMatchTokenHandler(TokenType.RIGHT_BRACKET, "]", 0, null, 12, null), new FullMatchTokenHandler(TokenType.LEFT_BRACE, "{", 0, null, 12, null), new FullMatchTokenHandler(TokenType.RIGHT_BRACE, "}", 0, null, 12, null), new FullMatchTokenHandler(TokenType.PLUS, "+", 0, null, 12, null), new FullMatchTokenHandler(TokenType.MINUS, "-", 0, null, 12, null), new FullMatchTokenHandler(TokenType.MULTIPLY, "*", 0, null, 12, null), new FullMatchTokenHandler(TokenType.DIVIDE, "/", 0, null, 12, null), new FullMatchTokenHandler(TokenType.MOD, "%", 0, null, 12, null), new FullMatchTokenHandler(TokenType.PLUS_ASSIGN, "+=", 0, null, 12, null), new FullMatchTokenHandler(TokenType.MINUS_ASSIGN, "-=", 0, null, 12, null), new FullMatchTokenHandler(TokenType.MULTIPLY_ASSIGN, "*=", 0, null, 12, null), new FullMatchTokenHandler(TokenType.DIVIDE_ASSIGN, "/=", 0, null, 12, null), new FullMatchTokenHandler(TokenType.MOD_ASSIGN, "%=", 0, null, 12, null), new FullMatchTokenHandler(TokenType.CMP_GT, ">", 0, null, 12, null), new FullMatchTokenHandler(TokenType.CMP_GE, ">=", 0, null, 12, null), new FullMatchTokenHandler(TokenType.CMP_LT, "<", 0, null, 12, null), new FullMatchTokenHandler(TokenType.CMP_LE, "<=", 0, null, 12, null), new FullMatchTokenHandler(TokenType.CMP_EQ, "==", 0, null, 12, null), new FullMatchTokenHandler(TokenType.CMP_NE, "!=", 0, null, 12, null), new FullMatchTokenHandler(TokenType.LOGIC_NOT, "!", 0, null, 12, null), new FullMatchTokenHandler(TokenType.LOGIC_AND, "&&", 0, null, 12, null), new FullMatchTokenHandler(TokenType.LOGIC_OR, "||", 0, null, 12, null), new FullMatchTokenHandler(TokenType.DOT, ".", 0, null, 12, null), new FullMatchTokenHandler(TokenType.COLON, ":", 0, null, 12, null), new FullMatchTokenHandler(TokenType.COMMA, ",", 0, null, 12, null)};
        this.handlers = CollectionsKt.listOf((Object[])objectArray);
        this.tokenBuffer = new VList();
    }

    @NotNull
    public final LineCol getOffset() {
        return this.offset;
    }

    public ExprTokenizer(@NotNull String str, @NotNull LineCol offset) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        this(CharStream.Companion.from(str), offset);
    }

    @Nullable
    public final Token peek(int n) {
        int size;
        if (this.tokenBuffer.size() >= n) {
            return this.tokenBuffer.get(n - 1);
        }
        do {
            int sizeBeforeRead = this.tokenBuffer.size();
            this.readToken();
            size = this.tokenBuffer.size();
            if (size != sizeBeforeRead) continue;
            return null;
        } while (n > size);
        return this.tokenBuffer.get(n - 1);
    }

    public static /* synthetic */ Token peek$default(ExprTokenizer exprTokenizer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return exprTokenizer.peek(n);
    }

    @Nullable
    public final Token next(int n) {
        int size;
        if (this.tokenBuffer.size() >= n) {
            Token ret2 = this.tokenBuffer.get(n - 1);
            this.tokenBuffer.removeFirst(n);
            return ret2;
        }
        int nn = n - this.tokenBuffer.size();
        this.tokenBuffer.clear();
        do {
            int sizeBeforeRead = this.tokenBuffer.size();
            this.readToken();
            size = this.tokenBuffer.size();
            if (sizeBeforeRead != size) continue;
            return null;
        } while (nn > size);
        this.tokenBuffer.removeFirst(nn - 1);
        return this.tokenBuffer.removeFirst();
    }

    public static /* synthetic */ Token next$default(ExprTokenizer exprTokenizer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return exprTokenizer.next(n);
    }

    @NotNull
    public final JSON.Object nextJsonObject() {
        JSON.Object object;
        boolean needBrace = false;
        if (!this.tokenBuffer.isEmpty()) {
            if (this.tokenBuffer.size() != 1) {
                throw new IllegalStateException("cannot retrieve json object because current token buffer is neither empty nor containing only `{`");
            }
            if (this.tokenBuffer.get(0).getType() != TokenType.LEFT_BRACE) {
                throw new IllegalStateException("cannot retrieve json object because current token buffer is neither empty nor containing only `{`");
            }
            this.tokenBuffer.clear();
            needBrace = true;
        }
        ObjectParser parser = new ObjectParser(InterpreterBuilder.Companion.interpreterOptions().setEnd(false));
        if (needBrace) {
            parser.feed("{");
        }
        if ((object = (JSON.Object)parser.feed(this.cs)) == null) {
            throw new IllegalStateException("cannot retrieve json object, expecting more input");
        }
        return object;
    }

    private final void readToken() {
        this.cs.skipBlank();
        if (!this.cs.hasNext()) {
            return;
        }
        char preCheck = this.cs.peekNext();
        if (preCheck == '\'' || preCheck == '\"') {
            this.tokenBuffer.add(this.readStringToken());
            return;
        }
        LineCol lineCol = this.cs.lineCol();
        for (TokenHandler h : this.handlers) {
            h.reset();
        }
        ArrayList<TokenHandler> last = new ArrayList<TokenHandler>();
        last.addAll((Collection)this.handlers);
        StringBuilder traveled = new StringBuilder();
        Character prevC = null;
        while (true) {
            if (!this.cs.hasNext()) {
                this.finish(lineCol, last, traveled, null);
                return;
            }
            char c = this.cs.peekNext();
            ArrayList<TokenHandler> current = new ArrayList<TokenHandler>();
            for (TokenHandler h : last) {
                if (!h.feed(c)) continue;
                current.add(h);
            }
            if (current.isEmpty()) {
                CharSequence charSequence = traveled;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    throw new ParserException(Intrinsics.stringPlus((String)"unable to parse the token: all rules failed when reading the first character ", (Object)Character.valueOf(c)), this.cs.lineCol());
                }
                if (!this.canSplitTokens(c) && prevC != null && !this.canSplitTokens(prevC.charValue())) {
                    throw new ParserException("unable to parse the token: all rules failed after reading `" + traveled + "`, the next character is " + c + ", both " + traveled.charAt(traveled.length() - 1) + " and " + c + " cannot be used to split a token, last applicable rules: " + last, this.cs.lineCol());
                }
                this.finish(lineCol, last, traveled, Character.valueOf(c));
                return;
            }
            this.cs.moveNextAndGet();
            prevC = Character.valueOf(c);
            traveled.append(c);
            last = current;
        }
    }

    private final Token readStringToken() {
        LineCol lineCol = this.cs.lineCol();
        StringBuilder raw = new StringBuilder();
        StringParser stringParser = new StringParser(new ParserOptions().setStringSingleQuotes(true));
        SimpleString result = null;
        while (this.cs.hasNext()) {
            char c = this.cs.moveNextAndGet();
            raw.append(c);
            char[] cArray = new char[]{c};
            JSON.String res = (JSON.String)stringParser.feed(new LineColCharStream(CharStream.Companion.from(cArray), lineCol.getFilename(), this.cs.lineCol()));
            if (res == null) continue;
            result = (SimpleString)res;
            break;
        }
        if (result == null) {
            throw new ParserException(Intrinsics.stringPlus((String)"unable to parse the token: incomplete string literal: ", (Object)raw), this.cs.lineCol());
        }
        String string = raw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"raw.toString()");
        return new Token(TokenType.STRING, string, lineCol, result);
    }

    private final void finish(LineCol lineCol, ArrayList<TokenHandler> last, StringBuilder traveled, Character c) {
        Object h;
        ArrayList<TokenHandler> current = new ArrayList<TokenHandler>();
        Object object = last.iterator();
        while (object.hasNext()) {
            h = object.next();
            if (!h.check()) continue;
            current.add((TokenHandler)h);
        }
        if (current.size() == 0) {
            throw new ParserException("unable to parse the token: all rules failed after reading `" + traveled + "`, the next character is " + (String)((object = c) == null ? "(eof)" : ((h = ((Character)object).toString()) == null ? "(eof)" : h)) + ", last applicable rules: " + last, this.cs.lineCol());
        }
        TokenHandler handler = null;
        if (current.size() == 1) {
            h = current.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)h, (String)"current[0]");
            handler = h;
        } else {
            Object h2;
            ArrayList<Object> foo = new ArrayList<Object>();
            Object object2 = current.iterator();
            while (object2.hasNext()) {
                h2 = (TokenHandler)object2.next();
                if (foo.isEmpty()) {
                    foo.add(h2);
                    continue;
                }
                if (((TokenHandler)foo.get(0)).precedence() < h2.precedence()) {
                    foo.clear();
                    foo.add(h2);
                    continue;
                }
                if (((TokenHandler)foo.get(0)).precedence() != h2.precedence()) continue;
                foo.add(h2);
            }
            if (foo.size() > 1) {
                throw new ParserException("unable to parse the token: multiple rules conflict after reading `" + traveled + (String)((object2 = c) == null ? "" : ((h2 = ((Character)object2).toString()) == null ? "" : h2)) + "`: " + foo, this.cs.lineCol());
            }
            object2 = foo.get(0);
            Intrinsics.checkNotNullExpressionValue(object2, (String)"foo[0]");
            handler = (TokenHandler)object2;
        }
        List<Token> tokens = handler.build(lineCol);
        if (tokens.isEmpty()) {
            throw new ParserException(Intrinsics.stringPlus((String)"unable to parse the token: no tokens built by ", (Object)handler), this.cs.lineCol());
        }
        for (Token t : tokens) {
            this.tokenBuffer.add(t);
        }
    }

    private final boolean canSplitTokens(char c) {
        boolean bl = 'a' <= c ? c <= 'z' : false;
        if (bl) {
            return false;
        }
        boolean bl2 = 'A' <= c ? c <= 'Z' : false;
        if (bl2) {
            return false;
        }
        if (c == '$') {
            return false;
        }
        if (c == '_') {
            return false;
        }
        boolean bl3 = '0' <= c ? c <= '9' : false;
        if (bl3) {
            return false;
        }
        char c2 = c;
        boolean bl4 = false;
        return c2 < '\u0080';
    }

    @NotNull
    public final LineCol currentLineCol() {
        return this.cs.lineCol();
    }
}

