/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import vjson.pl.RuntimeMemoryExplorer;
import vjson.pl.ast.Statement;
import vjson.pl.inst.ActionContext;
import vjson.pl.inst.Execution;
import vjson.pl.inst.Instruction;
import vjson.pl.inst.InstructionException;
import vjson.pl.inst.RuntimeMemory;
import vjson.pl.inst.RuntimeMemoryTotal;
import vjson.pl.type.MemoryAllocator;
import vjson.pl.type.TypeContext;
import vjson.pl.type.lang.Types;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0016\u001a\u00020\u0014J\u0006\u0010\u0017\u001a\u00020\tJ\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0014J\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0004R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00140\u0013j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lvjson/pl/Interpreter;", "", "types", "", "Lvjson/pl/type/lang/Types;", "ast", "Lvjson/pl/ast/Statement;", "(Ljava/util/List;Ljava/util/List;)V", "explorer", "Lvjson/pl/RuntimeMemoryExplorer;", "instructions", "Lvjson/pl/inst/Instruction;", "typeContext", "Lvjson/pl/type/TypeContext;", "typesOffset", "Ljava/util/ArrayList;", "Lvjson/pl/inst/RuntimeMemoryTotal;", "Lkotlin/collections/ArrayList;", "valueForTypes", "Ljava/util/HashMap;", "Lvjson/pl/inst/RuntimeMemory;", "Lkotlin/collections/HashMap;", "execute", "getExplorer", "putValues", "", "t", "values", "removeValues", "vjson"})
public final class Interpreter {
    @NotNull
    private final List<Types> types;
    @NotNull
    private final ArrayList<RuntimeMemoryTotal> typesOffset;
    @NotNull
    private final TypeContext typeContext;
    @NotNull
    private final HashMap<Types, RuntimeMemory> valueForTypes;
    @NotNull
    private final RuntimeMemoryExplorer explorer;
    @NotNull
    private final List<Instruction> instructions;

    /*
     * WARNING - void declaration
     */
    public Interpreter(@NotNull List<? extends Types> types, @NotNull List<? extends Statement> ast) {
        Collection<Instruction> collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter(ast, (String)"ast");
        this.types = types;
        this.typesOffset = new ArrayList();
        this.typeContext = new TypeContext(new MemoryAllocator());
        this.valueForTypes = new HashMap();
        RuntimeMemoryTotal offset = new RuntimeMemoryTotal(0, 0, 0, 0, 0, 0, 63, null);
        for (Types types2 : this.types) {
            this.typesOffset.add(offset);
            offset = types2.initiateType(this.typeContext, offset);
        }
        this.typeContext.checkStatements(ast);
        RuntimeMemoryExplorer.Builder explorerBuilder = new RuntimeMemoryExplorer.Builder(null, 1, null);
        explorerBuilder.feed(ast);
        this.explorer = explorerBuilder.build();
        Iterable iterable = ast;
        Interpreter interpreter = this;
        boolean $i$f$map = false;
        Iterable iterable2 = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Statement statement = (Statement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Instruction instruction = it.generateInstruction();
            collection.add(instruction);
        }
        collection = (List)destination$iv$iv;
        interpreter.instructions = collection;
    }

    public final void putValues(@NotNull Types t, @NotNull RuntimeMemory values) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Map map = this.valueForTypes;
        boolean bl = false;
        map.put(t, values);
    }

    public final void removeValues(@NotNull Types t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.valueForTypes.remove(t);
    }

    @NotNull
    public final RuntimeMemoryExplorer getExplorer() {
        return this.explorer;
    }

    @NotNull
    public final RuntimeMemory execute() {
        ActionContext actionContext = new ActionContext(this.typeContext.getMemoryAllocator().getTotal(), null);
        int n = 0;
        int n2 = this.types.size() + -1;
        if (n <= n2) {
            do {
                int i = n++;
                Types t = this.types.get(i);
                RuntimeMemoryTotal runtimeMemoryTotal = this.typesOffset.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)runtimeMemoryTotal, (String)"typesOffset[i]");
                t.initiateValues(actionContext, runtimeMemoryTotal, this.valueForTypes.get(t));
            } while (n <= n2);
        }
        Execution exec = new Execution();
        for (Instruction inst : this.instructions) {
            try {
                inst.execute(actionContext, exec);
            }
            catch (InstructionException e) {
                throw new Exception(e.formatException(), e.getCause());
            }
        }
        return actionContext.getCurrentMem();
    }
}

